# Generated by default/object.tt
package Paws::S3::Object;
  use Moose;
  has ETag => (is => 'ro', isa => 'Str');
  has Key => (is => 'ro', isa => 'Str');
  has LastModified => (is => 'ro', isa => 'Str');
  has Owner => (is => 'ro', isa => 'Paws::S3::Owner');
  has Size => (is => 'ro', isa => 'Int');
  has StorageClass => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3::Object

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3::Object object:

  $service_obj->Method(Att1 => { ETag => $value, ..., StorageClass => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3::Object object:

  $result = $service_obj->Method(...);
  $result->Att1->ETag

=head1 DESCRIPTION

An object consists of data and its descriptive metadata.

=head1 ATTRIBUTES


=head2 ETag => Str

The entity tag is a hash of the object. The ETag reflects changes only
to the contents of an object, not its metadata. The ETag may or may not
be an MD5 digest of the object data. Whether or not it is depends on
how the object was created and how it is encrypted as described below:

=over

=item *

Objects created by the PUT Object, POST Object, or Copy operation, or
through the AWS Management Console, and are encrypted by SSE-S3 or
plaintext, have ETags that are an MD5 digest of their object data.

=item *

Objects created by the PUT Object, POST Object, or Copy operation, or
through the AWS Management Console, and are encrypted by SSE-C or
SSE-KMS, have ETags that are not an MD5 digest of their object data.

=item *

If an object is created by either the Multipart Upload or Part Copy
operation, the ETag is not an MD5 digest, regardless of the method of
encryption.

=back



=head2 Key => Str

The name that you assign to an object. You use the object key to
retrieve the object.


=head2 LastModified => Str

Creation date of the object.


=head2 Owner => L<Paws::S3::Owner>

The owner of the object


=head2 Size => Int

Size in bytes of the object


=head2 StorageClass => Str

The class of storage used to store the object.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

