#!/usr/bin/env perl

use 5.010;
use strict;
use warnings;

package Medical::Growth::NHANES_2000::Weight_for_Age::Child::Female;

our ($VERSION) = '1.00';

use Moo::Lax;    # Vanilla Moo considered harmful

extends 'Medical::Growth::NHANES_2000::Base';

__PACKAGE__->_declare_params_LMS;

1;

# wtage, sex = 2

__DATA__

24	-0.73533951	12.05503983	0.107399495
24.5	-0.75220657	12.13455523	0.107740345
25.5	-0.78423366	12.2910249	0.10847701
26.5	-0.81409582	12.44469258	0.109280828
27.5	-0.841935504	12.59622335	0.110144488
28.5	-0.867889398	12.74620911	0.111060815
29.5	-0.892102647	12.89517218	0.112022759
30.5	-0.914718817	13.04357164	0.113023467
31.5	-0.935876584	13.19180874	0.114056328
32.5	-0.955723447	13.34022934	0.115114953
33.5	-0.974383363	13.48913319	0.116193327
34.5	-0.991980756	13.63877446	0.11728575
35.5	-1.008640742	13.78936547	0.118386848
36.5	-1.024471278	13.94108332	0.119491669
37.5	-1.039573604	14.09407175	0.120595658
38.5	-1.054039479	14.24844498	0.121694676
39.5	-1.067946784	14.40429169	0.12278503
40.5	-1.081374153	14.56167529	0.1238634
41.5	-1.094381409	14.72064045	0.124926943
42.5	-1.107021613	14.88121352	0.125973221
43.5	-1.119338692	15.04340553	0.127000212
44.5	-1.131367831	15.20721443	0.128006292
45.5	-1.143135936	15.37262729	0.128990225
46.5	-1.15466215	15.53962221	0.129951143
47.5	-1.165958392	15.70817017	0.130888527
48.5	-1.177029925	15.87823668	0.131802186
49.5	-1.187871001	16.04978452	0.132692269
50.5	-1.198484073	16.2227706	0.133559108
51.5	-1.208853947	16.39715363	0.134403386
52.5	-1.218965087	16.57289122	0.13522599
53.5	-1.228798212	16.74994187	0.136028014
54.5	-1.238330855	16.92826587	0.136810739
55.5	-1.247537914	17.10782615	0.137575606
56.5	-1.256392179	17.28858894	0.138324193
57.5	-1.264864846	17.47052444	0.139058192
58.5	-1.272926011	17.65360733	0.139779387
59.5	-1.28054514	17.83781722	0.140489635
60.5	-1.287691525	18.02313904	0.141190842
61.5	-1.294332076	18.20956418	0.141884974
62.5	-1.300441561	18.3970876	0.142573939
63.5	-1.305989011	18.58571243	0.143259709
64.5	-1.310946941	18.77544728	0.143944216
65.5	-1.315289534	18.966307	0.144629359
66.5	-1.318992925	19.15831267	0.14531699
67.5	-1.322035315	19.35149163	0.146008903
68.5	-1.324398133	19.54587708	0.146706813
69.5	-1.326064539	19.74150854	0.147412363
70.5	-1.327020415	19.93843145	0.148127109
71.5	-1.327256387	20.13669623	0.148852482
72.5	-1.326763834	20.33635961	0.149589838
73.5	-1.325538668	20.53748298	0.1503404
74.5	-1.323579654	20.74013277	0.151105277
75.5	-1.320888012	20.94438028	0.151885464
76.5	-1.317468695	21.15030093	0.152681819
77.5	-1.313331446	21.35797332	0.15349505
78.5	-1.308487081	21.56748045	0.154325756
79.5	-1.302948173	21.77890902	0.155174414
80.5	-1.296733913	21.99234686	0.15604132
81.5	-1.289863329	22.20788541	0.156926667
82.5	-1.282358762	22.4256177	0.157830504
83.5	-1.274244931	22.64563824	0.158752743
84.5	-1.265548787	22.86804258	0.159693163
85.5	-1.256299378	23.09292679	0.16065141
86.5	-1.24653066	23.32038549	0.161626956
87.5	-1.236266832	23.55051871	0.162619308
88.5	-1.225551344	23.78341652	0.1636276
89.5	-1.214410914	24.01917703	0.1646511
90.5	-1.202884389	24.25789074	0.165688808
91.5	-1.191007906	24.49964778	0.166739662
92.5	-1.178818621	24.74453536	0.167802495
93.5	-1.166354376	24.99263735	0.168876037
94.5	-1.153653688	25.24403371	0.169958922
95.5	-1.140751404	25.49880264	0.171049756
96.5	-1.127684095	25.7570168	0.172147043
97.5	-1.114490244	26.01874261	0.173249185
98.5	-1.101204848	26.28404312	0.174354569
99.5	-1.087863413	26.55297507	0.175461512
100.5	-1.074500927	26.82558904	0.176568284
101.5	-1.061151213	27.1019295	0.177673124
102.5	-1.047847141	27.38203422	0.178774242
103.5	-1.034620551	27.66593402	0.179869829
104.5	-1.021502197	27.9536524	0.180958063
105.5	-1.008521695	28.24520531	0.182037118
106.5	-0.995707494	28.54060085	0.183105172
107.5	-0.983086844	28.83983907	0.18416041
108.5	-0.970685789	29.14291171	0.185201039
109.5	-0.958529157	29.44980208	0.186225287
110.5	-0.946640568	29.76048479	0.187231416
111.5	-0.935042447	30.0749257	0.188217723
112.5	-0.923756041	30.39308176	0.18918255
113.5	-0.912801445	30.71490093	0.190124286
114.5	-0.902197638	31.0403221	0.191041375
115.5	-0.891962513	31.36927506	0.191932319
116.5	-0.882112919	31.7016805	0.192795682
117.5	-0.872664706	32.03744999	0.193630095
118.5	-0.863632768	32.37648607	0.19443426
119.5	-0.855031092	32.71868225	0.195206948
120.5	-0.846872805	33.06392318	0.195947008
121.5	-0.839170224	33.4120847	0.196653365
122.5	-0.831934903	33.76303402	0.197325023
123.5	-0.825177688	34.1166299	0.197961065
124.5	-0.818908758	34.47272283	0.198560655
125.5	-0.813137675	34.83115524	0.199123037
126.5	-0.807873433	35.19176177	0.199647538
127.5	-0.803122613	35.55437176	0.200133598
128.5	-0.79889771	35.91879976	0.200580618
129.5	-0.795203499	36.28486194	0.200988216
130.5	-0.792047959	36.65236365	0.201356017
131.5	-0.789435274	37.02110818	0.201683791
132.5	-0.787374433	37.39088668	0.201971282
133.5	-0.785870695	37.76148905	0.202218375
134.5	-0.784929893	38.1326991	0.202425006
135.5	-0.784557605	38.50429603	0.202591183
136.5	-0.78475917	38.87605489	0.20271698
137.5	-0.785539703	39.24774707	0.202802535
138.5	-0.786904102	39.61914076	0.202848049
139.5	-0.788858208	39.98999994	0.202853758
140.5	-0.791403051	40.36009244	0.202820053
141.5	-0.794546352	40.72917544	0.202747236
142.5	-0.79829102	41.09701099	0.202635758
143.5	-0.802640891	41.46335907	0.202486098
144.5	-0.807599577	41.82797963	0.202298783
145.5	-0.813170461	42.19063313	0.202074385
146.5	-0.819356692	42.55108107	0.201813521
147.5	-0.826161176	42.90908653	0.201516851
148.5	-0.833586038	43.2644155	0.201185082
149.5	-0.841634949	43.61683402	0.200818928
150.5	-0.850307441	43.9661169	0.200419208
151.5	-0.859607525	44.31203579	0.199986681
152.5	-0.869534339	44.65437319	0.199522233
153.5	-0.880088651	44.99291356	0.199026736
154.5	-0.891270585	45.32744704	0.198501096
155.5	-0.903079458	45.65777013	0.197946255
156.5	-0.915513542	45.98368656	0.197363191
157.5	-0.928569454	46.30500858	0.196752931
158.5	-0.942245864	46.62155183	0.196116472
159.5	-0.956537923	46.93314404	0.19545489
160.5	-0.971440492	47.23962058	0.194769279
161.5	-0.986947308	47.54082604	0.194060758
162.5	-1.003050887	47.83661466	0.193330477
163.5	-1.019742425	48.12685082	0.192579614
164.5	-1.037011698	48.41140938	0.191809374
165.5	-1.054846957	48.69017613	0.191020995
166.5	-1.073234825	48.9630481	0.190215739
167.5	-1.092160195	49.22993391	0.189394901
168.5	-1.111606122	49.49075409	0.188559804
169.5	-1.131553723	49.74544132	0.187711798
170.5	-1.151982079	49.99394068	0.186852266
171.5	-1.172868141	50.23620985	0.185982617
172.5	-1.19418462	50.47222213	0.185104331
173.5	-1.215907492	50.70195581	0.184218803
174.5	-1.238005268	50.92540942	0.183327556
175.5	-1.260445591	51.14259229	0.182432113
176.5	-1.283193626	51.3535268	0.181534018
177.5	-1.306212032	51.55824831	0.180634839
178.5	-1.329460945	51.75680513	0.179736168
179.5	-1.35289798	51.94925841	0.178839614
180.5	-1.376478254	52.13568193	0.177946804
181.5	-1.400154426	52.31616197	0.177059379
182.5	-1.423876772	52.49079703	0.17617899
183.5	-1.447593267	52.65969757	0.175307296
184.5	-1.471249702	52.82298572	0.174445958
185.5	-1.494789826	52.9807949	0.173596636
186.5	-1.518155513	53.13326946	0.172760982
187.5	-1.541286949	53.28056425	0.17194064
188.5	-1.564122852	53.42284417	0.171137232
189.5	-1.586600712	53.5602837	0.170352363
190.5	-1.608657054	53.69306637	0.169587605
191.5	-1.630227728	53.82138422	0.168844497
192.5	-1.651248208	53.94543725	0.168124538
193.5	-1.67165392	54.06543278	0.167429179
194.5	-1.691380583	54.18158486	0.166759816
195.5	-1.710364557	54.29411356	0.166117788
196.5	-1.728543207	54.40324431	0.165504365
197.5	-1.745855274	54.50920717	0.164920747
198.5	-1.762241248	54.61223603	0.164368054
199.5	-1.777643747	54.71256787	0.16384732
200.5	-1.792007891	54.81044184	0.163359491
201.5	-1.805281675	54.90609842	0.162905415
202.5	-1.817416335	54.99977846	0.162485839
203.5	-1.828366707	55.09172217	0.162101402
204.5	-1.838091576	55.18216811	0.161752634
205.5	-1.846554015	55.271352	0.161439944
206.5	-1.853721704	55.35950558	0.161163623
207.5	-1.859567242	55.44685531	0.160923833
208.5	-1.864068443	55.53362107	0.160720609
209.5	-1.86720861	55.62001464	0.16055385
210.5	-1.8689768	55.70623826	0.160423319
211.5	-1.869371157	55.79247939	0.160328578
212.5	-1.868386498	55.87892356	0.160269232
213.5	-1.866033924	55.96573022	0.160244549
214.5	-1.862327775	56.05304601	0.160253714
215.5	-1.857289195	56.14099882	0.160295765
216.5	-1.850946286	56.22969564	0.16036959
217.5	-1.84333425	56.3192203	0.16047393
218.5	-1.834495505	56.40963105	0.160607377
219.5	-1.824479785	56.50095811	0.16076838
220.5	-1.813344222	56.59320107	0.160955249
221.5	-1.801153404	56.68632619	0.161166157
222.5	-1.787979408	56.78026364	0.161399151
223.5	-1.773901816	56.87490465	0.161652158
224.5	-1.759007704	56.97009856	0.161922998
225.5	-1.743391606	57.06564989	0.162209399
226.5	-1.72715546	57.16131528	0.162509006
227.5	-1.710410733	57.25679821	0.162819353
228.5	-1.693267093	57.35175792	0.163138124
229.5	-1.67585442	57.44578172	0.163462715
230.5	-1.658302847	57.53840429	0.163790683
231.5	-1.640747464	57.62910094	0.164119574
232.5	-1.623332891	57.7172758	0.164446997
233.5	-1.606209374	57.80226553	0.164770638
234.5	-1.589533346	57.88333502	0.165088289
235.5	-1.573467222	57.95967458	0.165397881
236.5	-1.558179166	58.0303973	0.165697507
237.5	-1.543846192	58.09453209	0.165985386
238.5	-1.530642461	58.15103575	0.166260109
239.5	-1.518754013	58.1987714	0.16652037
240	-1.51336185	58.21897289	0.166644749

__END__

=head1 NAME

Medical::Growth::NHANES_2000::Weight_for_Age::Child::Female

=head1 SYNOPSIS

  use Medical::Growth::NHANES_2000;
  Medical::Growth::NHANES_2000->find_measure_class(
    ages => 'Child', sex => 'Female',
    measure => 'Weight for Age')->pct_for_value($wt,$age);

=head1 DESCRIPTION

This class provides the NHANES 2000 parameters for weight-for-age
tables for girls ages 2-20 years.

Weight values are expressed in kilograms, and ages in months.

For details of the methods provided to operate on observations, please see
L<Medical::Growth::NHANES_2000::Base>.  For overall information on use of
the NHANES 2000 system, please see L<Medical::Growth::NHANES_2000>.

=head1 VERSION

version 1.00

=head1 AUTHOR

Charles Bailey <cbail@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2012-2014 Charles Bailey.

This software may be used under the terms of the Artistic License or
the GNU General Public License, as the user prefers.

=head1 ACKNOWLEDGMENT

The code incorporated into this package was originally written with
United States federal funding as part of research work done by the
author at the Children's Hospital of Philadelphia.

=cut
