# Generated by default/object.tt
package Paws::AppMesh::TlsValidationContext;
  use Moose;
  has SubjectAlternativeNames => (is => 'ro', isa => 'Paws::AppMesh::SubjectAlternativeNames', request_name => 'subjectAlternativeNames', traits => ['NameInRequest']);
  has Trust => (is => 'ro', isa => 'Paws::AppMesh::TlsValidationContextTrust', request_name => 'trust', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::TlsValidationContext

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::TlsValidationContext object:

  $service_obj->Method(Att1 => { SubjectAlternativeNames => $value, ..., Trust => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::TlsValidationContext object:

  $result = $service_obj->Method(...);
  $result->Att1->SubjectAlternativeNames

=head1 DESCRIPTION

An object that represents how the proxy will validate its peer during
Transport Layer Security (TLS) negotiation.

=head1 ATTRIBUTES


=head2 SubjectAlternativeNames => L<Paws::AppMesh::SubjectAlternativeNames>

A reference to an object that represents the SANs for a Transport Layer
Security (TLS) validation context.


=head2 B<REQUIRED> Trust => L<Paws::AppMesh::TlsValidationContextTrust>

A reference to where to retrieve the trust chain when validating a
peerE<rsquo>s Transport Layer Security (TLS) certificate.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

