# Generated by default/object.tt
package Paws::SESv2::ListContactsFilter;
  use Moose;
  has FilteredStatus => (is => 'ro', isa => 'Str');
  has TopicFilter => (is => 'ro', isa => 'Paws::SESv2::TopicFilter');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::ListContactsFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::ListContactsFilter object:

  $service_obj->Method(Att1 => { FilteredStatus => $value, ..., TopicFilter => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::ListContactsFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->FilteredStatus

=head1 DESCRIPTION

A filter that can be applied to a list of contacts.

=head1 ATTRIBUTES


=head2 FilteredStatus => Str

The status by which you are filtering: C<OPT_IN> or C<OPT_OUT>.


=head2 TopicFilter => L<Paws::SESv2::TopicFilter>

Used for filtering by a specific topic preference.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

