# This Makefile.PL for Image-Leptonica was generated by
# inc::LeptonicaMakeMaker <self>.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;



use ExtUtils::MakeMaker ;



my %WriteMakefileArgs = (
  "ABSTRACT" => "bindings to the Leptonica image processing library",
  "AUTHOR" => "Zakariyya Mughal <zmughal\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "Alien::Leptonica" => 0,
    "ExtUtils::MakeMaker" => 0,
    "Inline" => "0.67",
    "Inline::C" => "0.62",
    "Inline::MakeMaker" => "0.45"
  },
  "DISTNAME" => "Image-Leptonica",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Image::Leptonica",
  "PREREQ_PM" => {
    "Alien::Leptonica" => 0,
    "ExtUtils::Depends" => 0,
    "ExtUtils::MakeMaker" => "6.52",
    "File::Spec::Functions" => 0,
    "Inline" => "0.67",
    "Inline::C" => "0.62",
    "Inline::MakeMaker" => "0.45",
    "Path::Class" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Module::Load" => 0,
    "Test::More" => 0
  },
  "VERSION" => "0.04",
  "test" => {
    "TESTS" => "t/*.t"
  }
);
use Inline::MakeMaker;
use ExtUtils::Depends;
use File::Spec::Functions;
use File::Path qw(make_path);
use File::Copy;
$WriteMakefileArgs{CONFIGURE} = sub {
	require Alien::Leptonica;
	my $l = Alien::Leptonica->new;
	my $pkg = ExtUtils::Depends->new('Image::Leptonica',);
	$pkg->set_inc( $l->cflags );
	$pkg->set_libs( $l->libs );

	# make path to install to
	my @dir = qw( lib Image Leptonica Install );
	make_path catfile @dir;

	my $typemap_path = catfile( @dir, 'typemap');
	$pkg->add_typemaps( $typemap_path );
	# copy typemap into that path
	copy( 'typemap', $typemap_path );

	# save config to that path
	$pkg->save_config( catfile( @dir, 'Files.pm' ) );

	+{ CCFLAGS => $l->cflags,
	   LIBS => $l->libs,
	   $pkg->get_makefile_vars()  };
};


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



