/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.hslf.usermodel.HSLFAutoShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.usermodel.FreeformShape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;

public final class HSLFFreeformShape
extends HSLFAutoShape
implements FreeformShape<HSLFShape, HSLFTextParagraph> {
    private static final POILogger LOG = POILogFactory.getLogger(HSLFFreeformShape.class);
    private static final byte[] SEGMENTINFO_MOVETO = new byte[]{0, 64};
    private static final byte[] SEGMENTINFO_LINETO = new byte[]{0, -84};
    private static final byte[] SEGMENTINFO_ESCAPE = new byte[]{1, 0};
    private static final byte[] SEGMENTINFO_ESCAPE2 = new byte[]{1, 32};
    private static final byte[] SEGMENTINFO_CUBICTO = new byte[]{0, -83};
    private static final byte[] SEGMENTINFO_CLOSE = new byte[]{1, 96};
    private static final byte[] SEGMENTINFO_END = new byte[]{0, -128};
    private static final BitField PATH_INFO = BitFieldFactory.getInstance(57344);

    protected HSLFFreeformShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public HSLFFreeformShape(ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super((EscherContainerRecord)null, parent);
        this.createSpContainer(ShapeType.NOT_PRIMITIVE, parent instanceof HSLFGroupShape);
    }

    public HSLFFreeformShape() {
        this((ShapeContainer<HSLFShape, HSLFTextParagraph>)null);
    }

    @Override
    public int setPath(Path2D.Double path) {
        Rectangle2D bounds = path.getBounds2D();
        PathIterator it = path.getPathIterator(new AffineTransform());
        ArrayList<byte[]> segInfo = new ArrayList<byte[]>();
        ArrayList<Point2D.Double> pntInfo = new ArrayList<Point2D.Double>();
        boolean isClosed = false;
        int numPoints = 0;
        while (!it.isDone()) {
            double[] vals = new double[6];
            int type = it.currentSegment(vals);
            switch (type) {
                case 0: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(SEGMENTINFO_MOVETO);
                    ++numPoints;
                    break;
                }
                case 1: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_ESCAPE);
                    ++numPoints;
                    break;
                }
                case 3: {
                    pntInfo.add(new Point2D.Double(vals[0], vals[1]));
                    pntInfo.add(new Point2D.Double(vals[2], vals[3]));
                    pntInfo.add(new Point2D.Double(vals[4], vals[5]));
                    segInfo.add(SEGMENTINFO_CUBICTO);
                    segInfo.add(SEGMENTINFO_ESCAPE2);
                    ++numPoints;
                    break;
                }
                case 2: {
                    LOG.log(5, "SEG_QUADTO is not supported");
                    break;
                }
                case 4: {
                    pntInfo.add((Point2D.Double)pntInfo.get(0));
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_ESCAPE);
                    segInfo.add(SEGMENTINFO_LINETO);
                    segInfo.add(SEGMENTINFO_CLOSE);
                    isClosed = true;
                    ++numPoints;
                    break;
                }
                default: {
                    LOG.log(5, "Ignoring invalid segment type " + type);
                }
            }
            it.next();
        }
        if (!isClosed) {
            segInfo.add(SEGMENTINFO_LINETO);
        }
        segInfo.add(SEGMENTINFO_END);
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = new EscherArrayProperty(16709, false, null);
        verticesProp.setNumberOfElementsInArray(pntInfo.size());
        verticesProp.setNumberOfElementsInMemory(pntInfo.size());
        verticesProp.setSizeOfElements(8);
        for (int i = 0; i < pntInfo.size(); ++i) {
            Point2D.Double pnt = (Point2D.Double)pntInfo.get(i);
            byte[] data = new byte[8];
            LittleEndian.putInt(data, 0, Units.pointsToMaster(pnt.getX() - bounds.getX()));
            LittleEndian.putInt(data, 4, Units.pointsToMaster(pnt.getY() - bounds.getY()));
            verticesProp.setElement(i, data);
        }
        opt.addEscherProperty(verticesProp);
        EscherArrayProperty segmentsProp = new EscherArrayProperty(16710, false, null);
        segmentsProp.setNumberOfElementsInArray(segInfo.size());
        segmentsProp.setNumberOfElementsInMemory(segInfo.size());
        segmentsProp.setSizeOfElements(2);
        for (int i = 0; i < segInfo.size(); ++i) {
            byte[] seg = (byte[])segInfo.get(i);
            segmentsProp.setElement(i, seg);
        }
        opt.addEscherProperty(segmentsProp);
        opt.addEscherProperty(new EscherSimpleProperty(322, Units.pointsToMaster(bounds.getWidth())));
        opt.addEscherProperty(new EscherSimpleProperty(323, Units.pointsToMaster(bounds.getHeight())));
        opt.sortProperties();
        this.setAnchor(bounds);
        return numPoints;
    }

    @Override
    public Path2D.Double getPath() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherArrayProperty verticesProp = (EscherArrayProperty)HSLFFreeformShape.getShapeProp(opt, 325);
        EscherArrayProperty segmentsProp = (EscherArrayProperty)HSLFFreeformShape.getShapeProp(opt, 326);
        Path2D.Double path = new Path2D.Double();
        if (verticesProp == null) {
            LOG.log(5, "Freeform is missing GEOMETRY__VERTICES ");
            return path;
        }
        if (segmentsProp == null) {
            LOG.log(5, "Freeform is missing GEOMETRY__SEGMENTINFO ");
            return path;
        }
        Iterator<byte[]> vertIter = verticesProp.iterator();
        Iterator<byte[]> segIter = segmentsProp.iterator();
        double[] xyPoints = new double[2];
        while (vertIter.hasNext() && segIter.hasNext()) {
            byte[] segElem = segIter.next();
            PathInfo pi = HSLFFreeformShape.getPathInfo(segElem);
            if (pi == null) continue;
            switch (pi) {
                case escape: {
                    break;
                }
                case moveTo: {
                    this.fillPoint(vertIter.next(), xyPoints);
                    double x = xyPoints[0];
                    double y = xyPoints[1];
                    path.moveTo(x, y);
                    break;
                }
                case curveTo: {
                    this.fillPoint(vertIter.next(), xyPoints);
                    double x1 = xyPoints[0];
                    double y1 = xyPoints[1];
                    this.fillPoint(vertIter.next(), xyPoints);
                    double x2 = xyPoints[0];
                    double y2 = xyPoints[1];
                    this.fillPoint(vertIter.next(), xyPoints);
                    double x3 = xyPoints[0];
                    double y3 = xyPoints[1];
                    path.curveTo(x1, y1, x2, y2, x3, y3);
                    break;
                }
                case lineTo: {
                    if (!vertIter.hasNext()) break;
                    this.fillPoint(vertIter.next(), xyPoints);
                    double x = xyPoints[0];
                    double y = xyPoints[1];
                    path.lineTo(x, y);
                    break;
                }
                case close: {
                    path.closePath();
                    break;
                }
            }
        }
        EscherSimpleProperty shapePath = (EscherSimpleProperty)HSLFFreeformShape.getShapeProp(opt, 324);
        ShapePath sp = ShapePath.valueOf(shapePath == null ? 1 : shapePath.getPropertyValue());
        if (sp == ShapePath.LINES_CLOSED || sp == ShapePath.CURVES_CLOSED) {
            path.closePath();
        }
        Rectangle2D anchor = this.getAnchor();
        Rectangle2D bounds = path.getBounds2D();
        AffineTransform at = new AffineTransform();
        at.translate(anchor.getX(), anchor.getY());
        at.scale(anchor.getWidth() / bounds.getWidth(), anchor.getHeight() / bounds.getHeight());
        return new Path2D.Double(at.createTransformedShape(path));
    }

    private void fillPoint(byte[] xyMaster, double[] xyPoints) {
        int y;
        int x;
        if (xyMaster == null || xyPoints == null) {
            LOG.log(5, "Master bytes or points not set - ignore point");
            return;
        }
        if (xyMaster.length != 4 && xyMaster.length != 8 || xyPoints.length != 2) {
            LOG.log(5, "Invalid number of master bytes for a single point - ignore point");
            return;
        }
        if (xyMaster.length == 4) {
            x = LittleEndian.getShort(xyMaster, 0);
            y = LittleEndian.getShort(xyMaster, 2);
        } else {
            x = LittleEndian.getInt(xyMaster, 0);
            y = LittleEndian.getInt(xyMaster, 4);
        }
        xyPoints[0] = Units.masterToPoints(x);
        xyPoints[1] = Units.masterToPoints(y);
    }

    private static <T extends EscherProperty> T getShapeProp(AbstractEscherOptRecord opt, int propId) {
        Object prop = HSLFFreeformShape.getEscherProperty(opt, (short)(propId + 16384));
        if (prop == null) {
            prop = HSLFFreeformShape.getEscherProperty(opt, propId);
        }
        return prop;
    }

    private static PathInfo getPathInfo(byte[] elem) {
        int elemUS = LittleEndian.getUShort(elem, 0);
        int pathInfo = PATH_INFO.getValue(elemUS);
        return PathInfo.valueOf(pathInfo);
    }

    static enum ShapePath {
        LINES(0),
        LINES_CLOSED(1),
        CURVES(2),
        CURVES_CLOSED(3),
        COMPLEX(4);

        private final int flag;

        private ShapePath(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        static ShapePath valueOf(int flag) {
            for (ShapePath v : ShapePath.values()) {
                if (v.flag != flag) continue;
                return v;
            }
            return null;
        }
    }

    static enum EscapeInfo {
        EXTENSION(0),
        ANGLE_ELLIPSE_TO(1),
        ANGLE_ELLIPSE(2),
        ARC_TO(3),
        ARC(4),
        CLOCKWISE_ARC_TO(5),
        CLOCKWISE_ARC(6),
        ELLIPTICAL_QUADRANT_X(7),
        ELLIPTICAL_QUADRANT_Y(8),
        QUADRATIC_BEZIER(9),
        NO_FILL(10),
        NO_LINE(11),
        AUTO_LINE(12),
        AUTO_CURVE(13),
        CORNER_LINE(14),
        CORNER_CURVE(15),
        SMOOTH_LINE(16),
        SMOOTH_CURVE(17),
        SYMMETRIC_LINE(18),
        SYMMETRIC_CURVE(19),
        FREEFORM(20),
        FILL_COLOR(21),
        LINE_COLOR(22);

        private final int flag;

        private EscapeInfo(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        static EscapeInfo valueOf(int flag) {
            for (EscapeInfo v : EscapeInfo.values()) {
                if (v.flag != flag) continue;
                return v;
            }
            return null;
        }
    }

    static enum PathInfo {
        lineTo(0),
        curveTo(1),
        moveTo(2),
        close(3),
        end(4),
        escape(5),
        clientEscape(6);

        private final int flag;

        private PathInfo(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        static PathInfo valueOf(int flag) {
            for (PathInfo v : PathInfo.values()) {
                if (v.flag != flag) continue;
                return v;
            }
            return null;
        }
    }
}

