# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Audio-GSM.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use Test::More (tests => 6);
BEGIN { use_ok('Audio::GSM') };


my $fail = 0;
foreach my $constname (qw(
	GSM_MAGIC GSM_MAJOR GSM_MINOR GSM_OPT_FAST GSM_OPT_FRAME_CHAIN
	GSM_OPT_FRAME_INDEX GSM_OPT_LTP_CUT GSM_OPT_VERBOSE GSM_OPT_WAV49
	GSM_PATCHLEVEL NeedFunctionPrototypes)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Audio::GSM macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my $gsm = new_ok('Audio::GSM');
ok(
   $gsm->option(GSM_OPT_WAV49) == 0
   && $gsm->option(GSM_OPT_WAV49, 0) == 0
   && $gsm->option(GSM_OPT_WAV49, 1) == 0
   && $gsm->option(GSM_OPT_WAV49, 1) == 1
   && $gsm->option(GSM_OPT_WAV49) == 1,
   'option'
);
my $gsmData = pack('H*', '265899A122842483D1B7EF43C1AA253E51CDCC4701412F3942CE41D7E1548FB1611E99F36E457835146F95561EB10D1C54AB59254212FEB679F81AE974CEABB10093');
my $pcmData = pack('H*', '00000000000000000000000000000000000000000000000000000001FFFF0002FFFE0002FFFE00010000FFFE0007FFF1006C011C019701C40193016A00BBFFB4FEC9FE26FE54FF14001B011B01CD025C02A803420345035C03E003EA0401044904D404AC04B2044603D8039D02A302A00226017D012C00970087FFEEFFB0FFDDFFCE00350058005CFFFFFFBBFF87FF81FF74FF56FFF0FFDBFFEAFF87FF38FF48FE97FE65FE3CFDC2FE06FDD8FD3DFD5DFCADFC5AFC75FCC2FD1FFD8FFE3CFEC9FED5FEE3FF2DFEBFFF44FF3CFF99001AFFDF00570032FFD2FF98007200D100B800E00051008D00600040005DFFC5FFAA0034FFD5FFAF0002FF8CFFF1FFF2FFD5FF60FF97FF3DFEEEFFF5FF57FF80FE7BFE77FEEFFEDCFF9FFF3C006E00C2012A015400A600BB000A004D00BB01590197013401F501FA015C0181019101FE02B902F3034103070310038903DD049F0538060605C205C5054604410449034E0348034F0386034E025C01FA010F002EFEE1FE38FD83FD41FCC1FC29FD0EFCCAFD31FCB2FC2CFCF0FC45FD1FFD51FCEFFD5CFD15FD36FD79FE33FE5EFEE2FF02FE93FEF2FE89FE88FE1BFDDCFE12FE5CFE4AFD83FDBAFD5CFD3AFD37FD58FDDBFDD6FDF4FDEAFDEAFD8DFD50FD5EFDAEFDD5FD76FD18FCECFCB0FC17FBCFFB58FAE3FACBFA5AFA03FA1FFA2CFA69FA88FA96FB42FBC4FC2EFC99FD2CFD7DFE0EFED3FF29000900BC016901F9027C02910258029202A5028A026D02DE030403680382030F0337033F035502D702BD02DD028202E703590401048D0498047B03F603370210019E017601350179017A019501320070FFA2FF6BFF8FFF56FFB8001E007700D5011A01400144014C01110125017C020C02AF02A602BE02FE02E302B40292');
is(length($gsm->encode($pcmData)), 65, 'encode');
is(length($gsm->decode($gsmData)), 640, 'decode');
