#!/usr/bin/perl

package eBay::API::XML::Call::GetCategories::GetCategoriesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategoriesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategories::GetCategoriesResponseType

=head1 DESCRIPTION

Contains the category data for the eBay site specified as input. The category
data is contained in a CategoryArrayType object, within which are zero, one, or
multiple CategoryType objects. Each CategoryType object contains the detail data
for one category. Other fields tell how many categories are returned in a call,
when the category hierarchy was last updated, and the version of the category
hierarchy (all three of which can differ from one eBay site to the next).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategories::GetCategoriesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::CategoryArrayType;


my @gaProperties = ( [ 'CategoryArray', 'ns:CategoryArrayType', ''
	     ,'eBay::API::XML::DataType::CategoryArrayType', '1' ]
	, [ 'CategoryCount', 'xs:int', '', '', '' ]
	, [ 'CategoryVersion', 'xs:string', '', '', '' ]
	, [ 'MinimumReservePrice', 'xs:double', '', '', '' ]
	, [ 'ReduceReserveAllowed', 'xs:boolean', '', '', '' ]
	, [ 'ReservePriceAllowed', 'xs:boolean', '', '', '' ]
	, [ 'UpdateTime', 'xs:dateTime', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryArray()

List of the returned categories. The category array contains one CategoryType
object for each returned category. Returns empty if no detail level is specified.

#    Argument: 'ns:CategoryArrayType'

=cut

sub setCategoryArray {
  my $self = shift;
  $self->{'CategoryArray'} = shift
}

=head2 getCategoryArray()

  Returned: Always
  Details: DetailLevel: ReturnAll
#    Returns: 'ns:CategoryArrayType'

=cut

sub getCategoryArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CategoryArray'
		,'eBay::API::XML::DataType::CategoryArrayType');
}


=head2 setCategoryCount()

Indicates the number of categories returned (i.e., the number of CategoryType
objects in CategoryArray).

#    Argument: 'xs:int'

=cut

sub setCategoryCount {
  my $self = shift;
  $self->{'CategoryCount'} = shift
}

=head2 getCategoryCount()

  Returned: Always
  Details: DetailLevel: ReturnAll
#    Returns: 'xs:int'

=cut

sub getCategoryCount {
  my $self = shift;
  return $self->{'CategoryCount'};
}


=head2 setCategoryVersion()

Indicates the version of the category hierarchy on the
specified eBay site.

#    Argument: 'xs:string'

=cut

sub setCategoryVersion {
  my $self = shift;
  $self->{'CategoryVersion'} = shift
}

=head2 getCategoryVersion()

  Returned: Always
  Details: DetailLevel: ReturnAll, none
#    Returns: 'xs:string'

=cut

sub getCategoryVersion {
  my $self = shift;
  return $self->{'CategoryVersion'};
}


=head2 setMinimumReservePrice()

Indicates the lowest possible reserve price allowed for any item
listed in any category on the site. You can use the fields returned by GetCategoryFeatures to determine if a different Minimum Reserve Price is defined for the category you want to use.

#    Argument: 'xs:double'

=cut

sub setMinimumReservePrice {
  my $self = shift;
  $self->{'MinimumReservePrice'} = shift
}

=head2 getMinimumReservePrice()

  Returned: Always
  Details: DetailLevel: ReturnAll, none
#    Returns: 'xs:double'

=cut

sub getMinimumReservePrice {
  my $self = shift;
  return $self->{'MinimumReservePrice'};
}


=head2 setReduceReserveAllowed()

If true, ReduceReserveAllowed indicates that all categories on the
site allow the seller to reduce an item's reserve price.
If false, this field is not returned in the response and all categories on the site do not normally allow sellers to reduce an
item's reserve price.
The Category.ORRA (override reduce reserve price) field can override (or toggle)
the reserve price reduction setting for a given category.
For example, if ReduceReserveAllowed is false and Category.ORRA is true,
the category overrides the site setting and supports reducing reserve prices.
If ReduceReserveAllowed is true and Category.ORRA is true, the category
overrides the site setting and does does not support reducing reserve prices.

#    Argument: 'xs:boolean'

=cut

sub setReduceReserveAllowed {
  my $self = shift;
  $self->{'ReduceReserveAllowed'} = shift
}

=head2 isReduceReserveAllowed()

  Returned: Always
  Details: DetailLevel: ReturnAll, none
#    Returns: 'xs:boolean'

=cut

sub isReduceReserveAllowed {
  my $self = shift;
  return $self->{'ReduceReserveAllowed'};
}


=head2 setReservePriceAllowed()

If true, ReservePriceAllowed indicates that all categories on the
site allow the seller to specify a reserve price for an item.
If false, this field is not returned in the response and all categories on the site do not normally allow sellers to specify reserve prices.
The Category.ORPA (override reserve price allowed) field can override (or toggle)
the reserve price allowed setting for a given category.
For example, if ReservePriceAllowed is false and Category.ORPA is true,
the category overrides the site setting and supports reserve prices.
If ReservePriceAllowed is true and Category.ORPA is true, the category
overrides the site setting and does does not support reserve prices.

#    Argument: 'xs:boolean'

=cut

sub setReservePriceAllowed {
  my $self = shift;
  $self->{'ReservePriceAllowed'} = shift
}

=head2 isReservePriceAllowed()

  Returned: Always
  Details: DetailLevel: ReturnAll, none
#    Returns: 'xs:boolean'

=cut

sub isReservePriceAllowed {
  my $self = shift;
  return $self->{'ReservePriceAllowed'};
}


=head2 setUpdateTime()

Indicates the last date and time that eBay modified the category hierarchy for the
specified eBay site.

#    Argument: 'xs:dateTime'

=cut

sub setUpdateTime {
  my $self = shift;
  $self->{'UpdateTime'} = shift
}

=head2 getUpdateTime()

  Returned: Always
  Details: DetailLevel: ReturnAll, none
#    Returns: 'xs:dateTime'

=cut

sub getUpdateTime {
  my $self = shift;
  return $self->{'UpdateTime'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
