{$N-,E-}
Unit bibcrt;

interface

Uses DOS, Objects, bibstrg;

Const
  MaxScrLen=60;           { Maximal allowed screen height         }
  MaxScrWidth=132;        { Maximal allowed screen width          }

  { Foreground and background color Constants }
  Black         = 0;
  Blue          = 1;
  Green         = 2;
  Cyan          = 3;
  Red           = 4;
  Magenta       = 5;
  Brown         = 6;
  LightGray     = 7;

  { Foreground color Constants }
  DarkGray      = 8;
  LightBlue     = 9;
  LightGreen    = 10;
  LightCyan     = 11;
  LightRed      = 12;
  LightMagenta  = 13;
  Yellow        = 14;
  White         = 15;
 
  PrnReady = $90;
  OffLine = $00;
  OffLine2 = $10;
  PaperOut = $20;
  PaperOut2 = $30;
  HookedButOff = $80;
  NoConnect = $B0;

Type
  AdapterType = (none,mda,cga,egaMono,egaColor,vgaMono,
                 vgaColor,mcgaMono,mcgaColor);
  Taskers = (NoTasker, DesqView, DoubleDOS, Windows, OS2, NetWare, DRDOS,
             UnknownTasker, AutoTasker);

Var
  OldVidMode     : Byte;
  MultiTasking   : Boolean;
  MultiTasker    : Taskers;
  VideoSeg       : Word;
  VideoOfs       : Word;
  VideoBuf       : Pointer;
  DirectVideo    : boolean;
  ScrLen,ScrWidth: Integer;
  xpixels,ypixels: byte;
  FixedVideoMode: byte;
  VideoAdapter: adapterType;
  IsVGA,IsEGA,IsMDA,ExtendCBreak,AltPrtScRoutine: boolean;
  UsingCursor,Virtualize_DV: boolean;
  SavedScreenSize: Word;
  OldXcursor,OldYcursor,OldNumColls,OldNumRows: Byte;
  Winx0,Winy0,Winx1,Winy1,GetKeystroke,CheckKeystroke: byte;
  
procedure SetCursor(startline, endline : Byte);
procedure CursorOff;
procedure CursorOn;           { original cursor shape }
procedure BlockCursor;
procedure LineCursor;         { Default Dos cursor }
procedure CheckForMultiTaskers;
procedure TimeSlice;
function  IsColor: boolean;
function  NormalMode: byte;
procedure Get_Video_Mode(var m : byte);
procedure SelectAltPrtSc;
procedure Set_Video_Mode(m : byte);
function  MaxX : Byte;
function  MaxY : Byte;
function  WhereX : Byte;
function  WhereY : Byte;
procedure GotoXY(x,y : Byte);
procedure AbsGotoXY(x,y : Byte);
procedure CLB;
function  KeyPressed : Boolean;
function  ReadKey : Char;
function  IsShift: boolean;
function  IsCtrl: boolean;
function  IsAlt: boolean;
procedure ShiftCtrlAlt(var Shift,Ctrl,Alt: boolean);
procedure Window(a,b,c,d: byte);
function  GetTicks: LongInt;
procedure Delay(ms : Word);
function  PrinterStatus(LPTName: string): Byte;
procedure VgaLines(n: byte);
procedure VideoInit(display: string);
procedure KeyboardInit(kb: string);
procedure ClrScr;

Implementation

Var
  dvaware,PrintRoutineChanged: Boolean;
  origstartline,origendline: byte;

Procedure SetCursor(startline, endline : Byte); Assembler;
Asm
  mov ah, $01
  mov ch, startline
  mov cl, endline
  int $10
end;

Procedure GetCursor(Var startline, endline : Byte); Assembler;
Asm
  mov ah, $03
  mov bh, $00
  int $10
  les di, startline
  mov Byte ptr es:[di], ch
  les di, endline
  mov Byte ptr es:[di], cl
end;

Procedure CursorOff;
begin
  if UsingCursor then setcursor(32, 32);
end;

Procedure CursorOn;
begin
  if not UsingCursor then Exit;
  setcursor(origstartline, origendline);
end;

Procedure BlockCursor;
begin
  if not UsingCursor then Exit;
  if IsMDA
    then setcursor(1, 12)
    else setcursor(1, 7);
end;

Procedure LineCursor;
begin
  if not UsingCursor then Exit;
  if IsMDA
    then setcursor(11, 12)
    else setcursor(6, 7);
end;

procedure CheckForMultiTaskers;  ASSEMBLER;
asm
   @CheckDV:
    mov   AX, $2B01
    mov   CX, $4445
    mov   DX, $5351
    int   $21
    cmp   AL, $FF
    je    @CheckWindows
    mov   MultiTasker, DesqView
    jmp   @CheckDone
   @CheckWindows:
    mov   AX, $1600
    int   $2F
    cmp   AL, $00
    je    @CheckOS2
    cmp   AL, $80
    je    @CheckOS2
    mov   MultiTasker, Windows
    jmp   @CheckDone
   @CheckOS2:
    mov   AX, $3001
    int   $21
    cmp   AL, $0A
    je    @InOS2
    cmp   AL, $14
    jne   @CheckDrDOS
   @InOS2:
    mov   MultiTasker, OS2
    jmp   @CheckDone
   @CheckDrDOS:
    mov   AX, $2700
    int   $2f
    cmp   AL, $FF
    jne   @CheckNetware
    mov   MultiTasker, DRDOS
    jmp   @CheckDone
   @CheckNetware:
    mov   AX,$7A00
    int   $2F
    cmp   AL,$FF
    jne   @CheckDoubleDOS
    mov   MultiTasker, NetWare
    jmp   @CheckDone
   @CheckDoubleDOS:
    mov   AX, $E400
    int   $21
    cmp   AL, $00
    je    @NoTasker
    mov   MultiTasker, DoubleDOS
    jmp   @CheckDone
   @NoTasker:
    mov   MultiTasker, NoTasker
   @CheckDone:
    {-Set MultiTasking }
    mov   MultiTasking, $00
    cmp   MultiTasker, NoTasker
    je    @NoMultiTasker
    mov   MultiTasking, $01
   @NoMultiTasker:
end;                              { CheckForMultiTaskers }

procedure TimeSlice;  ASSEMBLER;
asm
  cmp   MultiTasker, DesqView
  je    @DVwait
  cmp   MultiTasker, DoubleDOS
  je    @DoubleDOSwait
  cmp   MultiTasker, Windows
  je    @WinOS2wait
  cmp   MultiTasker, OS2
  je    @WinOS2wait
  cmp   MultiTasker, NetWare
  je    @Netwarewait
 @Doswait:
  int   $28
  jmp   @WaitDone
 @DVwait:
  mov   AX,$1000
  int   $15
  jmp   @WaitDone
 @DoubleDOSwait:
  mov   AX,$EE01
  int   $21
  jmp   @WaitDone
 @WinOS2wait:
  mov   AX,$1680
  int   $2F
  jmp   @WaitDone
 @Netwarewait:
  mov   BX,$000A
  int   $7A
  jmp   @WaitDone
 @WaitDone:
end;                   { TimeSlice }

function QueryAdapterType : adapterType;

var     regs : Registers;
        code : byte;
begin
  regs.ah := $1a; {vga identify}
  regs.al := $0;  {clear}
  intr($10,regs);
  if regs.al = $1a then { is this a bug ???? }
  begin {ps/2 bios search for ..}
    case regs.bl of {code back in here}
      $00 : queryAdapterType := none;
      $01 : queryAdapterType := mda;
      $02 : queryAdapterType := cga;
      $04 : queryAdapterType := egaColor;
      $05 : queryAdapterType := egaMono;
      $07 : queryAdapterType := vgaMono;
      $08 : queryAdapterType := vgaColor;
      $0A,$0C : queryAdapterType := mcgaColor;
      $0B : queryAdapterType := mcgaMono;
      else queryAdapterType := cga;
    end; {case}
  end {ps/2 search}
  else 
  begin {look for ega bios}
    regs.ah := $12;
    regs.bx := $10; {bl=$10 retrn ega info if ega}
    intr($10,regs);
    if regs.bx <> $10 then {bx unchanged mean no ega}
    begin
      regs.ah := $12; {ega call again}
      regs.bl := $10; {recheck}
      intr($10,regs);
      if (regs.bh = 0) then 
        queryAdapterType := egaColor
      else
        queryAdapterType := egaMono;
    end {ega identification}
  else {mda or cga}
  begin
    intr($11,regs); {get eqpt.}
    code := (regs.al and $30) shr 4;
    case code of
      1,2 : queryAdapterType := cga;
      3   : queryAdapterType := mda;
      else queryAdapterType := none;
    end; {case}
  end {mda, cga}
  end;
end;                                 { queryAdapterType }

function IsColor: boolean;
begin
  IsColor:=VideoAdapter in [cga,egacolor,vgacolor,mcgacolor];
end;

function NormalMode: byte;
begin
  if IsMDA then NormalMode:=7
  else if not IsColor then NormalMode:=2
  else NormalMode:=3;
end;

procedure get_video_mode(var m : byte);
{ Returns the current video mode (from interrupt $10,$f).
  Byte [$40:$49] also contains this information, but might not always
  have the correct value.
}

var
  check_b : byte; {video mode byte : absolute $40:$49}

begin {get_video_mode}
  if FixedVideoMode>0 then m:=FixedVideoMode
  else begin
    asm
      mov ah, 0fh
      int 10h
      mov check_b, al
    end;
    if check_b > 127
      then m:=check_b-128  {last mode change was done without
                                         screen clearing, mode is given by the
                                         low 7 bits}
      else m:=check_b;
  end;
end;                                    { get_video_mode }

procedure GetVideoBuffer(Also_Mode: boolean);
var
  nmode: byte;
begin
  if Also_Mode then get_video_mode(nmode);
  if (Multitasker=DesqView) and not Virtualize_DV then
  begin
    VideoSeg:=0; VideoOfs:=0;
    if IsMDA or (nmode=7) then
    asm
      mov   AH, $FE
      les   DI, [$B0000000]
      int   $10
      mov   VideoSeg, ES
      mov   VideoOfs, DI
    end else
    asm
      mov   AH, $FE
      les   DI, [$B8000000]
      int   $10
      mov   VideoSeg, ES
      mov   VideoOfs, DI
    end;
    if (VideoSeg<$400) or ((VideoSeg>=$B000) and (VideoSeg<=$BFFF)) then 
      Virtualize_DV:=true;
  end;
  if (Multitasker<>DesqView) or Virtualize_DV then
  begin
    if IsMDA or (nmode=7) then VideoSeg:=$B000
    else VideoSeg:=$B800;
    VideoOfs:=$0000;
  end;
{  writeln(VideoSeg,':',VideoOfs); readln; } 
  VideoBuf:=Ptr(VideoSeg,VideoOfs);
end;                                    { GetVideoBuffer }

procedure SelectAltPrtSc;
begin
  if not PrintRoutineChanged then
  begin
    Asm
      mov ah,12h                  {Select alternate printing routine}
      mov bl,20h
      int 10h
    End;
    PrintRoutineChanged:=true;
  end;
end;  

procedure set_video_mode(m : byte);
{ Sets the given video mode (via interrupt $10,0).
  If high bit is on screen is not cleared (works only for text modes?).
}

begin {set_video_mode}
  if FixedVideoMode>0 then exit;
  asm
    mov ah, 00h
    mov al, m
    int 10h
  End;
  ScrLen:=MaxY; ScrWidth:=MaxX;
  GetVideoBuffer(true);
  if AltPrtScRoutine and ((ScrWidth<>80) or (ScrLen<>25)) then SelectAltPrtSc;
end; {set_video_mode}


Function MaxX : Byte;

{----Return horizontal size of textmode in characters}

Var
  r      : Registers;

Begin
  r.ah:=$0F;
  Intr($10,r);
  MaxX:=r.AH;
End; {of MaxX}

{---------------------------------------------------------}

function MaxY: byte;
begin
  MaxY:=Mem[$40:$84]+1;
end;

                        { Changed lately to work around DOSEMU bug }
Function MaxY1 : Byte;

{----Return vertical size of textmode in characters}
Var
  r      : Registers;
  buf    : Array[0..63] Of byte;

Begin
  r.ah:=$1B;
  r.bx:=$00;
  r.es:=Seg(buf);
  r.di:=Ofs(buf);
  Intr($10,r);
  if buf[$22]<=60 then MaxY1:=buf[$22]
  else MaxY1:=25;
End; {of MaxY}

{---------------------------------------------------------}

Function WhereX : Byte;

{----WhereX, aware of textmodes larger than 80x25}

Var
  r : registers;

Begin
  r.ah:=$0f;
  Intr($10,r);
  r.ah:=$03;
  Intr($10,r);
  WhereX:=r.dl+2-Winx0;
End; {of WhereX}

{---------------------------------------------------------}

Function WhereY : Byte;

{----WhereY, aware of textmodes larger than 80x25}


Var
  r : registers;

Begin
  r.ah:=$0f;
  Intr($10,r);
  r.ah:=$03;
  Intr($10,r);
  WhereY:=r.dh+2-Winy0;
End; {of WhereY}

{---------------------------------------------------------}

Procedure GotoXY(x,y : Byte);

Var
  r : registers;

Begin
  r.ah:=$0f;
  Intr($10,r);
  r.ah:=$02;
  r.dh:=y+Winy0-2;
  r.dl:=x+Winx0-2;
  Intr($10,r);
End; {of GotoXY}

Procedure AbsGotoXY(x,y : Byte);

Var
  r : registers;

Begin
  r.ah:=$0f;
  Intr($10,r);
  r.ah:=$02;
  r.dh:=y-1;
  r.dl:=x-1;
  Intr($10,r);
End; {of GotoXY}

procedure CLB; assembler;  { clear keyboard buffer }
asm
  mov ax, 0C00h
  int 21h
end;

function KeyPressed: boolean; assembler;
asm
  mov ah,CheckKeystroke  {%$11}
  int $16
  mov al,0
  jz  @exit
  mov al,1
  @exit:
end;

function ReadKey: Char; assembler;
Asm
  mov ah, 07h
  int 21h
end;

function IsShift: boolean;
Var
  regs :  Registers;
begin
  regs.ah:=2; intr($16,regs);
  IsShift := regs.al AND 3 <> 0;   { Shift pressed  }
end;

function IsCtrl: boolean;
Var
  regs :  Registers;
begin
  regs.ah:=2; intr($16,regs);
  IsCtrl := regs.al AND 4 <> 0;   { Ctrl pressed  }
end;

function IsAlt: boolean;
Var
  regs :  Registers;
begin
  regs.ah:=2; intr($16,regs);
  IsAlt := regs.al AND 8 <> 0;   { Alt pressed  }
end;

procedure ShiftCtrlAlt(var Shift,Ctrl,Alt: boolean);
Var
  regs :  Registers;
begin
  regs.ah:=2; intr($16,regs);
  Shift := regs.al AND 3 <> 0; { Shift pressed  }
  Ctrl := regs.al AND 4 <> 0;  { Ctrl pressed  }
  Alt := regs.al AND 8 <> 0;   { Alt pressed  }
end;

procedure Window(a,b,c,d: byte);
begin
  if c>ScrWidth then c:=ScrWidth;
  if d>ScrLen then d:=ScrLen;
  Winx0:=a; Winy0:=b; Winx1:=c; Winy1:=d;
end;

function GetTicks: LongInt;
var
  regs: Registers;
begin
  regs.ah:=0;
  Intr($1A,regs);
  GetTicks:=regs.dx+65536*regs.cx;
end;                             { GetTicks }

Procedure Delay(ms : Word); Assembler;
Asm 
  mov ax, 1000;
  mul ms;
  mov cx, dx;
  mov dx, ax;
  mov ah, $86;
  int $15;
end;                             { Delay }

Function PrinterStatus(LPTName: string): Byte;
Var
  Regs : Registers;
  C,ErrorCode,NLPTs: Word;
  LPTPort: Word;
begin
  LPTPort:=0;
  for c:=1 to length(LPTName) do LPTName[c]:=UpCase(LPTName[c]);
  if LPTName='LPT2' then LPTPort:=1
  else if LPTName='LPT3' then LPTPort:=2;
  Intr($11,Regs);
  NLPTs:=Regs.AX SHR 14;
  if NLPTs<LPTPort+1 then
  begin
    PrinterStatus:=NoConnect; Exit;
  end;
  With Regs do
  begin
    Ah := 2;
    Dx := LPTport;
    intr($17,Regs);
    ErrorCode := Ah and $B0;
    C := ErrorCode SHL 6;
    if C > 0 then ErrorCode:=$B0;
    PrinterStatus:=ErrorCode;
  end;
end;                             { PrinterStatus }

procedure VGAlines(n: byte);
const
  scan200lines = $1200; scan350lines = $1201; scan400lines = $1202;
  font8x16     = $1114; font8x14     = $1111; font8x8      = $1112;
  VGAColorMode = $0003; VGAMonoMode  = $0002;
type
  tchar8x8=array[0..7] of byte;
  tfont8x8=array[0..255] of tchar8x8;
  tchar8x10=array[0..9] of byte;
  tfont8x10=array[0..255] of tchar8x10;
  tchar8x12=array[0..11] of byte;
  tfont8x12=array[0..255] of tchar8x12;
  tchar8x14=array[0..13] of byte;
  tfont8x14=array[0..255] of tchar8x14;
Var 
  CrtcReg:Array[1..8] of Word;
  Offset:Word;
  i,j,Data: Byte;
  vmode,scan,font: word;
  char8x8     : tchar8x8;
  fontArr8x8  : ^tfont8x8;
  char8x10    : tchar8x10;
  fontArr8x10 : ^tfont8x10;
  char8x12    : tchar8x12;
  fontArr8x12 : ^tfont8x12;
  char8x14    : tchar8x14;
  fontArr8x14 : ^tfont8x14;
  r: registers;
begin
  if not (IsEGA or IsVGA) then Exit;
  if not (n in [12,14,16,20,21,25,28,29,30,33,34,35,40,43,48,50,60]) then exit;
  if (not IsVGA) and not (n in [20,21,25,29,35,43]) then exit;
  if FixedVideoMode>0 then exit;
  vmode:=VGAColorMode; if not IsColor then vmode:=VGAMonoMode;
  fontArr8x10:=Nil; fontArr8x12:=Nil;
  if n in [20,35,40,48] then   { Create 8x10 font from ROM 8x8 font }
  begin
                 {call bios to get font8x8}
    r.ax:=$1130;
    r.bh:=03;
    intr($10,r);
    fontArr8x8:=ptr(r.es,r.bp);
    new(fontArr8x10);
    
                {make char8x10s from char 8x8s}
    for i:=0 to 255 do
    begin
      char8x8:=fontArr8x8^[i];
      for j:=0 to 7 do
        char8x10[j+1]:=char8x8[j];
      case i of
        176..178:
          begin
            char8x10[0]:=char8x8[7];
            char8x10[9]:=char8x8[6]
          end;
        8,10,179..182,185,186,195,197..199,215,216,204,206,219,221,222:
          begin
            char8x10[0]:=char8x8[7];
            char8x10[9]:=char8x8[7]
          end;
        183,184,187,191,194,201,203,209,210,213,214,218,220,244:
          begin
            char8x10[0]:=0;
            char8x10[9]:=char8x8[7]
          end;
        188..192,193,200,202,207,208,211,212,217,223,245:
          begin
            char8x10[0]:=char8x8[0];
            char8x10[9]:=0
          end;
        else
          begin
            char8x10[0]:=0;
            char8x10[9]:=0
          end;
      end;
      fontArr8x10^[i]:=char8x10;
    end;
  end;
  if n in [16,29,33] then  {- Create 8x12 font from ROM 8x14 font -}
  begin
    {call bios to get font8x14}
    r.ax:=$1130;
    r.bh:=02;
    intr($10,r);
    fontArr8x14:=ptr(r.es,r.bp);
    new(fontArr8x12);
    {make char8x12s from char 8x14s}
    for i:=0 to 255 do
    begin
      char8x14:=fontArr8x14^[i];
      for j:=0 to 11 do
        char8x12[j]:=char8x14[j+1];
      fontArr8x12^[i]:=char8x12;
    end;
  end;
  if n in [30,34,48,60] then  { Trick VGA to 480 scan lines }
  begin
    font:=font8x16;
    if n=34 then font:=font8x14
    else if n=60 then font:=font8x8;
    asm                          {First set 400 scan lines and video mode}
      mov ax, scan400lines
      mov bl, 30h
      int 10h
      mov ax, vmode
      int 10h
    end;
    if n=48 then                 { User-defined 8x10 font }
    begin
      with r do
      begin
        ax:=$1110; bx:=$0a00;  cx:=$0100; dx:=0;
        es:=seg(fontArr8x10^); bp:=ofs(fontArr8x10^);
      end;
      intr($10,r);
    end else                     { Usual ROM fonts }
    asm
      mov ax, font
      mov bl, 0h
      int 10h
    end;
    CrtcReg[1]:=$0c11;           {Vertical Display End (unprotect regs. 0-7)}
    CrtcReg[2]:=$0d06;           {Vertical Total}
    CrtcReg[3]:=$3e07;           {Overflow}
    CrtcReg[4]:=$ea10;           {Vertical Retrace Start}
    CrtcReg[5]:=$8c11;           {Vertical Retrace End (& protect regs. 0-7)}
    CrtcReg[6]:=$df12;           {Vertical Display Enable End}
    CrtcReg[7]:=$e715;           {Start Vertical Blanking}
    CrtcReg[8]:=$0616;           {End Vertical Blanking}

    MemW[$0040:$004c]:=8192*((160*n) div 8192 +1); {Change page size in bytes}
    Mem[$0040:$0084]:=n-1;       {Change page length}
    
    Offset:=MemW[$0040:$0063];   {Base of CRTRC}
    Asm
      cli                        {Clear Interrupts}
    End;
  
    For i:=1 to 8 do
      PortW[Offset]:=CrtcReg[i]; {Load Registers}
  
    Data:=Port[$03cc];
    Data:=Data And $33;
    Data:=Data Or $C4;
    Port[$03c2]:=Data;
    Asm
      sti                         {Set Interrupts}
    end;
  end else
  begin
    if n in [12,14,16,20] then Scan:=Scan200Lines
    else if n in [21,29,35,43] then Scan:=Scan350Lines
    else Scan:=Scan400Lines;
    if n in [43,50] then font:=font8x8
    else if n in [14,28] then font:=font8x14
    else font:=font8x16;
    asm                           { Scan lines and video mode }
      mov ax, Scan
      mov bl, 30h
      int 10h
      mov ax, vmode
      int 10h
    end;
    if n in [20,35,40] then        { User-defined 8x10 font }
    begin
      r.ax:=$1110;
      r.bx:=$0a00;
      r.cx:=$0100;
      r.dx:=0;
      r.es:=seg(fontArr8x10^);
      r.bp:=ofs(fontArr8x10^);
      intr($10,r);
    end else if n in [16,29,33] then  { User-defined 8x12 font }
    begin
      r.ax:=$1110;
      r.bx:=$0c00;
      r.cx:=$0100;
      r.dx:=0;
      r.es:=seg(fontArr8x12^);
      r.bp:=ofs(fontArr8x12^);
      intr($10,r);
    end else                       { Video ROM fonts }
    asm
      mov ax, font
      mov bl, 0h
      int 10h
    end;
  end;
  if fontArr8x10<>Nil then dispose(fontArr8x10);
  if fontArr8x12<>Nil then dispose(fontArr8x12);
  ScrLen:=MaxY; ScrWidth:=MaxX;
  GetVideoBuffer(true);
  if AltPrtScRoutine and ((ScrWidth<>80) or (ScrLen<>25)) then SelectAltPrtSc;
end;                                     { VGAlines }

procedure VideoInit(display: string);
begin
  UnTabify(display); ChrDel(display,' '); StrLwr(display);
  if (display='') or (Pos('auto',display)=1) then
    VideoAdapter:=QueryAdapterType
  else begin
    VideoAdapter:=vgacolor;
    if (Pos('vga',display)=1) or (Pos('ega',display)=1)
       or (Pos('mcga',display)=1) then
    begin
      if Pos('vga',display)=1 then VideoAdapter:=vgacolor
      else if Pos('ega',display)=1 then VideoAdapter:=egacolor
      else if Pos('mcga',display)=1 then VideoAdapter:=mcgacolor;
      if Pos('mono',display)>0 then
      begin
        if VideoAdapter=egacolor then VideoAdapter:=egamono
        else if VideoAdapter=vgacolor then VideoAdapter:=vgamono
        else if VideoAdapter=mcgacolor then VideoAdapter:=mcgamono;
      end;
    end else if Pos('cga',display)=1 then VideoAdapter:=cga
    else if (Pos('mda',display)=1) or (Pos('herc',display)=1)
               or (Pos('hgc',display)=1) or (Pos('none',display)=1) then
      VideoAdapter:=mda;
  end;
  IsEGA:=VideoAdapter in [egacolor,egamono];
  IsVGA:=VideoAdapter in [vgacolor,vgamono];
  IsMDA:=VideoAdapter in [none,mda];

  OldNumColls:=MaxX; OldNumRows:=MaxY;
  Xpixels:=8; Ypixels:=8;
  if IsVGA and (OldNumColls=80) and (OldNumRows in [30,48,60]) then
  begin
    if VideoAdapter=vgacolor then OldVidMode:=3
    else OldVidMode:=2;
  end else get_video_mode(OldVidMode);
  ScrLen:=OldNumRows; ScrWidth:=OldNumColls;
  window(1,1,OldNumColls,OldNumRows);
  OldXcursor:=WhereX; OldYcursor:=WhereY;
  GetVideoBuffer(false);
  GetCursor(OrigStartLine, OrigEndLine);
  UsingCursor:=true;
end;                              { VideoInit }

procedure KeyboardInit(kb: string);
var
  enh: boolean;
begin
  UnTabify(kb); ChrDel(kb,' '); StrLwr(kb);
  enh:=true;
  if (kb='') or (Pos('auto',kb)=1) then enh:=(mem[$40:$96] AND $10>0)
  else if (kb='xt') or (kb='88') then enh:=false
  else if (kb='at') or (kb='enhanced') or (kb='101') or (kb='102') then enh:=true;
  if enh then     { Enhanced keyboard }
  begin
    GetKeystroke:=$10;
    CheckKeystroke:=$11;
  end else                         { 88-key keyboard }
  begin
    GetKeystroke:=0;
    CheckKeystroke:=1;
  end;
end;                          { KeyboardInit }

procedure ClrScr;
var
  Space: array[1..MaxScrWidth] of Word;
  i,Xlen: integer;
begin
  if VideoBuf=Nil then exit;
  AbsGotoXY(1,1); write(' ');
  Move(VideoBuf^,Space[1],2);
  Xlen:=MaxX;
  for i:=2 to Xlen do Space[i]:=Space[1];
  for i:=0 to MaxY-1 do
    Move(Space[1],Ptr(VideoSeg,VideoOfs+i*Xlen*2)^,Xlen*2);
  AbsGotoXY(1,1);
end;

begin
  MultiTasker:=AutoTasker;
  MultiTasking:=false;
  DVAware:=true; Virtualize_DV:=false;

  VideoBuf:=Nil;
  FixedVideoMode:=0;
  AltPrtScRoutine:=true;
  PrintRoutineChanged:=false;
end.
