%{
#include "b.tab.h"
#include <X11/Intrinsic.h>
#include "bibview.h"

extern char yylval;
extern int ueIdx;
extern char uebergabe[];
extern int yynline;
extern int yynflexcalls;


%}


%%


"@comment"  { 
	      if (ueIdx+strlen(yytext) >= MAX_UEBERGABE)
	         return COMMENT;
	      strcpy(&uebergabe[ueIdx], yytext);
	      ueIdx += strlen(yytext);
              yynflexcalls += 1;
	      return COMMENT; 
             }

"@string"  {
	      if (ueIdx+strlen(yytext) >= MAX_UEBERGABE)
	         return STRING;
	      strcpy(&uebergabe[ueIdx], yytext);
	      ueIdx += strlen(yytext);
              yynflexcalls += 1;
	      return STRING; 
             }

"@preamble"  {
	      if (ueIdx+strlen(yytext) >= MAX_UEBERGABE)
	         return PREAMBLE;
	      strcpy(&uebergabe[ueIdx], yytext);
	      ueIdx += strlen(yytext);
              yynflexcalls += 1;
	      return PREAMBLE; 
             }

"@"[a-zA-Z]+      {
	           if (ueIdx+strlen(yytext) >= MAX_UEBERGABE)
	             return TYPE;
		   strcpy(&uebergabe[ueIdx], yytext);
		   ueIdx += strlen(yytext);
                   yynflexcalls += 1;
	           return TYPE; 
                  }

"@"        {
             yynflexcalls += 1;
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return AFFE;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return AFFE;
           }

"#"        {
             yynflexcalls += 1;
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return ZAUN;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return ZAUN;
           }


","        {
             yynflexcalls += 1;
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return KOMMA;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return KOMMA;
           }

"("        {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return LRKL;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return LRKL;
           }

")"        {
             yynflexcalls += 1;
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return RRKL;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return RRKL;
           }

"{"        {
             yynflexcalls += 1;
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return LGKL;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return LGKL;
           }

"}"        {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return RGKL;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return RGKL;
           }

"="        {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return EQ;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return EQ;
           }

[\"]        {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return DAZ;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return DAZ;
           }

[%]         {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return PROZENT;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return PROZENT;
           }

[ \t]      {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return WHITE_SPACE;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             if (yytext[0] == '\n') yynline += 1;
             return WHITE_SPACE;
           }

[\n]       {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return NEW_LINE;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             if (yytext[0] == '\n') yynline += 1;
             return NEW_LINE;
           }

[a-zA-Z0-9]  {
               yynflexcalls += 1;
               yylval = yytext[0];
	       if (ueIdx+1 >= MAX_UEBERGABE)
	          return BUCHSTABE_ZAHL;
               uebergabe[ueIdx] = yytext[0];
               uebergabe[ueIdx+1] = '\0';
               ueIdx++;
               return BUCHSTABE_ZAHL;
             }

<<EOF>>  {
           yynflexcalls += 1;
           YY_NEW_FILE;
           ueIdx = 0;
           return 0;
         }

.          {
             yynflexcalls += 1;
             yylval = yytext[0];
	     if (ueIdx+1 >= MAX_UEBERGABE)
	        return ZEICHEN;
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return ZEICHEN;
           }


%%

