#ifndef __TAILOR_H
#  define __TAILOR_H
/*
*  tailor.h:  Machine/target dependent definitions.
*
*
*  Copyright (c) 2000 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



/*
*  $Id: tailor.h 0.04 2000/06/06 00:00:04 tom Exp $
*/



/*
*  Include definitions (sub)header files  ;<
*/
#  include "defines.h"
#  if HAVE_CONFIG_H
#    include <config.h>
#  endif
#  ifndef PACKAGE
#    define  PACKAGE  PRGR_NAME
#  endif
#  ifndef VERSION
#    define  VERSION  VERSION_NO
#  endif
#  if ENABLE_NLS && !USE_DE
/*
*  National language support is only allowed on these systems.
*/
#    define  DVICHK_NLS
#    if HAVE_LOCALE_H
#      include <locale.h>
#    endif
#    include <libintl.h>
#if 0
#    define  _(Str)  (Str)
#endif
#    define  _(Str) gettext(Str)
#    ifdef gettext_noop
#      define  N_(Str)  gettext_noop(Str)
#    else /* !gettext_noop */
#      define  N_(Str)  (Str)
#    endif /* !gettext_noop */
#  else /* !ENABLE_NLS || USE_DE */
#    define   _(Str)  (Str)
#    define  N_(Str)  (Str)
#  endif /* !ENABLE_NLS || USE_DE */



/*
*  Detect the machine / os.
*/
/*
*  Define the symbol MSDOS for MS-DOS machines.
*/
#  if defined(__MSDOS__) || defined(__MSDOS) || defined(_MSDOS)
     /* Now let's define the symbol MSDOS generally. */
#    ifndef MSDOS
#      define MSDOS
#    endif
#  endif
#  if defined(__TURBOC__) || defined(__ZTC__) || defined(M_I86)
     /* Now let's define the symbol MSDOS generally. */
#    ifndef MSDOS
#      define MSDOS
#    endif
#  endif
/*
*  Define the symbol OS2 for OS/2 machines.
*/
#  if defined(__OS2__) || defined(__OS2) || defined(_OS2)
     /* Now let's define the symbol OS2 generally. */
#    ifndef OS2
#      define OS2
#    endif
#  endif
/*
*  Microsoft-C or Borland-C or Waterloo-C under OS/2.
*/
#  if defined(OS2)
#    if defined(MSDOS) || defined(__TURBOC__)
#      ifdef MSDOS
#        undef MSDOS
#      endif
#    endif
#  endif
/*
*  Define the symbol LINUX for Linux machines.
*/
#  if defined(__LINUX__) || defined(__LINUX) || defined(_LINUX) || defined(LINUX)
     /* Now let's define the symbol LINUX generally. */
#    ifndef LINUX
#      define LINUX
#    endif
#  endif
#  if defined(__linux__) || defined(__linux) || defined(_linux) || defined(linux)
     /* Now let's define the symbol LINUX generally. */
#    ifndef LINUX
#      define LINUX
#    endif
#  endif
/*
*  Define the symbol UNIX for UN*X machines.
*/
#  if defined(__UNIX__) || defined(__UNIX) || defined(_UNIX)
     /* Now let's define the symbol UNIX generally. */
#    ifndef UNIX
#      define UNIX
#    endif
#  endif
#  if defined(__unix__) || defined(__unix) || defined(_unix) || defined(unix)
     /* Now let's define the symbol UNIX generally. */
#    ifndef UNIX
#      define UNIX
#    endif
#  endif
#  ifdef MSDOS
#    ifdef UNIX
#      if (defined(__GNUC__) || defined(__GO32__)) && !defined(M_UNIX)
         /* Now let's define the symbol DJG (DJ-GCC under MSDOS) for these machines. */
#        ifndef DJG
#          define DJG
#        endif
#      endif
#      undef MSDOS
#    else /* !UNIX */
#      if defined(__i386) || defined(i386)
         /* Now let's define the symbol SCO for these machines, too. */
#        ifndef SCO
#          define SCO
#        endif
#        undef MSDOS
#      endif
#    endif /* !UNIX */
#  endif /* !MSDOS */



/*
*  Target specific predefines.
*/
#  if defined(MSDOS) || defined(DJG) || defined(WIN32)
#                define  USE_PROTOTYPES 1
#                define  STDC_HEADERS 1
#                define  HAVE_CTYPE_H 1
#                define  HAVE_SYS_STAT_H 1 
#                define  HAVE_LIMITS_H 1
#                define  HAVE_UPPER_LOWER 1
#                define  HAVE_ISDIGIT 1
#                define  HAVE_ISALPHA 1
#                define  HAVE_ISALNUM 1
#                define  HAVE_ISSPACE 1
#                define  HAVE_STRSTR 1
#                define  HAVE_STRDUP 1
#                define  HAVE_VOID 1
#                ifdef DJG
#                  define  HAVE_UNISTD_H 1
                   /* Directory/folder separator. */
#                  define  DIR2_SEP      "/"
#                else /* !DJG */
#                  include <io.h>
#                endif /* !DJG */
                 /* Disk/Drive separator. */
#                define  DISK_SEP      ":"
                 /* Directory/folder separator. */
#                define  DIR_SEP       "\\"
                 /* Path separator. */
#                define  PATH_SEP      ";"
#if 0
                 /* Name of data search path environment variable. */
#                define  ENV_VAR_DPATH "PATH"
#endif
#  else /* !MSDOS && !DJG && !WIN32 */
#    if defined(OS2)
#                define  USE_PROTOTYPES 1
#      if !defined(__GNUC__) && !defined(__EMX__)
#                define  STDC_HEADERS 1
#                define  HAVE_CTYPE_H 1
#                define  HAVE_SYS_STAT_H 1 
#                define  HAVE_LIMITS_H 1
#                define  HAVE_UPPER_LOWER 1
#                define  HAVE_ISDIGIT 1
#                define  HAVE_ISALPHA 1
#                define  HAVE_ISALNUM 1
#                define  HAVE_ISSPACE 1
#                define  HAVE_STRSTR 1
#                define  HAVE_STRDUP 1
#                define  HAVE_VOID 1
#      endif /* !__GCC__ && !__EMX__ */
#                include <io.h>
                 /* Disk/Drive separator. */
#                define  DISK_SEP      ":"
                 /* Directory/folder separator. */
#                define  DIR_SEP       "\\"
                 /* Path separator. */
#                define  PATH_SEP      ";"
#if 0
                 /* Name of data search path environment variable. */
#                define  ENV_VAR_DPATH "DPATH"
#endif
#    else /* !OS2 */
#      if defined(ACORN)
#                define  USE_PROTOTYPES 1
#                define  STDC_HEADERS 1
#                define  HAVE_CTYPE_H 1
#                define  HAVE_SYS_STAT_H 1 
#                define  HAVE_LIMITS_H 1
#                define  HAVE_UPPER_LOWER 1
#                define  HAVE_ISDIGIT 1
#                define  HAVE_ISALPHA 1
#                define  HAVE_ISALNUM 1
#                define  HAVE_ISSPACE 1
#                define  HAVE_STRSTR 1
#                define  HAVE_STRDUP 1
#                define  HAVE_VOID 1
                 /* Disk/Drive separator. */
#                define  DISK_SEP      "$"
                 /* Directory/Folder separator. */
#                define  DIR_SEP       "."
                 /* Path separator. */
#                define  PATH_SEP      ","
                 /* Name of program search path environment variable. */
#                define  ENV_VAR_PATH  "Run$Path"
#if 0
                 /* Name of data search path environment variable. */
#                define  ENV_VAR_DPATH "Run$Path"
#endif
#                ifdef __GNUC__
#                  define  HAVE_UNISTD_H 1
#                endif
#      else /* !ACORN */
#        if defined(AMIGA)
#                define  USE_PROTOTYPES 1
#                define  STDC_HEADERS 1
#                define  HAVE_CTYPE_H 1
#                define  HAVE_SYS_STAT_H 1 
#                define  HAVE_LIMITS_H 1
#                define  HAVE_UPPER_LOWER 1
#                define  HAVE_ISDIGIT 1
#                define  HAVE_ISALPHA 1
#                define  HAVE_ISALNUM 1
#                define  HAVE_ISSPACE 1
#                define  HAVE_STRSTR 1
#                define  HAVE_STRDUP 1
#                define  HAVE_VOID 1
#                ifdef __GNUC__
#                  define  HAVE_UNISTD_H 1
#                endif
#        else /* !AMIGA */
#          if defined(ATARI)
#                define  USE_PROTOTYPES 1
#                ifdef __GNUC__
#                  ifndef STDC_HEADERS
#                    define  STDC_HEADERS 1
#                  endif
#                  define  HAVE_UNISTD_H 1
#                else /* !__GNUC__ */
#                  define  STDC_HEADERS 1
#                endif /* !__GNUC__ */
#                define  HAVE_CTYPE_H 1
#                define  HAVE_SYS_STAT_H 1 
#                define  HAVE_LIMITS_H 1
#                define  HAVE_UPPER_LOWER 1
#                define  HAVE_ISDIGIT 1
#                define  HAVE_ISALPHA 1
#                define  HAVE_ISALNUM 1
#                define  HAVE_ISSPACE 1
#                define  HAVE_STRSTR 1
#                define  HAVE_STRDUP 1
#                define  HAVE_VOID 1
                 /* Directory/folder separator. */
#                define  DIR_SEP       "\\"
                 /* Path separator. */
#                define  PATH_SEP      ","
#          else /* !ATARI */
#            if defined(__50SERIES) || defined(PRIMOS)
                 /* Prime/PRIMOS. */
#                define  USE_PROTOTYPES 1
#                define  STDC_HEADERS 1
#                define  HAVE_CTYPE_H 1
#                define  HAVE_SYS_STAT_H 1 
#                define  HAVE_LIMITS_H 1
#                define  HAVE_UPPER_LOWER 1
#                define  HAVE_ISDIGIT 1
#                define  HAVE_ISALPHA 1
#                define  HAVE_ISALNUM 1
#                define  HAVE_ISSPACE 1
#                define  HAVE_STRSTR 1
#                define  HAVE_STRDUP 1
#                define  HAVE_VOID 1
                 /* Directory/folder separator. */
#                define  DIR_SEP       ">"
#            else /* !__50SERIES */
#              if defined(VAXC) || defined(VMS) || !HAVE_CONFIG_H
                 /* DEC Vax. */
                 /* Now let's define the symbol UNIX as default. */
#                ifndef UNIX
#                  define  UNIX
#                endif
#                define  USE_PROTOTYPES 1
#                define  STDC_HEADERS 1
#                define  HAVE_CTYPE_H 1
#                define  HAVE_SYS_STAT_H 1 
#                define  HAVE_LIMITS_H 1
#                define  HAVE_UPPER_LOWER 1
#                define  HAVE_ISDIGIT 1
#                define  HAVE_ISALPHA 1
#                define  HAVE_ISALNUM 1
#                define  HAVE_ISSPACE 1
#                define  HAVE_STRSTR 1
#                define  HAVE_STRDUP 1
#                define  HAVE_VOID 1
#                ifdef VAXC
#                  include <unixio.h>
#                endif
                 /* Disk/Drive separator. */
#                define  DISK_SEP       ":"
                 /* Directory/folder separator. */
#                define  DIR_SEP        "]"
                 /* Suffix (version number) separator. */
#                define  SUFFIX_SEP     ";"
                 /* Name of programs default options variable. */
#                define  ENV_VAR_DVICHK "DVICHK_OPT"
#              else
                 /*
                    default: UNIX.  Let `configure' detect what's in store .)
                    Now let's define the symbol UNIX (NOT GNU or RMS, hehe) as default
                 */
#                ifndef UNIX
#                  define  UNIX
#                endif
#              endif /* default: UNIX */
#            endif /* !__50SERIES */
#          endif /* !ATARI */
#        endif /* !AMIGA */
#      endif /* !ACORN */
#    endif /* !OS2 */
#  endif /* !MSDOS && !DJG && !WIN32 */



/*
*  More precise attributes.
*/
#  define  LOCAL           static
#  define  PUBLIC       /* Public */
#  define  IMPORT          extern
#  define  EXPORT          IMPORT



/*
*  Compiler specific macro for prototyping.
*/
#  ifndef __P_
#    if (defined(__STDC__) && __STDC__) || defined(__cplusplus) || USE_PROTOTYPES
#      define  __P_(gc_proto)  gc_proto
#    else /* !__STDC__ && !__cplusplus && !USE_PROTOTYPES */
#      define  __P_(gc_proto)  ()
#    endif /* !__STDC__ && !__cplusplus && !USE_PROTOTYPES */
#  endif



/*
*  Function prototype begin and end declarations.
*/
#  ifdef __cplusplus
#    ifndef __BEGIN_DECLARATIONS
#      define  __BEGIN_DECLARATIONS  extern "C" {
#    endif
#    ifndef __END_DECLARATIONS
#      define  __END_DECLARATIONS    }
#    endif
#  else /* !__cplusplus */
#    ifndef __BEGIN_DECLARATIONS
#      define  __BEGIN_DECLARATIONS
#    endif
#    ifndef __END_DECLARATIONS
#      define  __END_DECLARATIONS
#    endif
#  endif /* !__cplusplus */



/*
*  Target specific preprocessor statements.
*/
#  ifdef DVICHK_NLS
/* Name of first used national language environment variable. */
#    define  ENV_VAR_LANGUAGE     "LANGUAGE"

/* Name of second used national language environment variable. */
#    define  ENV_VAR_LC_ALL       "LC_ALL"

/* Name of third used national language environment variable. */
#    if HAVE_LC_MESSAGES
#      define  ENV_VAR_LC_MESSAGES  "LC_MESSAGES"
#    endif

/* Name of fourth used national language environment variable. */
#    define  ENV_VAR_LANG         "LANG"
#  endif



/* The character used to specify the actual directory folder. */
#  ifndef ACTUAL_DIR
#    define  ACTUAL_DIR         "."
#  endif

/* Default directory/folder separator. */
#  ifndef DIR_SEP
#    define  DIR_SEP            "/"
#  endif

/* Default path separator. */
#  ifndef PATH_SEP
#    define  PATH_SEP           ":"
#  endif

/* Name of home directory environment variable. */
#  ifndef ENV_VAR_HOME
#    define  ENV_VAR_HOME       "HOME"
#  endif

/* Name of program search path environment variable. */
#  ifndef ENV_VAR_PATH
#    define  ENV_VAR_PATH       "PATH"
#  endif

/* Name of data search path environment variable. */
#  ifndef ENV_VAR_DPATH
#    define  ENV_VAR_DPATH      "DVICHKPATH"
#  endif

/* Name of programs default options variable. */
#  ifndef ENV_VAR_DVICHK
#    define  ENV_VAR_DVICHK     "DVICHK"
#  endif



/*
*  Define how the German `Umlaute' letters are displayed.
*/
#  if USE_EASC
#    if defined(NeXT)
           /* NeXTstep character set. */
           /* \xd9. */
#          define  AE          "\331"
           /* \xf0. */
#          define  OE          "\360"
           /* \xf6. */
#          define  UE          "\366"
           /* \xfb. */
#          define  SZ          "\373"
           /* \x85. */
#          define  AAE         "\205"
           /* \x96. */
#          define  OOE         "\226"
           /* \x9a. */
#          define  UUE         "\232"
#    else
#      if defined(ATARI)
           /* Atari character set. */
           /* \x84. */
#          define  AE          "\204"
           /* \x94. */
#          define  OE          "\224"
           /* \x81. */
#          define  UE          "\201"
           /* \x9e. */
#          define  SZ          "\236"
           /* \x8e. */
#          define  AAE         "\216"
           /* \x99. */
#          define  OOE         "\231"
           /* \x9a. */
#          define  UUE         "\232"
#      else
#        if defined(MSDOS) || defined(OS2) || defined(WIN32) || defined(SCO) || defined(COHERENT)
           /* IBM PC character set. */
           /* \x84. */
#          define  AE          "\204"
           /* \x94. */
#          define  OE          "\224"
           /* \x81. */
#          define  UE          "\201"
           /* \xe1. */
#          define  SZ          "\341"
           /* \x8e. */
#          define  AAE         "\216"
           /* \x99. */
#          define  OOE         "\231"
           /* \x9a. */
#          define  UUE         "\232"
#        else /* !IBM PC character set */
           /* (defined(UNIX) && !defined(SCO) && !defined(COHERENT) && !defined(NeXT)) || defined(AMIGA) || ... */
           /* ISO Latin-1 character set. */
           /* \xe4. */
#          define  AE          "\344"
           /* \xf6. */
#          define  OE          "\366"
           /* \xfc. */
#          define  UE          "\374"
           /* \xdf. */
#          define  SZ          "\337"
           /* \xc4. */
#          define  AAE         "\304"
           /* \xd6. */
#          define  OOE         "\326"
           /* \xdc. */
#          define  UUE         "\334"
#        endif /* !IBM PC character set. */
#      endif /* Atari character set. */
#    endif /* NeXTstep character set. */
#  else /* !USE_EASC */
#    define  AE          "ae"
#    define  OE          "oe"
#    define  UE          "ue"
#    define  SZ          "ss"
#    define  AAE         "AE"
#    define  OOE         "OE"
#    define  UUE         "UE"
#  endif /* !USE_EASC */
#endif /* __TAILOR_H */
