{$N-,E-,V-}

Unit bibedent;

Interface

uses
  bibwindo, bibCrt, bibstrg, BibMouse, bibvars, bibdisp, bibutil, bibsedit,
  bibedit, bib8bit, bibselct, bibshow, bibclip, objects;

procedure EditEntry(Entry: EntryRecPtr; NewEntry: boolean;
                    Var Scroll: LongInt; var changed: boolean;
                    AlreadyClicked,PatternOn,WithFinish: boolean;
                    var EdExitCode: byte);


Implementation
 

procedure EditEntry(Entry: EntryRecPtr; NewEntry: boolean;
                    Var Scroll: LongInt; var changed: boolean;
                    AlreadyClicked,PatternOn,WithFinish: boolean;
                    var EdExitCode: byte);
var
  line,tmp,oldstr : string;
  i,ii,iii,Mem1,Mem2,LastY : longint;
  Slen,OldSLen: Word;
  entnum,nrows,nrowopt,nrowreq,nopt,nreq,nbr,nused,nunused,Nnew : integer;
  choice,lastchoice,n,n2: integer;
  etype,x,y,xfirst,att,ClickedOn,BIN: byte;
  KeptBuffer,CurrentBuffer,j,TypeNumber: Byte;
  selected: SelectionType;
  CurMaxBig: Word;
  fields,Spec : SpecArr;
  onit,outside,DoWait,OldShowBuf,retain,fchanged,Ok1,LastIsMore: boolean;
  BareQuote,accept,CaseSen,RegExp,SingleChoice,OldStripExtraBraces: Boolean;
  S: BigTypePtr;
  SBuffer: array[1..260] of char;
  ScrBar: ScrBarPtr;
  UsedList,NewList: ListArrPtr;
  UsedReal: array[1..MaxField] of byte;
  Menu: ^TopMenuType;

  S1: BigTypePtr;
  NewSLen,ncap,CapInd,i0,jj: word;

procedure ClickOutside(Var ClickedOn: Byte);   
                          { Clicked on a field on the screen }
var
  onit: Boolean;
  i,n: Integer;
  x,y,xfirst,att : Byte;
  tmp,tmp1: String;
begin                            { ClickOutside }
  ClickedOn:=0;
  x:=GetMouseX div xpixels+1; y:=GetMouseY div ypixels+1;
  if (y=2) then
  begin
    ReadScrStr(tmp,x,y,xfirst,att,[#30..#126]);
    ReadScrStr(tmp1,x,y,xfirst,att,[#30..#126]-[' ']);
    if (pos(tmp1,tmp)=1) then
    begin
      strlwr(tmp1); if tmp1=entry^.entrytype+':' then ClickedOn:=255;
    end else if (tmp1=entry^.name) or ((entry^.name='') and (tmp1='<UnNamed>'))
        then ClickedOn:=254;
  end else
  begin
    i:=0;
    onit:=false;
    while (not onit) and (i<shown.nshown) do
    begin
      inc(i);
      if (y>=shown.y1[i]) and (y<=shown.y2[i]) and (x>1)
                  and (x<79) then
      begin
        onit:=true;
        if (y=shown.y1[i]) and (x<shown.x1[i]) then onit:=false
        else if (y=shown.y2[i]) and (x>shown.x2[i]) then onit:=false;
        if onit then
        begin
          n:=1;
          ClickedOn:=shown.who[i];
        end;
      end;
    end;
  end;
end;                            { ClickOutside }
 
procedure FieldcChoose(etype: byte; Entry: EntryRecPtr; Var Fields: SpecArr;
                       Var n: integer; var SingleChoice: boolean);
const
  MaxColLen   = 18;
  MaxFieldWidth = 17;
type
  tfieldarr = array[1..maxfield] of ShortInt;
var
  i,j,nreq,nopt,nignore,ncolreq,ncolopt,ncolignore: byte;
  zreq,zopt,ozreq,ozopt,zignore,ozignore,nrows,ncols: byte;
  att,xfirst,xold,yold: byte;
  nline,x,y: ShortInt;
  ch: char;
  tfield: tfieldArr;
  line,tmp1: string;
  TurnOn: boolean;
  charr: array[1..maxfield] of boolean;
  
procedure ToggleRequired(On: boolean);
var
  i: integer;
begin
  nreq:=0; zreq:=ozreq;
  for i:=1 to fieldlast do
  begin
    if abs(tfield[i])=1 then {Required}
    begin
      nreq:=nreq+1;
      if nreq>MaxColLen then
      begin
        zreq:=zreq+MaxFieldWidth;
        nreq:=nreq-MaxColLen;
      end;
      if On then
      begin
        TpwprintW(5+nreq,zreq,typefield^[i],ListRev);
        charr[i]:=true;
      end else
      begin
        TpwprintW(5+nreq,zreq,typefield^[i],ListNorm);
        charr[i]:=false;
      end;
    end;
  end;
end;                           { ToggleRequired }

procedure ToggleOptional(On: boolean);
var
  i: integer;
begin
  nopt:=0; zopt:=ozopt;
  for i:=1 to fieldlast do
  begin
    if abs(tfield[i])=2 then {Optional}
    begin
      nopt:=nopt+1;
      if nopt>MaxColLen then
      begin
        zopt:=zopt+MaxFieldWidth;
        nopt:=nopt-MaxColLen;
      end;
      if on then
      begin
        TpwprintW(5+nopt,zopt,typefield^[i],ListRev);
        charr[i]:=true;
      end else
      begin
        TpwprintW(5+nopt,zopt,typefield^[i],ListNorm);
        charr[i]:=false;
      end;
    end;
  end;
end;                           { ToggleOptional }

procedure ToggleIgnored(On: boolean);
var
  i: integer;
begin
  nignore:=0; zignore:=ozignore;
  for i:=1 to fieldlast do
  begin
    if abs(tfield[i])=3 then {Ignored}
    begin
      nignore:=nignore+1;
      if nignore>MaxColLen then
      begin
        zignore:=zignore+MaxFieldWidth;
        nignore:=nignore-MaxColLen;
      end;
      if on then
      begin
        TpwprintW(5+nignore,zignore,typefield^[i],ListRev);
        charr[i]:=true;
      end else
      begin
        TpwprintW(5+nignore,zignore,typefield^[i],ListNorm);
        charr[i]:=false;
      end;
    end;
  end;
end;                           { ToggleIgnored }

procedure TurnOnDefault;
var
  i: byte;
  Colrs: array[boolean] of Word;
begin
  Colrs[false]:=ListNorm; Colrs[true]:=ListRev;
  nreq:=0; zreq:=ozreq;
  nopt:=0; zopt:=ozopt;
  nignore:=0; zignore:=ozignore;
  for i:=1 to fieldlast do
  begin
    charr[i]:=(Pos(Chr(i),DefEditFields^[etype])>0);
    if abs(tfield[i])=1 then
    begin
      nreq:=nreq+1;
      if nreq>MaxColLen then
      begin
        zreq:=zreq+MaxFieldWidth;
        nreq:=nreq-MaxColLen;
      end;
      TpwPrintW(5+nreq,zreq,typefield^[i],Colrs[charr[i]]);
    end else if abs(tfield[i])=2 then
    begin
      nopt:=nopt+1;
      if nopt>MaxColLen then
      begin
        zopt:=zopt+MaxFieldWidth;
        nopt:=nopt-MaxColLen;
      end;
      TpwPrintW(5+nopt,zopt,typefield^[i],Colrs[charr[i]]);
    end else if abs(tfield[i])=3 then
    begin
      nignore:=nignore+1;
      if nignore>MaxColLen then
      begin
        zignore:=zignore+MaxFieldWidth;
        nignore:=nignore-MaxColLen;
      end;
      TpwPrintW(5+nignore,zignore,typefield^[i],Colrs[charr[i]]);
    end;
  end;
end;                            { TurnOnDefault }

begin                           { FieldcChoose }
  nreq:=0; nopt:=0; nignore:=0; SingleChoice:=false;
  for i:=1 to fieldlast do
  begin
    tfield[i]:=-3;
    charr[i]:=false;
  end;
  for i:=1 to n do charr[fields[i]]:=true;
  for i:=1 to Required^[etype,0] do
  if Required^[etype,i]>0 then
  begin
    tfield[Required^[etype,i]]:=-1;
    nreq:=nreq+1;
  end else
  begin
    tfield[abs(Required^[etype,i])]:=-2;
    nopt:=nopt+1;
  end;
  for i:=1 to fieldlast do if entry^.index[i]>0 then
    tfield[i]:=abs(tfield[i]);
  nignore:=fieldlast-nreq-nopt;
  ncolreq:=0; ncolopt:=0; ncolignore:=0;
  if nreq>0 then    ncolreq   := 1 + (nreq-1) div MaxColLen;
  if nopt>0 then    ncolopt   := 1 + (nopt-1) div MaxColLen;
  if nignore>0 then ncolignore:= 1 + (nignore-1) div MaxColLen;
  nrows:=nreq;
  if nopt>nrows then nrows:=nopt;
  if nignore>nrows then nrows:=nignore;
  if nrows>MaxColLen then nrows:=MaxColLen;
  ncols:=ncolreq+ncolopt+ncolignore;

  MakeWindow(3,3,4+nrows,2+ncols*MaxFieldWidth,ListNorm,ListNorm,2,RNorm,shadow,0);
  line:=TypeEntry^[etype]; StrUpr(line);
  TitleWindow(1,ListNorm,Concat('[',#254,']'));
  TitleWindow(2,ListNorm,line);
  line:='[All]'+#205+'[None]'+#205+'[Default]'+#205+'[Keep]';
  Titlewindow(4,ListNorm,line);
  TpwAttr(6+nrows,4+Pos('A',line),1,1,ListBright);
  TpwAttr(6+nrows,4+Pos('N',line),1,1,ListBright);
  TpwAttr(6+nrows,4+Pos('D',line),1,1,ListBright);
  TpwAttr(6+nrows,4+Pos('K',line),1,1,ListBright);
  TitleWindow(6,ListNorm,'[ok]');
  TpwFill(5,4,1,ncols*17,#196,ListNorm);
  
  zreq:=6; zopt:=6; zignore:=6;
  if ncolreq>0 then
  begin
    zopt:=zopt+ncolreq*MaxFieldWidth;
    zignore:=zopt;
  end;
  if (ncolignore>0) and (ncolopt>0) then zignore:=zignore+ncolopt*MaxFieldWidth;
  for i:=1 to nreq div MaxColLen do
  begin
    TpwFillW(6,zreq+15+(i-1)*MaxFieldWidth,nrows,1,#179,ListNorm);
    TpwPrintW(5,zreq+15+(i-1)*MaxFieldWidth,#194,ListNorm);
  end;
  if (zopt>6) and (nopt>0) then
  begin
    TpwFillW(4,zopt-2,2+nrows,1,#179,ListNorm);
    TpwPrintW(5,zopt-2,#197,ListNorm);
  end;
  for i:=1 to nopt div MaxColLen do
  begin
    TpwFillW(6,zopt+15+(i-1)*MaxFieldWidth,nrows,1,#179,ListNorm);
    TpwPrintW(5,zopt+15+(i-1)*MaxFieldWidth,#194,ListNorm); 
  end;
  if (zignore>6) and (nignore>0) then
  begin
    TpwfillW(4,zignore-2,2+nrows,1,#179,ListNorm);
    TpwprintW(5,zignore-2,#197,ListNorm);
  end;
  for i:=1 to nignore div MaxColLen do
  begin
    TpwFillW(6,zignore+15+(i-1)*MaxFieldWidth,nrows,1,#179,ListNorm);
    TpwPrintW(5,zignore+15+(i-1)*MaxFieldWidth,#194,ListNorm); 
  end;
  if nreq>0 then
  begin
    TpwprintW(4,zreq,' Required',ListNorm);
    TpwAttrW(4,zreq+1,1,1,ListBright);
  end;
  if nopt>0 then
  begin
    TpwprintW(4,zopt,' Optional',ListNorm);
    TpwAttrW(4,zopt+1,1,1,ListBright);
  end;
  if nignore>0 then
  begin
    TpwprintW(4,zignore,' Ignored',ListNorm);
    TpwAttrW(4,zignore+1,1,1,ListBright);
  end;
  ozreq:=zreq; ozopt:=zopt; ozignore:=zignore;
  nopt:=0; nreq:=0; nignore:=0;
                             { Write the field names }
  for i:=1 to fieldlast do
  begin
    if abs(tfield[i])=1 then {Required}
    begin
      nreq:=nreq+1;
      if nreq>MaxColLen then
      begin
        zreq:=zreq+MaxFieldWidth;
        nreq:=nreq-MaxColLen;
      end;
      if tfield[i]>0 then TpwprintW(5+nreq,zreq-1,TagChar,ListNorm);
      if Charr[i] then TpwprintW(5+nreq,zreq,typefield^[i],ListRev)
      else TpwprintW(5+nreq,zreq,typefield^[i],ListNorm);
    end else if abs(tfield[i])=2 then {Optional}
    begin
      nopt:=nopt+1;
      if nopt>MaxColLen then
      begin
        zopt:=zopt+MaxFieldWidth;
        nopt:=nopt-MaxColLen;
      end;
      if tfield[i]>0 then TpwprintW(5+nopt,zopt-1,TagChar,ListNorm);
      if charr[i] then TpwprintW(5+nopt,zopt,typefield^[i],ListRev)
      else TpwprintW(5+nopt,zopt,typefield^[i],ListNorm);
    end else if abs(tfield[i])=3 then {Ignored}
    begin
      nignore:=nignore+1;
      if nignore>MaxColLen then
      begin
        zignore:=zignore+MaxFieldWidth;
        nignore:=nignore-MaxColLen;
      end;
      if tfield[i]>0 then TpwprintW(5+nignore,zignore-1,TagChar,ListNorm);
      if charr[i] then TpwprintW(5+nignore,zignore,typefield^[i],ListRev)
      else TpwprintW(5+nignore,zignore,typefield^[i],ListNorm);
    end;
  end;
  if UseMouse then
  begin
    WaitForRelease(255);
    ShowMouseCursor;
    HideMouseCursor;
  end;
  xold:=6; yold:=6; x:=6; y:=6;
                                { Start working }
  repeat
    TpwattrW(yold,xold,1,1,PixelAttr(xold+1,yold));
    TpwattrW(y,x,1,1,Blink);
    if UseMouse then ShowMouseCursor;
    ch:=ReadKeyMouse;
    if UseMouse then
    begin
      HideMouseCursor; WaitForRelease(255);
    end;
    line:='';
    xold:=x; yold:=y;
    SingleChoice:=false;
    if Event.mpress then
    begin
      line:='';
      x:=Event.x; y:=Event.y;
      if (x>3) and (x<5+ncols*MaxFieldWidth) and ((y>2) and (y<7+nrows)) then
      begin
        ReadScrStr(line,x,y,xfirst,att,[#33,#35..#122,#124,#126,#254]-
                       [#39,#44,#92,#96,TagChar]);
        x:=xfirst;
        if Event.RightButton then SingleChoice:=true;
      end;
    end else
    begin
      line:='';
      if (ch=#0) or (ch=#9) then
      begin
        if ch=#9 then ch:=#77                  { TAB = right arrow }
        else ch:=ReadKey;
        if (ch=#15) or (ch=#148) then ch:=#75; { ^TAB, S-TAB = left arrow }
        if ch=#59 then ContextHelp('Choose Edit Field')
        else if ch=#30 then line:='[All]'      { Alt-A }
        else if ch=#49 then line:='[None]'     { Alt-N }
        else if ch=#32 then line:='[Default]'  { Alt-D }
        else if ch=#37 then line:='[Keep]'     { Alt-K }
        else if ch=#19 then line:='Required'   { Alt-R }
        else if ch=#24 then line:='Optional'   { Alt-O }
        else if ch=#23 then line:='Ignored'    { Alt-I }
        else if ch=#77 then    { Right }
        begin
          x:=x+17;
          if x>6+(ncols-1)*17 then x:=6;
          while PixelChar(x,y)=' ' do y:=y-1;
        end else if ch=#75 then    { Left }
        begin
          x:=x-17;
          if x<5 then x:=6+(ncols-1)*17;
          while PixelChar(x,y)=' ' do y:=y-1;
        end else if ch=#72 then      { Up }
        begin
          y:=y-1;
          if y<6 then
          begin
            y:=5+nrows;
            x:=x-17;
            if x<6 then x:=(ncols-1)*17+6;
            while PixelChar(x,y)=' ' do y:=y-1;
          end;
        end else if ch=#80 then     { Down }
        begin
          y:=y+1;
          if (y>5+nrows) or (PixelChar(x,y)=' ') then
          begin
            y:=6;
            x:=x+17;
            if x>6+(ncols-1)*17 then x:=6;
          end;
        end;
        if ch in [#72,#80,#77,#75] then line:='$arrowkeys$';
      end else if (ch in ['R','r']) and (nreq>0)     then line:='Required'
      else if (ch in ['O','o']) and (nopt>0)         then line:='Optional'
      else if (ch in ['I','i'])  and (nignore>0)     then line:='Ignored'
      else if (ch in ['A','a'])                      then line:='[All]'
      else if (ch in ['N','n'])                      then line:='[None]'
      else if (ch in ['D','d'])                      then line:='[Default]'
      else if (ch in ['K','k'])                      then line:='[Keep]'
      else if ch=#27 then line:=Concat('[',#254,']')
      else if ch=#13 then line:='[ok]'
      else if ch=' ' then
      begin
        ReadScrStr(line,x,y,xfirst,att,[#33,#35..#122,#124,#126,#254]-
                       [#39,#44,#92,#96,TagChar]);
        x:=xfirst;
        if Event.Shift or Event.Ctrl then SingleChoice:=true;
      end;
    end;
    if line='Required' then
    begin
      TurnOn:=false;
      for i:=1 to fieldlast do
        if (abs(tfield[i])=1) and (not charr[i]) then TurnOn:=true;
      ToggleRequired(TurnOn);
      line:='';
    end else if line='Optional' then
    begin
      TurnOn:=false;
      for i:=1 to fieldlast do
        if (abs(tfield[i])=2) and (not charr[i]) then TurnOn:=true;
      ToggleOptional(TurnOn);
      line:='';
    end else if (line='Ignored') then
    begin
      TurnOn:=false;
      for i:=1 to fieldlast do
        if (abs(tfield[i])=3) and (not charr[i]) then TurnOn:=true;
      ToggleIgnored(TurnOn);
      line:='';
    end else if line='[All]' then
    begin
      ToggleRequired(true);
      ToggleOptional(true);
      ToggleIgnored(true);
      line:='';
    end else if line='[None]' then
    begin
      ToggleRequired(false);
      ToggleOptional(false);
      ToggleIgnored(false);
      line:='';
    end else if line='[Default]' then
    begin
      TurnOnDefault; line:='';
    end else if line='[Keep]' then
    begin
      DefEditFields^[etype]:='';
      for i:=1 to fieldlast do
        if Charr[i] then DefEditFields^[etype]:=DefEditFields^[etype]+Chr(i);
      line:='';
    end;
    if line='' then
    begin
      x:=xold; y:=yold;
    end else if line<>'$arrowkeys$' then
    begin
      j:=0;
      StrLwr(line);
      for i:=1 to fieldlast do if line=typefield^[i] then j:=i;
      if (j>0) and not SingleChoice then
      begin
        charr[j]:=not charr[j];
        if charr[j] then Tpwattr(y,xfirst,1,length(line),ListRev)
        else TpwAttr(y,xfirst,1,length(line),ListNorm);
      end;
    end;
  until (line=Concat('[',#254,']')) or (line='[ok]') or SingleChoice;
  n:=0;
  if SingleChoice then
  begin
    n:=1; Fields[1]:=j;
  end else if line='[ok]' then
  begin
    for i:=1 to fieldlast do
    if charr[i] then
    begin
      n:=n+1;
      fields[n]:=i;
    end;
  end else n:=-1;
  if UseMouse then HideMouseCursor;
  RemoveWindow;
end;                            { FieldcChoose }

procedure AlmostZeroEntry(var Entry: EntryRecPtr);
var
  ereal, eentry: longint;
begin
  ereal:=entry^.realnum; eentry:=Entry^.entrynum;
  ZeroEntry(Entry);
  Entry^.realnum:=ereal; Entry^.EntryNum:=eentry;
end;

begin                                   { EditEntry }
  changed:=false; ScrBar:=Nil; EdExitCode:=0;
  OldShowBuf:=FirstShowBuf;
  UsedList:=Nil; Nused:=0; NewList:=Nil; Nnew:=0;
  CaseSen:=false; Regexp:=false;
  if Entry^.LastField>DefFieldLast then DefFieldLast:=Entry^.LastField;
  FieldLast:=DefFieldLast;
  MakeWindowNo(2,1,ScrLen-1,ScrWidth,EntryNorm,EditBorder,2,RNorm,0,0);
  NewEntry:=(entry^.nentry=0);
  OldStripExtraBraces:=StripExtraBraces;
  StripExtraBraces:=false;
  if NewEntry then
  begin
    ZeroEntry(Entry); Scroll:=0; Entry^.name:='';
    if EditOnlyStrings then entry^.EntryType:='string'
    else entry^.EntryType:=TypeEntry^[1];
    FieldLast:=DefFieldLast;
  end;
  choice:=1;
  if EditOnlyStrings then
  begin
    if WithFinish then Menu:=@StringEditMenu
    else Menu:=@StringModifyMenu;
  end else
  begin
    if WithFinish then Menu:=@EntryEditMenu
    else Menu:=@EntryModifyMenu;
  end;
  Menu^.CurrentPos:=1;
  outside:=AlreadyClicked;
  DoWait:=false;
  New(ScrBar); ScrBar^.Color:=CScrBarEdit;
  GetMem(UsedList,(MaxField+1)*sizeof(ListArrRec));
  GetMem(NewList,(MaxField+1)*sizeof(ListArrRec));
  if NewEntry and EditOnlyStrings then
  begin
    GetAString(' String name: ',Entry^.name,4,50,46,NameForbid,accept,false);
    if Entry^.name='' then NewEntry:=false;
  end;
  repeat
    for i:=Entry^.LastField+1 to MaxField do
    begin
      Entry^.Index[i]:=0; Entry^.BigIndex[i]:=0;
    end;
    ShowEntry(Entry,Scroll,LastY,true,PatternOn,false);
    if DoWait and UseMouse then WaitForRelease(255); DoWait:=false;
    if EditOnlyStrings then
    begin
      TopLine(Menu^,selected,NewEntry,outside,Scroll,LastY,ScrBar);
      if NewEntry then Selected[0]:=CEditDefault
      else begin
        if AlreadyClicked then 
        begin
          outside:=true;
          AlreadyClicked:=false;
        end;
        ClickedOn:=0;
        if OutSide then ClickOutside(ClickedOn);
      end;
    end else
    begin
      nused:=0;
      if entry^.nentry=0 then
      begin
        EdMoveFieldOn^:=false; 
        EdCopyFieldOn^:=false; 
      end else begin
        EdMoveFieldOn^:=true; 
        EdCopyFieldOn^:=true; 
        UsedFieldsMenu^.nitems:=0;
        for i:=1 to fieldlast do
          if entry^.index[i]>0 then
          begin
            inc(UsedFieldsMenu^.nitems);
            inc(nused);
            UsedList^[nused]:=typefield^[i];
            UsedReal[Nused]:=i;
            if UsedFieldsMenu^.nitems<=20 then
              UsedFieldsMenu^.item[UsedFieldsMenu^.nitems]^:=
                Chr(UsedFieldsMenu^.nitems-1+Ord('A'))+': '+typefield^[i];
          end;
        LastIsMore:=false;
        if UsedFieldsMenu^.nitems>18 then
        begin
          LastIsMore:=true;
          UsedFieldsMenu^.item[18]^:='T: More...';
          UsedFieldsMenu^.nitems:=18;
        end;
      end;
      Nnew:=DefFieldLast-OrigFieldLast;
      for i:=OrigFieldLast+1 to DefFieldLast do
        NewList^[i-OrigFieldLast]:=typefield^[i];
      if StripExtraBraces then
        EdEnStripBracesCheck^:=MenuCheckChar
      else
        EdEnStripBracesCheck^:=' ';
      if FirstShowBuf then
        EdEnViewAllCheck^:=' '
      else
        EdEnViewAllCheck^:=MenuCheckChar;
      TopLine(Menu^, selected, false, outside, Scroll, LastY, ScrBar);
      if AlreadyClicked then 
      begin
        outside:=true;
        AlreadyClicked:=false;
      end;
      ClickedOn:=0;
      if OutSide then ClickOutside(ClickedOn);
    end;
    newentry:=false; choice:=selected[0];
    if choice=CTop_Scroll then { Cursor Movements }
    begin
      outside:=false; DoWait:=false;
    end else if choice=CTop_F1 then                { Help }
    begin
      if EditOnlyStrings then ContextHelp('Edit String Field')
      else ContextHelp('Edit Entry');
    end else if (choice=Ord('V')) then        { Toggle display mode }
      FirstShowBuf:=not FirstShowBuf
    else with entry^ do
    begin
      if outside or (choice in [CEditWhich,CEditFields,CEditDefault])
            then      { Click, Which? , Fields }
      begin
        for i:=1 to MaxField+1 do fields[i]:=0;
        n:=0;
        if outside then          { Clicked on a field on the screen }
        begin
          outside:=false;
          choice:=3;
          if ClickedOn=254 then choice:=2
          else if ClickedOn=255 then choice:=1
          else if ClickedOn>0 then
          begin
            n:=1;
            fields[1]:=ClickedOn;
          end;
        end else if (not EditOnlyStrings) and (choice=CEditWhich) then { Which? }
        begin
          TypeNumber:=1;
          repeat
            n:=0; n2:=0; fields[1]:=TypeNumber;
            FieldChoose(TypeEntry^,NumberOfTypes,3,15,fields,n2,true,
                        false,1,0,true,true);
            if n2>0 then
            begin
              etype:=fields[1]; TypeNumber:=etype;
              n:=length(EditFields^[etype]);
              for i:=1 to n do fields[i]:=Ord(EditFields^[etype][i]);
              FieldcChoose(etype,Entry,fields,n,SingleChoice);
              if not SingleChoice then
              begin
                if n>=0 then
                begin
                  EditFields^[etype]:='';
                  for i:=1 to n do
                    EditFields^[etype]:=Concat(EditFields^[etype],Chr(fields[i]));
                end else n:=0;
              end;
            end;
          until (n2=0) or (n>0);
          if n>0 then
          begin
            if entry^.entrytype<>TypeEntry^[etype] then
            begin
              entry^.entrytype:=TypeEntry^[etype];
              changed:=true;
            end;
          end;
        end else if choice=CEditFields then            { Fields }
        begin
          if EditOnlyStrings then
          begin
            etype:=StringTypeInd;
            n:=1;
            EditFields^[etype]:=Chr(StringIndex);
            fields[1]:=StringIndex;
          end else
          begin
            etype:=0;
            for i:=1 to NumberOfTypes do if Entry^.entrytype=TypeEntry^[i] then
            etype:=i;
            if etype>0 then
            begin
              n:=length(EditFields^[etype]);
              for i:=1 to n do fields[i]:=Ord(EditFields^[etype][i]);
              FieldcChoose(etype,Entry,fields,n,SingleChoice);
              if not SingleChoice then
              begin
                if n>=0 then
                begin
                  EditFields^[etype]:='';
                  for i:=1 to n do
                    EditFields^[etype]:=Concat(EditFields^[etype],Chr(fields[i]));
                end else n:=0;
              end;
            end;
          end;
        end else if choice=CEditDefault then         { Default }
        begin
          if EditOnlyStrings then
          begin
            n:=1; etype:=StringTypeInd;
            EditFields^[etype]:=Chr(StringIndex);
            Fields[1]:=StringIndex;
          end else
          begin
            etype:=FindInETypeList(Entry^.entrytype);
            if etype>0 then n:=length(EditFields^[etype]);
          end;
          if n=0 then ErrorMessage(' No default fields defined! ')
          else for i:=1 to n do fields[i]:=Ord(EditFields^[etype][i]);
        end;
        if n>0 then
        begin
          S:=Nil; KeptBuffer:=0;
          for i:=1 to n do
          begin
            if Pos(BinaryFields^,typefield^[fields[i]])=1 then
              ErrorMessage('"'+typefield^[fields[i]]+
                     '" is an uneditable binary field!')
            else begin
              if index[fields[i]]=0 then
              begin
                nentry:=nentry+1;
                index[fields[i]]:=nentry;
                content[index[fields[i]]]:='';
                BigIndex[fields[i]]:=0;
              end;
              oldstr:=content[index[fields[i]]];
              BIN:=fields[i];
              CurrentBuffer:=0; KeptBuffer:=0;
              CurrentBuffer:=FindBigFree(Entry,false);
              CurMaxBig:=MaxBig;
              if CurrentBuffer>0 then S:=@Big[CurrentBuffer]^
              else begin
                { message('No free buffer'); }
                if BigIndex[BIN]>0 then
                begin
                  CurrentBuffer:=BigIndex[BIN];
                  PushBufferStack(Big[CurrentBuffer]^,Blen[CurrentBuffer],
                      enoughmem(Blen[CurrentBuffer]),0);
                  KeptBuffer:=CurrentBuffer;
                  S:=@Big[CurrentBuffer]^
                end else if MaxNumberBig>1 then
                begin
                  CurrentBuffer:=1;
                  PushBufferStack(Big[CurrentBuffer]^,Blen[CurrentBuffer],
                      enoughmem(Blen[CurrentBuffer]),0);
                  KeptBuffer:=CurrentBuffer;
                  S:=@Big[CurrentBuffer]^
                end else
                begin
                  S:=@SBuffer; CurMaxBig:=255;
                end;
              end;
              {
              message('Buffer number '+num2str(CurrentBuffer)+' used.');
              if KeptBuffer>0 then message('Kept buffer.');
              }
              if BigIndex[BIN]=0 then
              begin
                if content[index[fields[i]]]=EmptyFieldChar then
                begin
                  Slen:=1; S^[1]:='~';
                end else
                begin
                  Slen:=length(content[index[fields[i]]]);
                  move(content[index[fields[i]]][1],S^,Slen);
                end;
              end else
              begin
                Slen:=Blen[BigIndex[BIN]];
                if CurrentBuffer<>BigIndex[BIN] then
                  Move(Big[BigIndex[BIN]]^[1],S^[1],Slen);
              end;
              OldSlen:=SLen; Ok1:=true;
              {
              if CaseSen then message('Case yes');
              if Regexp then message('Reg yes');
              message('ok');
              }
              repeat
                {
                ReadBig(typefield^[fields[i]]+': ',S^,Slen,
                     3,2,ScrLen-3,ScrWidth-2,[#0..#31,#255]-[#21],fchanged,retain,
                     CurMaxBig,false,CaseSen,RegExp,
                     (Slen=1) and (S^[1]='~'),Authorlike[fields[i]]);
                }
                ReadBig(typefield^[fields[i]]+': ',S^,Slen,
                     3,2,ScrLen-3,ScrWidth-2,[#0..#31,#255]-[#21],fchanged,retain,
                     CurMaxBig,false,CaseSen,RegExp,Nil,
                     (Slen=1) and (S^[1]='~'),
                     FieldParams^[fields[i]].AuthorLike,'');
                if retain then
                  Ok1:=OkField(S^,Slen,3,
                     ' Unbalanced quotes/braces in text! ',
                     ' Illegal macro/concatenation syntax in text! ', BareQuote);
              until Ok1 or not retain;
              if not retain then
              begin
                if BigIndex[BIN]=0 then
                  Move(content[index[fields[i]]][1],S^,OldSlen)
                else begin
                  if KeptBuffer<>BigIndex[BIN] then
                  begin
                    Move(Big[BigIndex[BIN]]^[1],S^[1],OldSlen);
                  end else RecallBufferStack(S^,0);
                end;
                fchanged:=false; Slen:=OldSlen;
              end;
              if fchanged then changed:=true;
                                          { Get rid of excess spaces }
              ii:=1;
              while ii<=Slen do
              begin
                if (S^[ii]=' ') and ((ii=1) or (S^[ii-1]=' ')) then
                begin
                  for iii:=ii to Slen do S^[iii]:=S^[iii+1];
                  Dec(Slen); changed:=true;
                end else Inc(ii);
              end;
              if Slen=0 then
              begin
                content[index[BIN]]:='';
                index[fields[i]]:=0;
                if BigIndex[BIN]>0 then
                begin
                  BigFree[BigIndex[BIN]]:=true;
                  Blen[BigIndex[BIN]]:=0;
                  BigIndex[BIN]:=0;
                end;
                if OldSlen>0 then changed:=true;
              end else
              begin
                if {RetainNullFields and} (Slen=1) and (S^[1]='~') then
                  S^[1]:=EmptyFieldChar;
                if EditOnlyStrings and fchanged then
                begin
                  if Prog8Bit then Conv28Bit(S^,Slen,false)
                  else if Prog7Bit then Conv27Bit(S^,Slen,false,CurMaxBig);
                end else if not EditOnlyStrings then
                begin
                  if fchanged then
                  begin
                    if Prog8Bit then Conv28Bit(S^,Slen,FieldParams^[fields[i]].AuthorLike)
                    else if Prog7Bit then Conv27Bit(S^,Slen,
                      FieldParams^[fields[i]].AuthorLike,CurMaxBig);
                  end;
                  if UseAutoCap and (FieldParams^[fields[i]].Capitalize) and fchanged then
                  begin
                    Capitalize(S,Slen,1,Slen,FieldParams^[fields[i]].AuthorLike);
                    changed:=true;
                  end;

                  { Protect unusual capitalization }
                  if FieldParams^[fields[i]].ProtectCase or
                    FieldParams^[fields[i]].ProtectCap then
                               ProtectMixedCase(S,SLen,MaxBig,FieldParams^[fields[i]].ProtectCap);
                end;
                content[index[BIN]]:=ScopyNS(S,1,Slen);
                changed:=changed or (Content[index[BIN]]<>oldstr);
                if (Slen<256) or (MaxNumberBig=0) or
                   ((keptbuffer>0) and (keptbuffer<>BigIndex[BIN])) then
                begin
                  if BigIndex[BIN]>0 then
                  begin
                    BigFree[BigIndex[BIN]]:=true;
                    Blen[BigIndex[BIN]]:=0;
                    BigIndex[BIN]:=0;
                    changed:=true;
                  end;
                end else
                begin
                  if BigIndex[BIN]=0 then
                  begin
                    changed:=true;
                    BigIndex[BIN]:=currentbuffer;
                    BigFree[CurrentBuffer]:=false;
                    Blen[BigIndex[BIN]]:=Slen;
                  end else
                  begin
                    changed:=changed or (SLen<>OldSlen);
                    if BigIndex[BIN]<>CurrentBuffer then
                      Move(S^,Big[BigIndex[BIN]]^,Slen);
                    Blen[BigIndex[BIN]]:=Slen;
                  end;
                end;
              end;
              if (KeptBuffer>0) and (KeptBuffer<>BigIndex[BIN])
                and (BigIndex[BIN]>0) then
                RecallBufferStack(Big[BigIndex[BIN]]^,0);
              if KeptBuffer>0 then DiscardBufferStack;
            end;
            S:=Nil;
          end;
        end;
        if EditOnlyStrings then
        begin
          if content[1]='' then
          begin
            nentry:=0;
            index[StringIndex]:=0; BigIndex[StringIndex]:=0;
          end;
        end else
        begin
          nentry:=0;
          for i:=1 to maxfield do
          begin
            if content[i]<>'' then
            begin
              ii:=0;
              while (ii<fieldlast+1) do
              begin
                Inc(ii);
                if index[ii]=i then
                begin
                  Inc(nentry);
                  content[nentry]:=content[i];
                  field[nentry]:=typefield^[ii];
                  index[ii]:=nentry;
                  ii:=fieldlast+1;
                end;
              end;
            end else
              for ii:=1 to fieldlast do if index[ii]=i then index[ii]:=0;
          end;
        end;
      end;
      if (not EditOnlyStrings) and (choice=CEditType) then       { Type }
      begin
        oldstr:=entrytype;
        n:=0; fields[1]:=1;
        FieldChoose(TypeEntry^,NumberOfTypes,3,15,fields,n,true,false,1,0,true,true);
        if n>0 then entrytype:=TypeEntry^[fields[1]];
        if entrytype='' then entrytype:='misc';
        if oldstr<>entrytype then changed:=true;
      end
      else if choice=CEditName then                { Name }
      begin
        oldstr:=name;
        GetAString(' Entry Name is: ',name,4,50,46,NameForbid,accept,true);
        if oldstr<>name then changed:=true;
      end else if choice=CEditEdit then                             { Edit }
      begin
        if (selected[1]=CEntEd_CopyFld) or (selected[1]=CEntEd_MoveFld) then
                                                                  { Move and Copy }
        begin
          if nentry=0 then ErrorMessage(' Entry is empty! ')
          else begin
            if (selected[2]=18) and (LastIsMore) then
            begin
              n:=0; spec[1]:=1;
              FieldChoose(UsedList^,Nused,3,15,spec,n,true,false,1,0,true,true);
              if n=0 then selected[2]:=0
              else selected[2]:=spec[1];
            end;
            if selected[2]>0 then
            begin
              n:=0; spec[1]:=1;
              FieldChoose(typefield^,FieldLast,3,15,spec,n,true,false,1,0,true,true);
              if (n>0) and ((Index[spec[1]]=0) or
                AskIf(' Field "'+typefield^[spec[1]]+'" is not empty! ','',
                      'Overwrite','Cancel')) then
              begin               { Do It! }
                if selected[1]=CEntEd_MoveFld then            { Move }
                begin
                  index[Spec[1]]:=index[UsedReal[selected[2]]];
                  BigIndex[Spec[1]]:=BigIndex[UsedReal[selected[2]]];
                  Field[index[Spec[1]]]:=typefield^[Spec[1]];
                  index[UsedReal[selected[2]]]:=0;
                  BigIndex[UsedReal[selected[2]]]:=0;
                end else if selected[1]=CEntEd_CopyFld then   { Copy }
                begin
                  if Index[spec[1]]=0 then
                  begin
                    inc(nentry);
                    field[nentry]:=typefield^[spec[1]];
                    index[spec[1]]:=nentry;
                  end;
                  Content[nentry]:=Content[index[UsedReal[selected[2]]]];
                  if BigIndex[UsedReal[selected[2]]]>0 then
                  begin
                    if BigIndex[spec[1]]=0 then
                    begin
                      BigIndex[spec[1]]:=FindBigFree(Entry,true);
                      if BigIndex[spec[1]]>0 then Blen[BigIndex[spec[1]]]:=0;
                    end;
                    if BigIndex[spec[1]]>0 then
                    begin
                      Move(Big[BigIndex[UsedReal[selected[2]]]]^[1],
                           Big[BigIndex[spec[1]]]^[1],
                           Blen[BigIndex[UsedReal[selected[2]]]]);
                      Blen[BigIndex[spec[1]]]:=
                          Blen[BigIndex[UsedReal[selected[2]]]];
                    end;
                  end;
                end;
                changed:=true;
              end;              
            end;
          end;
        end else if (Selected[1]=CEntEd_EraseFld) then { Erase field }
        begin
          if nentry=0 then ErrorMessage(' Entry is empty! ')
          else begin
            n:=0; spec[1]:=1;
            FieldChoose(UsedList^,Nused,3,15,spec,n,false,false,1,0,true,true);
            if n>0 then changed:=true;
            for i:=1 to n do
            begin
              Content[index[UsedReal[spec[i]]]]:='';
              if BigIndex[UsedReal[spec[i]]]>0 then
              begin
                BigFree[BigIndex[UsedReal[spec[i]]]]:=true;
                Blen[BigIndex[UsedReal[spec[i]]]]:=0;
              end;
              index[UsedReal[spec[i]]]:=0; BigIndex[UsedReal[spec[i]]]:=0;
            end;
          end;
        end else if Selected[1]=CEntEd_AddFld then                { Add }
        begin
          if fieldlast>=MaxField then ErrorMessage(' Too many fields! ')
          else begin
            inc(fieldlast);
            typefield^[fieldlast]:='';
            DumpFields[fieldlast]:=DumpUndecFields;
            GetAString(' Enter new field name: ',typefield^[fieldlast],4,
                       50,32,NameForbid,accept,false);
            if typefield^[fieldlast]<>'' then
            begin
              StrLwr(typefield^[fieldlast]);
              for i:=1 to fieldlast-1 do
                if typefield^[fieldlast]=typefield^[i] then
                begin
                  ErrorMessage(' Field "'+typefield^[fieldlast]+'" already exists! ');
                  typefield^[fieldlast]:='';
                end;
              if typefield^[fieldlast]='' then dec(fieldlast)
              else LastField:=FieldLast;
              DefFieldLast:=FieldLast;
            end;
          end;
        end else if selected[1]=CEntEd_RemFld then                { Remove }
        begin
          if DefFieldLast<=OrigFieldLast then
            ErrorMessage(' No added fields to remove! ')
          else begin
            n:=0; spec[1]:=1;
            FieldChoose(NewList^,NNew,3,15,spec,n,false,false,1,0,true,true);
            for i:=1 to n do
            begin
              spec[i]:=spec[i]+OrigFieldLast;
              if index[spec[i]]>0 then
              begin
                changed:=true;
                Content[index[spec[i]]]:='';
                if BigIndex[spec[i]]>0 then
                begin
                  BigFree[BigIndex[spec[i]]]:=true;
                  Blen[BigIndex[spec[i]]]:=0;
                end;
                index[spec[i]]:=0; BigIndex[spec[i]]:=0;
              end;
              for j:=spec[i] to MaxField-1 do
              begin
                typefield^[j]:=typefield^[j+1];
                index[j]:=index[j+1];
                BigIndex[j]:=BigIndex[j+1];
                DumpFields[j]:=DumpFields[j+1];
                if FieldParams^[j].AltName<>Nil then
                  DisposeStr(FieldParams^[j].AltName);
                FieldParams^[j]:=FieldParams^[j+1];
                FieldParams^[j+1].AltName:=Nil;
              end;
              Dec(FieldLast); LastField:=FieldLast;
              DefFieldLast:=FieldLast;
            end;
          end;
        end else if selected[1]=CEntEd_CutEnt then                { Cut }
        begin
          if ClipboardMode=DontKeep then ErrorMessage(' No clipboard - CUT disabled! ')
          else if nentry=0 then ErrorMessage(' Entry is empty! ')
          else begin
            EntryToClipboard(Entry);
            AlmostZeroEntry(Entry);
            changed:=false;
          end;
        end else if selected[1]=CEntEd_CopyEnt then                { Copy }
        begin
          if ClipboardMode=DontKeep then ErrorMessage(' No clipboard - COPY disabled! ')
          else if nentry=0 then ErrorMessage(' Entry is empty! ')
          else EntryToClipboard(Entry);
        end else if selected[1]=CEntEd_PasteEnt then                { Paste }
        begin
          if ClipboardMode=DontKeep then ErrorMessage(' No clipboard - PASTE disabled! ')
          else if ClipboardEmpty then ErrorMessage(' Clipboard is empty! ')
          else if ClipboardString and not EditOnlyStrings then
            ErrorMessage(' Clipboard contains a @STRING type entry! ')
          else if EditOnlyStrings and not ClipboardString then
            ErrorMessage(' Clipboard contains a non @STRING type entry! ')
          else begin
            ClipboardToEntry(Entry);
            changed:=true;
          end ;
        end else if selected[1]=CEntEd_ClearEnt then               { Clear }
        begin
          AlmostZeroEntry(Entry);
          changed:=false;
        end;
      end else if choice=CEditView then                   { View menu }
      begin
        if selected[1]=CEntEdView_All then
          FirstShowBuf:=not FirstShowBuf
        else if selected[1]=CEntEdView_Braces then
          StripExtraBraces:=not StripExtraBraces;
      end;
    end;
  until choice in [CEditFinish,CEditSave,CEditQuit];
  if ScrBar<>Nil then Dispose(ScrBar); ScrBar:=Nil;
  if Entry^.nentry=0 then changed:=false;
  if (choice=CEditSave) or (choice=CEditFinish) then changed:=true
  else if choice=CEditQuit then                 { Quit }
  begin
    if not changed or (selected[1]<>0) or not YesNo(' Save entry? ') then
    begin
      changed:=false;
      AlmostZeroEntry(Entry);
    end;
    if selected[1]>0 then choice:=selected[1];
  end;
  EdExitCode:=choice;
  if NewList<>Nil then FreeMem(NewList,(MaxField+1)*sizeof(ListArrRec));
  if UsedList<>Nil then FreeMem(UsedList,(MaxField+1)*sizeof(ListArrRec));
  RemoveWindow;
  FirstShowBuf:=OldShowBuf;
  StripExtraBraces:=OldStripExtraBraces;
end;                                       { EditEntry }

end.
