{$N-,V-,W-,G+}

Unit wbibabv1;

Interface

Uses
  Strings, WObjects, WinTypes, WinProcs, {Wbibdisp,} bibvars, bibstrg;

type

  PCopyListObj = ^TCopyListObj;
  TCopyListObj = object(TObject)
    Ind: integer;
    constructor init(AInd: integer);
  end;

  PCopyListCol = ^TCopyListCol;
  TCopyListCol = object(TSortedCollection)
    function Compare(Key1,Key2: Pointer): integer; virtual;
  end;

  POneStringObj = ^TOneStringObj;
  TOneStringObj = object(TObject)
    Sname:  PString;
    Svalue: PChar;
    constructor init(Entry: EntryRecPtr);
    constructor ValueInit(N: string; F: PChar);
    destructor  done; virtual;
  end;

  PAbbrevList = ^TAbbrevList;
  TAbbrevList = object(TSortedCollection)
    SortUp,SortDown: boolean;
    constructor init(ALimit,ADelta: integer; ASortUp,ASortDown: boolean);
    function    Compare(Key1,Key2: Pointer): integer;    virtual;
    procedure   AtInsert(Index: integer; Item: Pointer); virtual;
    function    FindName(N: string; Exclude: integer): integer;
    function    FindPName(P: POneStringObj; Exclude: integer): integer;
  end;

var
  ExpandStrings,  ExpandIniAbbrevs, ExpandMacros: boolean;
  StrAbbrevsList, IniAbbrevsList,   BIBAbbrevsList, BSTAbbrevsList: TAbbrevList;

procedure DecodeAbbrevs(var s; Slen: Word; var P: PChar; var PLen,PSize: word);

implementation

{ TCopyListObj, Col methods }

constructor TCopyListObj.init(AInd: integer);
begin
  TObject.init;
  Ind:=AInd;
end;

function TCopyListCol.Compare(Key1,Key2: Pointer): integer;
var
  Ind1,Ind2: integer;
begin
  Ind1:=PCopyListObj(Key1)^.Ind; Ind2:=PCopyListObj(Key2)^.Ind;
  if Ind1>Ind2 then Compare:=1
  else if Ind1<Ind2 then Compare:=-1
  else Compare:=0;
end;

{ TOneStringObj methods }

constructor TOneStringObj.init(Entry: EntryRecPtr);
var
  N: string;
begin
  TObject.init;
  Sname:=Nil; SValue:=Nil;
  if Entry=Nil then Exit;
  with entry^ do
  begin
    N:=name; StrLwr(N);
    Sname:=NewStr(N);
    if BigIndex[1]=0 then    { Short }
    begin
      GetMem(SValue,length(content[1])+1);
      StrPCopy(SValue,Content[1]);
    end else                 { long }
    begin
      GetMem(Svalue,BLen[1]+1);
      Move(Big[1]^[1],SValue^,Blen[1]);
      Svalue[BLen[1]]:=#0;
    end;
  end;
end;                             { TOneStringObj.init }

constructor TOneStringObj.ValueInit(N: string; F: PChar);
begin
  TObject.init;
  StrLwr(N); ChrDelL(N,' '); ChrDelR(N,' ');
  SName:=NewStr(N);
  SValue:=StrNew(F);
end;

destructor TOneStringObj.done;
begin
  if SValue<>Nil then StrDispose(SValue);
  if SName<>Nil then  DisposeStr(Sname);
  TObject.done;
end;

{ TAbbrevList methods }

constructor TAbbrevList.init(ALimit,ADelta: integer; ASortUp,ASortDown: boolean);
begin
  TSortedCollection.init(ALimit,ADelta);
  SortUp:=ASortUp; SortDown:=ASortDown;
end;

function TAbbrevList.Compare(Key1,Key2: Pointer): integer;
var
  S1,S2: PString;
  Preamble1,Preamble2: boolean;
begin
  S1:=POneStringObj(Key1)^.SName; S2:=POneStringObj(Key2)^.SName;
  Preamble1:=(S1^<>'') and (S1^[1]=lbrace);
  Preamble2:=(S2^<>'') and (S2^[1]=lbrace);
  if      (SortUp or SortDown) and Preamble1 then Compare:=1
  else if (SortUp or SortDown) and Preamble2 then Compare:=-1
  else if SortUp then
    Compare:=StrCmpI(S1^,S2^,1,1,255)
  else if SortDown then
    Compare:=StrCmpI(S2^,S1^,1,1,255)
  else Compare:=1;
end;                              { TAbbrevList.Compare }

procedure TAbbrevList.AtInsert(Index: integer; Item: Pointer);
begin
  if SortUp or SortDown then TSortedCollection.Insert(Item)
  else if Index=-1 then TSortedCollection.AtInsert(Count,Item)
  else TSortedCollection.AtInsert(Index,Item);
end;

function TAbbrevList.FindName(N: string; Exclude: integer): integer;
var
  i,j: integer;
  tmp: string;
begin
  FindName:=-1;
  StrLwr(N);
  i:=-1; j:=-1;
  while (i<Count-1) and (j=-1) do
  begin
    inc(i);
    tmp:=POneStringObj(at(i))^.SName^; StrLwr(tmp);
    if (i<>Exclude) and (N=tmp) then j:=i;
  end;
  FindName:=j;
end;                                { TAbbrevList.FindName }

function TAbbrevList.FindPName(P: POneStringObj; Exclude: integer): integer;
begin
  FindPName:=FindName(P^.SName^,Exclude);
end;

type
  PSegmentObj = ^TSegmentObj;
  TSegmentObj = object(TObject)
    Len: Integer;
    Seg: PChar;
    Macro: boolean;
    constructor init(ASeg: Pointer; ALen: integer; AMacro: boolean);
  end;

constructor TSegmentObj.init(ASeg: Pointer; ALen: integer; AMacro: boolean);
var
  tmp: string;
  T: TOneStringObj;
  Ind: integer;
  F,F1: PChar;
begin
  TObject.init;
  Len:=ALen; Seg:=ASeg;
  Macro:=AMacro;
  if Macro and (Len<255) then
  begin
    Move(Seg^,tmp[1],Len); tmp[0]:=Chr(Len);
    ChrDelL(tmp,' '); ChrDelR(tmp,' '); StrLwr(tmp);
{    message('"'+tmp+'"');}
    T.ValueInit(tmp,Nil);
    if ExpandStrings and StrAbbrevsList.Search(@T,Ind) then
    begin
      Seg:=POneStringObj(StrAbbrevsList.at(Ind))^.SValue;
      Len:=StrLen(Seg); Macro:=false;
    end else if ExpandIniAbbrevs and BibAbbrevsList.Search(@T,Ind) then
    begin
      Seg:=POneStringObj(BibAbbrevsList.at(Ind))^.SValue;
      Len:=StrLen(Seg); Macro:=false;
    end else if ExpandIniAbbrevs and BstAbbrevsList.Search(@T,Ind) then
    begin
      Seg:=POneStringObj(BstAbbrevsList.at(Ind))^.SValue;
      Len:=StrLen(Seg); Macro:=false;
    end else if ExpandIniAbbrevs and IniAbbrevsList.Search(@T,Ind) then
    begin
      Seg:=POneStringObj(IniAbbrevsList.at(Ind))^.SValue;
      Len:=StrLen(Seg); Macro:=false;
    end;
    T.Done;
  end;
  {
  GetMem(F,Len+3);
  F[0]:='"'; F1:=F+1; Move(Seg^,F1^,Len); F[Len+1]:='"'; F[Len+2]:=#0;
  messagebox(HMainW,F,'',mb_ok);
  FreeMem(F,Len+3);
  }
end;                          { TSegmentObj.init }


procedure DecodeAbbrevs(var s; Slen: Word; var P: PChar; var PLen,PSize: word);
var
  T: TCollection;
  Ind,i,j,nbr,LenMax: longint;
  SS: BigType ABSOLUTE S;
  F: PChar;
  WasMacro,AnyMacro: boolean;
begin
  P:=Nil; PLen:=0; PSize:=0;

  ind:=1;
  T.init(20,10);
  while (ind<=SLen) do
  begin
    while (ind<=SLen) and (SS[Ind] in [' ','#']) do inc(Ind);
    if (Ind>SLen-2) and ((Ind>SLen) or (SS[ind] in ['"',lbrace])) then ind:=SLen+1
    else if (SS[Ind] ='"') then   { string }
    begin
      j:=Ind+1;
      while (j<=SLen) and
        ((not (SS[j]='"')) or
         ((j<Slen) and not (ss[j+1] in [' ','#']) )) do inc(j);
      T.Insert(New(PSegmentObj,init(@SS[Ind+1],j-Ind-1,false)));
      Ind:=j+1;
    end else if (SS[Ind]=lbrace) then
    begin
      j:=Ind; nbr:=1;
      repeat
        inc(j);
        if SS[j]=lbrace then inc(nbr)
        else if SS[j]=rbrace then dec(Nbr);
      until (j>SLen) or (nbr<=0);
      T.Insert(New(PSegmentObj,init(@SS[Ind+1],j-Ind-1,false)));
      Ind:=j+1;
    end else if (Ind<=SLen) then  { Abbreviation }
    begin
      j:=Ind+1;
      while (j<=SLen) and not (SS[j] in [' ','#']) do inc(j);
      T.Insert(New(PSegmentObj,init(@SS[Ind],j-Ind,true)));
      Ind:=j;
    end else inc(ind);
  end;

  if T.Count>0 then
  begin
    PSize:=0; LenMax:=0; AnyMacro:=false;
    for i:=0 to T.Count-1 do
    with PSegmentObj(T.at(i))^ do
    begin
      PSize:=PSize+Len+5;
      if LenMax<Len then LenMax:=Len;
      if Macro then AnyMacro:=true;
    end;
    GetMem(P,PSize);
    GetMem(F,LenMax+1);
    PLen:=0; WasMacro:=true;
    if PSegmentObj(T.at(0))^.Macro then StrPCopy(P,'@')
    else if AnyMacro then StrPCopy(P,'@"')
    else StrPCopy(P,'');
    for i:=0 to T.Count-1 do
    with PSegmentObj(T.at(i))^ do
    begin
      if Macro and (i>0) then
      begin
        if not WasMacro then StrLCat(P,'"',PSize-1);
        StrLCat(P,' # ',PSize-1);
      end else if WasMacro and (i>0) then StrLCat(P,' # "',PSize-1);
      Move(Seg^,F^,Len); F[Len]:=#0;
      StrLCat(P,F,PSize-1);
{      messagebox(HMainW,P,'',mb_ok);}
      WasMacro:=Macro;
    end;
    if AnyMacro and not WasMacro then StrLCat(P,'"',PSize-1);
    PLen:=StrLen(P);
    FreeMem(F,LenMax+1);
  end;
  T.Done;
end;                            { DecodeAbbrevs }

begin
end.



