{$N-,V-,W-,G+,R+}
Unit wbibbin;

interface

Uses
  WObjects, WinTypes, WinProcs, streams, wHugeMem, rc_id, strings, 
  bibstrg;

const
  Bin_MagicNum = $9A84;
  Bin_Version  = 1;
  Bin_EncodedLineLen = 60;
  Bin_DecodedLineLen = (Bin_EncodedLineLen div 4)*3;

  BinTyp_All = 0; BinTyp_Object = 1; BinTyp_Image = 2;

  { flags }
  Bin_Error     = 1;
type
  { Use the Huge Memory stream }
  PBinStream = PHugeMemStream;
  TBinStream = THugeMemStream;
  TCodedHeader = record
    MagicNum: word;
    Size    : longint;
    CRC32   : longint;
    Version : byte;
    typ     : word;
    flags   : word;
  end;
  PCodedHeader = ^TCodedHeader;
  CodedLineStr = string[Bin_EncodedLineLen+1];

  { The binary object itself }
  PBinObject = ^TBinObject; PPBinObject = ^PBinObject;
  TBinObject = object(TObject)
    P    : PBinStream;
    CRC32: longint;
    typ  : word;
    mark : word;
    flags: word;
    ok   : boolean;
    name : String;
    constructor init(AName: String; AInitial: longint; ATyp,Aflags: word);
    constructor load (var S: TStream);
    procedure   Store(var S: TStream);
    function    GetCodedLine(first: boolean): CodedLineStr;
    constructor FirstCodedSegment(Buf,AName: PString);
    procedure   AddCodedSegment(Buf: PString);
    function    CheckCRC: boolean;
    function    IsOk: boolean;
    destructor  done; virtual;
  end;

  PBinList = ^TBinList;
  TBinList = object(TSortedCollection)
    function Compare (Key1, Key2: Pointer): Integer; virtual;
    function FindName(S: PString; typ: word): PBinObject;
    function FreeName(S: PString): boolean;
  end;

function DecodeSegment(ABuf: PString; var ARes): integer;

var
  ZeroEncodingChar: char;

implementation

type
  TByteArray  = array[0..255] of byte;
  PByteArray  = ^TByteArray;
  TCRC32Table = array [Byte] of LongInt;

var
  EncTable  : PChar;
  DecTable  : PByteArray;
  ReadSize  : longint;
  CRC32Table: ^TCRC32Table;

function imin(a,b: longint): longint;
begin
  if a<=b then imin:=a else imin:=b;
end;

procedure MakeCRC32Table;
Var
  crc : LongInt;
  i,n : Byte;
begin
  New(CRC32Table);
  For i := 0 to 255 do
  begin
    crc := i;
    For n := 1 to 8 do
      if odd(crc) then
        crc := (crc shr 1) xor $EDB88320
      else
        crc := crc shr 1;

    crc32table^[i] := crc;
  end;
end;              { MakeCRC32Table }

procedure UpdateCRC32(c: Byte; var CRC: LongInt);
begin
  if CRC=0 then CRC:=$FFFFFFFF;
  CRC:=CRC32Table^[lo(CRC) xor c] xor (CRC shr 8);
end;

{ TBinObject methods }

constructor TBinObject.init(AName: String; AInitial: longint; ATyp,Aflags: word);
begin
  TObject.init;
  New(P,Init(AInitial)); P^.seek(0);
  Flags:=Aflags; Typ:=ATyp;
  ok:=(P<>Nil) and (P^.Status=stOK);
  Name:=AName;
  ChrDel(Name,'<'); ChrDel(Name,'>');
  Name[length(Name)+1]:=#0;
  Mark:=0; CRC32:=0;
end;              { TBinObject.init }

constructor TBinObject.Load(var S: TStream);
var
  StrSize: longint;
begin
  TObject.init;
  S.Read(StrSize,sizeof(StrSize));
  S.Read(CRC32,sizeof(CRC32));
  S.Read(Typ,  sizeof(Typ));
  S.Read(Flags,sizeof(Flags));
  S.Read(Name[0],1); S.read(Name[1],ord(Name[0]));
  Name[length(Name)+1]:=#0;
  if StrSize<=0 then P:=Nil
  else begin
    New(P,Init(StrSize)); P^.seek(0);
    P^.CopyFrom(S,StrSize);
    P^.seek(0);
  end;
  ok:=(P<>Nil) and (P^.Status=stOK);
  Mark:=0;
end;             { TBinObject.Load }

procedure TBinObject.Store(var S: TStream);
var
  StrSize,OldPos: longint;
begin
  StrSize:=0;
  if IsOk then
  begin
    StrSize:=P^.GetSize; Flags:=Flags and not Bin_Error;
    if CRC32=0 then CheckCRC;
  end else Flags:=Flags or Bin_Error;
  S.write(StrSize,sizeof(StrSize));
  S.write(CRC32,  sizeof(CRC32));
  S.write(Typ,    sizeof(Typ));
  S.write(Flags,  sizeof(Flags));
  S.write(Name,length(Name)+1);
  if StrSize>0 then
  begin
    OldPos:=P^.GetPos; P^.seek(0);
    S.CopyFrom(P^,StrSize);
    if OldPos<>0 then P^.seek(OldPos);
  end;
end;             { TBinObject.Store }

function TBinObject.GetCodedLine(First: boolean): CodedLineStr;
var
  Buf0: array[0..Bin_DecodedLineLen+4] of char;
  Buf: PChar;
  BBuf: PByteArray;
  T: PCodedHeader;
  len,readlen,i: integer;
  S: CodedLineStr;
begin
  GetCodedLine:='';
  if not (IsOk or First) then Exit;
  FillChar(Buf0,sizeof(Buf0),0); S:=''; Buf:=@Buf0[0];

  if First then
  begin
    if IsOk then
    begin
      Flags:=Flags and not Bin_Error;
      if CRC32=0 then CheckCRC;
    end else Flags:=Flags or Bin_Error;
    T:=PCodedHeader(Buf);
    T^.MagicNum:=Bin_MagicNum;
    T^.Size:=P^.GetSize; T^.CRC32:=CRC32;
    T^.Version:=Bin_Version;
    T^.typ:=typ; T^.flags:=flags;
    Buf:=Buf+sizeof(TCodedHeader);
    P^.seek(0);
    if IsOk then
    begin
      readlen:=Bin_DecodedLineLen-sizeof(TCodedHeader);
      if readlen>P^.GetSize then readlen:=P^.GetSize;
      if P^.GetPos+readlen>P^.GetSize then readlen:=P^.GetSize-P^.GetPos;
    end else ReadLen:=0;
    len:=ReadLen+sizeof(TCodedHeader);
  end else
  begin
    readlen:=Bin_DecodedLineLen;
    if P^.GetPos+readlen>P^.GetSize then readlen:=P^.GetSize-P^.GetPos;
    len:=ReadLen;
  end;
  if readlen>0 then P^.read(Buf^,ReadLen);
  S:=EncTable[len];
  i:=0;
  repeat
    BBuf:=PByteArray(@Buf0[i]);
    S:=S+EncTable[                               BBuf^[0] SHR 2  ];
    S:=S+EncTable[((BBuf^[0] AND $03) SHL 4) OR (BBuf^[1] SHR 4) ];
    if i+1<len then
    S:=S+EncTable[((BBuf^[1] AND $0F) SHL 2) OR (BBuf^[2] SHR 6) ];
    if i+2<len then
    S:=S+EncTable[  BBuf^[2] AND $3F                             ];
    i:=i+3;
  until i>=len;
  GetCodedLine:=S;
end;                   { TBinObject.GetCodedLine }

constructor TBinObject.FirstCodedSegment(Buf,AName: PString);
var
  PF,PF0: PChar;
  datalen,BufLen: integer;
  tmp: string[60];
begin
  TObject.init;
  P:=Nil; Flags:=0; ok:=false; ReadSize:=0; Mark:=0; typ:=0; CRC32:=0;
  if (AName<>Nil) and (AName^<>'') then Name:=AName^
  else Name:='';
  Name[length(Name)+1]:=#0;
  BufLen:=length(Buf^);
  GetMem(PF0,256); PF:=PF0;
  DataLen:=DecodeSegment(Buf,PF^);
  {
  if (DataLen>=sizeof(TCodedHeader)) and (PCodedHeader(PF)^.Magic<>Bin_MagicNum) then
    ErrorMessageRC(Str_BadBinMagic,'');
  }
  if (DataLen>=sizeof(TCodedHeader)) and (PCodedHeader(PF)^.MagicNum=Bin_MagicNum) then
  begin
    New(P,Init(PCodedHeader(PF)^.Size)); P^.seek(0);
    CRC32:=PCodedHeader(PF)^.CRC32;
    typ  :=PCodedHeader(PF)^.typ;
    Flags:=PCodedHeader(PF)^.Flags;
    ReadSize:=PCodedHeader(PF)^.Size;
    PF:=PF+sizeof(TCodedHeader);
    if DataLen>sizeof(TCodedHeader) then
    begin
      P^.write(PF^,imin(DataLen-sizeof(TCodedHeader),ReadSize));
    end;
    ok:=(P<>Nil) and (P^.Status=stOK);
  end;
  FreeMem(PF0,256);
end;                   { TBinObject.FirstCodedSegment }

procedure TBinObject.AddCodedSegment(Buf: PString);
var
  PF: PChar;
  DataLen,BufLen: integer;
  tmp: string[60];
begin
  if not IsOk then Exit;
  BufLen:=length(Buf^);
  GetMem(PF,256);
  DataLen:=imin(DecodeSegment(Buf,PF^),ReadSize-P^.GetPos);
  if DataLen>0 then P^.write(PF^,DataLen)
  else if DataLen<0 then ok:=false;
  FreeMem(PF,256);
end;               { TBinObject.AddCodedSegment }

function TBinObject.CheckCRC: boolean;
const
  BufSize = 512;
var
  NewCRC,Left: longint;
  Buf: PChar;
  ToRead,i: word;
begin
  CheckCRC:=true;
  if (P<>Nil) and (P^.Status=stOK) and (P^.GetSize=0) then Exit;
  CheckCRC:=false;
  if not IsOK then Exit;
  NewCRC:=0; Left:=P^.GetSize;
  GetMem(Buf,BufSize);
  P^.seek(0);
  repeat
    ToRead:=imin(BufSize,Left);
    if ToRead>0 then
    begin
      P^.read(Buf^,ToRead);
      for i:=0 to ToRead-1 do UpdateCRC32(byte(Buf[i]),NewCRC);
      Left:=Left-ToRead;
    end;
  until Left<=0;
  if CRC32=0 then CRC32:=NewCRC;
  if CRC32=NewCRC then CheckCRC:=true
  else ok:=false;
  FreeMem(Buf,BufSize);
end;                { TBinObject.CheckCRC }

function TBinObject.IsOk: boolean;
begin
  IsOk:=ok and (P<>Nil) and (P^.Status=stOK);
end;

destructor TBinObject.done;
begin
  if P<>Nil then Dispose(P,Done);
  TObject.Done;
end;

{ TBinList methods }

function TBinList.Compare(Key1, Key2: Pointer): Integer;
begin
  Compare:=StrCmpI(PBinObject(Key1)^.Name,PBinObject(Key2)^.Name,1,1,255);
end;

function TBinList.FindName(S: PString; typ: word): PBinObject;
var
  i: integer;
begin
  FindName:=Nil;
  if (S=Nil) or (S^='') then Exit;
  i:=0;
  while (i<Count) do
  begin
    if (StrCmpI(S^,PBinObject(at(i))^.Name,1,1,255)=0) and
       ((typ=BinTyp_All) or (PBinObject(at(i))^.typ=typ)) then
    begin
      FindName:=PBinObject(at(i));
      Exit;
    end else inc(i);
  end;
end;            { TBinList.FindName }

function TBinList.FreeName(S: PString): boolean;
var
  i: integer;
begin
  FreeName:=false;
  if (S=Nil) or (S^='') then Exit;
  i:=0;
  while (i<Count) do
  begin
    if StrCmpI(S^,PBinObject(at(i))^.Name,1,1,255)=0 then
    begin
      FreeName:=true; AtFree(i); Exit;
    end else inc(i);
  end;
end;            { TBinList.FreeName }

{--------------------------}

function DecodeSegment(ABuf: Pstring; var ARes): integer;
var
  len,i,j: word;
  Inp,Out: PByteArray;
  Buf,Res: PChar;
begin
  DecodeSegment:=-1;
  Buf:=@ABuf^[1]; Res:=@ARes;
  Len:=DecTable^[Ord(Buf^)];
  if len mod 3<>0 then len:=len+3-(len mod 3);
  if Len div 3>(length(ABuf^)-1) div 4 then Exit;    { Some kind of error }
  inc(Buf);
  for i:=1 to Len div 3 do
  begin
    Inp:=PByteArray(Buf); Out:=PByteArray(Res);
    {
    if i=1 then
    begin
      logstring(num2str(i)+': '+num2str(Inp^[0])+','+num2str(Inp^[1])+','
       +num2str(Inp^[2])+','+num2str(Inp^[3]));
      logstring(byte2hex(DecodingTable^[Inp^[0]])+','+byte2hex(DecodingTable^[Inp^[1]])+','
       +byte2hex(DecodingTable^[Inp^[2]])+','+byte2hex(DecodingTable^[Inp^[3]]));
    end;
    }
    for j:=0 to 3 do if DecTable^[Inp^[j]]=$FF then  { Error }
    begin
      Exit;
    end;

    Out^[0]:=(DecTable^[Inp^[0]] SHL 2) OR
             (DecTable^[Inp^[1]] SHR 4);
    Out^[1]:=((DecTable^[Inp^[1]] AND $0F) SHL 4) OR
             (DecTable^[Inp^[2]] SHR 2);
    Out^[2]:=((DecTable^[Inp^[2]] AND $03) SHL 6) OR
             (DecTable^[Inp^[3]]);
{    if i=1 then logstring(byte2hex(Out^[1])+','+byte2hex(Out^[1])+','+byte2hex(Out^[2]));}
    Buf:=Buf+4; Res:=Res+3;
  end;
  DecodeSegment:=DecTable^[Ord(ABuf^[1])];
end;            { DecodeSegment }


{-----------------------}


const
  RBinObject: TStreamRec = (
    ObjType: 200;
    VmtLink: Ofs(TypeOf(TBinObject)^);
    Load   : @TBinObject.Load;
    Store  : @TBinObject.Store
    );

procedure BinUnit_Init;
var
  i: integer;
begin
  RegisterType(RBinObject);
  GetMem(EncTable,70);
  LoadString(HInstance,BinDec_XX,EncTable,69);
  GetMem(DecTable,256); FillChar(DecTable^,256,$FF);
  for i:=0 to Strlen(EncTable)-1 do DecTable^[byte(EncTable[i])]:=i;
  ZeroEncodingChar:=EncTable[0];

  MakeCRC32Table;
end;                { BinUnit_Init }

begin
  BinUnit_Init;
end.
