{$N-,V-,W-,G+}

unit wbibpatt;

interface

Uses
  WinDos, wobjects, strings, WinTypes, WinProcs, Win31, commdlg,
  rc_id, rc_strng, wbibgui, wbibdisp, wbibshow, wbibupdt, wbibeden,
  bibvars, bibutil, bibPChec, bibwild, bibstrg, bibsrtpt, wbibstat,
  bib8bit, wc_help, bibfile, streams, wbibslct, lfnunit;

type
  PPattHeirarchy = ^TPattHeirarchy;
  PPatHeirarchyObj = ^TPatHeirarchyObj;

  TPattHeirarchy = object(TCollection)
    Parent: PPattHeirarchy;
    item  : PPatHeirarchyObj;  
    Name  : PChar;
    constructor Init(ALimit, ADelta: Integer);
    procedure   FreeAll; virtual;
  end;
  PPPattHeirarchy=^PPattHeirarchy;

  TPatHeirarchyObj = object(TObject)
    Desc,Patt: PChar;
    SubMenu: PPattHeirarchy;
    Separator: boolean;
    id: word;
    constructor init(Sec,Item,Buf: PChar; BufLen: word);
    constructor CopyItem(From: PPatHeirarchyObj);
    constructor Manual(AParent: PWindowsObject);
    destructor  done; virtual;
  end;

  PPattHeirList = ^TPattHeirList;
  TPattHeirList = object(TSortedCollection)
    function  Compare(Key1, Key2: Pointer): Integer; virtual;
    function  FindDesc(Desc: PChar): integer;
    procedure ReadHeirarchy(which: integer);
  end;
  PAssocFile = ^TAssocFile;
  TAssocFile = object(TObject)
    fname,AssocDesc: PChar;
    AssocPos: integer;
    Regexp: boolean;
    constructor init(Item: PChar);
    constructor Duplicate(P: PAssocFile);
    constructor Associate(AFName: PChar; which: integer);
    procedure   ReAssociate(which: integer);
    destructor  done; virtual;
  end;
  PPattAssocList = ^TPattAssocList;
  TPattAssocList = object(TSortedCollection)
    function Compare(Key1, Key2: Pointer): Integer; virtual;
    function Find(f: Pstring): integer;
  end;

  PAssocPattListDlg = ^TAssocPattListDlg;
  TAssocPattListDlg = object(TBasicDialog)
    Assoc: PPattAssocList;
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   Upload;
    procedure   FileLBox(var Msg: TMessage); virtual id_first+dl_AssocPattFList;
    procedure   PattLBox(var Msg: TMessage); virtual id_first+dl_AssocPattPList;
    procedure   DelBtn(var Msg: TMessage);   virtual id_first+dl_AssocPattDelete;
    procedure   EditBtn(var Msg: TMessage);  virtual id_first+dl_AssocPattEdit;
    procedure   NewBtn(var Msg: TMessage);   virtual id_first+dl_AssocPattNew;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
    Destructor  done; virtual;
  end;

  PPatMenuFilesDlg = ^TPatMenuFilesDlg;
  TPatMenuFilesDlg = object(TBasicDialog)
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   HandleLBox(var Msg: TMessage); virtual id_first+dl_PatMenFilesLBox;
    procedure   LoadFiles;
    procedure   NewBtn(var Msg: TMessage);     virtual id_first+dl_PatMenFilesNew;
    procedure   ModifyBtn(var Msg: TMessage);  virtual id_first+dl_PatMenFilesModify;
    procedure   DeleteBtn(var Msg: TMessage);  virtual id_first+dl_PatMenFilesDelete;
  end;

  PEdPattHeirDlg = ^TEdPattHeirDlg;
  TEdPattHeirDlg = object(TBasicDialog)
    level,lbSel,which: integer;
    CurHeir : PPattHeirarchy;
    OrigHeir: PPPattHeirarchy;
    SymbolFont,HeirUpFont,HeirDnFont: HFont;
    OrigTitle: PChar;
    constructor init(AParent: PWindowsObject; AHeir: PPPattHeirarchy;
                     AWhich: integer);
    procedure   SetupWindow; virtual;
    procedure   LoadLevel;
    procedure   HandleLBox(var Msg: TMessage);virtual id_first+dl_EdHeirLbox;
    procedure   EditBtn(var Msg: TMessage);   virtual id_first+dl_EdHeirEdit;
    procedure   NewItem(ins: boolean);
    procedure   InsertBtn(var Msg: TMessage); virtual id_first+dl_EdHeirInsert;
    procedure   AppendBtn(var Msg: TMessage); virtual id_first+dl_EdHeirAppend;
    procedure   DeleteBtn(var Msg: TMessage); virtual id_first+dl_EdHeirDelete;
    procedure   DefaultBtn(var Msg: TMessage);virtual id_first+dl_EdHeirDefault;
    procedure   Shift(Up: boolean);
    procedure   UpBtn(var Msg: TMessage);     virtual id_first+dl_EdHeirUp;
    procedure   DownBtn(var Msg: TMessage);   virtual id_first+dl_EdHeirDown;
    procedure   ok(var Msg: TMessage);        virtual id_first+id_ok;
    procedure   wmDestroy(var Msg: TMessage); virtual wm_first+wm_Destroy;
    destructor  done; virtual;
  end;

var
  PattHeirarchy: PPattHeirarchy;
  PattHeirCount: integer;

{ Pattern Heirarchy stuff }
procedure FindAllPattLists;
procedure FindAllPattAssoc;
procedure SaveAllPattLists;
function  GetPattHeirarchy(Heir: PPattHeirarchy; which: integer;
                           fname: Pstring; Regexp: boolean): integer;
procedure InsertPattHeirarchyMenu(H: HMenu; MainHeir: PPattHeirarchy);
function  GetMenuPattern(Pattern: PatRecPtr; id: word): boolean;
{ Pattern Edit stuff }
procedure PatternGet(W: PWindowsObject; Pattern: PatRecPtr; var changed: boolean);
function  OneCritPattern(Pattern: PatRecPtr; CritInd: integer): boolean;

implementation

{ Include the Pattern Heirarchy stuff }

{$I wbibheir.inc}

{ Include the Pattern Edit dialogs }

{$I wbibpatt.inc}


type

  PPattEditDlg = ^TPattEditDlg;
  TPattEditDlg = object(TResizableDialog)
    DisplayArea: PDisplayArea;
    changed,FirstTime: boolean;
    Pattern:    PatRecPtr;
    ChosenFields: PattFieldStr;
    HelpBar:    PPattStatusBar;
    OldHelpBar: PHelpBar;
    MenuHelp,PopupHelp: TCollection;
    HFloating:  HMenu;
    CurrentInd: integer;
    OpMenuPos,EditMenuPos,CritMenuPos: integer;
    MemFields:  PattFieldStr;
    MemCrit:    string;
    MemFlag:    byte;
    WindowCaption: PChar;
    AccelKeys: TCollection;
    constructor init(AParent: PWindowsObject; APattern: PatRecPtr);
    procedure   SetupWindow; virtual;
    procedure   InitMenuHelp;
    procedure   UpdateEditMenu;
    procedure   Update;
    procedure   UpdatePos(NewInd: integer);
    procedure   wmSize(var Msg: TMessage);       virtual wm_first+wm_size;
    procedure   wmInitMenu(var Msg: TMessage);   virtual wm_first+wm_InitMenu;
    procedure   wmMenuSelect(var Msg: TMessage); virtual wm_first+wm_MenuSelect;
    procedure   ArrowKeys(var Msg: Tmessage);    virtual wm_first+bib_ArrowKeys;
    procedure   WmNCHitTest(var Msg: TMessage);  virtual wm_first+wm_NCHitTest;
    procedure   wmEnterIdle(var Msg: TMessage);  virtual wm_first+wm_EnterIdle;
    procedure   wmActivate(var Msg: TMessage);   virtual wm_first+wm_activate;
    procedure   ClickedOnField(var Msg: TMessage);
                             virtual wm_First+bib_ClickedOnField;

    procedure   RemoveItem(Ind: integer);
    function    ModifyField(Ind: integer): boolean;
    function    ModifyOp(Ind: integer)   : boolean;
    function    InsertCrit(Ind: integer; flds,strng: string;
                             Neg,CaseSen,RegExp: boolean): boolean;
    function    InsertOperator(Ind: Integer; ANDOp,Neg: boolean): boolean;
    procedure   NewField(selected: integer);

    procedure   AddName(var Msg: TMessage);   virtual cm_first+mi_PattAddName;
    procedure   AddType(var Msg: TMessage);   virtual cm_first+mi_PattAddType;
    procedure   AddTagged(var Msg: TMessage); virtual cm_first+mi_PattAddTagged;
    procedure   AddUser1(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField;
    procedure   AddUser2(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField+1;
    procedure   AddUser3(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField+2;
    procedure   AddUser4(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField+3;
    procedure   AddUser5(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField+4;
    procedure   AddUser6(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField+5;
    procedure   AddUser7(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField+6;
    procedure   AddUser8(var Msg: TMessage);  virtual cm_first+cm_FirstUserPattField+7;
    procedure   AddAll(var Msg: TMessage);    virtual cm_first+mi_PattAddAll;
    procedure   AddOther(var Msg: TMessage);  virtual cm_first+mi_PattAddOther;
    {-------}
    procedure   AddAND(var Msg: TMessage);     virtual cm_first+mi_PattAND;
    procedure   AddOR(var Msg: TMessage);      virtual cm_first+mi_PattOR;
    procedure   AddNAND(var Msg: TMessage);    virtual cm_first+mi_PattNAND;
    procedure   AddNOR(var Msg: TMessage);     virtual cm_First+mi_PattNOR;
    {-------}
    procedure   Modify(var Msg: TMessage);     virtual cm_First+mi_PattEditModify;
    procedure   NegateItem(var Msg: TMessage); virtual cm_First+mi_PattEditNegate;
    procedure   CutItem(var Msg: TMessage);    virtual cm_first+mi_PattEditCut;
    procedure   CopyItem(var Msg: TMessage);   virtual cm_First+mi_PattEditCopy;
    procedure   PasteItem(var Msg: TMessage);  virtual cm_First+mi_PattEditPaste;
    procedure   Backspace(var Msg: TMessage);  virtual cm_first+mi_PattEditBS;
    procedure   DelKey(var Msg: TMessage);     virtual cm_first+mi_PattEditDel; 
    procedure   Clear(var Msg: TMessage);      virtual cm_first+mi_PattClear;
    {-------}
    procedure   LoadFile(var Msg: TMessage);   virtual cm_first+mi_PattFileLoad;
    procedure   SaveFile(var Msg: TMessage);   virtual cm_first+mi_PattFileSave;
    procedure   SaveIt(var Msg: TMessage);     virtual cm_first+id_ok;
    procedure   QuitIt(var Msg: TMessage);     virtual cm_first+id_cancel;
    procedure   ok(var Msg: TMessage);         virtual id_first+id_ok;

    function    CanClose: boolean; virtual;
    destructor  Done; virtual;
  end;

Var
  ghKbrdHook: HHook;
  KbdHookInst: TFarProc;
  PattWindowActive,PattMenuActive: boolean;
  PattWindow: PPattEditDlg;

{$F+}
function TrapKbHook(Code: integer; wParam: Word; lParam: longint): longint; export;
var
  Send,ScanCode,i: word;
  CtrlPressed,ShftPressed,arrow: boolean;
begin
  Send:=0; arrow:=false;
  if PattMenuActive or (Code<0) or (Code<>HC_ACTION) or
     (lParam and wmChar_BeingReleased<>0) or
     (not PattWindowActive) or AmWaiting then
       { key releases, active menu, and the like - ignore }
  else if (wParam=vk_up)   or (wParam=vk_down) or (wParam=vk_Prior) or
          (wParam=vk_Next) or (wParam=vk_Home) or (wParam=vk_End)   then
    Arrow:=not PattMenuActive
  else if (lParam and (wmChar_AltPressed or wmChar_KeyWasDown) = 0) then 
  begin            { ALT not pressed, and not a repeat }
    ScanCode:=LoByte(HiWord(lParam));
    CtrlPressed:=GetKeyState(vk_Control)<0;
    ShftPressed:=GetKeyState(vk_Shift)<0;
    if CtrlPressed and (wParam=vk_Add)           then Send:=mi_PattNOR
    else if wParam=vk_add                        then Send:=mi_PattOR
    else if CtrlPressed and (wParam=vk_Multiply) then send:=mi_PattNAND
    else if wParam=vk_Multiply                   then Send:=mi_PattAND
    else if wParam=vk_Back                       then Send:=mi_PattEditBS
    else if ShftPressed and (wParam=vk_Delete)   then Send:=mi_PattEditCut
    else if wParam=vk_Delete                     then Send:=mi_PattEditDel
    else if CtrlPressed and (wParam=vk_Insert)   then Send:=mi_PattEditCopy
    else if ShftPressed and (wParam=vk_Insert)   then Send:=mi_PattEditPaste
    else if wParam=vk_Insert                     then Send:=mi_PattEditModify
    else for i:=0 to PattWindow^.AccelKeys.Count-1 do
      with PAccelKey(PattWindow^.AccelKeys.at(i))^ do
        if (SCode=ScanCode) and (Ctrl=CtrlPressed) then Send:=id;
  end;

  if arrow then            { Send arrowkeys command to parent }
  begin
    PostMessage(PattWindow^.HWindow,bib_ArrowKeys,wParam,0);
    TrapKbHook:=1
  end else if Send<>0 then { Send wm_Command accelerator msg to parent }
  begin
    PostMessage(PattWindow^.HWindow,wm_Command,Send,MakeLong(0,1));
    TrapKbHook:=1
  end else                 { Pass it on to the previous handler }
      TrapKbHook:=CallNextHookEx(ghKbrdHook,Code,wparam,lparam);

end;                           { TrapKbHook }
{$F-}

{ TPattEditDlg methods }

constructor TPattEditDlg.init(AParent: PWindowsObject; APattern: PatRecPtr);
begin
  TResizableDialog.init(AParent,PChar(rc_PattEditDlg),@PattEditSize);
  Pattern:=APattern;
  New(HelpBar,init(@Self));
  new(DisplayArea,init(@Self,Pattern,HelpBar,true));
  changed:=false;
  ChosenFields:='';
  HelpContext:=hc_PattEdit;
  HFloating:=0;
  CurrentInd:=Pattern^.noper;
  FirstTime:=true;
  DisplayArea^.CaretInd:=CurrentInd;
  MemCrit:=''; MemFields:=''; MemFlag:=0;
  PattWindowActive:=false;
  PattMenuActive:=false;
  WindowCaption:=Nil;
  PattWindow:=@Self;
end;                         { TPattEditDlg.init }

procedure TPattEditDlg.SetupWindow;
var
  Rect: TRect;
  F: array[0..255] of char;
  S: string;
  mchars: string;
  i,j,id,N: integer;
  H: HMenu;

begin
  TResizableDialog.SetupWindow;
  if UseCtl3d and Win95 and Win95_3d then
     SetWindowLong(HWindow,gwl_Style,
             GetWindowLong(HWindow,gwl_Style) and not DS_3DLOOK);
  GetWindowText(HWindow,F,255);
  WindowCaption:=StrNew(F);

  H:=GetMenu(HWindow);
  HFloating:=GetSubmenu(H,0);
  RemoveMenu(H,0,mf_ByPosition);

  InitMenuHelp;

  CritMenuPos:=-1; EditMenuPos:=-1; OpMenuPos:=-1;
  for i:=0 to GetMenuItemCount(H) do
  begin
    GetMenuString(H,i,F,255,mf_ByPosition);
    S:=StrPas(F); ChrDel(S,'&'); StrLwr(S);
    if S='criterion' then CritMenuPos:=i
    else if S='edit' then EditMenuPos:=i
    else if S='operator' then OpMenuPos:=i;
  end;

  H:=GetSubmenu(H,CritMenuPos);
  N:=GetMenuItemCount(H);
  AccelKeys.init(N+6+PMenuNum,10);
  mchars:='';
  for i:=0 to N-1 do
  begin
    id:=GetMenuItemID(H,i);
    if (id<>-1) and (id<>0) then
    begin
      j:=GetMenuString(H,i,F,64,mf_ByPosition);
      S:=StrPas(F); j:=Pos('&',S);
      if (j>0) and (j<length(S)) and (Pos(UpCase(S[j+1]),mchars)=0) then
      begin
        AccelKeys.Insert(New(PAccelKey,init(UpCase(S[j+1]),id,True)));
        mchars:=mchars+UpCase(S[j+1]);
      end;
    end;
  end;
  if PMenuNum>0 then                    { Adding the user-defined Add items }
  begin
    for i:=1 to PMenuNum do
    begin
      S:=PMenuStr[i]^;
      j:=Pos(PMenuChars[i],S);
      if (j>0) and (Pos(UpCase(S[j]),mchars)=0) then
      begin
        Insert('&',S,j); S:=S+#9+'Ctrl+'+UpCase(S[j+1]);
        AccelKeys.Insert(New(PAccelKey,init(UpCase(S[j+1]),
                                 cm_FirstUserPattField+i-1,True)));
        mchars:=mchars+UpCase(S[j+1]);
      end;
      StrPCopy(F,S);
      InsertMenu(H,i+3,mf_ByPosition+mf_String,
                                 cm_FirstUserPattField+i-1,F);
    end;
    InsertMenu(H,PMenuNum+4,mf_ByPosition+mf_Separator,0,'');
  end;
                           { more accelerators }
  AccelKeys.Insert(New(PAccelKey,init('|',mi_PattOR,  false)));
  AccelKeys.Insert(New(PAccelKey,init('+',mi_PattOR,  false)));
  AccelKeys.Insert(New(PAccelKey,init('|',mi_PattNOR, true )));
  AccelKeys.Insert(New(PAccelKey,init('+',mi_PattNOR, true )));
  AccelKeys.Insert(New(PAccelKey,init('*',mi_PattAND, false)));
  AccelKeys.Insert(New(PAccelKey,init('&',mi_PattAND, false)));
  AccelKeys.Insert(New(PAccelKey,init('*',mi_PattNAND,true )));
  AccelKeys.Insert(New(PAccelKey,init('&',mi_PattNAND,true )));
  AccelKeys.Insert(New(PAccelKey,init('^',mi_PattEditNegate,false)));
  AccelKeys.Insert(New(PAccelKey,init('!',mi_PattEditNegate,false)));
  AccelKeys.Insert(New(PAccelKey,init('~',mi_PattEditNegate,false)));
  AccelKeys.Insert(New(PAccelKey,init('s',id_ok,      false)));
  AccelKeys.Insert(New(PAccelKey,init('q',id_cancel,  false)));

  GetClientRect(HWindow,Rect);
  with DisplayArea^.Attr do
  begin
    X:=-1; Y:=-1; W:=rect.right+2; H:=rect.bottom+1;
  end;
  if Application^.MakeWindow(DisplayArea)=Nil
        then FatalErrorRC(Str_CantCreateChild,'');
  if Application^.MakeWindow(HelpBar)=Nil
        then FatalErrorRC(Str_CantCreateChild,'');
  OldHelpBar:=CurrentHelpBar;
  CurrentHelpBar:=HelpBar;

  InitPos;

  { Set keyboard hook for the accelerators }
  KbdHookInst:=MakeProcInstance(@TrapKbHook,HInstance);
  ghKbrdHook:=SetWindowsHookEx(wh_Keyboard,THookProc(KbdHookInst),
                               Hinstance,GetCurrentTask);
end;                                { TPattEditDlg.SetupWindow }

procedure TPattEditDlg.InitMenuHelp;
var
  H: HMenu;
begin
  MenuHelp.init(40,20);
  with MenuHelp do
  begin
    {--Criterion submenu--}
      Insert(New(PMenuHelpObj,init(mi_PattAddName,   HelpPatt_AddName)));
      Insert(New(PMenuHelpObj,init(mi_PattAddType,   HelpPatt_AddType)));
      Insert(New(PMenuHelpObj,init(mi_PattAddTagged, HelpPatt_AddTagged)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField,   HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField+1, HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField+2, HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField+3, HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField+4, HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField+5, HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField+6, HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(cm_FirstUserPattField+7, HelpPatt_AddUser)));
      Insert(New(PMenuHelpObj,init(mi_PattAddAll,   HelpPatt_AddAll  )));
      Insert(New(PMenuHelpObj,init(mi_PattAddOther, HelpPatt_AddOther)));

    {--Operator submenu--}
      Insert(New(PMenuHelpObj,init(mi_PattAND,  HelpPatt_AND)));
      Insert(New(PMenuHelpObj,init(mi_PattOR,   HelpPatt_OR )));
      Insert(New(PMenuHelpObj,init(mi_PattNAND, HelpPatt_NAND)));
      Insert(New(PMenuHelpObj,init(mi_PattNOR,  HelpPatt_NOR)));

    {--Edit submenu--}
      Insert(New(PMenuHelpObj,init(mi_PattEditModify,HelpPatt_Modify)));
      Insert(New(PMenuHelpObj,init(mi_PattEditNegate,HelpPatt_NOT   )));
      Insert(New(PMenuHelpObj,init(mi_PattEditCut,   HelpPatt_Cut   )));
      Insert(New(PMenuHelpObj,init(mi_PattEditCopy,  HelpPatt_Copy  )));
      Insert(New(PMenuHelpObj,init(mi_PattEditPaste, HelpPatt_Paste )));
      Insert(New(PMenuHelpObj,init(mi_PattEditDel,   HelpPatt_Delete)));
      Insert(New(PMenuHelpObj,init(mi_PattEditBS,    HelpPatt_BS    )));
      Insert(New(PMenuHelpObj,init(mi_PattClear,     HelpPatt_Clear )));
    
    {--File submenu--}
      Insert(New(PMenuHelpObj,init(mi_PattFileLoad, HelpPatt_FileLoad)));
      Insert(New(PMenuHelpObj,init(mi_PattFileSave, HelpPatt_FileSave)));

    Insert(New(PMenuHelpObj,init(id_ok,     HelpPatt_Save)));
    Insert(New(PMenuHelpObj,init(id_Cancel, HelpPatt_Quit)));

    { System menu }
    Insert(New(PMenuHelpObj,init(sc_Restore,  HelpSys_Restore)));
    Insert(New(PMenuHelpObj,init(sc_Move,     HelpSys_Move)));
    Insert(New(PMenuHelpObj,init(sc_Size,     HelpSys_Size)));
    Insert(New(PMenuHelpObj,init(sc_Minimize, HelpSys_Minimize)));
    Insert(New(PMenuHelpObj,init(sc_Maximize, HelpSys_Maximize)));
    Insert(New(PMenuHelpObj,init(sc_TaskList, HelpSys_TaskList)));
    Insert(New(PMenuHelpObj,init(sc_Close,    HelpSys_Close)));
    if SystemMenu_SystemID<>0 then
      Insert(New(PMenuHelpObj,init(SystemMenu_SystemID,HelpSys_System)));
  end;

  PopupHelp.Init(5,10);
  with PopupHelp do
  begin
    H:=GetMenu(HWindow);
    Insert(New(PMenuHelpObj,Init(Word(SearchForMenuItem(H,'Criterion')),
                                                        HelpPatt_AddMenu)));
    Insert(New(PMenuHelpObj,Init(Word(SearchForMenuItem(H,'Operator')),
                                                        HelpPatt_OpMenu)));
    Insert(New(PMenuHelpObj,Init(Word(SearchForMenuItem(H,'Edit')),
                                                        HelpPatt_EditMenu)));
    Insert(New(PMenuHelpObj,Init(Word(SearchForMenuItem(H,'File')),
                                                        HelpPatt_FileMenu)));
    PopupHelp.Insert(New(PMenuHelpObj,Init(GetSystemMenu(HWindow,false),HelpSys_Menu)));
  end;
end;                            { TPattEditDlg.InitMenuHelp }

procedure TPattEditDlg.UpdateEditMenu;

procedure DoIt(H: HMenu);
var
  en: boolean;
begin
  en:=(CurrentInd<Pattern^.noper);
  ChangeMenuState(H,mi_PattEditModify,en);
  ChangeMenuState(H,mi_PattEditNegate,en);
  ChangeMenuState(H,mi_PattEditDel,   en);
  ChangeMenuState(H,mi_PattEditBS,    CurrentInd>0);
  en:=en and (Pattern^.operation[CurrentInd+1]>0);
  ChangeMenuState(H,mi_PattEditCut,  en);
  ChangeMenuState(H,mi_PattEditCopy, en);
  ChangeMenuState(H,mi_PattEditPaste,MemFields<>'');
  ChangeMenuState(H,mi_PattClear,    Pattern^.noper>0);
end;

begin
  DoIt(GetMenu(HWindow));
  DoIt(HFloating);
end;                           { TPattEditDlg.UpdateEditMenu }

procedure TPattEditDlg.Update;
var
  H: HMenu;
  CaseSen,RegExp: boolean;
  i,depth: integer;
begin
  if CurrentInd<0 then CurrentInd:=0;
  if CurrentInd>Pattern^.noper then CurrentInd:=Pattern^.noper;
  CleanupPattern(Pattern);
  depth:=0;
  with Pattern^ do for i:=1 to noper do
    if operation[i]>0 then inc(depth) else dec(depth);

  GetPattCase(Pattern,CurrentInd,CaseSen,RegExp);
  H:=GetMenu(HWindow);

  ChangeMenuState(H,-CritMenuPos,(Pattern^.noper<MaxPattOper) and
                                 (Pattern^.npatt<MaxPattCrit));
  ChangeMenuState(H,-OpMenuPos,(Pattern^.noper<MaxPattOper) and (depth>1));
  ChangeMenuState(H,-EditMenuPos,(Pattern^.noper>0) or (MemFields<>''));

  ChangeMenuState(H,mi_PattFileSave,Pattern^.noper>0);
  ChangeMenuState(H,id_ok,          Pattern^.noper>0);
  DrawMenuBar(HWindow);
  DisplayArea^.Update; UpdateWindow(DisplayArea^.HWindow);
  DisplayArea^.CaretMove(CurrentInd,true);
  UpdateEditMenu;

  HelpBar^.Update(CaseSen,RegExp);
  FirstTime:=false;
end;                               { TPattEditDlg.Update }

procedure TPattEditDlg.wmSize(var Msg: TMessage);
var
  Rect: TRect;
  W,H: integer;
  F: array[0..255] of char;
  D,N,E: Pstring;
begin
  if Msg.wParam=Size_Minimized then
  begin
    AllocStrings(true,@D,@N,@E,Nil);
    CanonicalFname(bibname^);
    LFNFSplit(bibname^,D,N,E); 
    StrPCopy(F,StrPas(WindowCaption)+' - '+N^+E^);
    AllocStrings(false,@D,@N,@E,Nil);
    SetWindowText(HWindow,F);
    ShowWindow(HMainW,sw_Hide);
  end else
  begin
    GetWindowText(HWindow,F,255);
    if StrComp(F,WindowCaption)<>0 then SetWindowText(HWindow,WindowCaption);
    ShowWindow(HMainW,sw_Show);
    GetClientRect(HWindow,Rect);
    W:=Rect.right-Rect.left; H:=rect.Bottom-Rect.Top;
    MoveWindow(DisplayArea^.HWindow,-1,-1,Rect.right+2,
               Rect.bottom-HelpBar^.Height+1,true);
    HelpBar^.MoveBarTo(W,H);
    Update;
  end;
end;                             { TPattEditDlg.wmSize }

procedure TPattEditDlg.wmNCHitTest(var Msg: TMessage);
begin
  HelpBar^.HideHelpText(false,true);       
  DefWndProc(Msg);
end;

procedure TPattEditDlg.wmInitMenu(var Msg: TMessage);
begin
  PattMenuActive:=true;
end;

procedure TPattEditDlg.wmMenuSelect(var Msg: TMessage);
var
  MP: PMenuHelpObj;

function Matches(P: Pointer): boolean; far;
begin
  Matches:=PMenuHelpObj(P)^.m=Msg.wParam;
end;

begin
  if (Msg.lParamLo=word(-1)) and (Msg.lParamHi=0) then  { Closed the menu }
  begin
    HelpBar^.ClearHelpText;
    InvalidateRect(HelpBar^.HWindow,Nil,true);
    PattMenuActive:=false;
    UpdateWindow(HelpBar^.HWindow);
  end else if Msg.lParamLo and mf_Separator=0 then
  begin
    if Msg.lParamLo and mf_Popup<>0 then
      MP:=PopupHelp.FirstThat(@Matches)
    else MP:=MenuHelp.FirstThat(@Matches);
    if MP=Nil then HelpBar^.HideHelpText(false,true)
    else begin
      HelpBar^.PutHelpText(MP^.s);
    end;
  end else HelpBar^.ClearHelpText;
end;                           { TPattEditDlg.wmMenuSelect }

procedure TPattEditDlg.wmEnterIdle(var Msg: TMessage);
begin
  if (Msg.wparam=msgf_DialogBox) then
    TResizableDialog.wmEnterIdle(Msg)
  else HelpBar^.CheckHelpPos(true);
end;

procedure TPattEditDlg.UpdatePos(NewInd: integer);
var
  i,depth,OldDep,OldInd: integer;
  H: HMenu;
  CaseSen,Regexp: boolean;
begin
  if NewInd<0 then NewInd:=0;
  if NewInd>Pattern^.noper then NewInd:=Pattern^.noper;
  depth:=0; OldDep:=0; OldInd:=CurrentInd;
  for i:=1 to CurrentInd do
    if Pattern^.operation[i]>0 then inc(OldDep) else dec(OldDep);
  for i:=1 to NewInd do
    if Pattern^.operation[i]>0 then inc(Depth) else dec(Depth);

  CurrentInd:=NewInd;
  DisplayArea^.CaretMove(CurrentInd,true);

  UpdateEditMenu;
  if (depth<2)<>(OldDep<2) then
  begin
    H:=GetMenu(HWindow);
    ChangeMenuState(H,-OpMenuPos,(Pattern^.noper<MaxPattOper) and (depth>1));
    DrawMenuBar(HWindow);
  end;

  GetPattCase(Pattern,CurrentInd+1,CaseSen,RegExp);
  HelpBar^.Update(CaseSen,RegExp);
end;                            { TPattEditDlg.UpdatePos }

procedure TPattEditDlg.ArrowKeys(var Msg: TMessage);
var
  Ctrl: boolean;
begin
  Ctrl:=GetKeyState(vk_Control)<0;
  case Msg.wParam of
    vk_Down:
      if Ctrl then DisplayArea^.Scroller^.ScrollBy(0,1)
      else if CurrentInd<Pattern^.noper then UpdatePos(CurrentInd+1);
    vk_Up:
      if Ctrl then DisplayArea^.Scroller^.ScrollBy(0,-1)
      else if CurrentInd>0 then UpdatePos(CurrentInd-1);
    vk_Next:      DisplayArea^.Scroller^.ScrollBy(0,DisplayArea^.Scroller^.YPage);
    vk_Prior:     DisplayArea^.Scroller^.ScrollBy(0,-DisplayArea^.Scroller^.YPage);
    vk_Home:
      if Ctrl then DisplayArea^.Scroller^.ScrollTo(0,0)
      else if CurrentInd<>0 then UpdatePos(0);
    vk_End:
      if Ctrl then DisplayArea^.Scroller^.ScrollTo(0,DisplayArea^.Scroller^.YRange)
      else if CurrentInd<>Pattern^.noper then UpdatePos(Pattern^.noper);
  end;
end;                              { TPattEditDlg.ArrowKeys }

procedure TPattEditDlg.wmActivate(var Msg: TMessage);
begin
  if Msg.wParam=wa_Inactive then
  begin
    PattWindowActive:=false;
    DisplayArea^.CaretDestroy;
  end else
  begin
    DisplayArea^.CaretRestore;
    PattWindowActive:=true;
  end;
  TResizableDialog.wmActivate(Msg);
end;

procedure TPattEditDlg.ClickedOnField(var Msg: TMessage);
var
  MP: longint;
begin
  UpdatePos(Msg.wParam);;
  MP:=GetMessagePos;
  if Msg.lParamLo=mk_RButton then
  begin
    TrackPopupMenu(HFloating,tpm_LeftAlign or tpm_RightButton,
                   LoWord(MP), HiWord(MP), 0, HWindow, Nil)
  end else if Msg.lParamLo=mk_MButton then
    Modify(Msg);
end;                            { TPattEditDlg.ClickedOnField }

{ Work methods }

function TPattEditDlg.InsertCrit(Ind: integer; flds,strng: string;
         Neg,CaseSen,RegExp: boolean): boolean;
var
  i,fpatt: integer;
begin
  InsertCrit:=false;
  with Pattern^ do
  if (noper>=MaxPattOper) or (npatt>=MaxPattCrit) then
        ErrorMessageRC(Str_PattTooComplex,'')
  else begin
    fpatt:=0;
    for i:=1 to Ind-1 do if operation[i]>0 then fpatt:=operation[i];
    inc(fpatt);
    inc(npatt);
    if npatt>1 then
    for i:=npatt downto fpatt+1 do
    begin
      Patrn[i]:=Patrn[i-1]; Field[i]:=Field[i-1];
    end;
    Field[fpatt]:=flds; Patrn[fpatt]:=strng;
    inc(noper);
    if noper>1 then
    for i:=noper downto Ind+1 do
    begin
      operation[i]:=operation[i-1]; flag[i]:=flag[i-1];
      if operation[i]>0 then inc(operation[i]);
    end;
    operation[Ind]:=fpatt;
    Flag[Ind]:=0;
    if Neg then Flag[Ind]:=Flag[Ind] or PattFlag_NOT;
    if CaseSen then Flag[Ind]:=Flag[Ind] or PattFlag_CaseSen;
    if RegExp  then Flag[Ind]:=Flag[Ind] or PattFlag_Regexp;
    InsertCrit:=true;
    changed:=true; 
  end;
end;                           { TPattEditDlg.InsertCrit }

function TPattEditDlg.InsertOperator(Ind: Integer; ANDOp,Neg: boolean): boolean;
var
  i,dep: integer;
begin
  InsertOperator:=false;
  with Pattern^ do
  if noper>=MaxPattOper then
    ErrorMessageRC(Str_PattTooComplex,'')
  else begin
    dep:=0;
    for i:=1 to Ind-1 do
      if operation[i]>0 then inc(dep) else dec(dep);
    if dep>1 then
    begin
      inc(noper);
      for i:=noper downto Ind+1 do
      begin
        operation[i]:=operation[i-1]; flag[i]:=flag[i-1];
        if operation[i]>0 then inc(operation[i]);
      end;
      if ANDOp then operation[Ind]:=Patt_AND
      else operation[Ind]:=Patt_OR;
      Flag[Ind]:=0;
      if Neg then Flag[Ind]:=Flag[Ind] or PattFlag_NOT;
      InsertOperator:=true;
      changed:=true;
    end;
  end;
end;                          { TPattEditDlg.InsertOperator }

procedure TPattEditDlg.RemoveItem(Ind: integer);
var
  i,op: integer;
begin
  with Pattern^ do
  begin
    op:=operation[Ind];
    if op>0 then
    begin
      for i:=op to npatt-1 do
      begin
        Field[i]:=Field[i+1]; Patrn[i]:=Patrn[i+1];
      end;
      dec(npatt);
    end;
    for i:=Ind to noper-1 do
    begin
      operation[i]:=operation[i+1]; flag[i]:=flag[i+1];
      if (op>0) and (operation[i]>op) then dec(operation[i]);
    end;
    noper:=noper-1;
    changed:=true;
  end;
end;                           { TPattEditDlg.RemoveItem }

function TPattEditDlg.ModifyField(Ind: integer): boolean;
var
  CaseSen,RegExp,OldCase,OldReg,Negate,OldNegate: boolean;
  i,j,ipatt: integer;
  modified: boolean;
  op: integer;
  flds: PattFieldStr;
  Ptrn: string;
begin
  modified:=false;
  with Pattern^ do
  begin
    op:=0;
    ipatt:=operation[Ind]; if ipatt<0 then Exit;
    CaseSen:=(flag[Ind] and PattFlag_CaseSen)<>0;
    RegExp :=(flag[Ind] and PattFlag_Regexp )<>0;
    Negate :=(flag[Ind] and PattFlag_NOT    )<>0;
    OldNegate:=Negate;
    flds:=field[ipatt]; Ptrn:=Patrn[ipatt];
    if flds=PattField_Tagged then
    begin
      modified:=Application^.ExecDialog(New(PTaggedDlg,
                                init(@Self,@Negate)))=id_ok;
      if modified then
      begin
        field[ipatt]:=flds; Patrn[ipatt]:=Ptrn;
        flag[Ind]:=0; if negate then flag[Ind]:=PattFlag_NOT;
      end;
    end else if flds=PattField_Type then
    begin
      modified:=Application^.ExecDialog(New(PSelectTypesDlg,
                                init(@Self,@Ptrn,@negate)))=id_ok;
      if modified then
      begin
        field[ipatt]:=flds; Patrn[ipatt]:=Ptrn;
        flag[Ind]:=0; if negate then flag[Ind]:=PattFlag_NOT;
      end;
    end else
    begin
      modified:=Application^.ExecDialog(New(PEditPattFieldDlg,
          init(@Self,@RegExp,@CaseSen,@Negate,@flds,@Ptrn)))=id_ok;
      if modified then
      begin
        field[ipatt]:=flds; Patrn[ipatt]:=Ptrn;
        flag[Ind]:=0;
        if CaseSen then flag[Ind]:=flag[Ind] or PattFlag_CaseSen;
        if Regexp  then flag[Ind]:=flag[Ind] or PattFlag_Regexp;
        if Negate  then flag[Ind]:=flag[Ind] or PattFlag_NOT;
      end;
    end;
  end;
  if Modified then Changed:=true;
  ModifyField:=Modified;
end;                             { TPattEditDlg.ModifyField }

function TPattEditDlg.ModifyOp(Ind: integer): boolean;
var
  ipatt: integer;
  modified,Negate: boolean;
begin
  modified:=false;
  ModifyOp:=false;
  with Pattern^ do
  begin
    ipatt:=operation[Ind]; if ipatt>=0 then Exit;
    Negate:=(flag[Ind] and PattFlag_NOT)<>0;
    modified:=Application^.ExecDialog(New(PLogOperDlg,
                                       init(@Self,@ipatt,@negate)))=id_ok;
    if modified then
    begin
      operation[Ind]:=ipatt;
      if Negate then flag[Ind]:=PattFlag_NOT
      else flag[Ind]:=0;
    end;
  end;
  if Modified then Changed:=true;
  ModifyOp:=modified;
end;                             { TPattEditDlg.ModifyOp }

procedure TPattEditDlg.NewField(selected: integer);
var
  i,j,icode : integer;
  ifld,lastfld : byte;
  CaseSen,RegExp,o_k,AuthorAll,retain,Negate: boolean;
  nspec: integer;
  flds,crit: string;
begin
  if selected=0 then Exit;
  with Pattern^ do
  if (noper>=MaxPattOper) or (npatt>=MaxPattCrit) then
    ErrorMessageRC(Str_PattTooComplex,'')
  else begin
    o_k:=false;
    GetPattCase(Pattern,CurrentInd+1,CaseSen,RegExp);
    flds:=''; Crit:=''; Negate:=false;

    { Fields }
    case selected of
      CPattAdd_name:   flds:=PattField_Name;
      CPattAdd_Type:   flds:=PattField_Type;
      CPattAdd_Tagged: flds:=PattField_Tagged;
      CPattAdd_All:    for i:=1 to StringIndex+1 do flds:=flds+Chr(i-1);
      CPattAdd_Same:
        begin
          i:=npatt-1;
          while (i>0) and (operation[i]<=0) do dec(i);
          if i<>0 then flds:=field[i];
        end; 
      CPattAdd_Other: if Application^.ExecDialog(New(PSearchFieldsDlg,
                         Init(@Self,@flds)))<>id_ok then Exit;
      CPattAdd_User..cPattAdd_User+7:
        for i:=1 to PmenuChoice[selected-CPattAdd_User+1,0] do
          flds:=flds+Chr(PmenuChoice[selected-CPattAdd_User+1,i]);
    end;
    if flds='' then Exit;

    { Data }
    if flds=PattField_Type then   {Type}
    begin
      if (Application^.ExecDialog(New(PSelectTypesDlg,Init(@Self,@crit,
                              @Negate)))<>id_ok) then  Exit;
    end else if flds<>PattField_Tagged then
    begin
      AuthorAll:=true;
      nspec:=length(flds);
      for i:=1 to nspec do
      begin
        if (ord(flds[i])>0) and (ord(flds[i])<=fieldlast) then
            AuthorAll:=AuthorAll and FieldParams^[ord(flds[i])].Authorlike
        else if (ord(flds[i])>0) and (ord(flds[i])=StringIndex) then
            AuthorAll:=false;
      end;
      if Application^.ExecDialog(New(PEditPattFieldDlg,
            init(@Self,@RegExp,@CaseSen,@Negate,
              @Flds,@Crit)))<>id_ok then Exit;
      ChrDelL(Crit,' '); ChrDelR(Crit,' ');
      if Prog7bit then SConv27Bit(Crit,AuthorAll)
      else if Prog8bit then SConv28Bit(Crit,AuthorAll);
    end;

    if InsertCrit(CurrentInd+1,flds,Crit,Negate,CaseSen,Regexp) then
    begin
      changed:=true; UpdatePos(CurrentInd+1);;
      Update;
    end;
  end;
end;                     { NewField }

procedure   TPattEditDlg.AddName(var Msg: TMessage);
begin NewField(CPattAdd_name); end;

procedure   TPattEditDlg.AddType(var Msg: TMessage);
begin NewField(CPattAdd_Type); end;

procedure   TPattEditDlg.AddTagged(var Msg: TMessage);
begin NewField(CPattAdd_Tagged); end;

procedure   TPattEditDlg.AddUser1(var Msg: TMessage);
begin NewField(CPattAdd_User); end;

procedure   TPattEditDlg.AddUser2(var Msg: TMessage);
begin NewField(CPattAdd_User+1); end;

procedure   TPattEditDlg.AddUser3(var Msg: TMessage);
begin NewField(CPattAdd_User+2); end;

procedure   TPattEditDlg.AddUser4(var Msg: TMessage);
begin NewField(CPattAdd_User+3); end;

procedure   TPattEditDlg.AddUser5(var Msg: TMessage);
begin NewField(CPattAdd_User+4); end;

procedure   TPattEditDlg.AddUser6(var Msg: TMessage);
begin NewField(CPattAdd_User+5); end;

procedure   TPattEditDlg.AddUser7(var Msg: TMessage);
begin NewField(CPattAdd_User+6); end;

procedure   TPattEditDlg.AddUser8(var Msg: TMessage);
begin NewField(CPattAdd_User+7); end;

procedure   TPattEditDlg.AddAll(var Msg: TMessage);
begin NewField(CPattAdd_All); end;

procedure   TPattEditDlg.AddOther(var Msg: TMessage);
begin NewField(CPattAdd_Other); end;

{----}

procedure TPattEditDlg.AddAND(var Msg: TMessage);
begin
  if InsertOperator(CurrentInd+1,true,false) then
  begin
    UpdatePos(CurrentInd+1); Update;
  end;
end;                          { TPattEditDlg.AddAND }

procedure TPattEditDlg.AddOR(var Msg: TMessage);
begin
  if InsertOperator(CurrentInd+1,false,false) then
  begin
    UpdatePos(CurrentInd+1); Update;
  end;
end;                         { TPattEditDlg.AddOR }

procedure TPattEditDlg.AddNAND(var Msg: TMessage);
begin
  if InsertOperator(CurrentInd+1,true,true) then
  begin
    UpdatePos(CurrentInd+1); Update;
  end;
end;                          { TPattEditDlg.AddAND }

procedure TPattEditDlg.AddNOR(var Msg: TMessage);
begin
  if InsertOperator(CurrentInd+1,false,true) then
  begin
    UpdatePos(CurrentInd+1); Update;
  end;
end;                         { TPattEditDlg.AddOR }

procedure TPattEditDlg.NegateItem(var Msg: TMessage);
var
  Ind: integer;
begin
  Ind:=CurrentInd+1;
  with Pattern^ do
  if Ind<=noper then
  begin
    if (flag[Ind] and PattFlag_NOT)<>0 then
      flag[Ind]:=flag[Ind] and not PattFlag_NOT
    else
      flag[Ind]:=flag[Ind] or PattFlag_NOT;
    changed:=true;
    Update;
  end;
end;                        { TPattEditDlg.Negate }

procedure TPattEditDlg.Modify(var Msg: TMessage);
var
  o_k: boolean;
begin
  with Pattern^ do
  if CurrentInd<noper then
  begin
    if operation[CurrentInd+1]<0 then
      o_k:=ModifyOp(CurrentInd+1)
    else
      o_k:=ModifyField(CurrentInd+1);
    if o_k then Update;
  end;
end;

procedure TPattEditDlg.CutItem(var Msg: TMessage);
begin
  with Pattern^ do
  if (CurrentInd<noper) and (operation[CurrentInd+1]>0) then
  begin
    MemFields:=field[operation[CurrentInd+1]];
    MemCrit:=patrn[operation[CurrentInd+1]];
    MemFlag:=flag[CurrentInd+1];
    RemoveItem(CurrentInd+1);
    changed:=true; Update;
  end;
end;

procedure TPattEditDlg.CopyItem(var Msg: TMessage);
begin
  with Pattern^ do
  if (CurrentInd<noper) and (operation[CurrentInd+1]>0) then
  begin
    MemFields:=field[operation[CurrentInd+1]];
    MemCrit:=patrn[operation[CurrentInd+1]];
    MemFlag:=flag[CurrentInd+1];
    UpdateEditMenu;
  end;
end;

procedure TPattEditDlg.PasteItem(var Msg: TMessage);
begin
  if (MemFields<>'') and
    InsertCrit(CurrentInd+1,MemFields,MemCrit,(MemFlag and PattFlag_NOT<>0),
               (MemFlag and PattFlag_CaseSen<>0),
               (MemFlag and PattFlag_Regexp<>0)) then
  begin
    changed:=true;
    UpdatePos(CurrentInd+1);
    Update;
  end;
end;

procedure TPattEditDlg.Backspace(var Msg: TMessage);
begin
  if CurrentInd>0 then
  begin
    RemoveItem(CurrentInd);
    UpdatePos(CurrentInd-1);
    Update;
  end;
end;                         { TPattEditDlg.Backspace }

procedure TPattEditDlg.DelKey(var Msg: TMessage);
begin
  if CurrentInd<Pattern^.noper then
  begin
    RemoveItem(CurrentInd+1); Update;
  end;
end;                         { TPattEditDlg.DelKey }

procedure TPattEditDlg.Clear(var Msg: TMessage);
begin
  with Pattern^ do
  begin
    if noper=0 then Exit;
    noper:=0; npatt:=0; on:=false;
  end;
  changed:=true; UpdatePos(0);        
  Update;
end;                            { TPattEditDlg.Clear }

procedure TPattEditDlg.LoadFile(var Msg: TMessage);
var
  o_k: boolean;
begin
  PatternLoad(Pattern,'',true,o_k);
  if o_k then
  begin
    changed:=true;
    UpdatePos(Pattern^.noper);
    Update;
  end;
end;                     { TPattEditDlg.LoadFile }

procedure TPattEditDlg.SaveFile(var Msg: TMessage);
var
  i,depth: integer;
begin
  depth:=0;
  with Pattern^ do
  for i:=1 to noper do
    if operation[i]>0 then inc(depth) else dec(depth);
  if depth<=1 then PatternSave(Pattern)
  else ErrorMessageRC(Str_PatternIncomplete,'');
end;                       { TPattEditDlg.SaveFile }

function TPattEditDlg.CanClose: boolean;
var
  i,j: integer;
begin
  j:=0;
  with Pattern^ do
    for i:=1 to noper do
      if operation[i]>0 then inc(j)
      else if (operation[i]=Patt_AND) or (operation[i]=Patt_OR) then dec(j);
  if j>1 then
  begin
    ErrorMessageRC(Str_PatternIncomplete,''); CanClose:=false;
  end else CanClose:=true;
end;                      { TPattEditDlg.CanClose }

procedure TPattEditDlg.SaveIt(var Msg: TMessage);
var
  i: integer;
begin
  if not CanClose then Exit;
  if not changed then EndDlg(id_cancel)
  else begin
    with Pattern^ do
    begin
      for i:=1 to noper do
        if operation[i]>0 then
          SortPattField(Field[operation[i]]);
      on:=(noper>0);
    end;
    EndDlg(id_ok);
  end;
end;                    { TPattEditDlg.SaveIt }

procedure TPattEditDlg.QuitIt(var Msg: TMessage);
begin
  if not changed then EndDlg(id_cancel)
  else case AskIf3(StringRC(Str_PattChangedQuit,''),'&Quit','&Save','Cance&l') of
    1: EndDlg(id_Cancel);
    2: SaveIt(Msg);
  end;
end;

procedure TPattEditDlg.ok(var Msg: TMessage);
begin
  SaveIt(Msg);
end;

destructor TPattEditDlg.Done;
begin
  UnhookWindowsHookEx(ghKbrdHook);
  FreeProcInstance(KbdHookInst);
  if HFloating<>0 then DestroyMenu(HFloating);
  MenuHelp.Done; PopupHelp.Done; AccelKeys.Done;
  CurrentHelpBar:=OldHelpBar;
  StrDispose(WindowCaption);
  TResizableDialog.Done;
end;

{---------------------------------------------}

procedure PatternGet(W: PWindowsObject;
                     Pattern: PatRecPtr; var changed: boolean);
begin
  PushBufferStack(Pattern^,sizeof(PatRec),EnoughMem(sizeof(PatRec)),0);
  changed:=Application^.ExecDialog(New(PPattEditDlg,init(W,Pattern)))=id_ok;
  if not changed then RecallBufferStack(Pattern^,0)   { Quit }
  else inc(PatternNumber);
  if (Pattern^.npatt=0) or (Pattern^.noper=0) then Pattern^.on:=false;
  DiscardBufferStack;
end;

function OneCritPattern(Pattern: PatRecPtr; CritInd: integer): boolean;
var
  Regexp,Casesen,Negate,AuthorAll: boolean;
  Crit,flds: string;
  i,nspec: integer;
begin
  OneCritPattern:=false;
  Regexp:=false; Casesen:=false; Negate:=false; Crit:='';
  with Pattern^ do
  begin
    if (noper=1) then
    begin
      CaseSen:=(flag[1] and PattFlag_CaseSen)<>0;
      RegExp :=(flag[1] and PattFlag_CaseSen)<>0;
      Negate :=(flag[1] and PattFlag_NOT    )<>0;
      Crit:=Patrn[1];
    end;
    flds:='';
    if CritInd=CPatt_AllFields then
      for i:=1 to StringIndex+1 do flds:=flds+Chr(i-1)
    else flds:=PString(@PmenuChoice[CritInd-CPatt_User+1,0])^;
    AuthorAll:=true;
    nspec:=length(flds);
    for i:=1 to nspec do
    begin
      if (ord(flds[i])>0) and (ord(flds[i])<=fieldlast) then
          AuthorAll:=AuthorAll and FieldParams^[ord(flds[i])].Authorlike
      else if (ord(flds[i])>0) and (ord(flds[i])=StringIndex) then
          AuthorAll:=false;
    end;
    if Application^.ExecDialog(New(PEditPattFieldDlg,
          init(MainW,@RegExp,@CaseSen,@Negate,
            @Flds,@Crit)))<>id_ok then Exit;
    ChrDelL(Crit,' '); ChrDelR(Crit,' ');
    if Prog7bit then SConv27Bit(Crit,AuthorAll)
    else if Prog8bit then SConv28Bit(Crit,AuthorAll);

    noper:=1; npatt:=1;
    Patrn[1]:=Crit; Field[1]:=flds;
    operation[1]:=1;
    Flag[1]:=0;
    if Negate  then Flag[1]:=Flag[1] or PattFlag_NOT;
    if CaseSen then Flag[1]:=Flag[1] or PattFlag_CaseSen;
    if RegExp  then Flag[1]:=Flag[1] or PattFlag_Regexp;
    on:=true;
    OneCritPattern:=true;
  end;
end;

begin
  { Pattern heirarchy }
  New(PattHeirarchy,init(20,20));
  PattHeirMenuStart:=-1;
  PattHeirMenu:=0;
  PattHeirList:=Nil; PattAssocList:=Nil;
end.
