#ifndef _Cpptcl_cpptclcompilers_
#define _Cpptcl_cpptclcompilers_

#ifndef __WIN32__
#   if defined(_WIN32) || defined(WIN32)
#	define __WIN32__
#   endif
#endif

#if defined(__WIN32__)
/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */
	#   define WIN32_LEAN_AND_MEAN
	#   include <windows.h>
	#   undef WIN32_LEAN_AND_MEAN
	#   if defined(_MSC_VER)
		#	define EXPORT(a,b) __declspec(dllexport) a b
		#	define DllEntryPoint DllMain
	#   else
		#	if defined(__BORLANDC__)
		#	    define EXPORT(a,b) a _export b
		#	else
		#	    define EXPORT(a,b) a b
		#	endif
	#   endif
	#ifndef IGNORE_CPPTCL_ENTRY_POINT
	#ifdef USE_TCL_STUBS
	#define CPPTCL_PLATFORM_ENTRY \
	BOOL APIENTRY \
	DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved); \
	BOOL APIENTRY \
	DllEntryPoint(HINSTANCE, DWORD, LPVOID) { \
		Tcl_InitStubs(NULL,TCL_VERSION,0);\
		return TRUE; \
	}
	#else
	#define CPPTCL_PLATFORM_ENTRY \
	BOOL APIENTRY \
	DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved); \
	BOOL APIENTRY \
	DllEntryPoint(HINSTANCE, DWORD, LPVOID) { \
		return TRUE; \
	}
	#endif
	#else
	#define CPPTCL_PLATFORM_ENTRY
	#endif
	// Microsoft define the most obnoxious macros
	#ifdef min
	#undef min
	#endif
	#ifdef max
	#undef max
	#endif
	#ifdef __MWERKS__  // MetroWerks CodeWarrior Pro
		#define NO_EXCEPTION_HANDLING
	#endif
	//EXTERN EXPORT(int,Example_Init) _ANSI_ARGS_((Tcl_Interp *interp));
	//EXTERN EXPORT(int,Example_SafeInit) _ANSI_ARGS_((Tcl_Interp *interp));
#else
	// Not Windows: i.e. sensible OS like Unix or MacOS
	// which doesn't need the above nonsense
	#   define EXPORT(a,b) a b
	#define CPPTCL_PLATFORM_ENTRY
	#ifdef __MWERKS__  // MetroWerks CodeWarrior Pro
		// MacOS
		#include "MW_CpptclHeader.h"
		#define MSL_USE_PRECOMPILED_HEADERS 0
		#define NO_EXCEPTION_HANDLING
	#endif
#endif

// You need to uncomment this to build big monolithic dll's rather
// than using the standard hierarchy of separate dll's.
//#define CPPTCL_EXPORT_EVERYTHING

#if defined(__WIN32__)
	#ifndef DLL_EXPORT
	#define DLL_EXPORT __declspec(dllexport)
	#endif
	#ifndef DLL_IMPORT
	#ifdef CPPTCL_EXPORT_EVERYTHING
	#define DLL_IMPORT __declspec(dllexport)
	#else
	#define DLL_IMPORT __declspec(dllimport)
	#endif
	#endif
#else
	// Not Windows: i.e. sensible OS like Unix or MacOS
	// which doesn't need the above nonsense
	#ifndef DLL_EXPORT
	#define DLL_EXPORT 
	#endif
	#ifndef DLL_IMPORT
	#define DLL_IMPORT 
	#endif
#endif

#endif

