/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_member_object.cc"
 *                                    created: 25/10/97 {6:46:34 pm} 
 *                                last update: 05/06/98 {16:29:39 PM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ========================================================================
 *               Copyright (c) 1997 Vince Darley
 * ========================================================================
 *  See header file for further information
 * ###################################################################
 */

#include "cpptcl_member_object.h"
#include "tcl_object.h"
#include "meta_object.h"

Cpptcl_IBaseClass(cpp_object_mem,"memberobject",cpp_config_mem);
Cpptcl_IBaseClass(cpp_objectbag_mem,"membertclobject",cpp_object_mem);
Cpptcl_IBaseClass(cpp_tclobject_mem,"memberbagofobjects",cpp_object_mem);

int cpp_tclobject_mem::parse_tcl_command(tcl_args& arg) {
	// behave like an object
	container = (tcl_object*)arg.container;
	tcl_object* setter = container->*obptr;
	if(setter) {
		return setter->tcl_command_entry_point(arg);
	} else {
		tcl_obj& tcl_ = arg;
		tcl_ << "No object has yet been embedded." << tcl_error;
		return tcl_; 
	}
}

void cpp_tclobject_mem::tcl_get(tcl_object* o, tcl_obj& tcl_) const {
	tcl_object* e = o->*obptr;
	if(e) {
		tcl_ << e;
	}
}

void cpp_tclobject_mem::tcl_set(tcl_object* o, tcl_args_reader& istr) const {
	// remove old value if set
	tcl_object* setter = o->*obptr;
	tcl_object* embed;
	if(embed_this(istr,embed)) {
		if(setter) {
			remove_this_object(setter);
		}
		o->*obptr = embed;
	} else {
		int len;
		Tcl_GetStringFromObj(istr,&len);
		// check if setting to ""
		if(len == 0) {
			if(setter) {
				remove_this_object(setter);
			}
			o->*obptr = 0;
			return;
		} else {
			istr.setstate(tcl_args_reader::Fail);
			return;
		}
	}
}

void cpp_object_mem::remove_this_object(tcl_object *& setter) const {
	if(setter) {
		if(setter->embedded()) {
			delete setter;
		}
		setter = 0;
	}
}

void cpp_objectbag_mem::tcl_get(tcl_object* o, tcl_obj& tcl_) const {
	tcl_ << bag(o);
}

void cpp_objectbag_mem::tcl_set(tcl_object* o, tcl_args_reader& istr) const {
	// adds to the bag
	tcl_object* embed;
	if(embed_this(istr,embed)) {
		append(o,embed);
	} else {
		istr.setstate(tcl_args_reader::Fail);
	}
}

tcl_object* cpp_objectbag_mem::get_bagged_item(tcl_args& arg) {
	container = (tcl_object*)arg.container;
	list<tcl_object*>& items = bag(container);
	for(list_pos<tcl_object*> s = items.headConst(); s; s++) {
		if(arg == s.item()->char_tcl_command()) {
			return s.item();
		}
	}
	arg.no_match();
	return 0;
}

tcl_object*& cpp_objectbag_mem::where_is_it(tcl_object* cont) {
	list<tcl_object*>& items = bag(cont);
	items.append(0);
	return items.tail_element();
}

int cpp_objectbag_mem::parse_tcl_command(tcl_args& arg) {
	// check names of bagged items
	if(arg("item","removes it")=="remove") {
		tcl_object* b = get_bagged_item(arg);
		arg >> done;
		NO_EXCEPTIONS(arg);
		if(b) {
			remove((tcl_object*)arg.container,b);
			remove_this_object(b);
		}
		return TCL_OK;
	} else if(arg("item","add it")=="add") {
	    configure_member(arg);
	    arg >> done;
	    NO_EXCEPTIONS(arg);
	    return TCL_OK;
	} else {
		tcl_object *sub = get_bagged_item(arg);
		NO_EXCEPTIONS(arg);
		arg >> done;
		NO_EXCEPTIONS(arg);
		return sub->tcl_command_entry_point(arg);
	}
}
