/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "Demofour.cc"
 *									  created: 21/10/95 {4:43:33 pm}	
 *								  last update: 29/10/97 {6:34:13 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "Demofour.h"
#include <string.h>

Cpptcl_Members(siteswap) = { 
	cppDatamember("Ground or excited",siteswap::ground,int).set_items("Ground only\0Excited only\0Both\0\0"),
	cppDatamember("Just count",siteswap::numonly,bool),
	cppDatamember("Irreducible only",siteswap::irred,bool),
	cppDatamember("Allow 11",siteswap::allow_oneone,bool),
	cppDatamember("Rhythm",siteswap::rhythm,int).set_items("Asynch Solo\0Synch Solo\0Asynch Passing\0Custom\0\0"),
	cppDatamember("Number of balls",siteswap::number,int).set_min(1),
	cppDatamember("Maximum throw",siteswap::maxThrow,int).set_min(1),
	cppDatamember("Pattern length",siteswap::pattLen,int).set_min(1),
	cppDatamember("Multiplex",siteswap::multiplex,int).set_min(1),
	cppDatamember("Streams",siteswap::streams,int).set_min(1),
	cppDatamember("Total number",siteswap::total_num,long).set_min(0)
};

Cpptcl_IClass(siteswap,"Siteswap",tcl_object);


int solo_rhythm_repunit[1][1] =           { { 1 } };
int synch_rhythm_repunit[2][2] =          { { 1, 0 },
                                            { 1, 0 } };
int asynch_passing_rhythm_repunit[2][1] = { { 1 },
                                            { 1 } };
siteswap::siteswap(tcl_args& arg)
	:tcl_object(arg)
{
	// default values
	ground = 3;
	numonly = false;
	irred = true;
	allow_oneone = false;
	rhythm = 1;
	number = 5;
	maxThrow = 9;
	pattLen = 3;
	multiplex = 1;
	streams = 1;
	total_num = 0;

}


//virtual
int siteswap::parse_tcl_command(tcl_args& arg){
  	if (arg("")=="listPatterns"){
  		DONE(arg);
  		set_rhythm();
  		declare_arrays();
  		if(!find_ground())
  			return TCL_ERROR;
  		total_num = 0;
		do {
			print_streams();
		}
		while (find_next_possible(pattLen-1,1,multiplex-1,0));	
  		delete_arrays();
  		tcl_ << result;
  		return TCL_OK;
  	} else if (arg("")=="findGround"){
  		DONE(arg);
  		set_rhythm();
		declare_arrays();
  		find_ground();
  		delete_arrays();
  		tcl_ << result;
  		return tcl_;
  	} else {
    	return tcl_object::parse_tcl_command(arg); 
  	}
}

/*	char	starting_seq[MaxStreams*MaxThrow*CHARS_PER_THROW],
			ending_seq[MaxStreams*MaxThrow*CHARS_PER_THROW];
	
	int	pattern_catch[MaxLength][MaxStreams],
			ground_rhythm[MaxBalls][MaxStreams][MaxMplex],
			pattern_rhythm[MaxLength][MaxStreams][MaxMplex];
			
	struct	jthrow pattern_throw[MaxLength][MaxStreams][MaxMplex];
*/	



/*  gen_patterns -- This generates loops, given a particular   */
/*                  starting state.                            */

bool siteswap::find_next_possible(int position, int stream, int mplex_slot, int remainder) {
   	
	do {	
		while (!remainder 
				|| (!pattern_rhythm[position][stream][mplex_slot])
				|| (pattern_throw[position][stream][mplex_slot].height == maxThrow)
				|| ((mplex_slot>0)  
					&& (pattern_throw[position][stream][mplex_slot].height 
							>= pattern_throw[position][stream][mplex_slot-1].height))
			) {
			if (pattern_increment(position,stream,mplex_slot,remainder))
				return(false);
		}
			
		pattern_throw[position][stream][mplex_slot].height++;
		remainder--;
		position = pattLen-1;
		mplex_slot = multiplex -1;
		stream = 1;
	
	} while (remainder);
	return(true);
}	

 
 /*  check_pattern -- checks for validity  */

bool siteswap::check_pattern() {
	
   int i, j, k, di, dj, dk, p1, p2, t1, t2;
   bool gflag;
   
	
/* clear state, insert rhythm , subtract catches */

	for (j = 1; j <= streams; j++) {
		oneone[j] = false;
		for (i = 0; i < pattLen; i++)
			pattern_catch[i][j] = 0;
	}

/* insert catches and check for '11' */
	
	for (i = 0; i < pattLen; i++)		
		for (j = 1; j <= streams; j++) {
			old_oneone[j] = oneone[j];
			for (k = 0; k < multiplex; k++)
				if (p1 = pattern_throw[i][j][k].height) {
					pattern_catch[i][j] ++;
					if ( (oneone[j] = (bool)((p1 == 1) && !allow_oneone)) 
						&& old_oneone[j])
						return(false);
				}
		}

/* check '11' wrap-around to zeroth throw */
	
	for (j = 1; j <= streams; j++)		
			for (k = 0; k < multiplex; k++)
				if ((pattern_throw[0][j][k].height == 1) && oneone[j])
					return(false);

/* check if ground state */

	if (ground != 3) {
		gflag = excited();
		if (gflag ^ (ground-1))
			return(false);
	}	
	
/* remove catches; return if not valid */
				
	for (i = 0; i < pattLen; i++)		
		for (j = 1; j <= streams; j++)
			for (k = 0; k < multiplex; k++)
				if (pattern_throw[i][j][k].height)
					if (--pattern_catch[(i+pattern_throw[i][j][k].height) % pattLen]
											[1+(j+pattern_throw[i][j][k].to-1)%streams] < 0)
						return(false);


/* reject if there exists a larger cyclic variant */	
	
	for(di=1; di < pattLen; di++) {
		for(dj=0;dj < streams;dj++) {
			for(dk=0;dk < multiplex;dk++) {
				for (i = 0; i < pattLen; i++) {
					for (j = 1; j <= streams; j++) {
						for (k = 0; (k < multiplex) && pattern_rhythm[i][j][k]; k++) {
							p1 = pattern_throw[i][j][k].height;
							p2 = pattern_throw[(i+di)%pattLen][1+(j+dj-1)%streams][(k+dk)%multiplex].height;							if (p1<p2)
							if (p1<p2)	
								return(false);
							if (p1>p2)
								break;
						}
						if (p1>p2) break;
					}
					if (p1 == p2) {
						t1 = t2;
						for (j = 1; j <= streams; j++){
							for (k = 0; k < multiplex; k++) {
								if ((t1 = pattern_throw[i][j][k].to) 
										> 
									(t2 = pattern_throw[(i+di)%pattLen][1+(j+dj-1)%streams][(k+dk)%multiplex].to))
									return(false);
								else if (t1<t2)
									break;
							}
							if (t1<t2)
								break;
						}
					}
					if (p1>p2 || t1<t2) break;
				}
				if ((p1 == p2) && (t1==t2) && irred == true && (dj==0))
					return(false);
			}
		}
	}

/* Check that streams are ordered */
	
	if (streams>1)
		for (j = 1; j < streams; j++) {
			for (i = 0; i < pattLen; i++) {
				for (k = 0; k < multiplex; k++) {
					p1 = pattern_throw[i][j][k].height;
					p2 = pattern_throw[i][j+1][k].height;
					if (p1<p2) return(false);
					if (p1>p2) break;
				}
				if (p1>p2) break;
			}
			if (p1>p2) break;
		}
	if ((p1 == p2) && irred == true) return(false); /* Do we want this ? */
	
		
	
	return(true);	
	    	
}


/*  find_ground -- Find the ground state for our rhythm.  Just put  */
/*                 the balls in the lowest possible slots, with no  */
/*                 multiplexing.                                    */

bool siteswap::find_ground(void){
	// make sure we're setup ok.
	make_rhythm();
	
	int i,j,k, slots, base, remainder, balls_left, total, add, max;
	bool plus;

	slots = 0;
	
	for (k = 0; k<multiplex; k++)
		for (j=1; j<= streams; j++)
			for (i = 0; i< number; i++) {
				if(i<pattLen)
					pattern_throw[i][j][k].height = 0;
				ground_rhythm[i][j][k] = 0;
				if ((i<pattLen) && pattern_rhythm[i][j][k])   /* available slots */
	    			slots ++;
	    	}
	
	total = pattLen * number;
	
	base = total / slots;
	remainder = total % slots;
	
	if (maxThrow*slots < total) {
		tcl_ << "Maximum throw value is too small" << tcl_error;
		return(false);
	}
				
	total -= (pattern_throw[0][1][0].height = (base + (remainder>0)));
	
	while(total) {
		plus = true;
		while(plus && total) {
			plus = false;
			for (k = 0; (k<multiplex) && total; k++)
				for (j=streams; j && total; j--)
					for (i = pattLen-1; (i >= 0) && total; i--)
						if (pattern_rhythm[i][j][k]) {      /* available slots */
			    			for (add = 1; !pattern_rhythm[(i+add+pattern_throw[i][j][k].height) % pattLen][j][k]; add++);
			    			if ((pattern_throw[i][j][k].height + add) <= pattern_throw[0][1][0].height)
			    				if (i || (j!=1) || k) {
			    					pattern_throw[i][j][k].height += add;
			    					total -= add;
			    					plus = true;
			    				}
			    		}
		}
		if(total) {
			for (add = 1; !pattern_rhythm[(add+pattern_throw[0][1][0].height)% pattLen][1][0]; add++);
			pattern_throw[0][1][0].height += add;	    			
			total -= add;
		}
	}

	
			
	balls_left = number;
	
	for (i = 0; (i< number) && balls_left; i++)
		for (j=1; (j<= streams) && balls_left; j++)
			for (k = 0; (k<multiplex) && balls_left; k++)
				if (pattern_rhythm[i % pattLen][j][k] 
						&& pattern_throw[i % pattLen][j][k].height 
						&& (balls_left-->0))
					ground_rhythm[i][j][k] = 1;
	
	print_pattern(tcl_);
	return(true);			
}
	
	

/* Check if it's a ground or excited state */

bool siteswap::excited()
{
	int i, j, k, p1, num_of_balls;
	
	num_of_balls = number;
	
	for (i = 0; (i < number) && num_of_balls; i++)
		for (j = 1; (j <= streams) && num_of_balls; j++)
			for (k = 0; (k < multiplex) && num_of_balls; k++)
				if (ground_rhythm[i][j][k]) 
					if (!((p1=pattern_throw[i % pattLen][j][k].height)>0))
						return(true);
					else {
						num_of_balls--;
						if ((i+p1)< number)
							if (ground_rhythm[i+p1][j][0])
								return(true); 
					}
						
	return(false);
		
}

/** Printing methods **/


char *siteswap::print_number(char *pos, int number)
{
   if (number < 10)
      *pos = (char)number + '0';
   else
      *pos = (char)(number - 10) + 'A';

   return (++pos);
}


char *siteswap::print_throw(char *pos, struct jthrow** jthrow, int** prhythm){
	int i, j;
   
	for (i = 1, j = 1; (i <= streams) && j; i++)
		if (prhythm[i][0])			/* supposed to make a throw? */
			j = 0;
	if (j)	
		return (pos);				/* can't make a throw, skip out */

   switch ((int) rhythm) {
      case ASYNCH_SOLO:
    	 if ((multiplex > 1) && jthrow[1][1].height) {
            *pos++ = '[';
            for (i = 0; (i < multiplex) && (j = jthrow[1][i].height); i++)
	           pos = print_number(pos, j);
	        *pos++ = ']';
	     } else
	        pos = print_number(pos, jthrow[1][0].height);
         break;
         
      case SYNCH_SOLO:
         *pos++ = '(';
		 if ((multiplex > 1) && jthrow[1][1].height) {
		    *pos++ = '[';
		    for (i = 0; (i<multiplex) && (j=jthrow[1][i].height); i++) {
		       pos = print_number(pos, j);
		       if (jthrow[1][i].to)
		          *pos++ = 'x';
		    }
		    *pos++ = ']';
		 } else {
		    pos = print_number(pos, jthrow[1][0].height);
		    if (jthrow[1][0].to)
		       *pos++ = 'x';
		 }
		 *pos++ = ',';
		 if ((multiplex > 1) && jthrow[2][1].height) {
		    *pos++ = '[';
		    for (i = 0; (i<multiplex) && (j=jthrow[2][i].height); i++) {
		       pos = print_number(pos, j);
		       if (jthrow[2][i].to)
		          *pos++ = 'x';
		    }
		    *pos++ = ']';
		 } else {
		    pos = print_number(pos, jthrow[2][0].height);
		    if (jthrow[2][0].to)
		       *pos++ = 'x';
		 }
		 *pos++ = ')';
		 break;
		 
      case ASYNCH_PASSING:
		 *pos++ = '<';
         if ((multiplex > 1) && jthrow[1][1].height) {
		    *pos++ = '[';
		    for (i = 0; (i<multiplex) && (j=jthrow[1][i].height); i++) {
		       pos = print_number(pos, j);
		       if (jthrow[1][i].to)
		          *pos++ = 'p';
		    }
    	    *pos++ = ']';
		 } else {
		    pos = print_number(pos, jthrow[1][0].height);
		    if (jthrow[1][0].to)
		       *pos++ = 'p';
		 }
         *pos++ = '|';
		 if ((multiplex > 1) && jthrow[2][1].height) {
		    *pos++ = '[';
		    for (i = 0; (i<multiplex) && (j=jthrow[2][i].height); i++) {
		       pos = print_number(pos, j);
		       if (jthrow[2][i].to)
		          *pos++ = 'p';
		    }
		    *pos++ = ']';
		 } else {
		    pos = print_number(pos, jthrow[2][0].height);
		    if (jthrow[2][0].to)
		       *pos++ = 'p';
		 }
		 *pos++ = '>';
		 break;
	     
   }

   return (pos);
}




void siteswap::print_pattern(tcl_obj& print)
{
	int i;
	char *pattern_buffer = new char[ (streams+1)*pattLen*(2*multiplex+3)];
	char *pos;      
   
	pos = pattern_buffer;
	for (i = 0; i < pattLen; i++)
		pos = print_throw(pos, pattern_throw[i], pattern_rhythm[i]);
   
	*pos = (char)0;         /* terminate the string */
   
	for(i=(print_width - strlen(pattern_buffer));i>0;i--)
		strcat(pattern_buffer," ");
	print << pattern_buffer;
	
	delete [] pattern_buffer;
}


void siteswap::print_streams(void) {
	
	int i,j,k,m;
	
	if (streams == 1) {
		if (check_pattern()) {
			if (!numonly) print_pattern(tcl_);
			total_num++;
		}
		return;
	}
	
	for (i = 0; i < pattLen; i++)
		for (j = 1; j <= streams; j++)
			for (k = 0; k < multiplex; k++)
				pattern_throw[i][j][k].to = 0;

	while(true) {
		i = 0, j = 1, k = 0;
					
		if (pattern_throw[i][j][k].height && pattern_rhythm[i][j][k])
			for (m=0; m< streams ; m++) {
				pattern_throw[i][j][k].to = m;
				if (check_pattern()) {
					if (!numonly) print_pattern(tcl_);
					total_num++;
				}
		
			}
		
		while((pattern_throw[i][j][k].to >= streams - 1)
					|| !(pattern_throw[i][j][k].height)
					|| !pattern_rhythm[i][j][k]) {
			pattern_throw[i][j][k].to = 0;
			if(++k == multiplex) {
				k=0;
				if(j++ == streams) {
					j=1;
					if(++i == pattLen)
						return;
				}
			}
		}
		pattern_throw[i][j][k].to++;
	}
}	


void siteswap::make_rhythm(void) {
	/* Need to setup rhythm-repunit and period */
	
	/* insert rhythm */

	for (int i = 0; i < pattLen; i++)
		for (int j = 1; j <= streams; j++)
			for (int k = 0; k < multiplex; k++)
				pattern_rhythm[i][j][k] = rhythm_repunit[j-1][i % rhythm_period];

   	print_width = (((multiplex*(1+(streams>1)))
   					+ 2*(multiplex>1)			/* square brackets */
   					+ (streams>1))				/* commas + close paren */
   					* streams + (streams>1))	/* each term + paren */
   					* pattLen +1;


}


bool siteswap::pattern_increment(int &p, int &s, int &m, int &r) {
	r += pattern_throw[p][s][m].height;
	pattern_throw[p][s][m].height = 0;
	if (s-- == 1){
		s = streams;
		if (m-- == 0){
			m = multiplex-1;
			return (bool) (p-- ==0);
		}
	}
	return false;
}

void siteswap::delete_arrays(void) {
	delete [] starting_seq;
	delete [] ending_seq;
	delete [] pattern_catch;
	for(int i=0;i<number;i++) {
		delete [] ground_rhythm[i];
		for(int j=0;j<=streams;j++) {
			delete [] ground_rhythm[i][j];
		}
	}
	delete [] ground_rhythm;

	for(int i=0;i<pattLen;i++) {
		delete [] pattern_rhythm[i];
		for(int j=0;j<=streams;j++) {
			delete [] pattern_rhythm[i][j];
		}
	}
	delete [] pattern_rhythm;

	for(int i=0;i<pattLen;i++) {
		delete [] pattern_throw[i];
		for(int j=0;j<=streams;j++) {
			delete [] pattern_throw[i][j];
		}
	}
	delete [] pattern_throw;
	
	delete [] oneone;
	delete [] old_oneone;
	

}

void siteswap::set_rhythm(void) {
	int people;
	int person_number[2];
   switch ( rhythm) {
      case ASYNCH_SOLO:
	 	rhythm_repunit[0][0] = solo_rhythm_repunit[0][0];
	 	streams = 1;
	 	rhythm_period = 1;
        people = 1;
        person_number[0] = 1;
	 break;
      case SYNCH_SOLO:
      	for (int i = 0; i < 2; i++)
	  		for (int j = 0; j < 2; j++)
        		rhythm_repunit[i][j] = synch_rhythm_repunit[i][j];
	 	streams = 2;
	 	rhythm_period = 2;
     	people = 1;
     	person_number[0] = person_number[1] = 1;
	 break;
      case ASYNCH_PASSING:
	 	for (int i = 0; i < 2; i++)
	    	rhythm_repunit[i][0] = asynch_passing_rhythm_repunit[i][0];
	    streams = 2;
		rhythm_period = 1;
		people = 2;
		person_number[0] = 1;
		person_number[1] = 2;
	 break;
   }		
}

void siteswap::declare_arrays(void) {
	starting_seq = new char[ (streams+1)*maxThrow*CHARS_PER_THROW];
	ending_seq = new char[ (streams+1)*maxThrow*CHARS_PER_THROW];
	pattern_catch = new int*[ pattLen];
	for(int i=0;i<pattLen;i++)
		pattern_catch[i] = new int[ streams +1];
		
	ground_rhythm = new int**[ number];
	for(int i=0;i<number;i++) {
		ground_rhythm[i] = new int*[ streams+1];
		for(int j=0;j<=streams;j++) {
			ground_rhythm[i][j] = new int[ multiplex];
		}
	}

	pattern_rhythm = new int**[ pattLen];
	for(int i=0;i<pattLen;i++) {
		pattern_rhythm[i] = new int*[ streams+1];
		for(int j=0;j<=streams;j++) {
			pattern_rhythm[i][j] = new int[ multiplex];
		}
	}
			
	pattern_throw = new jthrow**[ pattLen];
	for(int i=0;i<pattLen;i++) {
		pattern_throw[i] = new jthrow*[ streams+1];
		for(int j=0;j<=streams;j++) {
			pattern_throw[i][j] = new jthrow[ multiplex];
		}
	}
	
	oneone = new bool[ streams+1];
	old_oneone = new bool[ streams+1];
}

//virtual
siteswap::~siteswap(void){
  	// delete
  	
}

int Cpptcl_InitFunction(Vjuggle_Init) {
	Tcl_PkgRequire(interp,"Cpptcl","2.0",0);
	Cpptcl_Object(siteswap, tcl_base);
	Tcl_PkgProvide(interp,"Vjuggle","1.0");	
	return TCL_OK;
}

