#!/usr/local/bin/jperl
#
# (Requires Japanese-extended perl...)
#
# Laptop survey formatter
# 
# Copyright (c) 1996 by Tatsumi Hosokawa <hosokawa@mt.cs.keio.ac.jp>
#

print '=' x 75, "\n";
print ' ' x 25, "Laptop Survey / FreeBSD\n";
print '=' x 75, "\n\n";

if (shift(@ARGV) =~ /j/) {
	$jmode = 1;
}
else {
	$jmode = 0;
}

while (<STDIN>) {
	if (/^\)ITEM$/) {
		$name  = $item{1};
		$addr  = $item{2};
		$mcn   = $item{3};
		$cpu   = $item{4};
		$ram   = $item{5};
		$hdd   = $item{6};
		$bios  = $item{7};
		$fbsd  = $item{8};
		$fbsdv = $item{9};
		$pccv  = $item{10};
		$apm   = $item{11};
		$apmv  = $item{12};
		$config= $item{13};
		$pcic  = $item{14};
		$crd   = $item{15};
		$ngcrd = $item{16};
		$misc  = $item{17};
		$miscj = $item{18};
		if ($addr) {
			$name = sprintf("%s (%s)", $name, $addr);
		}
		&printitem("Name", $name);
		if ($mcn && $cpu && $ram && $hdd) {
			$spec = sprintf("%s (CPU %s, HDD %s, RAM %s)", $mcn, $cpu, $hdd, $ram);
			&printitem("Machine", $spec);
		}
		else {
			die "Incomplete Machine Spec.";
		}
		if ($fbsd) {
			if ($fbsdv) {
				$fbsdok = sprintf("%s (%s)", $fbsd, $fbsdv);
			}
			else {
				$fbsdok = $fbsd;
			}
			&printitem("FreeBSD", $fbsdok);
		}
		if ($pccv) {
			&printitem("Pccard Pkg", $pccv);
		}
		if ($apm) {
			if ($apmv) {
				$apmok = sprintf("%s (%s)", $apm, $apmv);
			}
			else {
				$apmok = $apm;
			}
			&printitem("APM BIOS", $apmok);
		}
		if ($config) {
			&printitem("Config Opt", $config);
		}
		if ($pcic) {
			&printitem("PCIC", $pcic);
		}
		if ($crd) {
			&printitem("Cards", $crd);
		}
		if ($ngcrd) {
			&printitem("NG-Cards", $ngcrd);
		}
		if ($misc) {
			&printitem("Misc Info", $misc);
		}
		if ($jmode && $miscj) {
			&printitem("Misc Info", $miscj);
		}
	}
	elsif (/^\(ITEM$/) {
		print '=' x 75, "\n";
		for ($i = 0; $i < 20; $i++) {
			$item{$i} = 0;
		}
		$crdcnt = 0;
		$ngcrdcnt = 0;
	}
	elsif (/^\(NAME$/) {
		$mode = 1;
	}
	elsif (/^\(ADDR$/) {
		$mode = 2;
	}
	elsif (/^\(MCN$/) {
		$mode = 3;
	}
	elsif (/^\(CPU$/) {
		$mode = 4;
	}
	elsif (/^\(RAM$/) {
		$mode = 5;
	}
	elsif (/^\(HDD$/) {
		$mode = 6;
	}
	elsif (/^\(BIOS$/) {
		$mode = 7;
	}
	elsif (/^\(FBSD$/) {
		$mode = 8;
	}
	elsif (/^\(FBSDV$/) {
		$mode = 9;
	}
	elsif (/^\(PCCV$/) {
		$mode = 10;
	}
	elsif (/^\(APM$/) {
		$mode = 11;
	}
	elsif (/^\(APMV$/) {
		$mode = 12;
	}
	elsif (/^\(CONFIG$/) {
		$mode = 13;
	}
	elsif (/^\(PCIC$/) {
		$mode = 14;
	}
	elsif (/^\(CRD$/) {
		$mode = 15;
	}
	elsif (/^\(NGCRD$/) {
		$mode = 16;
	}
	elsif (/^\(MISC$/) {
		$mode = 17;
	}
	elsif (/^\(MISCJ$/) {
		$mode = 18;
	}
	elsif (/^\(TYPE$/) {
		$crdmode = 1;
	}
	elsif (/^\(CONF$/) {
		$crdmode = 2;
	}
	if (/^-/) {
		if ($mode == 15 || $mode == 16) {
			if (!$item{$mode}) {
				$item{$mode} = "";
			}
			s/^-\s*//;
			chop;
			s/^(\s|\\n)*//;
			s/(\s|\\n)*$//;
			if ($crdmode == 1) {
				$item{$mode} .= sprintf("- %s\\n", $_);
			}
			elsif ($crdmode == 2) {
				s/\\n/\\n\\011/g;
				$item{$mode} .= ("\\011" . $_ . "\\n");
			}
		}
		else {
			s/^-\s*//;
			chop;
			s/\s+$//;
			$item{$mode} = $_;
		}
	}
}
print '=' x 80, "\n";


sub printitem
{
	local($name, $item) = @_;
	local($colon);

	if (!($item =~ /\\n/)) {
		$item =~ s/\011//g;
		$colon = ":";
		piloop: while (1) {
			if (length($item) >= 60) {
				$pritem = substr($item, 0, 60 - 1);
				$pritem =~ s/\S+$//;
				substr($item, 0, length($pritem)) = '';
				$item =~ s/^\s*//;
			}
			else {
				$pritem = $item;
				printf("%-10s%s %s\n", $name, $colon, $pritem);
				last piloop;
			}
			printf("%-10s%s %s\n", $name, $colon,  $pritem);
			$name = "";
			$colon = " ";
		}
	}
	else {
		printf("%-10s:\n", $name);
		$item =~ s/^(\\n)*//;
		$item =~ s/(\\n)*$//;
		$item =~ s/\\n/\n  /g;
		$item =~ s/\\011/\011/g;
		print "  ", $item, "\n";
	}
}
