#ifndef	SYSINSTALL
#define DEBUG 1
#endif	/* SYSINSTALL */
/*
 *	pcmciad
 */
#define	PCCARDD_MAIN
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <syslog.h>
#include <stdarg.h>
#include "cardd.h"

char	*config_file = "/etc/pccard.conf";
char	*stand_config_file = "/stand/etc/pccard.conf";

void	dump_config_file();
void	readslots();
void	slot_change(struct slot *);

/*
 *	mainline code for cardd
 */
int
main(int argc, char *argv[])
{
struct slot *sp;
int count, debug = 0;
int	verbose = 0;
char	*conf = 0;
FILE	*fp;
extern char *optarg;
extern int optind, optopt;
#define	COM_OPTS	":dvf:"

	cards = last_card = 0;

	while ((count = getopt(argc, argv, COM_OPTS))!= -1) {
		switch(count) {
		case 'd':
			setbuf(stdout,0);
			setbuf(stderr,0);
			debug = 1;
			break;
		case 'v':
			verbose = 1;
			break;
		case 'f':
			conf = optarg;
			break;
		case ':':
			die("No config file argument");
			break;
		case '?':
			die("Illegal option");
			break;
		}
	}
#ifdef	DEBUG
	debug = 1;
#endif
	io_avail = bit_alloc(IOPORTS);	/* Only supports ISA ports */
/*
 *	Mem allocation done in MEMUNIT units.
 */
	mem_avail = bit_alloc(MEMBLKS);
	if (!conf) {
		if ((fp = fopen(config_file, "r"))) {
			conf = config_file;
			fclose(fp);
		}
		else if ((fp = fopen(stand_config_file, "r"))) {
			conf = stand_config_file;
			fclose(fp);
		}
	}
	readfile(conf);
	if (verbose)
		dump_config_file();
	if (!debug)
		{
		if (daemon(0, 0))
			die("fork failed");
		openlog("cardd", LOG_PID, LOG_DAEMON);
		do_log = 1;
		}
	printf("Before readslots\n");
	readslots();
	printf("After readslots\n");
	if (slots == 0)
		die("No PC-CARD slots");
	for (;;)
		{
		fd_set mask;
		FD_ZERO(&mask);
		for (sp = slots; sp; sp = sp->next)
			FD_SET(sp->fd,&mask);
printf("Doing select\n");
		count = select(32, 0, 0, &mask, 0);
printf("select=%d\n",count);
		if (count == -1)
			{
			perror("Select");
			continue;
			}
		if (count)
			for (sp = slots; sp; sp = sp->next)
			if (FD_ISSET(sp->fd,&mask))
				slot_change(sp);
		}
}
