/*
 * Copyright (c) 1995 Andrew McRae.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* 
 * Code cleanup, bug-fix and extention
 * by Tatsumi Hosokawa <hosokawa@mt.cs.keio.ac.jp>                   
 */

#ifndef	SYSINSTALL
#define DEBUG 1
#endif	/* SYSINSTALL */
/*
 *	pcmciad
 */
#define	PCCARDD_MAIN
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <syslog.h>
#include <stdarg.h>
#include "cardd.h"

char           *config_file = "/etc/pccard.conf";
char           *stand_config_file = "/stand/etc/pccard.conf";

void            dump_config_file(void);
void            readslots(void);
void            slot_change(struct slot *);

/*
 *	mainline code for cardd
 */
int
main(int argc, char *argv[])
{
	struct slot    *sp;
	int             count, debug = 0;
	int             verbose = 0;
	char           *conf = 0;
	FILE           *fp;
	extern char    *optarg;
	extern int      optind, optopt;
#define	COM_OPTS	":dvf:"

	cards = last_card = 0;

	while ((count = getopt(argc, argv, COM_OPTS)) != -1) {
		switch (count) {
		case 'd':
			setbuf(stdout, 0);
			setbuf(stderr, 0);
			debug = 1;
			break;
		case 'v':
			verbose = 1;
			break;
		case 'f':
			conf = optarg;
			break;
		case ':':
			die("No config file argument");
			break;
		case '?':
			die("Illegal option");
			break;
		}
	}
#ifdef	DEBUG
	debug = 1;
#endif
	io_avail = bit_alloc(IOPORTS);	/* Only supports ISA ports */
/*
 *	Mem allocation done in MEMUNIT units.
 */
	mem_avail = bit_alloc(MEMBLKS);
	if (!conf) {
		if ((fp = fopen(config_file, "r"))) {
			conf = config_file;
			fclose(fp);
		} else if ((fp = fopen(stand_config_file, "r"))) {
			conf = stand_config_file;
			fclose(fp);
		}
	}
	if (!conf) {
		die ("can't open default config file");
	}
	readfile(conf);
	if (verbose)
		dump_config_file();
#ifndef	SYSINSTALL
	openlog("pccardd", LOG_PID, LOG_DAEMON);
	do_log = 1;
#endif
	if (!debug) {
		if (daemon(0, 0))
			die("fork failed");
	}
	readslots();
	if (slots == 0)
		die("No PC-CARD slots");
	syslog(LOG_NOTICE, "pccardd started");
	for (;;) {
		fd_set          mask;
		FD_ZERO(&mask);
		for (sp = slots; sp; sp = sp->next)
			FD_SET(sp->fd, &mask);
		count = select(32, 0, 0, &mask, 0);
		if (count == -1) {
			perror("Select");
			continue;
		}
		if (count)
			for (sp = slots; sp; sp = sp->next)
				if (FD_ISSET(sp->fd, &mask))
					slot_change(sp);
	}
}
