/*
 * IBM Smart Capture Card driver.
 *
 * Copyright (c) 1996
 *	 Koji OKAMURA and Takeshi OHASHI.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Koji OKAMURA
 *	and Takeshi OHASHI.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI OKAMURA, TAKESHI OHASHI AND
 * CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TAKESHI OHASHI OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Changed by Koji OKAMURA <oka@kobe-u.ac.jp>
 * Changed by Takeshi OHASHI <ohashi@mickey.ai.kyutech.ac.jp>
 * Version 0.33, Aug 8, 1996.
 *
 */

typedef struct scc_geomet {
  int  width;   
  int  height;   
} scc_geomet_t ;

typedef struct scc_color {
  int brightness;
  int contrast;
  int saturation;
  int hue;
} scc_color_t ;

typedef struct scc_tv {
  int tuntype;
  int channel;
  int fine;
  int country;
} scc_tv_t ;

typedef struct scc_card {
  int             mode;
  scc_geomet_t    geomet;
  int             format;
  int             spdmode;
  scc_tv_t        tv;
  scc_color_t     color;
  int             intput;
} scc_card_t;

#define SCCSETMODE		_IOW('s', 1, int)
#define SCCGETMODE		_IOR('s', 2, int)
#define SCCSETGEO		_IOW('s', 3, scc_geomet_t)
#define SCCGETGEO		_IOR('s', 4, scc_geomet_t)
#define SCCSETFMT		_IOW('s', 5, int)
#define SCCGETFMT		_IOR('s', 6, int)
#define SCCSETSPDMODE		_IOW('s', 7, int)
#define SCCGETSPDMODE		_IOR('s', 8, int)
#define SCCSETTVCHANNEL		_IOW('s', 9, scc_tv_t)
#define SCCGETTVCHANNEL		_IOR('s',10, scc_tv_t)
#define SCCSETCOLOR		_IOW('s',11, scc_color_t)
#define SCCGETCOLOR		_IOR('s',12, scc_color_t)

#define SCC_PAL   0
#define SCC_NTSC  1

#define SCC_NTSCWIDTH  640
#define SCC_NTSCHEIGHT 240
#define SCC_PALWIDTH   768
#define SCC_PALHEIGHT  288

#define	SCC_YUV422		0
#define	SCC_YUV444		1
#define	SCC_YUV411		2
#define	SCC_YUVDPCM		3
#define	SCC_RGB888N		4
#define	SCC_RGB888		5
#define	SCC_RGB565		6
#define	SCC_RGB555		7

#define SCC_SLOW 1
#define SCC_FAST 0

#define	SCC_DEFBRIGHTNESS	 150
#define	SCC_DEFCONTRAST	          40
#define	SCC_DEFSATURATION	2800
#define	SCC_DEFHUE		2048

#define SCC_MAXBRIGHTNESS        255
#define SCC_MAXCONTRAST           63
#define SCC_MAXSATURATION       4095
#define SCC_MAXHUE              4095

#define SCC_MINCHANNELJP           1
#define SCC_MAXCHANNELJP          62
#define SCC_MINCHANNELUS           2
#define SCC_MAXCHANNELUS          69
