/* 
 * HISTORY
 * $Log: if_wlp.h,v $
 * Revision 1.1  1994/06/02  20:26:55  klemets
 * Initial revision
 *
 *
 */
/*
 * Definitions for the NCR WaveLAN PCMCIA driver.
 *
 * Copyright 1994, Anders Klemets <klemets@it.kth.se>
 * All rights reserved.
 *
 * I permit including this code in the releases of FreeBSD.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The names of the authors may not be used to endorse or promote products
 *    derived from this software withough specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PCMCIA_IF_WLP_H
#define	_PCMCIA_IF_WLP_H

#include <i386/isa/ic/i82593.h>		/* Definitions for the Intel chip */

/* WaveLAN host interface definitions */

#define	LCCR(base)	(base)		/* LAN Controller Command Register */
#define	LCSR(base)	(base)		/* LAN Controller Status Register */
#define	HACR(base)	(base+0x1)	/* Host Adapter Command Register */
#define	HASR(base)	(base+0x1)	/* Host Adapter Status Register */
#define PIORL(base)	(base+0x2)	/* Program I/O Register Low */
#define RPLL(base)	(base+0x2)	/* Receive Pointer Latched Low */
#define PIORH(base)	(base+0x3)	/* Program I/O Register High */
#define RPLH(base)	(base+0x3)	/* Receive Pointer Latched High */
#define PIOP(base)	(base+0x4)	/* Program I/O Port */
#define MMR(base)	(base+0x6)	/* MMI Address Register */
#define MMD(base)	(base+0x7)	/* MMI Data Register */

/* HACR bit definitions */

#define HACR_LOF	  (1 << 3)	/* Lock Out Flag, toggle every 250ms */
#define HACR_PWR_STAT	  (1 << 4)	/* Power State, 1=active, 0=sleep */
#define HACR_TX_DMA_RESET (1 << 5)	/* Reset transmit DMA ptr on high */
#define HACR_RX_DMA_RESET (1 << 6)	/* Reset receive DMA ptr on high */
#define HACR_ROM_WEN	  (1 << 7)	/* EEPROM write enabled when true */

/* HASR bit definitions */

#define HASR_MMI_BUSY	(1 << 2)	/* MMI is busy when true */
#define HASR_LOF	(1 << 3)	/* Lock out flag status */
#define HASR_NO_CLK	(1 << 4)	/* active when modem not connected */

/* Miscellaneous bit definitions */

#define PIORH_SEL_TX	(1 << 5)	/* PIOR points to 0=rx/1=tx buffer */
#define MMR_MMI_WR	(1 << 0)	/* Next MMI cycle is 0=read, 1=write */
#define PIORH_MASK	0x1f		/* only low 5 bits are significant */
#define RPLH_MASK	0x1f		/* only low 5 bits are significant */
#define MMI_ADDR_MASK	0x7e		/* Bits 1-6 of MMR are significant */

/* Attribute Memory map */

#ifndef	WL_PCCARD
#define CIS_ADDR	0x0000		/* Card Information Satus Register */
#define PSA_ADDR	0x0e00		/* Parameter Storage Area address */
#define EEPROM_ADDR	0x1000		/* EEPROM address */
#define COR_ADDR	0x4000		/* Configuration Option Register */
#endif

/* Configuration Option Register bit definitions */

#define COR_CONFIG	(1 << 0)	/* Config Index, 0 when unconfigured */
#define COR_SW_RESET	(1 << 7)	/* Software Reset on true */

/* Local Memory map */

#define RX_BASE		0x0000		/* Receive memory, 8 kB */
#define TX_BASE		0x2000		/* Transmit memory, 2 kB */
#define UNUSED_BASE	0x2800		/* Unused, 22 kB */
#define RX_SIZE		(TX_BASE-RX_BASE)	/* Size of receive area */
#define RX_SIZE_SHIFT	6		/* Bits to shift in stop register */

#define MMI_WRITE(cmd,val)	\
	while(inb(HASR(sp->base)) & HASR_MMI_BUSY) ; \
	outb(MMR(sp->base), ((cmd) << 1) | MMR_MMI_WR); \
	outb(MMD(sp->base), val);

#ifndef	WL_PCCARD
#define READ_PSA(addr) *(sp->psa + 2*(addr))
#endif

#define DSF_RUNNING	1

#define MOD_ENAL 1
#define MOD_PROM 2

/* "flags" in config file */
#define	WLP_2400MHZ	0x01	/* use 2.4GHz band instead of 915MHz on 
				 * WaveLAN PCMCIA */

#endif _PCMCIA_IF_WLP_H


