/*
 * Copyright (c) 1998,1999 Trans New Technology, Inc. and
 *                         Hiroki NAKANO <cas@trans-nt.com>
 * All rights reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that this notice is retained,
 * the conditions in the following notices are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *	Trans New Technology, Inc. (in Japan)
 *
 *
 * THIS SOFTWARE IS PROVIDED BY TRANS NEW TECHNOLOGY, INC. ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TRANS NEW TECHNOLOGY, INC. BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char * const RCSID =
"$UxDriver: uxctl.c,v 1.10 1999/04/15 04:31:38 cas Exp $";

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>

#include "if_uxtypes.h"
#include "am79c930reg.h"
#include "am79c930ioctl.h"

int so = -1;

int
opensocket()
{
	so = socket(PF_INET, SOCK_DGRAM, 0);
	if(so < 0) {
		perror("socket()");
		exit(2);
	}
	return 0;
}

int
callioctl(unsigned int req, void *arg)
{
	if(ioctl(so, req, arg) < 0) {
		perror("ioctl()");
		exit(3);
	}
	return 0;
}

int
setifname(struct ifreq *ifr)
{
	strncpy(ifr->ifr_name, "ux0", sizeof(ifr->ifr_name));
	ifr->ifr_name[sizeof(ifr->ifr_name) - 1] = '\0';
	return 0;
}

/*---------------------------*/

unsigned int
atoul(char *s)
{
	unsigned int r; 
	char *e;
	r = strtoul(s, &e, 0);
	if(*e != '\0') {
		printf("invalid uint. '%s'\n", s);
		exit(1);
	}
	return r;
}

void
dumphex(unsigned char *p, unsigned int base, unsigned int size)
{
	int i;
	for(i = 0; i < size; i++) {
		if((i & 15) == 0) printf("%04x ", base + i);
		if((i & 15) == 8) printf(" ");
		printf(" %02x", p[i] & 0xff);
		if((i & 15) == 15) printf("\n");
	}
	if((i & 15) != 0) printf("\n");
}

/*---------------------------*/

int
checkstructsize(void)
{
	int ok = 1;

#define	UX_CHECKSTRUCTSIZE(tag)						\
	if(sizeof(struct tag) != tag##_STRUCTSIZE) {			\
		printf("%s:%d found error. realsize=%d truesize=%d\n",	\
			__FILE__, __LINE__,				\
			sizeof(struct tag), tag##_STRUCTSIZE);		\
		ok = 0;							\
	}

/* Macros to Check Size of Structures */
/*    produced automatically by 'make check' */
	UX_CHECKSTRUCTSIZE(Am79C930_Last_Completed_Descriptor_Block)
	UX_CHECKSTRUCTSIZE(Am79C930_Banner)
	UX_CHECKSTRUCTSIZE(Am79C930_Command_Block)
	UX_CHECKSTRUCTSIZE(Am79C930_Control_Status_Block)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Set_MIB_Variables)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Init_Tx)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Flush_Tx)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Enable_Receiver)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Sleep)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Get_MIB_Variables)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Scan)
	UX_CHECKSTRUCTSIZE(Am79C930_CmdParam_Sync)
	UX_CHECKSTRUCTSIZE(Am79C930_Rx_Desc)
	UX_CHECKSTRUCTSIZE(Am79C930_Tx_Desc)
	UX_CHECKSTRUCTSIZE(Am79C930_ESS_ID)
	UX_CHECKSTRUCTSIZE(Am79C930_Local_MIB)
	UX_CHECKSTRUCTSIZE(Am79C930_MAC_Address_Status_grp)
	UX_CHECKSTRUCTSIZE(Am79C930_MAC_MIB)
	UX_CHECKSTRUCTSIZE(Am79C930_MAC_Statistic_MIB)
	UX_CHECKSTRUCTSIZE(Am79C930_MAC_Mgmt_MIB)
	UX_CHECKSTRUCTSIZE(Am79C930_Drvr_MAC_Mgmt_MIB)
	UX_CHECKSTRUCTSIZE(Am79C930_PHY_MIB)
	UX_CHECKSTRUCTSIZE(Am79C930_80211_Header)
	UX_CHECKSTRUCTSIZE(Am79C930_80211_BeaconHeader)
/* END of Macros to Check Size of Structures */

	return ok;
}

/*---------------------------*/

int
cmd_test(int argc, char *argv[])
{
	struct uxioctl_execcmd ec;
	setifname(&ec.ifr);
	ec.cb.Command = AM79C930_CMD_TEST_INTERFACE_NOP;
	opensocket();
	callioctl(UXIOCEXECCMD, &ec);
	printf("Command_Status=%d\n", ec.cb.Command_Status);
	printf("Error_Offset=%d\n", ec.cb.Error_Offset);
	return 0;
}

int
cmd_execcmd(int argc, char *argv[])
{
	struct uxioctl_execcmd ec;
	struct Am79C930_CmdParam_Get_MIB_Variables cpgm;

	if(argc < 4) exit(1);
	cpgm.Type = atoul(argv[1]);
	cpgm.Size = atoul(argv[2]);
	cpgm.Index = atoul(argv[3]);

	setifname(&ec.ifr);

	ec.cb.Command = AM79C930_CMD_GET_MIB_VARIABLES;
	bcopy(&cpgm, &ec.cb.Command_Parameters, sizeof(cpgm));

	opensocket();
	callioctl(UXIOCEXECCMD, &ec);

	printf("Command_Status=%d\n", ec.cb.Command_Status);
	printf("Error_Offset=%d\n", ec.cb.Error_Offset);
	printf("Command_Parmeters:\n");
	dumphex(ec.cb.Command_Parameters, 0, sizeof(ec.cb.Command_Parameters));

	return 0;
}

int
cmd_readmem(int argc, char *argv[])
{
	struct uxioctl_cardmem cm;
	
	if(argc < 3) exit(1);
	cm.addr = atoul(argv[1]);
	cm.size = atoul(argv[2]);
	printf("addr=0x%x\n", cm.addr);
	printf("size=%d\n", cm.size);

	setifname(&cm.ifr);

	opensocket();
	callioctl(UXIOCREADMEM, &cm);

	dumphex(cm.data, cm.addr, cm.size);

	return 0;
}

int
cmd_bpfmode(int argc, char *argv[])
{
	struct uxioctl_int ui;
	setifname(&ui.ifr);

	if(argc < 2) exit(1);
	ui.i = atoul(argv[1]);

	opensocket();
	callioctl(UXIOCSRAWMACBPF, &ui);

	return 0;
}

int
cmd_essid(int argc, char *argv[])
{
	struct uxioctl_essid ue;
	setifname(&ue.ifr);
	
	if(argc < 2) exit(1);
	ue.length = strlen(argv[1]);
	if(ue.length > sizeof(ue.essid)) {
		printf("too long ESSID\n");
		exit(1);\
	}
	bcopy(argv[1], &ue.essid, ue.length);

	opensocket();
	callioctl(UXIOCSESSID, &ue);

	return 0;
}

int
main(int argc, char *argv[])
{
	int i;

	checkstructsize();

	for(i = 0; i < 2 && argc > 0; i++, argc--, argv++) {
		switch(argv[0][0]) {
		case 't':	return cmd_test(argc, argv);
		case 'g':	return cmd_execcmd(argc, argv);
		case 'r':	return cmd_readmem(argc, argv);
		case 'b':	return cmd_bpfmode(argc, argv);
		case 'e':	return cmd_essid(argc, argv);
		}
	}
	printf(
		"usage: test\n"
		"       getmib type size index\n"
		"       readmem addr size\n"
		"       bpfmode flag\n"
		"       essid id-string\n"
	);
}

/* EOF */
