#!/usr/bin/perl
foreach $file (@ARGV) {
	open(FILE, $file) || die "Can't open $file";
	$filename = $file;
	$filename =~ s/.*\///;
	print STDERR "Converting $filename\n";
	print "\n\n# $filename\n\n";
	$min{$filename} = 100000;
	$max{$filename} = 0;
	while (<FILE>) {
		chop;
		s/\s+$//;
		$line = $_;
		$work = $line;
		$lastchar = chop($work);
		while ($lastchar eq "\"") {
			$newline = <FILE>;
			$newline =~ s/\s+$//;
			$line .= $newline;
			$work = $line;
			$lastchar = chop($work);
		}
		while ($line =~ /\"%%\d\d\d\d\d /) {
			while ($line =~ /\"[^\"]*\"\s*\"[^\"]*\"/) {
				$line =~ s/(\"[^\"]*)\"\s*\"([^\"]*\")/$1$2/;
			}
			$line =~ s/\\\"/__XQUOTE__/g;
			$line =~ s/\"([^\"]*)\"(.*)$/$2/;
			$string = $1;
			if ($string =~ /^%%(\d\d\d\d\d) (.*)$/) {
				$num = $1;
				$num =~ s/^0+//;
				$cont = $2;
				if ($occurence{$num}) {
					if ($2 eq $occurence{$num}) {
						printf(STDERR "Warning: Multiple reference for message ID %05d.\n", $num);
					}
					else {
						printf(STDERR "Warning: Multiple reference with different contents\nfor message ID %05d. (maybe serious problem)\n", $num);
					}
				}
				$occurence{$num} = $2;
				$max{$filename} = $num if ($num > $max{$filename});
				$min{$filename} = $num if ($num < $min{$filename});
				$cnt{$filename} ++;
				$string =~ s/__XQUOTE__/\"/g;
				&printline($string);
			}
		}
	}
	close(FILE);
}

print "\n\n# Summary\n";

foreach $i (sort keys %max) {
	if ($max{$i} != 0) {
		printf("# %18s: %05d - %05d (%4d messages)\n", $i, $min{$i}, $max{$i}, $cnt{$i});
	}
}


sub printline {
	local($id, $content);
	$string = shift;

	$string =~ /^%%(\d\d\d\d\d) (.*)$/;
	$id = $1;
	$content = $2;
	$content =~ s/\\n/\n/g;
	$content =~ s/\\t/\t/g;
	print "MES#$id\n$content\\\\\n\n";
}
