/*
 * PC-card support for sysinstall
 *
 * $Id: pccard.c,v 1.6 1999/05/10 10:04:02 toshi Exp $
 *
 * Copyright (c) 1997-1999
 *	Tatsumi Hosokawa <hosokawa@jp.FreeBSD.org>.  All rights reserved.
 *
 * This software may be used, modified, copied, and distributed, in
 * both source and binary form provided that the above copyright and
 * these terms are retained. Under no circumstances is the author
 * responsible for the proper functioning of this software, nor does
 * the author assume any responsibility for damages incurred with its
 * use.
 */

#include "sysinstall.h"
#include <sys/fcntl.h>
#include <sys/time.h>
#include <pccard/cardinfo.h>

#ifdef	PCCARD

int	pccard_mode = 0;

DMenu MenuPCICMem = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "%%34004 Please select free address area used by PC-card controller",
    "%%34005 PC-card controller uses memory area to get card information.\n"
    "Please specify an address that is not used by other devices.\n"
    "If you're uncertain of detailed specification of your hardware,\n"
    "leave it untouched (default == 0xd0000).",
    "%%34006 Press F1 for more HELP",
    "pccard",
    {	{ "Default",  "I/O address 0xd0000 - 0xd3fff",
	    NULL, dmenuSetVariable, NULL, "pcicmem=0"},
	{ "D4", "I/O address 0xd4000 - 0xd7fff",
	    NULL, dmenuSetVariable, NULL, "pcicmem=1"},
	{ "D8", "I/O address 0xd8000 - 0xdbfff",
	    NULL,  dmenuSetVariable, NULL, "pcicmem=2"},
	{ "DC", "I/O address 0xdc000 - 0xdffff",
	    NULL,  dmenuSetVariable, NULL, "pcicmem=3"},
	{ NULL } },
};

DMenu MenuCardIRQ = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "%%34056 Please select IRQs that CANNOT be used by PC-cards",
    "%%34057 Please specify an IRQs that CANNOT be used by PC-card.\n"
    "For example, if you have a sound card that can't be probed by\n"
    "this installation floppy and it uses IRQ 5, you have to specify\n"
    "IRQ 5 from this menu.  If you're using CardBus machine, you may\n"
    "have to use \"Option 3\" or \"Option 4\".\n",
    "%%34006 Press F1 for more HELP",
    "pccard",
    {	{ "Default",  "%%34058 No IRQ is reserved",
	    NULL, dmenuSetVariable, NULL, "cardirq=0"},
	{ "Option 1", "%%34059 IRQ 5 (ex. soundcard on IRQ 5)",
	    NULL, dmenuSetVariable, NULL, "cardirq=1"},
	{ "Option 2", "%%34060 IRQ 10 (ex. soundcard on IRQ 10)",
	    NULL, dmenuSetVariable, NULL, "cardirq=2"},
	{ "Option 3", "%%34061 IRQ 1-9 (ex. CardBus machine)",
	    NULL, dmenuSetVariable, NULL, "cardirq=3"},
	{ "Option 4", "%%34062 IRQ 1-10 (ex. CardBus machine)",
	    NULL, dmenuSetVariable, NULL, "cardirq=4"},
	{ NULL } },
};

void
pccardInitialize(void)
{
    int fd;
    int t;
    int	pcic_mem = 0xd0000;
    char card_device[16];
    char *card_irq = "";
    char *spcic_mem;
    char *scard_irq;
    char pccardd_cmd[256];

    pccard_mode = 1;
    
    if (!RunningAsInit && !Fake) {
	/* It's not my job... */
	return;
    }

    dmenuOpenSimple(&MenuPCICMem, FALSE);
    spcic_mem = variable_get("pcicmem");
    dmenuOpenSimple(&MenuCardIRQ, FALSE);
    scard_irq = variable_get("cardirq");

    sscanf(spcic_mem, "%d", &t);
    switch (t) {
      case 0:
	pcic_mem = 0xd0000;
	break;
      case 1:
	pcic_mem = 0xd4000;
	break;
      case 2:
	pcic_mem = 0xd8000;
	break;
      case 3:
	pcic_mem = 0xdc000;
	break;
    }

    sscanf(scard_irq, "%d", &t);

    switch (t) {
      case 0:
	card_irq = " ";
	break;
      case 1:
	card_irq = " -i 5 ";
	break;
      case 2:
	card_irq = " -i 10 ";
	break;
      case 3:
	card_irq = " -i 1 -i 2 -i 3 -i 4 -i 5 -i 6 -i 7 -i 8 -i 9 ";
	break;
      case 4:
	card_irq = " -i 1 -i 2 -i 3 -i 4 -i 5 -i 6 -i 7 -i 8 -i 9 -i 10 ";
	break;
    }

    sprintf(card_device, CARD_DEVICE, 0);
    
    dialog_clear();
    msgConfirm("%%34042 Now starts initializing PC-card controller and cards.\n"
	       "If you've executed this installer from PC-card floppy\n"
	       "drive, this is the last chance to replace it with\n"
	       "installation media (PC-card Ethernet, CDROM, etc.).\n"
	       "Please insert installation media and press [Enter].\n"
	       "If you've not plugged the PC-card installation media\n"
	       "yet, please plug it now and press [Enter].\n"
	       "Otherwise, just press [Enter] to proceed."); 

    dialog_clear();
    msgNotify("%%34043 Initializing PC-card controller....");
    
    if (!Fake) {
	if ((fd = open(card_device, O_RDWR)) < 1) {
	    msgNotify("%%34051 Can't open PC-card controller %s.\n", 
		      card_device);
	    return;
	}

	if (ioctl(fd, PIOCRWMEM, &pcic_mem) < 0){
	    msgNotify("ioctl %s failed.\n", card_device);
	    return;
	}
    }

    strcpy(pccardd_cmd, "/stand/pccardd ");
    strcat(pccardd_cmd, card_irq);
    strcat(pccardd_cmd, " -n -z");
    vsystem(pccardd_cmd);
}

#endif	/* PCCARD */
