/* This data for the cyrillic coding table analizer has been elaborated
 * after more the 119 texts on 62 cyrillic based languages analysis.
 *       (c) Sergei V. Znamenskii, RFBR, 1996-1998
 *
 *       znamensk@rustex.botik.ru
 *
 * The expression

table[key_last[last_char]][(key_new[new_char])>>2]>>(key_new[new_char]<<1))&3;

 *  returns the index of biletter frequences in internal (iso) encoding:
 *
 *    3    extremally rare
 *    0    indifferent
 *    1    often
 *    2    very often
 *
 */
#define win 0   /* CP1251 */
#define dos 1   /* CP866 */
#define koi 2   /* KOI8 */
#define mac 3   /* MacOS */
#define iso 4   /* ISO8859-5 */
/*
 *      The "key_last" is the first key for the table of biletter frequences:
 */
unsigned char key_last[256]={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 1, 2, 3, 4, 5, 6, 4, 7, 8, 4, 9, 4, 10, 4, 11, 12, 6, 4, 13, 14,
4, 4, 6, 15, 6, 4, 0, 0, 0, 0, 0, 0, 1, 4, 16, 4, 17, 4, 4, 6, 18, 4, 19,
4, 4, 4, 20, 21, 19, 4, 22, 4, 23, 4, 19, 24, 25, 4, 0, 0, 0, 0, 0, 26,
27, 26, 28, 26, 26, 27, 29, 27, 26, 27, 29, 27, 27, 27, 27, 27, 29, 28,
27, 26, 29, 28, 29, 28, 28, 28, 27, 27, 26, 27, 28, 30, 31, 32, 29, 33,
29, 34, 33, 35, 36, 37, 38, 39, 30, 40, 41, 42, 43, 44, 45, 46, 47, 48,
49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
67, 68, 69, 70, 71, 72, 73, 42, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
102, 103, 104, 30, 105, 106, 29, 107, 29, 108, 107, 109, 110, 111, 112,
111, 30, 113, 114};
/*
 *      The "key_new" is the second key for the table of biletter frequences:
 */
unsigned char key_new[256]={0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 1, 2, 3, 4, 5, 6, 4, 7, 8, 4, 9, 4, 10, 4, 11, 12, 6, 4, 13, 14,
4, 4, 6, 15, 16, 4, 0, 0, 0, 0, 0, 0, 17, 4, 18, 4, 19, 4, 4, 16, 8, 4,
16, 4, 4, 4, 20, 21, 16, 4, 22, 4, 23, 4, 16, 24, 25, 4, 0, 0, 0, 0, 0,
26, 26, 27, 26, 27, 27, 26, 27, 26, 28, 28, 26, 26, 26, 26, 26, 26, 28,
29, 29, 27, 28, 28, 29, 29, 29, 26, 29, 27, 26, 27, 29, 30, 31, 32, 28,
33, 34, 28, 35, 36, 37, 38, 39, 40, 41, 42, 28, 43, 44, 45, 46, 47, 48,
49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
103, 104, 105, 106, 41, 107, 28, 108, 109, 110, 111, 112, 113, 108, 114,
108, 115, 41, 116, 117};
/*
 *      The "to_the[]" are the maps from ISO 8859-5 encoding:
 */
unsigned char to_the[4][128]={{149, 133, 153, 130, 135, 136, 137, 139,
160, 155, 166, 183, 152, 176, 173, 164, 169, 172, 174, 177, 181, 182, 165,
180, 150, 151, 145, 146, 147, 148, 132, 134, 171, 168, 128, 129, 170, 189,
178, 175, 163, 138, 140, 142, 141, 187, 161, 143, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226,
227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 185,
184, 144, 131, 186, 190, 179, 191, 188, 154, 156, 158, 157, 167, 162, 159}
,
{201, 176, 203, 218, 202, 206, 223, 185, 255, 204, 177, 178, 254, 248,
251, 253, 220, 179, 197, 191, 205, 186, 195, 180, 194, 193, 192, 217, 188,
200, 187, 196, 183, 240, 213, 222, 242, 184, 221, 244, 212, 211, 190, 189,
249, 214, 246, 198, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153,
154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168,
169, 170, 171, 172, 173, 174, 175, 224, 225, 226, 227, 228, 229, 230, 231,
232, 233, 234, 235, 236, 237, 238, 239, 252, 241, 199, 181, 243, 182, 209,
245, 210, 207, 208, 216, 215, 250, 247, 219},
{165, 144, 184, 130, 187,
190, 139, 181, 154, 177, 145, 146, 148, 156, 150, 140, 191, 129, 138, 131,
160, 161, 134, 135, 136, 137, 132, 133, 174, 171, 168, 128, 167, 179, 162,
143, 153, 166, 142, 147, 169, 170, 172, 173, 149, 164, 159, 175, 225, 226,
247, 231, 228, 229, 246, 250, 233, 234, 235, 236, 237, 238, 239, 240, 242,
243, 244, 245, 230, 232, 227, 254, 251, 253, 255, 249, 248, 252, 224, 241,
193, 194, 215, 199, 196, 197, 214, 218, 201, 202, 203, 204, 205, 206, 207,
208, 210, 211, 212, 213, 198, 200, 195, 222, 219, 221, 223, 217, 216, 220,
192, 209, 157, 163, 176, 178, 152, 180, 182, 155, 183, 185, 186, 188, 189,
158, 151, 141},
{165, 201, 170, 163, 173, 176, 198, 178, 202, 179, 214,
196, 197, 161, 195, 255, 169, 194, 168, 177, 181, 166, 162, 182, 208, 209,
212, 213, 210, 211, 215, 160, 199, 221, 171, 174, 184, 193, 167, 186, 183,
188, 190, 203, 205, 200, 216, 218, 128, 129, 130, 131, 132, 133, 134, 135,
136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150,
151, 152, 153, 154, 155, 156, 157, 158, 159, 224, 225, 226, 227, 228, 229,
230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 223, 220, 222, 172, 175,
185, 207, 180, 187, 192, 189, 191, 204, 206, 164, 217, 219}};
/*
 *      The "from_the[]" are the maps to ISO 8859-5 encoding:
 */
unsigned char from_the[4][128]={{162, 163, 131, 243, 158, 129, 159, 132,
133, 134, 169, 135, 170, 172, 171, 175, 242, 154, 155, 156, 157, 128, 152,
153, 140, 130, 249, 137, 250, 252, 251, 255, 136, 174, 254, 168, 143, 150,
138, 253, 161, 144, 164, 160, 145, 142, 146, 167, 141, 147, 166, 246, 151,
148, 149, 139, 241, 240, 244, 173, 248, 165, 245, 247, 176, 177, 178, 179,
180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239}
,
{176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
220, 221, 222, 223, 129, 138, 139, 145, 151, 243, 245, 160, 165, 135, 149,
158, 156, 171, 170, 147, 154, 153, 152, 150, 159, 146, 175, 242, 157, 128,
132, 130, 137, 148, 133, 249, 250, 246, 248, 169, 168, 162, 173, 252, 251,
155, 131, 255, 144, 166, 163, 134, 224, 225, 226, 227, 228, 229, 230, 231,
232, 233, 234, 235, 236, 237, 238, 239, 161, 241, 164, 244, 167, 247, 174,
254, 141, 172, 253, 142, 240, 143, 140, 136},
{159, 145, 131, 147, 154,
155, 150, 151, 152, 153, 146, 134, 143, 255, 166, 163, 129, 138, 139, 167,
140, 172, 142, 254, 244, 164, 136, 247, 141, 240, 253, 174, 148, 149, 162,
241, 173, 128, 165, 160, 158, 168, 169, 157, 170, 171, 156, 175, 242, 137,
243, 161, 245, 135, 246, 248, 130, 249, 250, 132, 251, 252, 133, 144, 238,
208, 209, 230, 212, 213, 228, 211, 229, 216, 217, 218, 219, 220, 221, 222,
223, 239, 224, 225, 226, 227, 214, 210, 236, 235, 215, 232, 237, 233, 231,
234, 206, 176, 177, 198, 180, 181, 196, 179, 197, 184, 185, 186, 187, 188,
189, 190, 191, 207, 192, 193, 194, 195, 182, 178, 204, 203, 183, 200, 205,
201, 199, 202},
{176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186,
187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201,
202, 203, 204, 205, 206, 207, 159, 141, 150, 131, 253, 128, 149, 166, 146,
144, 130, 162, 242, 132, 163, 243, 133, 147, 135, 137, 246, 148, 151, 168,
164, 244, 167, 247, 169, 249, 170, 250, 248, 165, 145, 142, 139, 140, 134,
160, 173, 129, 136, 171, 251, 172, 252, 245, 152, 153, 156, 157, 154, 155,
138, 158, 174, 254, 175, 255, 240, 161, 241, 239, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227,
228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 143}};

unsigned char table[115][30]={{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 85,
81, 85, 85, 21, 81, 204, 81, 85, 81, 85, 85, 21, 81, 204, 17, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 68, 85, 20, 85, 81, 5, 81, 0, 80, 85, 20,
85, 81, 5, 81, 0, 16, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 16, 192, 0, 116, 3, 65, 3, 69, 208, 0, 16, 64, 3,
65, 3, 69, 208, 0, 16, 0, 0, 3, 3},
{0, 0, 0, 0, 0, 0, 0, 16, 192, 0, 116, 0, 65, 23, 5, 21, 0, 80, 80, 0,
65, 23, 5, 21, 0, 80, 16, 0, 3, 3},
{0, 0, 0, 0, 0, 0, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255,
255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 15},
{0, 0, 0, 0, 0, 0, 0, 16, 252, 0, 52, 85, 16, 85, 81, 5, 65, 240, 0, 85,
16, 85, 81, 5, 65, 240, 0, 60, 3, 3},
{0, 0, 0, 0, 0, 0, 0, 192, 3, 255, 3, 0, 0, 0, 0, 0, 12, 252, 60, 0, 0,
0, 0, 0, 12, 252, 252, 3, 252, 12},
{0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 68, 80, 65, 64, 5, 21, 16, 80, 81, 80,
65, 64, 5, 21, 16, 80, 17, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 192, 3, 0, 0, 0, 0, 3, 0, 0, 0, 255, 63, 0, 0, 3,
0, 0, 0, 255, 255, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 16, 204, 0, 116, 3, 65, 23, 4, 213, 0, 19, 112, 3,
65, 23, 4, 213, 0, 19, 48, 12, 3, 3},
{0, 0, 0, 0, 0, 0, 0, 208, 204, 3, 68, 0, 113, 3, 4, 16, 0, 31, 64, 0,
113, 3, 4, 16, 0, 31, 192, 12, 15, 0},
{0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 4, 85, 16, 85, 81, 5, 65, 12, 0, 85, 16,
85, 81, 5, 65, 12, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 16, 192, 0, 116, 80, 65, 84, 5, 21, 0, 16, 64, 80,
65, 84, 5, 21, 0, 16, 0, 0, 3, 3},
{0, 0, 0, 0, 0, 0, 0, 192, 3, 252, 3, 0, 0, 0, 0, 0, 0, 252, 0, 0, 0, 0,
0, 0, 0, 252, 192, 3, 240, 12},
{0, 0, 0, 0, 0, 0, 0, 16, 192, 0, 68, 4, 125, 23, 5, 20, 0, 83, 65, 4,
125, 23, 5, 20, 0, 83, 1, 0, 3, 0},
{0, 0, 0, 0, 0, 0, 0, 208, 204, 0, 68, 0, 76, 3, 4, 212, 0, 3, 76, 0, 76,
3, 4, 212, 0, 3, 204, 204, 3, 0},
{0, 0, 0, 0, 0, 0, 0, 208, 255, 255, 247, 255, 255, 255, 255, 255, 255,
255, 127, 0, 65, 23, 5, 21, 0, 80, 16, 0, 3, 3},
{0, 0, 0, 0, 0, 0, 0, 208, 255, 255, 247, 255, 255, 255, 255, 255, 255,
255, 63, 85, 16, 85, 81, 5, 65, 240, 0, 60, 3, 3},
{0, 0, 0, 0, 0, 0, 0, 192, 255, 255, 243, 255, 255, 255, 255, 255, 255,
255, 63, 0, 0, 3, 0, 0, 0, 255, 255, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 192, 255, 255, 243, 255, 255, 255, 255, 255, 255,
255, 63, 0, 0, 0, 0, 0, 12, 252, 252, 3, 252, 12},
{0, 0, 0, 0, 0, 0, 0, 208, 255, 255, 247, 255, 255, 255, 255, 255, 255,
255, 63, 85, 16, 85, 81, 5, 65, 12, 0, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 208, 255, 255, 247, 255, 255, 255, 255, 255, 255,
255, 127, 80, 65, 84, 5, 21, 0, 16, 0, 0, 3, 3},
{0, 0, 0, 0, 0, 0, 0, 192, 255, 255, 243, 255, 255, 255, 255, 255, 255,
255, 63, 0, 0, 0, 0, 0, 0, 252, 192, 3, 240, 12},
{0, 0, 0, 0, 0, 0, 0, 208, 255, 255, 247, 255, 255, 255, 255, 255, 255,
255, 63, 84, 16, 85, 65, 5, 80, 204, 16, 0, 0, 0},
{0, 0, 0, 0, 0, 0, 0, 208, 255, 255, 247, 255, 255, 255, 255, 255, 255,
255, 127, 0, 76, 3, 4, 212, 0, 3, 204, 204, 3, 0},
{0, 0, 0, 0, 0, 0, 0, 208, 255, 255, 247, 255, 255, 255, 255, 255, 255,
255, 63, 84, 16, 85, 81, 5, 81, 12, 192, 48, 3, 3},
{0, 3, 3, 0, 0, 0, 0, 0, 207, 204, 3, 0, 0, 0, 0, 0, 0, 204, 12, 0, 0,
0, 0, 0, 0, 204, 12, 12, 243, 12},
{0, 3, 3, 0, 0, 0, 0, 0, 207, 252, 3, 0, 0, 0, 0, 0, 0, 204, 12, 0, 0,
0, 0, 0, 0, 204, 12, 207, 243, 12},
{0, 3, 3, 0, 0, 0, 0, 0, 207, 60, 3, 0, 0, 0, 0, 0, 0, 204, 12, 0, 0, 0,
0, 0, 0, 204, 12, 207, 3, 12},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0},
{84, 71, 84, 81, 84, 69, 5, 64, 1, 0, 128, 170, 166, 170, 170, 106, 166,
220, 166, 170, 166, 170, 170, 106, 166, 220, 102, 0, 0, 0},
{0, 63, 3, 12, 195, 240, 252, 204, 255, 255, 51, 0, 195, 0, 65, 48, 1,
255, 51, 0, 195, 0, 65, 48, 1, 255, 243, 255, 255, 15},
{240, 243, 63, 255, 51, 60, 51, 220, 207, 207, 119, 255, 60, 255, 243,
207, 255, 255, 127, 255, 60, 255, 243, 207, 255, 255, 255, 60, 255, 15}
,
{0, 3, 0, 0, 0, 0, 240, 204, 3, 252, 3, 0, 0, 0, 0, 0, 0, 252, 0, 0, 0,
0, 0, 0, 0, 252, 192, 3, 240, 12},
{0, 3, 0, 0, 0, 0, 0, 192, 3, 0, 0, 0, 0, 3, 0, 0, 0, 255, 63, 0, 0, 3,
0, 0, 0, 255, 255, 0, 0, 0},
{0, 51, 0, 0, 3, 0, 0, 192, 204, 0, 112, 3, 0, 3, 48, 192, 12, 255, 127,
3, 0, 3, 48, 192, 12, 255, 255, 12, 3, 3},
{0, 51, 0, 12, 3, 48, 240, 192, 252, 0, 48, 0, 0, 0, 0, 0, 0, 255, 63,
0, 0, 0, 0, 0, 0, 255, 255, 12, 3, 3},
{0, 51, 0, 12, 3, 48, 240, 204, 252, 0, 48, 0, 0, 0, 0, 0, 0, 255, 63,
0, 0, 0, 0, 0, 0, 255, 255, 60, 3, 3},
{0, 51, 0, 204, 3, 48, 243, 204, 252, 3, 48, 243, 60, 3, 48, 192, 3, 255,
63, 243, 60, 3, 48, 192, 3, 255, 255, 60, 15, 3},
{0, 51, 0, 12, 3, 48, 240, 204, 255, 0, 48, 0, 0, 0, 0, 0, 0, 255, 63,
0, 0, 0, 0, 0, 0, 255, 255, 60, 3, 3},
{0, 3, 0, 0, 0, 0, 240, 204, 3, 252, 3, 0, 0, 0, 0, 0, 0, 204, 0, 0, 0,
0, 0, 0, 0, 204, 192, 3, 240, 12},
{240, 243, 63, 255, 51, 60, 51, 204, 207, 207, 51, 255, 60, 255, 243, 207,
255, 255, 63, 255, 60, 255, 243, 207, 255, 255, 255, 60, 255, 15},
{85, 67, 20, 81, 20, 4, 1, 96, 1, 0, 136, 170, 105, 170, 162, 90, 166,
0, 164, 170, 105, 170, 162, 90, 166, 0, 100, 0, 0, 0},
{4, 55, 64, 0, 71, 65, 4, 80, 0, 3, 132, 0, 130, 19, 72, 224, 192, 32,
145, 0, 130, 19, 72, 224, 192, 32, 81, 0, 12, 0},
{5, 119, 64, 1, 71, 69, 4, 96, 192, 0, 184, 3, 130, 23, 138, 229, 1, 32,
129, 3, 130, 23, 138, 229, 1, 32, 65, 0, 3, 3},
{5, 7, 64, 1, 68, 69, 4, 224, 192, 3, 184, 64, 190, 19, 137, 228, 204,
103, 129, 64, 190, 19, 137, 228, 204, 103, 193, 0, 15, 3},
{5, 119, 64, 0, 71, 65, 4, 96, 209, 3, 184, 84, 150, 19, 74, 225, 1, 99,
145, 84, 150, 19, 74, 225, 1, 99, 81, 16, 15, 3},
{81, 67, 20, 93, 16, 52, 1, 96, 252, 0, 56, 170, 37, 170, 162, 10, 150,
240, 0, 170, 37, 170, 162, 10, 150, 240, 64, 60, 3, 3},
{4, 51, 48, 204, 7, 112, 3, 192, 252, 3, 176, 0, 177, 195, 49, 208, 199,
31, 188, 0, 177, 195, 49, 208, 199, 31, 252, 60, 15, 3},
{5, 119, 0, 0, 71, 64, 4, 224, 204, 3, 136, 149, 130, 83, 6, 224, 204,
99, 128, 149, 130, 83, 6, 224, 204, 99, 192, 12, 15, 0},
{81, 67, 20, 17, 16, 4, 0, 96, 0, 0, 72, 169, 101, 170, 150, 74, 165, 204,
96, 169, 101, 170, 150, 74, 165, 204, 96, 0, 0, 0},
{1, 115, 0, 16, 3, 64, 0, 224, 207, 255, 123, 144, 129, 36, 70, 9, 0, 239,
67, 144, 129, 36, 70, 9, 0, 239, 195, 15, 255, 15},
{69, 55, 68, 16, 87, 65, 4, 96, 221, 0, 184, 7, 130, 43, 73, 234, 4, 39,
177, 7, 130, 43, 73, 234, 4, 39, 113, 28, 3, 3},
{5, 71, 80, 80, 68, 65, 5, 96, 17, 0, 136, 161, 150, 164, 10, 40, 2, 160,
166, 161, 150, 164, 10, 40, 2, 160, 102, 16, 0, 0},
{5, 55, 64, 0, 71, 65, 4, 224, 205, 3, 136, 65, 178, 23, 73, 33, 0, 47,
129, 65, 178, 23, 73, 33, 0, 47, 193, 12, 15, 0},
{69, 71, 80, 16, 84, 65, 4, 96, 17, 0, 136, 164, 130, 148, 10, 42, 36,
160, 162, 164, 130, 148, 10, 42, 36, 160, 98, 16, 0, 0},
{81, 115, 20, 81, 19, 4, 1, 96, 0, 0, 72, 170, 101, 170, 166, 10, 150,
13, 80, 170, 101, 170, 166, 10, 150, 13, 80, 0, 0, 0},
{53, 55, 64, 16, 71, 65, 4, 96, 192, 3, 187, 12, 190, 23, 72, 232, 0, 32,
140, 12, 190, 23, 72, 232, 0, 32, 76, 0, 207, 3},
{69, 71, 84, 16, 84, 65, 4, 96, 193, 0, 184, 164, 134, 168, 10, 106, 81,
32, 129, 164, 134, 168, 10, 106, 81, 32, 65, 0, 3, 3},
{69, 71, 68, 16, 84, 65, 4, 96, 209, 0, 184, 4, 130, 107, 26, 42, 17, 160,
161, 4, 130, 107, 26, 42, 17, 160, 97, 16, 3, 3},
{21, 119, 68, 16, 71, 65, 4, 96, 209, 0, 136, 72, 190, 107, 74, 41, 0,
167, 146, 72, 190, 107, 74, 41, 0, 167, 82, 16, 3, 0},
{81, 67, 20, 93, 16, 52, 1, 224, 240, 0, 120, 169, 100, 170, 162, 26, 162,
28, 84, 169, 100, 170, 162, 26, 162, 28, 212, 48, 3, 3},
{48, 51, 12, 192, 3, 0, 3, 192, 204, 3, 112, 255, 125, 15, 52, 4, 255,
207, 124, 255, 125, 15, 52, 4, 255, 207, 252, 12, 15, 3},
{5, 3, 67, 16, 4, 65, 4, 224, 204, 0, 136, 0, 141, 19, 9, 232, 0, 87, 141,
0, 141, 19, 9, 232, 0, 87, 205, 204, 3, 0},
{4, 243, 3, 0, 7, 64, 0, 16, 220, 3, 180, 3, 189, 0, 55, 208, 252, 15,
128, 3, 189, 0, 55, 208, 252, 15, 0, 220, 15, 3},
{4, 55, 0, 192, 71, 64, 7, 16, 204, 3, 180, 243, 190, 7, 53, 228, 3, 35,
177, 243, 190, 7, 53, 228, 3, 35, 49, 12, 15, 3},
{5, 55, 4, 16, 71, 64, 0, 224, 204, 0, 184, 0, 190, 107, 5, 216, 12, 35,
188, 0, 190, 107, 5, 216, 12, 35, 252, 12, 3, 3},
{240, 51, 63, 195, 51, 12, 243, 12, 207, 252, 51, 255, 124, 255, 240, 195,
255, 12, 0, 255, 124, 255, 240, 195, 255, 12, 0, 207, 243, 15},
{192, 51, 15, 12, 51, 48, 240, 12, 255, 255, 115, 0, 64, 15, 48, 211, 252,
220, 80, 0, 64, 15, 48, 211, 252, 220, 16, 255, 255, 15},
{65, 115, 215, 29, 19, 55, 0, 224, 255, 255, 59, 165, 21, 169, 174, 10,
145, 204, 3, 165, 21, 169, 174, 10, 145, 204, 195, 255, 255, 15},
{1, 3, 3, 0, 0, 0, 0, 96, 207, 255, 123, 0, 64, 20, 5, 21, 0, 220, 64,
0, 64, 20, 5, 21, 0, 220, 64, 207, 255, 15},
{0, 67, 23, 16, 0, 0, 240, 220, 207, 255, 55, 148, 0, 169, 82, 9, 17, 252,
13, 148, 0, 169, 82, 9, 17, 252, 205, 207, 255, 15},
{48, 51, 3, 12, 3, 48, 0, 16, 243, 255, 55, 12, 0, 16, 49, 196, 0, 60,
51, 12, 0, 16, 49, 196, 0, 60, 51, 243, 255, 15},
{81, 115, 195, 12, 19, 243, 12, 224, 243, 255, 59, 88, 208, 84, 78, 246,
1, 12, 3, 88, 208, 84, 78, 246, 1, 12, 195, 243, 255, 15},
{252, 255, 252, 255, 71, 65, 4, 208, 255, 255, 247, 255, 255, 255, 255,
255, 255, 255, 191, 0, 130, 19, 72, 224, 192, 32, 81, 0, 12, 0},
{253, 255, 252, 255, 71, 69, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 3, 130, 23, 138, 229, 1, 32, 65, 0, 3, 3},
{253, 255, 252, 255, 68, 69, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 64, 190, 19, 137, 228, 204, 103, 193, 0, 15, 3},
{253, 255, 252, 255, 71, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 84, 150, 19, 74, 225, 1, 99, 81, 16, 15, 3},
{253, 255, 252, 255, 16, 52, 1, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 63, 170, 37, 170, 162, 10, 150, 240, 64, 60, 3, 3},
{252, 255, 252, 255, 7, 112, 3, 192, 255, 255, 243, 255, 255, 255, 255,
255, 255, 255, 191, 0, 177, 195, 49, 208, 199, 31, 252, 60, 15, 3},
{253, 255, 252, 255, 71, 64, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 149, 130, 83, 6, 224, 204, 99, 192, 12, 15, 0},
{253, 255, 252, 255, 16, 4, 0, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 127, 169, 101, 170, 150, 74, 165, 204, 96, 0, 0, 0},
{253, 255, 252, 255, 3, 64, 0, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 127, 144, 129, 36, 70, 9, 0, 239, 195, 15, 255, 15},
{253, 255, 252, 255, 87, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 7, 130, 43, 73, 234, 4, 39, 113, 28, 3, 3},
{253, 255, 252, 255, 68, 65, 5, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 161, 150, 164, 10, 40, 2, 160, 102, 16, 0, 0},
{253, 255, 252, 255, 71, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 65, 178, 23, 73, 33, 0, 47, 193, 12, 15, 0},
{253, 255, 252, 255, 84, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 164, 130, 148, 10, 42, 36, 160, 98, 16, 0, 0},
{253, 255, 252, 255, 19, 4, 1, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 127, 170, 101, 170, 166, 10, 150, 13, 80, 0, 0, 0},
{253, 255, 252, 255, 71, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 12, 190, 23, 72, 232, 0, 32, 76, 0, 207, 3},
{253, 255, 252, 255, 84, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 164, 134, 168, 10, 106, 81, 32, 65, 0, 3, 3},
{253, 255, 252, 255, 84, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 4, 130, 107, 26, 42, 17, 160, 97, 16, 3, 3},
{253, 255, 252, 255, 71, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 72, 190, 107, 74, 41, 0, 167, 82, 16, 3, 0},
{253, 255, 252, 255, 16, 52, 1, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 127, 169, 100, 170, 162, 26, 162, 28, 212, 48, 3, 3},
{252, 255, 252, 255, 3, 0, 3, 192, 255, 255, 243, 255, 255, 255, 255, 255,
255, 255, 127, 255, 125, 15, 52, 4, 255, 207, 252, 12, 15, 3},
{253, 255, 255, 255, 4, 65, 4, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 0, 141, 19, 9, 232, 0, 87, 205, 204, 3, 0},
{252, 255, 255, 255, 7, 64, 0, 208, 255, 255, 247, 255, 255, 255, 255,
255, 255, 255, 191, 3, 189, 0, 55, 208, 252, 15, 0, 220, 15, 3},
{252, 255, 252, 255, 71, 64, 7, 208, 255, 255, 247, 255, 255, 255, 255,
255, 255, 255, 191, 243, 190, 7, 53, 228, 3, 35, 49, 12, 15, 3},
{253, 255, 252, 255, 71, 64, 0, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 191, 0, 190, 107, 5, 216, 12, 35, 252, 12, 3, 3},
{252, 255, 255, 255, 51, 12, 243, 204, 255, 255, 243, 255, 255, 255, 255,
255, 255, 255, 63, 255, 124, 255, 240, 195, 255, 12, 0, 207, 243, 15},
{252, 255, 255, 255, 51, 48, 240, 204, 255, 255, 243, 255, 255, 255, 255,
255, 255, 255, 127, 0, 64, 15, 48, 211, 252, 220, 16, 255, 255, 15},
{253, 255, 255, 255, 19, 55, 0, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 63, 165, 21, 169, 174, 10, 145, 204, 195, 255, 255, 15},
{253, 255, 255, 255, 0, 0, 0, 224, 255, 255, 251, 255, 255, 255, 255, 255,
255, 255, 127, 0, 64, 20, 5, 21, 0, 220, 64, 207, 255, 15},
{252, 255, 255, 255, 0, 0, 240, 220, 255, 255, 247, 255, 255, 255, 255,
255, 255, 255, 63, 148, 0, 169, 82, 9, 17, 252, 205, 207, 255, 15},
{252, 255, 255, 255, 3, 48, 0, 208, 255, 255, 247, 255, 255, 255, 255,
255, 255, 255, 63, 12, 0, 16, 49, 196, 0, 60, 51, 243, 255, 15},
{253, 255, 255, 255, 19, 243, 12, 224, 255, 255, 251, 255, 255, 255, 255,
255, 255, 255, 63, 88, 208, 84, 78, 246, 1, 12, 195, 243, 255, 15},
{252, 255, 255, 255, 195, 240, 252, 204, 255, 255, 243, 255, 255, 255,
255, 255, 255, 255, 63, 0, 195, 0, 65, 48, 1, 255, 243, 255, 255, 15},
{252, 255, 255, 255, 51, 60, 243, 192, 255, 63, 247, 255, 255, 255, 255,
255, 255, 255, 127, 255, 60, 255, 243, 207, 255, 255, 255, 207, 3, 15},
{252, 255, 252, 255, 0, 0, 240, 204, 255, 255, 243, 255, 255, 255, 255,
255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 252, 192, 3, 240, 12},
{252, 255, 252, 255, 0, 0, 0, 192, 207, 207, 243, 255, 255, 255, 255, 255,
255, 255, 63, 0, 0, 3, 0, 0, 0, 255, 255, 0, 0, 0},
{252, 255, 252, 255, 3, 0, 0, 192, 255, 63, 243, 255, 255, 255, 255, 255,
255, 255, 127, 3, 0, 3, 48, 192, 12, 255, 255, 12, 3, 3},
{252, 255, 252, 255, 3, 48, 48, 204, 207, 207, 243, 255, 255, 255, 255,
255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 255, 255, 60, 3, 3},
{252, 255, 252, 255, 3, 48, 240, 192, 255, 63, 243, 255, 255, 255, 255,
255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 255, 255, 12, 3, 3},
{252, 255, 252, 255, 3, 48, 51, 204, 207, 207, 243, 255, 255, 255, 255,
255, 255, 255, 63, 243, 60, 3, 48, 192, 3, 255, 255, 60, 15, 3},
{252, 255, 252, 255, 0, 0, 240, 204, 255, 255, 243, 255, 255, 255, 255,
255, 255, 255, 63, 0, 0, 0, 0, 0, 0, 204, 192, 3, 240, 12},
{252, 255, 255, 255, 51, 60, 243, 204, 255, 255, 243, 255, 255, 255, 255,
255, 255, 255, 63, 255, 60, 255, 243, 207, 255, 255, 255, 255, 255, 15}
};

