--- include/openscep_err.h.orig	Thu May 19 16:26:46 2005
+++ include/openscep_err.h	Thu May 19 16:26:46 2005
@@ -0,0 +1,33 @@
+#ifndef HEADER_OPENSCEP_ERR_H
+#define HEADER_OPENSCEP_ERR_H
+
+#if OPENSSL_VERSION_NUMBER < 0x00907000L
+/* ERR_unload_strings was added in 0.9.7. with older versions, it's
+   redefined as a no-op here so the auto-generated code in
+   openscep_err.c doesn't need to be changed. */
+#define ERR_unload_strings(A,B) do{}while(0)
+#endif
+
+/* BEGIN ERROR CODES */
+/* The following lines are auto generated by the script mkerr.pl. Any changes
+ * made after this point may be overwritten when the script is next run.
+ */
+void ERR_load_OPENSCEP_strings(void);
+void ERR_unload_OPENSCEP_strings(void);
+void ERR_OPENSCEP_error(int function, int reason, char *file, int line);
+#define OPENSCEPerr(f,r) ERR_OPENSCEP_error((f),(r),__FILE__,__LINE__)
+
+/* Error codes for the OPENSCEP functions. */
+
+/* Function codes. */
+#define OPENSCEP_F_D2I_ISSUER_AND_SUBJECT		 100
+#define OPENSCEP_F_D2I_PAYLOAD				 101
+#define OPENSCEP_F_ISSUER_AND_SUBJECT_NEW		 102
+#define OPENSCEP_F_PAYLOAD_NEW				 103
+
+/* Reason codes. */
+
+#ifdef  __cplusplus
+}
+#endif
+#endif
