/* _mpfr_ceil_log2 - returns ceil(log(d)/log(2))

Copyright 1999, 2000, 2001, 2002 Free Software Foundation.

This file is part of the MPFR Library.

The MPFR Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The MPFR Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the MPFR Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#include "gmp.h"
#include "gmp-impl.h"
#include "mpfr.h"
#include "mpfr-impl.h"

/* returns ceil(log(d)/log(2)) */
long
_mpfr_ceil_log2 (double d)
{
  long exp;
  union ieee_double_extract x;

  x.d = d;
  exp = x.s.exp - 1023;
  x.s.exp = 1023; /* value for 1 <= d < 2 */
  if (x.d != 1.0) /* d: not a power of two? */
    exp++;
  return exp;
}
