/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.commonlisp.lang.Symbols;
import gnu.jemacs.buffer.BufferLocal;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EKeymap;
import gnu.jemacs.buffer.EToolkit;
import gnu.jemacs.buffer.EWindow;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Mode;
import gnu.jemacs.buffer.Signal;
import gnu.lists.AbstractSequence;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.mapping.InPort;
import gnu.mapping.WrappedException;
import gnu.text.Char;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;

public abstract class Buffer
extends AbstractSequence
implements CharSeq {
    String name;
    String filename;
    String encoding;
    static Buffer current;
    public Marker pointMarker;
    public Marker markMarker;
    Object[] localBindings;
    Mode modes;
    public static Hashtable buffers;
    public static Hashtable fileBuffers;
    EKeymap localKeymap;
    public EKeymap[] activeKeymaps;
    int activeLength;
    int eliminated = 0;
    int tabWidth = 8;

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String fname) {
        if (this.filename != null && fileBuffers.get(this.filename) == this) {
            fileBuffers.remove(this.filename);
        }
        if (this.name != null && buffers.get(this.name) == this) {
            buffers.remove(this.name);
        }
        this.filename = fname;
        this.name = Buffer.generateNewBufferName(new File(fname).getName());
        buffers.put(this.name, this);
        fileBuffers.put(this.filename, this);
        this.redrawModeline();
    }

    public abstract CharSeq getStringContent();

    public char charAt(int index) {
        return this.getStringContent().charAt(index);
    }

    public void setCharAt(int index, char ch) {
        this.getStringContent().setCharAt(index, ch);
    }

    public void fill(char value) {
        this.getStringContent().fill(value);
    }

    public void fill(int fromIndex, int toIndex, char value) {
        this.getStringContent().fill(fromIndex, toIndex, value);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.getStringContent().getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public CharSequence subSequence(int start, int end) {
        return this.getStringContent().subSequence(start, end);
    }

    public void writeTo(int start, int count, Writer dest) throws IOException {
        this.getStringContent().writeTo(start, count, dest);
    }

    public void writeTo(Writer str) throws IOException {
        this.writeTo(0, this.length(), str);
    }

    public void consume(int start, int count, Consumer out) {
        this.getStringContent().consume(start, count, out);
    }

    public static Buffer findFile(String fname) {
        Buffer buffer = (Buffer)fileBuffers.get(fname);
        if (buffer == null) {
            buffer = EToolkit.getInstance().newBuffer(null);
            buffer.setFileName(fname);
            buffer.encoding = System.getProperty("file.encoding", "UTF8");
            try {
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(fname), buffer.encoding);
                buffer.insertFile(in);
                ((Reader)in).close();
            }
            catch (FileNotFoundException ex) {
                Signal.message("New file");
            }
            catch (Exception ex) {
                throw new RuntimeException("error reading file \"" + fname + "\": " + ex);
            }
        }
        return buffer;
    }

    public static Buffer getBuffer(String name) {
        return (Buffer)buffers.get(name);
    }

    public static Buffer coerceBuffer(Object buf) {
        if (buf instanceof Buffer) {
            return (Buffer)buf;
        }
        return Buffer.getBuffer(buf.toString());
    }

    public static String generateNewBufferName(String start) {
        Buffer buf = Buffer.getBuffer(start);
        if (buf == null) {
            return start;
        }
        int len = start.length();
        StringBuffer sbuf = new StringBuffer(len + 5);
        sbuf.append(start);
        sbuf.append('<');
        int i = 2;
        while (true) {
            sbuf.append(i);
            sbuf.append('>');
            String name = sbuf.toString();
            buf = Buffer.getBuffer(name);
            if (buf == null) {
                return name;
            }
            sbuf.setLength(len + 1);
            ++i;
        }
    }

    public abstract void redrawModeline();

    public Buffer(String name) {
        this.name = name;
        this.activeKeymaps = new EKeymap[6];
        this.activeLength = 1;
        this.activeKeymaps[0] = EKeymap.globalKeymap;
    }

    public int checkMark() {
        return this.markMarker.getOffset();
    }

    public static Buffer getCurrent() {
        return current;
    }

    public static void setCurrent(Buffer buffer) {
        current = buffer;
    }

    public int getDot() {
        return this.pointMarker.getOffset();
    }

    public int getPoint() {
        return 1 + this.getDot();
    }

    public void setDot(int i) {
        if (i > this.maxDot()) {
            throw new Error("set dot to " + i + " max:" + this.maxDot());
        }
        this.pointMarker.set(this, i);
    }

    public final void setPoint(int i) {
        this.setDot(i - 1);
    }

    public int minDot() {
        return 0;
    }

    public abstract int getLength();

    public final int length() {
        return this.getLength();
    }

    public abstract int maxDot();

    public void forwardChar(int i) {
        this.pointMarker.forwardChar(i);
    }

    public void backwardChar(int i) {
        this.pointMarker.backwardChar(i);
    }

    public String toString() {
        return "#<buffer \"" + this.name + "\">";
    }

    public abstract void insert(String var1, Object var2, int var3);

    public void insert(char[] chars, int offset, int count, Object style, int ipos) {
        this.insert(new String(chars, offset, count), style, ipos);
    }

    public void insertAll(Object[] values, Object style) {
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            Object value = values[i];
            if (value instanceof Char) {
                this.insert(((Char)value).charValue(), 1, style);
                continue;
            }
            this.pointMarker.insert(value.toString(), style);
        }
    }

    public void insert(String string, Object style) {
        this.pointMarker.insert(string, style);
    }

    public void insert(Object value, Object style) {
        if (value instanceof Char) {
            this.insert(((Char)value).charValue(), 1, style);
        } else {
            this.pointMarker.insert(value.toString(), style);
        }
    }

    public void insert(char ch, int count) {
        this.pointMarker.insert(ch, count, null);
    }

    public void insert(char ch, int count, Object style) {
        this.pointMarker.insert(ch, count, style);
    }

    public void removeChar(int count) {
        this.pointMarker.removeChar(count);
    }

    public abstract void removeAll();

    public Marker getPointMarker(boolean share) {
        return share ? this.pointMarker : new Marker(this.pointMarker);
    }

    public Marker getMarkMarker(boolean force) {
        return this.markMarker;
    }

    public int positionToOffset(Object position) {
        if (position instanceof Number) {
            int min = this.minDot();
            int max = this.maxDot();
            int goal = ((Number)position).intValue() - 1;
            return goal < min ? min : (goal > max ? max : goal);
        }
        return ((Marker)position).getOffset();
    }

    public abstract void insertFile(Reader var1) throws Exception;

    public abstract void save(Writer var1) throws Exception;

    public void save() {
        try {
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding", "UTF8");
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), this.encoding);
            this.save(out);
            ((Writer)out).close();
        }
        catch (Exception ex) {
            throw new RuntimeException("error save-buffer: " + ex);
        }
    }

    public void insertFile(String filename) {
        try {
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding", "UTF8");
            }
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(filename), this.encoding);
            this.insertFile(in);
            ((Reader)in).close();
        }
        catch (Exception ex) {
            throw new RuntimeException("error reading file \"" + filename + "\": " + ex);
        }
    }

    public int charWidth(char ch, int column) {
        if (ch < '\u3000') {
            if (ch < ' ') {
                if (ch == '\t') {
                    return (column + this.tabWidth) / this.tabWidth * this.tabWidth - column;
                }
                return 0;
            }
        } else {
            if (ch < '\ud800' || ch >= '\uff01' && ch <= '\uff5e' || ch >= '\uffe0' && ch <= '\uffe6') {
                return 2;
            }
            if (ch < '\ue000') {
                return 0;
            }
        }
        return 1;
    }

    public int countColumns(char[] chars, int start, int count, int initial) {
        while (--count >= 0) {
            initial += this.charWidth(chars[start++], initial);
        }
        return initial;
    }

    public int currentColumn() {
        return this.currentColumn(this.getDot());
    }

    public int currentColumn(int offset) {
        try {
            int lineStart = this.lineStartOffset(offset);
            InPort port = this.openReader(lineStart, offset - lineStart);
            int column = 0;
            while (port.read() >= 0) {
                int start = port.pos - 1;
                column = this.countColumns(port.buffer, start, port.limit - start, column);
                port.pos = port.limit;
            }
            return column;
        }
        catch (IOException ex) {
            throw new WrappedException(ex);
        }
    }

    public int moveToColumn(int column, boolean force) {
        return this.pointMarker.moveToColumn(column, force);
    }

    public abstract int lineStartOffset(int var1);

    public int lineStartOffset() {
        return this.lineStartOffset(this.getDot());
    }

    public abstract long scan(char var1, int var2, int var3, int var4, boolean var5);

    public final long forwardLine(int lines, int start) {
        boolean neg = lines <= 0;
        long scanned = this.scan('\n', start, 0, lines - (neg ? 1 : 0), true);
        int shortage = (int)(scanned >> 32);
        int pos = (int)scanned;
        if (shortage > 0 && (neg || this.maxDot() > this.minDot() && pos != start && this.charAt(pos - 1) != '\n')) {
            --shortage;
        }
        return (long)(neg ? -shortage : shortage) << 32 | (long)pos;
    }

    public int forwardLine(int lines) {
        long value = this.forwardLine(lines, this.getDot());
        this.setDot((int)value);
        return (int)(value >> 32);
    }

    public EWindow display(boolean notThisWindow, EFrame frame71) {
        EWindow window;
        EWindow selected;
        if (frame71 == null) {
            frame71 = EFrame.getSelectedFrame();
        }
        if ((selected = frame71.getSelectedWindow()) == (window = frame71.otherWindow(1)) && notThisWindow) {
            window = selected.split(-1, false);
        }
        window.setBuffer(this);
        return window;
    }

    public static void makeBufferLocal(Object symbol, boolean all) {
        BufferLocal.make(Symbols.getSymbol(symbol), all);
    }

    public EKeymap getLocalKeymap() {
        return this.localKeymap;
    }

    public void setLocalKeymap(EKeymap map2) {
        if (this.localKeymap != null) {
            this.activeKeymaps[this.activeLength - 2] = this.activeKeymaps[this.activeLength - 1];
            --this.activeLength;
            this.localKeymap = null;
        }
        if (map2 != null) {
            this.activeKeymaps[this.activeLength] = this.activeKeymaps[this.activeLength - 1];
            this.activeKeymaps[this.activeLength - 1] = map2;
            ++this.activeLength;
            this.localKeymap = map2;
        }
    }

    public abstract InPort openReader(int var1, int var2);

    public abstract long savePointMark();

    public abstract void restorePointMark(long var1);

    public abstract void invoke(Runnable var1);

    static {
        buffers = new Hashtable(100);
        fileBuffers = new Hashtable(100);
    }
}

