/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.lists.AbstractFormat;
import gnu.lists.Consumer;
import gnu.mapping.OutPort;
import gnu.text.ReportFormat;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.ParsePosition;
import kawa.standard.Scheme;

public class ObjectFormat
extends ReportFormat {
    int maxChars;
    boolean readable;
    private static ObjectFormat readableFormat;
    private static ObjectFormat plainFormat;

    public static ObjectFormat getInstance(boolean readable) {
        if (readable) {
            if (readableFormat == null) {
                readableFormat = new ObjectFormat(true);
            }
            return readableFormat;
        }
        if (plainFormat == null) {
            plainFormat = new ObjectFormat(false);
        }
        return plainFormat;
    }

    public ObjectFormat(boolean readable) {
        this.readable = readable;
        this.maxChars = -1073741824;
    }

    public ObjectFormat(boolean readable, int maxChars) {
        this.readable = readable;
        this.maxChars = maxChars;
    }

    public int format(Object[] args, int start, Writer dst, FieldPosition fpos) throws IOException {
        int maxChars = ObjectFormat.getParam(this.maxChars, -1, args, start);
        if (this.maxChars == -1610612736) {
            ++start;
        }
        return ObjectFormat.format(args, start, dst, maxChars, this.readable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(Object obj, OutPort out, boolean readable) {
        boolean saveReadable = out.printReadable;
        AbstractFormat saveFormat = out.objectFormat;
        try {
            AbstractFormat format;
            out.printReadable = readable;
            out.objectFormat = format = readable ? Scheme.writeFormat : Scheme.displayFormat;
            format.writeObject(obj, (Consumer)out);
        }
        finally {
            out.printReadable = saveReadable;
            out.objectFormat = saveFormat;
        }
    }

    public static boolean format(Object arg, Writer dst, int maxChars, boolean readable) throws IOException {
        if (maxChars < 0 && dst instanceof OutPort) {
            ObjectFormat.print(arg, (OutPort)dst, readable);
            return true;
        }
        if (maxChars < 0 && dst instanceof CharArrayWriter) {
            OutPort oport = new OutPort(dst);
            ObjectFormat.print(arg, oport, readable);
            oport.close();
            return true;
        }
        CharArrayWriter wr = new CharArrayWriter();
        OutPort oport = new OutPort(wr);
        ObjectFormat.print(arg, oport, readable);
        oport.close();
        int len = wr.size();
        if (maxChars < 0 || len <= maxChars) {
            wr.writeTo(dst);
            return true;
        }
        dst.write(wr.toCharArray(), 0, maxChars);
        return false;
    }

    public static int format(Object[] args, int start, Writer dst, int maxChars, boolean readable) throws IOException {
        Object arg;
        if (start >= args.length) {
            arg = "#<missing format argument>";
            --start;
            readable = false;
            maxChars = -1;
        } else {
            arg = args[start];
        }
        ObjectFormat.format(arg, dst, maxChars, readable);
        return start + 1;
    }

    public Object parseObject(String text, ParsePosition status) {
        throw new RuntimeException("ObjectFormat.parseObject - not implemented");
    }
}

