/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.EnclosingMethodAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.InnerClassesAttr;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.SourceDebugExtAttr;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Type;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassType
extends ObjectType
implements AttrContainer,
Externalizable,
Member {
    public static final int JDK_1_1_VERSION = 2949123;
    public static final int JDK_1_2_VERSION = 0x2E0000;
    public static final int JDK_1_3_VERSION = 0x2F0000;
    public static final int JDK_1_4_VERSION = 0x300000;
    public static final int JDK_1_5_VERSION = 0x310000;
    public static final int JDK_1_6_VERSION = 0x320000;
    public static final int JDK_1_7_VERSION = 0x330000;
    int classfileFormatVersion = 2949123;
    int thisClassIndex;
    ClassType superClass;
    int superClassIndex = -1;
    ClassType[] interfaces;
    int[] interfaceIndexes;
    int access_flags;
    Attribute attributes;
    public static final ClassType[] noClasses = new ClassType[0];
    boolean emitDebugInfo = true;
    ConstantPool constants;
    ClassType firstInnerClass;
    ClassType nextInnerClass;
    Member enclosingMember;
    SourceDebugExtAttr sourceDbgExt;
    Field fields;
    int fields_count;
    Field last_field;
    int ConstantValue_name_index;
    int Code_name_index;
    int LocalVariableTable_name_index;
    int LineNumberTable_name_index;
    Method methods;
    int methods_count;
    Method last_method;
    public Method constructor;

    public short getClassfileMajorVersion() {
        return (short)(this.classfileFormatVersion >> 16);
    }

    public short getClassfileMinorVersion() {
        return (short)(this.classfileFormatVersion & 0xFFFF);
    }

    public void setClassfileVersion(int n, int n2) {
        this.classfileFormatVersion = (n & 0xFFFF) * 65536 + n2 * 65535;
    }

    public void setClassfileVersion(int n) {
        this.classfileFormatVersion = n;
    }

    public int getClassfileVersion() {
        return this.classfileFormatVersion;
    }

    public void setClassfileVersionJava5() {
        this.setClassfileVersion(0x310000);
    }

    public static ClassType make(String string) {
        return (ClassType)Type.getType(string);
    }

    public static ClassType make(String string, ClassType classType) {
        ClassType classType2 = ClassType.make(string);
        if (classType2.superClass == null) {
            classType2.setSuper(classType);
        }
        return classType2;
    }

    @Override
    public final Attribute getAttributes() {
        return this.attributes;
    }

    @Override
    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public final ConstantPool getConstants() {
        return this.constants;
    }

    public final CpoolEntry getConstant(int n) {
        if (this.constants == null || this.constants.pool == null || n > this.constants.count) {
            return null;
        }
        return this.constants.pool[n];
    }

    @Override
    public final int getModifiers() {
        if (this.access_flags == 0 && (this.flags & 0x10) != 0 && this.getReflectClass() != null) {
            this.access_flags = this.reflectClass.getModifiers();
        }
        return this.access_flags;
    }

    @Override
    public final boolean getStaticFlag() {
        return (this.getModifiers() & 8) != 0;
    }

    public final void setModifiers(int n) {
        this.access_flags = n;
    }

    public final void addModifiers(int n) {
        this.access_flags |= n;
    }

    public String getSimpleName() {
        int n;
        String string;
        int n2;
        if ((this.flags & 0x10) != 0 && this.getReflectClass() != null) {
            try {
                return this.reflectClass.getSimpleName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((n2 = (string = this.getName()).lastIndexOf(46)) > 0) {
            string = string.substring(n2 + 1);
        }
        if ((n = string.lastIndexOf(36)) >= 0) {
            char c;
            int n3;
            int n4 = string.length();
            for (n3 = n + 1; n3 < n4 && (c = string.charAt(n3)) >= '0' && c <= '9'; ++n3) {
            }
            string = string.substring(n3);
        }
        return string;
    }

    public void addMemberClass(ClassType classType) {
        ClassType classType2 = null;
        ClassType classType3 = this.firstInnerClass;
        while (classType3 != null) {
            if (classType3 == classType) {
                return;
            }
            classType2 = classType3;
            classType3 = classType3.nextInnerClass;
        }
        if (classType2 == null) {
            this.firstInnerClass = classType;
        } else {
            classType2.nextInnerClass = classType;
        }
    }

    public ClassType getDeclaredClass(String string) {
        this.addMemberClasses();
        ClassType classType = this.firstInnerClass;
        while (classType != null) {
            if (string.equals(classType.getSimpleName())) {
                return classType;
            }
            classType = classType.nextInnerClass;
        }
        return null;
    }

    @Override
    public ClassType getDeclaringClass() {
        this.addEnclosingMember();
        if (this.enclosingMember instanceof ClassType) {
            return (ClassType)this.enclosingMember;
        }
        return null;
    }

    public Member getEnclosingMember() {
        this.addEnclosingMember();
        return this.enclosingMember;
    }

    public void setEnclosingMember(Member member) {
        this.enclosingMember = member;
    }

    void addEnclosingMember() {
        if ((this.flags & 0x18) != 16) {
            return;
        }
        Class clazz = this.getReflectClass();
        this.flags |= 8;
        Class<?> clazz2 = clazz.getEnclosingClass();
        if (clazz2 == null) {
            return;
        }
        if (!clazz.isMemberClass()) {
            java.lang.reflect.Method method = clazz.getEnclosingMethod();
            if (method != null) {
                this.enclosingMember = this.addMethod(method);
                return;
            }
            Constructor<?> constructor = clazz.getEnclosingConstructor();
            if (constructor != null) {
                this.enclosingMember = this.addMethod(constructor);
                return;
            }
        }
        this.enclosingMember = (ClassType)Type.make(clazz2);
    }

    public void addMemberClasses() {
        if ((this.flags & 0x14) != 16) {
            return;
        }
        Class clazz = this.getReflectClass();
        this.flags |= 4;
        Class<?>[] classArray = clazz.getClasses();
        int n = classArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ClassType classType = (ClassType)Type.make(classArray[i]);
                this.addMemberClass(classType);
            }
        }
    }

    public final boolean hasOuterLink() {
        this.getFields();
        return (this.flags & 0x20) != 0;
    }

    public ClassType getOuterLinkType() {
        return !this.hasOuterLink() ? null : (ClassType)this.getDeclaredField("this$0").getType();
    }

    public final Field setOuterLink(ClassType classType) {
        if ((this.flags & 0x10) != 0) {
            throw new Error("setOuterLink called for existing class " + this.getName());
        }
        Field field = this.getDeclaredField("this$0");
        if (field == null) {
            field = this.addField("this$0", classType);
            this.flags |= 0x20;
            for (Method method = this.methods; method != null; method = method.getNext()) {
                if (!"<init>".equals(method.getName())) continue;
                if (method.code != null) {
                    throw new Error("setOuterLink called when " + method + " has code");
                }
                Type[] typeArray = method.arg_types;
                Type[] typeArray2 = new Type[typeArray.length + 1];
                System.arraycopy(typeArray, 0, typeArray2, 1, typeArray.length);
                typeArray2[0] = classType;
                method.arg_types = typeArray2;
                method.signature = null;
            }
        } else if (!classType.equals(field.getType())) {
            throw new Error("inconsistent setOuterLink call for " + this.getName());
        }
        return field;
    }

    public boolean isAccessible(Member member, ObjectType objectType) {
        if (member.getStaticFlag()) {
            objectType = null;
        }
        return this.isAccessible(member.getDeclaringClass(), objectType, member.getModifiers());
    }

    public boolean isAccessible(ClassType classType, ObjectType objectType, int n) {
        String string;
        String string2;
        int n2 = classType.getModifiers();
        if ((n & 1) != 0 && (n2 & 1) != 0) {
            return true;
        }
        String string3 = this.getName();
        if (string3.equals(string2 = classType.getName())) {
            return true;
        }
        if ((n & 2) != 0) {
            return false;
        }
        int n3 = string3.lastIndexOf(46);
        String string4 = n3 >= 0 ? string3.substring(0, n3) : "";
        n3 = string2.lastIndexOf(46);
        String string5 = string = n3 >= 0 ? string2.substring(0, n3) : "";
        if (string4.equals(string)) {
            return true;
        }
        if ((n2 & 1) == 0) {
            return false;
        }
        return (n & 4) != 0 && this.isSubclass(classType) && (!(objectType instanceof ClassType) || ((ClassType)objectType).isSubclass(this));
    }

    @Override
    public void setName(String string) {
        this.this_name = string;
        this.setSignature("L" + string.replace('.', '/') + ";");
    }

    public void setStratum(String string) {
        if (this.sourceDbgExt == null) {
            this.sourceDbgExt = new SourceDebugExtAttr(this);
        }
        this.sourceDbgExt.addStratum(string);
    }

    public void setSourceFile(String string) {
        int n;
        if (this.sourceDbgExt != null) {
            this.sourceDbgExt.addFile(string);
            if (this.sourceDbgExt.fileCount > 1) {
                return;
            }
        }
        if ((n = (string = SourceFileAttr.fixSourceFile(string)).lastIndexOf(47)) >= 0) {
            string = string.substring(n + 1);
        }
        SourceFileAttr.setSourceFile(this, string);
    }

    public void setSuper(String string) {
        this.setSuper(string == null ? Type.pointer_type : ClassType.make(string));
    }

    public void setSuper(ClassType classType) {
        this.superClass = classType;
    }

    public ClassType getSuperclass() {
        if (this.superClass == null && !this.isInterface() && !"java.lang.Object".equals(this.getName()) && (this.flags & 0x10) != 0 && this.getReflectClass() != null) {
            this.superClass = (ClassType)ClassType.make(this.reflectClass.getSuperclass());
        }
        return this.superClass;
    }

    public String getPackageName() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? "" : string.substring(0, n);
    }

    public synchronized ClassType[] getInterfaces() {
        if (this.interfaces == null && (this.flags & 0x10) != 0 && this.getReflectClass() != null) {
            Class<?>[] classArray = this.reflectClass.getInterfaces();
            int n = classArray.length;
            this.interfaces = n == 0 ? noClasses : new ClassType[n];
            for (int i = 0; i < n; ++i) {
                this.interfaces[i] = (ClassType)Type.make(classArray[i]);
            }
        }
        return this.interfaces;
    }

    public void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public void addInterface(ClassType classType) {
        int n;
        if (this.interfaces == null || this.interfaces.length == 0) {
            n = 0;
            this.interfaces = new ClassType[1];
        } else {
            int n2 = n = this.interfaces.length;
            while (--n2 >= 0) {
                if (this.interfaces[n2] != classType) continue;
                return;
            }
            ClassType[] classTypeArray = new ClassType[n + 1];
            System.arraycopy(this.interfaces, 0, classTypeArray, 0, n);
            this.interfaces = classTypeArray;
        }
        this.interfaces[n] = classType;
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final void setInterface(boolean bl) {
        this.access_flags = bl ? (this.access_flags |= 0x600) : (this.access_flags &= 0xFFFFFDFF);
    }

    public ClassType() {
    }

    public ClassType(String string) {
        this.setName(string);
    }

    public final synchronized Field getFields() {
        if ((this.flags & 0x11) == 16) {
            this.addFields();
        }
        return this.fields;
    }

    public final int getFieldCount() {
        return this.fields_count;
    }

    public Field getDeclaredField(String string) {
        Field field = this.getFields();
        while (field != null) {
            if (string.equals(field.name)) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    @Override
    public Field getField(String string, int n) {
        ClassType classType = this;
        do {
            Field field;
            if ((field = classType.getDeclaredField(string)) != null && (n == -1 || (field.getModifiers() & n) != 0)) {
                return field;
            }
            ClassType[] classTypeArray = classType.getInterfaces();
            if (classTypeArray == null) continue;
            for (int i = 0; i < classTypeArray.length; ++i) {
                field = classTypeArray[i].getField(string, n);
                if (field == null) continue;
                return field;
            }
        } while ((classType = classType.getSuperclass()) != null);
        return null;
    }

    public Field getField(String string) {
        return this.getField(string, 1);
    }

    public Field addField() {
        return new Field(this);
    }

    public Field addField(String string) {
        Field field = new Field(this);
        field.setName(string);
        return field;
    }

    public final Field addField(String string, Type type) {
        Field field = new Field(this);
        field.setName(string);
        field.setType(type);
        return field;
    }

    public final Field addField(String string, Type type, int n) {
        Field field = this.addField(string, type);
        field.flags = n;
        return field;
    }

    public void addFields() {
        java.lang.reflect.Field[] fieldArray;
        Class clazz = this.getReflectClass();
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            fieldArray = clazz.getFields();
        }
        for (java.lang.reflect.Field field : fieldArray) {
            if ("this$0".equals(field.getName())) {
                this.flags |= 0x20;
            }
            this.addField(field.getName(), Type.make(field.getType()), field.getModifiers());
        }
        this.flags |= 1;
    }

    public final Method getMethods() {
        return this.methods;
    }

    public final int getMethodCount() {
        return this.methods_count;
    }

    Method addMethod() {
        return new Method(this, 0);
    }

    public Method addMethod(String string) {
        return this.addMethod(string, 0);
    }

    public Method addMethod(String string, int n) {
        Method method = new Method(this, n);
        method.setName(string);
        return method;
    }

    public Method addMethod(String string, Type[] typeArray, Type type, int n) {
        return this.addMethod(string, n, typeArray, type);
    }

    public Method addMethod(String string, int n, Type[] typeArray, Type type) {
        Method method = this.getDeclaredMethod(string, typeArray);
        if (method != null && type.equals(method.getReturnType()) && (n & method.access_flags) == n) {
            return method;
        }
        method = this.addMethod(string, n);
        method.arg_types = typeArray;
        method.return_type = type;
        return method;
    }

    public Method addMethod(java.lang.reflect.Method method) {
        int n = method.getModifiers();
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        Type[] typeArray = new Type[n2];
        while (--n2 >= 0) {
            typeArray[n2] = Type.make(classArray[n2]);
        }
        Type type = Type.make(method.getReturnType());
        return this.addMethod(method.getName(), n, typeArray, type);
    }

    public Method addMethod(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = constructor.getModifiers();
        int n2 = classArray.length;
        Type[] typeArray = new Type[n2];
        while (--n2 >= 0) {
            typeArray[n2] = Type.make(classArray[n2]);
        }
        return this.addMethod("<init>", n, typeArray, Type.voidType);
    }

    public Method addMethod(String string, String string2, int n) {
        Method method = this.addMethod(string, n);
        method.setSignature(string2);
        return method;
    }

    public Method getMethod(java.lang.reflect.Method method) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        Type[] typeArray = new Type[classArray.length];
        int n = classArray.length;
        while (--n >= 0) {
            typeArray[n] = Type.make(classArray[n]);
        }
        return this.addMethod(string, method.getModifiers(), typeArray, Type.make(method.getReturnType()));
    }

    public final synchronized Method getDeclaredMethods() {
        if ((this.flags & 0x12) == 16) {
            this.addMethods(this.getReflectClass());
        }
        return this.methods;
    }

    public final int countMethods(Filter filter, int n) {
        Vector<Method> vector = new Vector<Method>();
        this.getMethods(filter, n, vector);
        return vector.size();
    }

    public Method[] getMethods(Filter filter, boolean bl) {
        return this.getMethods(filter, bl ? 1 : 0);
    }

    public Method[] getMethods(Filter filter, int n) {
        Vector<Method> vector = new Vector<Method>();
        this.getMethods(filter, n, vector);
        int n2 = vector.size();
        Method[] methodArray = new Method[n2];
        for (int i = 0; i < n2; ++i) {
            methodArray[i] = vector.elementAt(i);
        }
        return methodArray;
    }

    public int getMethods(Filter filter, int n, Method[] methodArray, int n2) {
        Vector<Method> vector = new Vector<Method>();
        this.getMethods(filter, n, vector);
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            methodArray[n2 + i] = vector.elementAt(i);
        }
        return n3;
    }

    @Override
    public int getMethods(Filter filter, int n, List<Method> list) {
        int n2 = 0;
        String string = null;
        for (ClassType classType = this; classType != null; classType = classType.getSuperclass()) {
            int n3;
            ClassType[] classTypeArray;
            String string2 = classType.getPackageName();
            for (classTypeArray = classType.getDeclaredMethods(); classTypeArray != null; classTypeArray = classTypeArray.getNext()) {
                if (classType != this && (((n3 = classTypeArray.getModifiers()) & 2) != 0 || (n3 & 5) == 0 && !string2.equals(string)) || !filter.select(classTypeArray)) continue;
                if (list != null) {
                    list.add((Method)classTypeArray);
                }
                ++n2;
            }
            string = string2;
            if (n == 0) break;
            if (n <= 1 || (classTypeArray = classType.getInterfaces()) == null) continue;
            for (n3 = 0; n3 < classTypeArray.length; ++n3) {
                n2 += classTypeArray[n3].getMethods(filter, n, list);
            }
        }
        return n2;
    }

    public Method getDeclaredMethod(String string, Type[] typeArray) {
        int n = "<init>".equals(string) && this.hasOuterLink() ? 1 : 0;
        Method method = this.getDeclaredMethods();
        while (method != null) {
            if (string.equals(method.getName())) {
                Type[] typeArray2 = method.getParameterTypes();
                if (typeArray == null || typeArray == typeArray2 && n == 0) {
                    return method;
                }
                int n2 = typeArray.length;
                if (n2 == typeArray2.length - n) {
                    String string2;
                    String string3;
                    Type type;
                    Type type2;
                    while (--n2 >= 0 && ((type2 = typeArray2[n2 + n]) == (type = typeArray[n2]) || type == null || (string3 = type2.getSignature()).equals(string2 = type.getSignature()))) {
                    }
                    if (n2 < 0) {
                        return method;
                    }
                }
            }
            method = method.next;
        }
        return null;
    }

    public Method getDeclaredMethod(String string, int n) {
        Method method = null;
        int n2 = "<init>".equals(string) && this.hasOuterLink() ? 1 : 0;
        Method method2 = this.getDeclaredMethods();
        while (method2 != null) {
            if (string.equals(method2.getName()) && n + n2 == method2.getParameterTypes().length) {
                if (method != null) {
                    throw new Error("ambiguous call to getDeclaredMethod(\"" + string + "\", " + n + ")\n - " + method + "\n - " + method2);
                }
                method = method2;
            }
            method2 = method2.next;
        }
        return method;
    }

    @Override
    public Method getMethod(String string, Type[] typeArray) {
        ClassType[] classTypeArray;
        ClassType classType = this;
        do {
            if ((classTypeArray = classType.getDeclaredMethod(string, typeArray)) == null) continue;
            return classTypeArray;
        } while ((classType = classType.getSuperclass()) != null);
        classType = this;
        do {
            if ((classTypeArray = classType.getInterfaces()) == null) continue;
            for (int i = 0; i < classTypeArray.length; ++i) {
                Method method = classTypeArray[i].getDeclaredMethod(string, typeArray);
                if (method == null) continue;
                return method;
            }
        } while ((classType = classType.getSuperclass()) != null);
        return null;
    }

    public void addMethods(Class clazz) {
        Constructor<?>[] constructorArray;
        java.lang.reflect.Method[] methodArray;
        this.flags |= 2;
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (SecurityException securityException) {
            methodArray = clazz.getMethods();
        }
        for (java.lang.reflect.Method method : methodArray) {
            if (!method.getDeclaringClass().equals(clazz)) continue;
            this.addMethod(method);
        }
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (SecurityException securityException) {
            constructorArray = clazz.getConstructors();
        }
        for (Constructor<?> constructor : constructorArray) {
            if (!constructor.getDeclaringClass().equals(clazz)) continue;
            this.addMethod(constructor);
        }
    }

    public Method[] getMatchingMethods(String string, Type[] typeArray, int n) {
        Object object2;
        int n2 = 0;
        Vector<Object[]> vector = new Vector<Object[]>(10);
        for (object2 = this.methods; object2 != null; object2 = object2.getNext()) {
            Type[] typeArray2;
            if (!string.equals(object2.getName()) || (n & 8) != (object2.access_flags & 8) || (n & 1) > (object2.access_flags & 1) || (typeArray2 = object2.arg_types).length != typeArray.length) continue;
            ++n2;
            vector.addElement((Object[])object2);
        }
        object2 = new Method[n2];
        vector.copyInto((Object[])object2);
        return object2;
    }

    public void doFixups() {
        int n;
        if (this.constants == null) {
            this.constants = new ConstantPool();
        }
        if (this.thisClassIndex == 0) {
            this.thisClassIndex = this.constants.addClass((ObjectType)this).index;
        }
        if (this.superClass == this) {
            this.setSuper((ClassType)null);
        }
        if (this.superClassIndex < 0) {
            int n2 = this.superClassIndex = this.superClass == null ? 0 : this.constants.addClass((ObjectType)this.superClass).index;
        }
        if (this.interfaces != null && this.interfaceIndexes == null) {
            int n3 = this.interfaces.length;
            this.interfaceIndexes = new int[n3];
            for (n = 0; n < n3; ++n) {
                this.interfaceIndexes[n] = this.constants.addClass((ObjectType)this.interfaces[n]).index;
            }
        }
        Object object2 = this.fields;
        while (object2 != null) {
            ((Field)object2).assign_constants(this);
            object2 = ((Field)object2).next;
        }
        object2 = this.methods;
        while (object2 != null) {
            ((Method)object2).assignConstants();
            object2 = ((Method)object2).next;
        }
        if (this.enclosingMember instanceof Method) {
            object2 = EnclosingMethodAttr.getFirstEnclosingMethod(this.getAttributes());
            if (object2 == null) {
                object2 = new EnclosingMethodAttr(this);
            }
            ((EnclosingMethodAttr)object2).method = (Method)this.enclosingMember;
        } else if (this.enclosingMember instanceof ClassType) {
            this.constants.addClass((ClassType)this.enclosingMember);
        }
        object2 = this.firstInnerClass;
        while (object2 != null) {
            this.constants.addClass((ObjectType)object2);
            object2 = ((ClassType)object2).nextInnerClass;
        }
        object2 = InnerClassesAttr.getFirstInnerClasses(this.getAttributes());
        if (object2 != null) {
            ((Attribute)object2).setSkipped(true);
        }
        Attribute.assignConstants(this, this);
        for (n = 1; n <= this.constants.count; ++n) {
            ClassType classType;
            CpoolEntry cpoolEntry = this.constants.pool[n];
            if (!(cpoolEntry instanceof CpoolClass)) continue;
            CpoolClass cpoolClass = (CpoolClass)cpoolEntry;
            if (!(cpoolClass.clas instanceof ClassType) || (classType = (ClassType)cpoolClass.clas).getEnclosingMember() == null) continue;
            if (object2 == null) {
                object2 = new InnerClassesAttr(this);
            }
            ((InnerClassesAttr)object2).addClass(cpoolClass, this);
        }
        if (object2 != null) {
            ((Attribute)object2).setSkipped(false);
            ((InnerClassesAttr)object2).assignConstants(this);
        }
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.doFixups();
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.getClassfileMinorVersion());
        dataOutputStream.writeShort(this.getClassfileMajorVersion());
        if (this.constants == null) {
            dataOutputStream.writeShort(1);
        } else {
            this.constants.write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.thisClassIndex);
        dataOutputStream.writeShort(this.superClassIndex);
        if (this.interfaceIndexes == null) {
            dataOutputStream.writeShort(0);
        } else {
            int n = this.interfaceIndexes.length;
            dataOutputStream.writeShort(n);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeShort(this.interfaceIndexes[i]);
            }
        }
        dataOutputStream.writeShort(this.fields_count);
        Member member = this.fields;
        while (member != null) {
            ((Field)member).write(dataOutputStream, this);
            member = ((Field)member).next;
        }
        dataOutputStream.writeShort(this.methods_count);
        member = this.methods;
        while (member != null) {
            ((Method)member).write(dataOutputStream, this);
            member = ((Method)member).next;
        }
        Attribute.writeAll(this, dataOutputStream);
        this.flags |= 3;
    }

    public void writeToFile(String string) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        this.writeToStream(bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
    }

    public void writeToFile() throws IOException {
        this.writeToFile(this.this_name.replace('.', File.separatorChar) + ".class");
    }

    public byte[] writeToArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
        try {
            this.writeToStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] to_utf8(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n > 0 && n <= 127) {
                ++n3;
                continue;
            }
            if (n <= 2047) {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        byte[] byArray = new byte[n3];
        n = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                byArray[n++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | c >> 12 & 0xF);
            byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return byArray;
    }

    public final boolean implementsInterface(ClassType classType) {
        if (this == classType) {
            return true;
        }
        ClassType classType2 = this.getSuperclass();
        if (classType2 != null && classType2.implementsInterface(classType)) {
            return true;
        }
        ClassType[] classTypeArray = this.getInterfaces();
        if (classTypeArray != null) {
            int n = classTypeArray.length;
            while (--n >= 0) {
                if (!classTypeArray[n].implementsInterface(classType)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isSubclass(String string) {
        ClassType classType = this;
        do {
            if (!string.equals(classType.getName())) continue;
            return true;
        } while ((classType = classType.getSuperclass()) != null);
        return false;
    }

    public final boolean isSubclass(ClassType classType) {
        if (classType.isInterface()) {
            return this.implementsInterface(classType);
        }
        if (this == toStringType && classType == javalangStringType || this == javalangStringType && classType == toStringType) {
            return true;
        }
        for (ClassType classType2 = this; classType2 != null; classType2 = classType2.getSuperclass()) {
            if (classType2 != classType) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(Type type) {
        if (type == nullType) {
            return 1;
        }
        if (!(type instanceof ClassType)) {
            return ClassType.swappedCompareResult(type.compare(this));
        }
        String string = this.getName();
        if (string != null && string.equals(type.getName())) {
            return 0;
        }
        ClassType classType = (ClassType)type;
        if (this.isSubclass(classType)) {
            return -1;
        }
        if (classType.isSubclass(this)) {
            return 1;
        }
        if (this == toStringType) {
            return classType == Type.pointer_type ? -1 : 1;
        }
        if (classType == toStringType) {
            return this == Type.pointer_type ? 1 : -1;
        }
        if (this.isInterface() || classType.isInterface()) {
            return -2;
        }
        return -3;
    }

    @Override
    public String toString() {
        return "ClassType " + this.getName();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.getName());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName(objectInput.readUTF());
        this.flags |= 0x10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readResolve() throws ObjectStreamException {
        HashMap hashMap;
        String string = this.getName();
        HashMap hashMap2 = hashMap = mapNameToType;
        synchronized (hashMap2) {
            Type type = (Type)hashMap.get(string);
            if (type != null) {
                return type;
            }
            hashMap.put(string, this);
        }
        return this;
    }

    public void cleanupAfterCompilation() {
        for (Method method = this.methods; method != null; method = method.getNext()) {
            method.cleanupAfterCompilation();
        }
        this.constants = null;
        this.attributes = null;
        this.sourceDbgExt = null;
    }
}

