/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.Duration;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.Unit;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTime
extends Quantity
implements Cloneable {
    Unit unit = Unit.date;
    int nanoSeconds;
    GregorianCalendar calendar;
    int mask;
    static final int YEAR_COMPONENT = 1;
    static final int MONTH_COMPONENT = 2;
    static final int DAY_COMPONENT = 3;
    static final int HOURS_COMPONENT = 4;
    static final int MINUTES_COMPONENT = 5;
    static final int SECONDS_COMPONENT = 6;
    static final int TIMEZONE_COMPONENT = 7;
    public static final int YEAR_MASK = 2;
    public static final int MONTH_MASK = 4;
    public static final int DAY_MASK = 8;
    public static final int HOURS_MASK = 16;
    public static final int MINUTES_MASK = 32;
    public static final int SECONDS_MASK = 64;
    public static final int TIMEZONE_MASK = 128;
    public static final int DATE_MASK = 14;
    public static final int TIME_MASK = 112;
    private static final Date minDate = new Date(Long.MIN_VALUE);
    public static TimeZone GMT = TimeZone.getTimeZone("GMT");

    public int components() {
        return this.mask & 0xFFFFFF7F;
    }

    public DateTime cast(int n) {
        int n2 = this.mask & 0xFFFFFF7F;
        if (n == n2) {
            return this;
        }
        DateTime dateTime = new DateTime(n, (GregorianCalendar)this.calendar.clone());
        if ((n & ~n2) != 0 && (n2 != 14 || n != 126)) {
            throw new ClassCastException("cannot cast DateTime - missing conponents");
        }
        dateTime.mask = this.isZoneUnspecified() ? (dateTime.mask &= 0xFFFFFF7F) : (dateTime.mask |= 0x80);
        int n3 = n2 & ~n;
        if ((n3 & 0x70) != 0) {
            dateTime.calendar.clear(11);
            dateTime.calendar.clear(12);
            dateTime.calendar.clear(13);
        } else {
            dateTime.nanoSeconds = this.nanoSeconds;
        }
        if ((n3 & 2) != 0) {
            dateTime.calendar.clear(1);
            dateTime.calendar.clear(0);
        }
        if ((n3 & 4) != 0) {
            dateTime.calendar.clear(2);
        }
        if ((n3 & 8) != 0) {
            dateTime.calendar.clear(5);
        }
        return dateTime;
    }

    public DateTime(int n) {
        this.calendar = new GregorianCalendar();
        this.calendar.setGregorianChange(minDate);
        this.calendar.clear();
        this.mask = n;
    }

    public DateTime(int n, GregorianCalendar gregorianCalendar) {
        this.calendar = gregorianCalendar;
        this.mask = n;
    }

    public static DateTime parse(String string, int n) {
        boolean bl;
        DateTime dateTime = new DateTime(n);
        string = string.trim();
        int n2 = string.length();
        int n3 = 0;
        boolean bl2 = (n & 0xE) != 0;
        boolean bl3 = bl = (n & 0x70) != 0;
        if (bl2) {
            n3 = dateTime.parseDate(string, n3, n);
            if (bl) {
                n3 = n3 < 0 || n3 >= n2 || string.charAt(n3) != 'T' ? -1 : ++n3;
            }
        }
        if (bl) {
            n3 = dateTime.parseTime(string, n3);
        }
        if ((n3 = dateTime.parseZone(string, n3)) != n2) {
            throw new NumberFormatException("Unrecognized date/time '" + string + '\'');
        }
        return dateTime;
    }

    int parseDate(String string, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n < 0) {
            return n;
        }
        int n7 = string.length();
        boolean bl = false;
        if (n < n7 && string.charAt(n) == '-') {
            ++n;
            bl = true;
        }
        int n8 = n;
        if ((n2 & 2) == 0) {
            if (!bl) {
                return -1;
            }
            n6 = -1;
        } else {
            n5 = DateTime.parseDigits(string, n8);
            n6 = n5 >> 16;
            n8 = n5 & 0xFFFF;
            if (n8 != n + 4 && (n8 <= n + 4 || string.charAt(n) == '0')) {
                return -1;
            }
            if (bl || n6 == 0) {
                this.calendar.set(0, 0);
                this.calendar.set(1, n6 + 1);
            } else {
                this.calendar.set(1, n6);
            }
        }
        if ((n2 & 0xC) == 0) {
            return n8;
        }
        if (n8 >= n7 || string.charAt(n8) != '-') {
            return -1;
        }
        n = ++n8;
        if ((n2 & 4) != 0) {
            n5 = DateTime.parseDigits(string, n);
            n4 = n5 >> 16;
            n8 = n5 & 0xFFFF;
            if (n4 <= 0 || n4 > 12 || n8 != n + 2) {
                return -1;
            }
            this.calendar.set(2, n4 - 1);
            if ((n2 & 8) == 0) {
                return n8;
            }
        } else {
            n4 = -1;
        }
        if (n8 >= n7 || string.charAt(n8) != '-') {
            return -1;
        }
        n = n8 + 1;
        n5 = DateTime.parseDigits(string, n);
        int n9 = n5 >> 16;
        n8 = n5 & 0xFFFF;
        if (n9 > 0 && n8 == n + 2 && n9 <= (n3 = (n2 & 4) == 0 ? 31 : DateTime.daysInMonth(n4 - 1, (n2 & 2) != 0 ? n6 : 2000))) {
            this.calendar.set(5, n9);
            return n8;
        }
        return -1;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static int daysInMonth(int n, int n2) {
        switch (n) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return DateTime.isLeapYear(n2) ? 29 : 28;
            }
        }
        return 31;
    }

    int parseZone(String string, int n) {
        if (n < 0) {
            return n;
        }
        int n2 = this.parseZoneMinutes(string, n);
        if (n2 == 0) {
            return -1;
        }
        if (n2 == n) {
            return n;
        }
        int n3 = n2 >> 16;
        int n4 = n2 & 0xFFFF;
        TimeZone timeZone = n3 == 0 ? GMT : TimeZone.getTimeZone("GMT" + string.substring(n, n4));
        this.calendar.setTimeZone(timeZone);
        this.mask |= 0x80;
        return n4;
    }

    int parseZoneMinutes(String string, int n) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n == n4 || n < 0) {
            return n;
        }
        char c = string.charAt(n);
        if (c == 'Z') {
            return n + 1;
        }
        if (c != '+' && c != '-') {
            return n;
        }
        if ((n3 = (n2 = DateTime.parseDigits(string, ++n)) >> 16) > 14) {
            return 0;
        }
        int n5 = 60 * n3;
        int n6 = n2 & 0xFFFF;
        if (n6 != n + 2) {
            return 0;
        }
        if (n6 < n4) {
            if (string.charAt(n6) == ':') {
                n = n6 + 1;
                n2 = DateTime.parseDigits(string, n);
                n6 = n2 & 0xFFFF;
                if ((n2 >>= 16) > 0 && (n2 >= 60 || n3 == 14)) {
                    return 0;
                }
                n5 += n2;
                if (n6 != n + 2) {
                    return 0;
                }
            }
        } else {
            return 0;
        }
        if (n5 > 840) {
            return 0;
        }
        if (c == '-') {
            n5 = -n5;
        }
        return n5 << 16 | n6;
    }

    int parseTime(String string, int n) {
        if (n < 0) {
            return n;
        }
        int n2 = string.length();
        int n3 = n;
        int n4 = DateTime.parseDigits(string, n);
        int n5 = n4 >> 16;
        n3 = n4 & 0xFFFF;
        if (n5 <= 24 && n3 == n + 2 && n3 != n2 && string.charAt(n3) == ':') {
            n = n3 + 1;
            n4 = DateTime.parseDigits(string, n);
            int n6 = n4 >> 16;
            n3 = n4 & 0xFFFF;
            if (n6 < 60 && n3 == n + 2 && n3 != n2 && string.charAt(n3) == ':') {
                n = n3 + 1;
                n4 = DateTime.parseDigits(string, n);
                int n7 = n4 >> 16;
                n3 = n4 & 0xFFFF;
                if (n7 < 60 && n3 == n + 2) {
                    if (n3 + 1 < n2 && string.charAt(n3) == '.' && Character.digit(string.charAt(n3 + 1), 10) >= 0) {
                        int n8;
                        int n9 = 0;
                        int n10 = 0;
                        for (n3 = n = n3 + 1; n3 < n2 && (n8 = Character.digit(string.charAt(n3), 10)) >= 0; ++n3) {
                            if (n10 < 9) {
                                n9 = 10 * n9 + n8;
                            } else if (n10 == 9 && n8 >= 5) {
                                ++n9;
                            }
                            ++n10;
                        }
                        while (n10++ < 9) {
                            n9 = 10 * n9;
                        }
                        this.nanoSeconds = n9;
                    }
                    if (n5 == 24 && (n6 != 0 || n7 != 0 || this.nanoSeconds != 0)) {
                        return -1;
                    }
                    this.calendar.set(11, n5);
                    this.calendar.set(12, n6);
                    this.calendar.set(13, n7);
                    return n3;
                }
            }
        }
        return -1;
    }

    private static int parseDigits(String string, int n) {
        char c;
        int n2;
        int n3;
        int n4 = -1;
        int n5 = string.length();
        for (n3 = n; n3 < n5 && (n2 = Character.digit(c = string.charAt(n3), 10)) >= 0; ++n3) {
            if (n4 > 20000) {
                return 0;
            }
            n4 = n4 < 0 ? n2 : 10 * n4 + n2;
        }
        return n4 < 0 ? n3 : n4 << 16 | n3;
    }

    public int getYear() {
        int n = this.calendar.get(1);
        if (this.calendar.get(0) == 0) {
            n = 1 - n;
        }
        return n;
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getHours() {
        return this.calendar.get(11);
    }

    public int getMinutes() {
        return this.calendar.get(12);
    }

    public int getSecondsOnly() {
        return this.calendar.get(13);
    }

    public int getWholeSeconds() {
        return this.calendar.get(13);
    }

    public int getNanoSecondsOnly() {
        return this.nanoSeconds;
    }

    public static int compare(DateTime dateTime, DateTime dateTime2) {
        long l = dateTime.calendar.getTimeInMillis();
        long l2 = dateTime2.calendar.getTimeInMillis();
        if (((dateTime.mask | dateTime2.mask) & 0xE) == 0) {
            if (l < 0L) {
                l += 86400000L;
            }
            if (l2 < 0L) {
                l2 += 86400000L;
            }
        }
        int n = dateTime.nanoSeconds;
        int n2 = dateTime2.nanoSeconds;
        l += (long)(n / 1000000);
        l2 += (long)(n2 / 1000000);
        return l < l2 ? -1 : (l > l2 ? 1 : (n < n2 ? -1 : ((n %= 1000000) > (n2 %= 1000000) ? 1 : 0)));
    }

    public int compare(Object object2) {
        if (object2 instanceof DateTime) {
            return DateTime.compare(this, (DateTime)object2);
        }
        return ((Numeric)object2).compareReversed(this);
    }

    public static Duration sub(DateTime dateTime, DateTime dateTime2) {
        long l = dateTime.calendar.getTimeInMillis();
        long l2 = dateTime2.calendar.getTimeInMillis();
        int n = dateTime.nanoSeconds;
        int n2 = dateTime2.nanoSeconds;
        l += (long)(n / 1000000);
        l2 += (long)(n2 / 1000000);
        n %= 1000000;
        long l3 = l - l2;
        long l4 = l3 / 1000L;
        int n3 = (int)(l3 % 1000L * 1000000L + (long)(n2 %= 1000000) - (long)n2);
        l4 += (long)(n3 / 1000000000);
        return Duration.make(0, l4, n3 %= 1000000000, Unit.second);
    }

    public DateTime withZoneUnspecified() {
        if (this.isZoneUnspecified()) {
            return this;
        }
        DateTime dateTime = new DateTime(this.mask, (GregorianCalendar)this.calendar.clone());
        dateTime.calendar.setTimeZone(TimeZone.getDefault());
        dateTime.mask &= 0xFFFFFF7F;
        return dateTime;
    }

    public DateTime adjustTimezone(int n) {
        TimeZone timeZone;
        DateTime dateTime = new DateTime(this.mask, (GregorianCalendar)this.calendar.clone());
        if (n == 0) {
            timeZone = GMT;
        } else {
            StringBuffer stringBuffer = new StringBuffer("GMT");
            DateTime.toStringZone(n, stringBuffer);
            timeZone = TimeZone.getTimeZone(stringBuffer.toString());
        }
        dateTime.calendar.setTimeZone(timeZone);
        if ((dateTime.mask & 0x80) != 0) {
            long l = this.calendar.getTimeInMillis();
            dateTime.calendar.setTimeInMillis(l);
            if ((this.mask & 0x70) == 0) {
                dateTime.calendar.set(11, 0);
                dateTime.calendar.set(12, 0);
                dateTime.calendar.set(13, 0);
                dateTime.nanoSeconds = 0;
            }
        } else {
            dateTime.mask |= 0x80;
        }
        return dateTime;
    }

    public static DateTime add(DateTime dateTime, Duration duration, int n) {
        long l;
        if (duration.unit == Unit.duration || duration.unit == Unit.month && (dateTime.mask & 0xE) != 14) {
            throw new IllegalArgumentException("invalid date/time +/- duration combinatuion");
        }
        DateTime dateTime2 = new DateTime(dateTime.mask, (GregorianCalendar)dateTime.calendar.clone());
        if (duration.months != 0) {
            int n2;
            int n3;
            int n4 = 12 * dateTime2.getYear() + dateTime2.calendar.get(2);
            int n5 = dateTime2.calendar.get(5);
            if ((n4 += n * duration.months) >= 12) {
                n3 = n4 / 12;
                dateTime2.calendar.set(0, 1);
                n2 = DateTime.daysInMonth(n4 %= 12, n3);
            } else {
                n4 = 11 - n4;
                dateTime2.calendar.set(0, 0);
                n3 = n4 / 12 + 1;
                n4 = 11 - n4 % 12;
                n2 = DateTime.daysInMonth(n4, 1);
            }
            if (n5 > n2) {
                n5 = n2;
            }
            dateTime2.calendar.set(n3, n4, n5);
        }
        if ((l = (long)dateTime.nanoSeconds + (long)n * (duration.seconds * 1000000000L + (long)duration.nanos)) != 0L) {
            if ((dateTime.mask & 0x70) == 0) {
                long l2 = 86400000000000L;
                long l3 = l % l2;
                if (l3 < 0L) {
                    l3 += l2;
                }
                l -= l3;
            }
            long l4 = dateTime2.calendar.getTimeInMillis();
            dateTime2.calendar.setTimeInMillis(l4 += l / 1000000000L * 1000L);
            dateTime2.nanoSeconds = (int)(l % 1000000000L);
        }
        return dateTime2;
    }

    public static DateTime addMinutes(DateTime dateTime, int n) {
        return DateTime.addSeconds(dateTime, 60 * n);
    }

    public static DateTime addSeconds(DateTime dateTime, int n) {
        DateTime dateTime2 = new DateTime(dateTime.mask, (GregorianCalendar)dateTime.calendar.clone());
        long l = (long)n * 1000000000L;
        if (l != 0L) {
            l = (long)dateTime.nanoSeconds + l;
            long l2 = dateTime.calendar.getTimeInMillis();
            dateTime2.calendar.setTimeInMillis(l2 += l / 1000000L);
            dateTime2.nanoSeconds = (int)(l % 1000000L);
        }
        return dateTime2;
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof Duration) {
            return DateTime.add(this, (Duration)object2, n);
        }
        if (object2 instanceof DateTime && n == -1) {
            return DateTime.sub(this, (DateTime)object2);
        }
        throw new IllegalArgumentException();
    }

    public Numeric addReversed(Numeric numeric, int n) {
        if (numeric instanceof Duration && n == 1) {
            return DateTime.add(this, (Duration)numeric, n);
        }
        throw new IllegalArgumentException();
    }

    private static void append(int n, StringBuffer stringBuffer, int n2) {
        int n3 = stringBuffer.length();
        stringBuffer.append(n);
        int n4 = n3 + n2 - stringBuffer.length();
        while (--n4 >= 0) {
            stringBuffer.insert(n3, '0');
        }
    }

    public void toStringDate(StringBuffer stringBuffer) {
        int n = this.components();
        if ((n & 2) != 0) {
            int n2 = this.calendar.get(1);
            if (this.calendar.get(0) == 0 && --n2 != 0) {
                stringBuffer.append('-');
            }
            DateTime.append(n2, stringBuffer, 4);
        } else {
            stringBuffer.append('-');
        }
        if ((n & 0xC) != 0) {
            stringBuffer.append('-');
            if ((n & 4) != 0) {
                DateTime.append(this.getMonth(), stringBuffer, 2);
            }
            if ((n & 8) != 0) {
                stringBuffer.append('-');
                DateTime.append(this.getDay(), stringBuffer, 2);
            }
        }
    }

    public void toStringTime(StringBuffer stringBuffer) {
        DateTime.append(this.getHours(), stringBuffer, 2);
        stringBuffer.append(':');
        DateTime.append(this.getMinutes(), stringBuffer, 2);
        stringBuffer.append(':');
        DateTime.append(this.getWholeSeconds(), stringBuffer, 2);
        Duration.appendNanoSeconds(this.nanoSeconds, stringBuffer);
    }

    public boolean isZoneUnspecified() {
        return (this.mask & 0x80) == 0;
    }

    public int getZoneMinutes() {
        return this.calendar.getTimeZone().getRawOffset() / 60000;
    }

    public static TimeZone minutesToTimeZone(int n) {
        if (n == 0) {
            return GMT;
        }
        StringBuffer stringBuffer = new StringBuffer("GMT");
        DateTime.toStringZone(n, stringBuffer);
        return TimeZone.getTimeZone(stringBuffer.toString());
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }

    public void toStringZone(StringBuffer stringBuffer) {
        if (this.isZoneUnspecified()) {
            return;
        }
        DateTime.toStringZone(this.getZoneMinutes(), stringBuffer);
    }

    public static void toStringZone(int n, StringBuffer stringBuffer) {
        if (n == 0) {
            stringBuffer.append('Z');
        } else {
            if (n < 0) {
                stringBuffer.append('-');
                n = -n;
            } else {
                stringBuffer.append('+');
            }
            DateTime.append(n / 60, stringBuffer, 2);
            stringBuffer.append(':');
            DateTime.append(n % 60, stringBuffer, 2);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        boolean bl;
        int n = this.components();
        boolean bl2 = (n & 0xE) != 0;
        boolean bl3 = bl = (n & 0x70) != 0;
        if (bl2) {
            this.toStringDate(stringBuffer);
            if (bl) {
                stringBuffer.append('T');
            }
        }
        if (bl) {
            this.toStringTime(stringBuffer);
        }
        this.toStringZone(stringBuffer);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean isExact() {
        return (this.mask & 0x70) == 0;
    }

    public boolean isZero() {
        throw new Error("DateTime.isZero not meaningful!");
    }

    public Unit unit() {
        return this.unit;
    }

    public Complex number() {
        throw new Error("number needs to be implemented!");
    }
}

