/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.io.Path;
import gnu.kawa.models.Display;
import gnu.kawa.models.Model;
import gnu.kawa.models.Paintable;
import gnu.kawa.models.WithTransform;
import gnu.mapping.WrappedException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class DrawImage
extends Model
implements Paintable,
Serializable {
    BufferedImage image;
    Path src;
    String description;

    public DrawImage() {
    }

    @Override
    public void makeView(Display display, Object where) {
        display.addImage(this, where);
    }

    void loadImage() {
        if (this.image == null) {
            try {
                this.image = ImageIO.read(this.src.openInputStream());
            }
            catch (Exception ex) {
                throw WrappedException.wrapIfNeeded(ex);
            }
        }
    }

    public DrawImage(BufferedImage image) {
        this.image = image;
    }

    @Override
    public void paint(Graphics2D graphics) {
        this.loadImage();
        graphics.drawImage(this.image, null, null);
    }

    @Override
    public Rectangle2D getBounds2D() {
        this.loadImage();
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        return new Rectangle2D.Float(0.0f, 0.0f, w, h);
    }

    @Override
    public Paintable transform(AffineTransform tr) {
        return new WithTransform(this, tr);
    }

    public Image getImage() {
        this.loadImage();
        return this.image;
    }

    public Path getSrc() {
        return this.src;
    }

    public void setSrc(Path src) {
        this.src = src;
    }
}

