/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import org.jline.utils.Log;

public class NonBlockingReader
extends Reader
implements Runnable {
    public static final int READ_EXPIRED = -2;
    private Reader in;
    private int ch = -2;
    private String name;
    private boolean threadIsReading = false;
    private IOException exception = null;
    private long threadDelay = 60000L;
    private Thread thread;

    public NonBlockingReader(String name, Reader in) {
        this.in = in;
        this.name = name;
    }

    private synchronized void startReadingThreadIfNeeded() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setName(this.name + " non blocking reader thread");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public synchronized void shutdown() {
        if (this.thread != null) {
            this.notify();
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.shutdown();
    }

    @Override
    public int read() throws IOException {
        return this.read(0L, false);
    }

    public int peek(long timeout) throws IOException {
        return this.read(timeout, true);
    }

    public int read(long timeout) throws IOException {
        return this.read(timeout, false);
    }

    @Override
    public synchronized boolean ready() throws IOException {
        return this.ch >= 0 || this.in.ready();
    }

    private synchronized int read(long timeout, boolean isPeek) throws IOException {
        if (this.exception != null) {
            assert (this.ch == -2);
            IOException toBeThrown = this.exception;
            if (!isPeek) {
                this.exception = null;
            }
            throw toBeThrown;
        }
        if (this.ch >= -1) {
            assert (this.exception == null);
        } else if (!isPeek && timeout <= 0L && !this.threadIsReading) {
            this.ch = this.in.read();
        } else {
            boolean isInfinite;
            if (!this.threadIsReading) {
                this.threadIsReading = true;
                this.startReadingThreadIfNeeded();
                this.notifyAll();
            }
            boolean bl = isInfinite = timeout <= 0L;
            while (isInfinite || timeout > 0L) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    this.exception = (IOException)new InterruptedIOException().initCause(e);
                }
                if (this.exception != null) {
                    assert (this.ch == -2);
                    IOException toBeThrown = this.exception;
                    if (!isPeek) {
                        this.exception = null;
                    }
                    throw toBeThrown;
                }
                if (this.ch >= -1) {
                    assert (this.exception == null);
                    break;
                }
                if (isInfinite) continue;
                timeout -= System.currentTimeMillis() - start;
            }
        }
        int ret = this.ch;
        if (!isPeek) {
            this.ch = -2;
        }
        return ret;
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read(0L);
        if (c == -1) {
            return -1;
        }
        b[off] = (char)c;
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Log.debug("NonBlockingReader start");
        while (true) {
            NonBlockingReader nonBlockingReader = this;
            // MONITORENTER : nonBlockingReader
            boolean needToRead = this.threadIsReading;
            try {
                if (!needToRead) {
                    this.wait(this.threadDelay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            needToRead = this.threadIsReading;
            if (needToRead) break block18;
            // MONITOREXIT : nonBlockingReader
            break;
        }
        catch (Throwable throwable) {
            Log.debug("NonBlockingReader shutdown");
            NonBlockingReader nonBlockingReader = this;
            // MONITORENTER : nonBlockingReader
            this.thread = null;
            // MONITOREXIT : nonBlockingReader
            throw throwable;
        }
        {
            block18: {
                Log.debug("NonBlockingReader shutdown");
                NonBlockingReader nonBlockingReader = this;
                // MONITORENTER : nonBlockingReader
                this.thread = null;
                // MONITOREXIT : nonBlockingReader
                return;
            }
            // MONITOREXIT : nonBlockingReader
            int charRead = -2;
            IOException failure = null;
            try {
                charRead = this.in.read();
            }
            catch (IOException e) {
                failure = e;
            }
            NonBlockingReader nonBlockingReader = this;
            // MONITORENTER : nonBlockingReader
            this.exception = failure;
            this.ch = charRead;
            this.threadIsReading = false;
            this.notify();
            // MONITOREXIT : nonBlockingReader
            continue;
        }
    }

    public synchronized void clear() throws IOException {
        while (this.ready()) {
            this.read();
        }
    }
}

