{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.NativeVolumeMonitor
    ( 

-- * Exported types
    NativeVolumeMonitor(..)                 ,
    IsNativeVolumeMonitor                   ,
    toNativeVolumeMonitor                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getConnectedDrives]("GI.Gio.Objects.VolumeMonitor#g:method:getConnectedDrives"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getMountForUuid]("GI.Gio.Objects.VolumeMonitor#g:method:getMountForUuid"), [getMounts]("GI.Gio.Objects.VolumeMonitor#g:method:getMounts"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getVolumeForUuid]("GI.Gio.Objects.VolumeMonitor#g:method:getVolumeForUuid"), [getVolumes]("GI.Gio.Objects.VolumeMonitor#g:method:getVolumes").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveNativeVolumeMonitorMethod        ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.VolumeMonitor as Gio.VolumeMonitor
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.VolumeMonitor as Gio.VolumeMonitor

#endif

-- | Memory-managed wrapper type.
newtype NativeVolumeMonitor = NativeVolumeMonitor (SP.ManagedPtr NativeVolumeMonitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype NativeVolumeMonitor where
    toManagedPtr (NativeVolumeMonitor p) = p

foreign import ccall "g_native_volume_monitor_get_type"
    c_g_native_volume_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject NativeVolumeMonitor where
    glibType = c_g_native_volume_monitor_get_type

instance B.Types.GObject NativeVolumeMonitor

-- | Type class for types which can be safely cast to t'NativeVolumeMonitor', for instance with `toNativeVolumeMonitor`.
class (SP.GObject o, O.IsDescendantOf NativeVolumeMonitor o) => IsNativeVolumeMonitor o
instance (SP.GObject o, O.IsDescendantOf NativeVolumeMonitor o) => IsNativeVolumeMonitor o

instance O.HasParentTypes NativeVolumeMonitor
type instance O.ParentTypes NativeVolumeMonitor = '[Gio.VolumeMonitor.VolumeMonitor, GObject.Object.Object]

-- | Cast to t'NativeVolumeMonitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNativeVolumeMonitor :: (MIO.MonadIO m, IsNativeVolumeMonitor o) => o -> m NativeVolumeMonitor
toNativeVolumeMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo NativeVolumeMonitor

-- | Convert t'NativeVolumeMonitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NativeVolumeMonitor) where
    gvalueGType_ = c_g_native_volume_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NativeVolumeMonitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NativeVolumeMonitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NativeVolumeMonitor ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNativeVolumeMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNativeVolumeMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNativeVolumeMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNativeVolumeMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNativeVolumeMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNativeVolumeMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNativeVolumeMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNativeVolumeMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNativeVolumeMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNativeVolumeMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNativeVolumeMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNativeVolumeMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNativeVolumeMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNativeVolumeMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNativeVolumeMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNativeVolumeMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNativeVolumeMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNativeVolumeMonitorMethod "getConnectedDrives" o = Gio.VolumeMonitor.VolumeMonitorGetConnectedDrivesMethodInfo
    ResolveNativeVolumeMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNativeVolumeMonitorMethod "getMountForUuid" o = Gio.VolumeMonitor.VolumeMonitorGetMountForUuidMethodInfo
    ResolveNativeVolumeMonitorMethod "getMounts" o = Gio.VolumeMonitor.VolumeMonitorGetMountsMethodInfo
    ResolveNativeVolumeMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNativeVolumeMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNativeVolumeMonitorMethod "getVolumeForUuid" o = Gio.VolumeMonitor.VolumeMonitorGetVolumeForUuidMethodInfo
    ResolveNativeVolumeMonitorMethod "getVolumes" o = Gio.VolumeMonitor.VolumeMonitorGetVolumesMethodInfo
    ResolveNativeVolumeMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNativeVolumeMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNativeVolumeMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNativeVolumeMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNativeVolumeMonitorMethod t NativeVolumeMonitor, O.OverloadedMethod info NativeVolumeMonitor p) => OL.IsLabel t (NativeVolumeMonitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNativeVolumeMonitorMethod t NativeVolumeMonitor, O.OverloadedMethod info NativeVolumeMonitor p, R.HasField t NativeVolumeMonitor p) => R.HasField t NativeVolumeMonitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNativeVolumeMonitorMethod t NativeVolumeMonitor, O.OverloadedMethodInfo info NativeVolumeMonitor) => OL.IsLabel t (O.MethodProxy info NativeVolumeMonitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NativeVolumeMonitor
type instance O.AttributeList NativeVolumeMonitor = NativeVolumeMonitorAttributeList
type NativeVolumeMonitorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NativeVolumeMonitor = NativeVolumeMonitorSignalList
type NativeVolumeMonitorSignalList = ('[ '("driveChanged", Gio.VolumeMonitor.VolumeMonitorDriveChangedSignalInfo), '("driveConnected", Gio.VolumeMonitor.VolumeMonitorDriveConnectedSignalInfo), '("driveDisconnected", Gio.VolumeMonitor.VolumeMonitorDriveDisconnectedSignalInfo), '("driveEjectButton", Gio.VolumeMonitor.VolumeMonitorDriveEjectButtonSignalInfo), '("driveStopButton", Gio.VolumeMonitor.VolumeMonitorDriveStopButtonSignalInfo), '("mountAdded", Gio.VolumeMonitor.VolumeMonitorMountAddedSignalInfo), '("mountChanged", Gio.VolumeMonitor.VolumeMonitorMountChangedSignalInfo), '("mountPreUnmount", Gio.VolumeMonitor.VolumeMonitorMountPreUnmountSignalInfo), '("mountRemoved", Gio.VolumeMonitor.VolumeMonitorMountRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("volumeAdded", Gio.VolumeMonitor.VolumeMonitorVolumeAddedSignalInfo), '("volumeChanged", Gio.VolumeMonitor.VolumeMonitorVolumeChangedSignalInfo), '("volumeRemoved", Gio.VolumeMonitor.VolumeMonitorVolumeRemovedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


