// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "iCalendar-params.hxx"

namespace icalendar_2_0
{
  // BaseParameterType
  //


  // ArrayOfParameters
  //

  const ArrayOfParameters::baseParameter_sequence& ArrayOfParameters::
  baseParameter () const
  {
    return this->baseParameter_;
  }

  ArrayOfParameters::baseParameter_sequence& ArrayOfParameters::
  baseParameter ()
  {
    return this->baseParameter_;
  }

  void ArrayOfParameters::
  baseParameter (const baseParameter_sequence& s)
  {
    this->baseParameter_ = s;
  }


  // BooleanParameterType
  //

  const BooleanParameterType::boolean_type& BooleanParameterType::
  boolean () const
  {
    return this->boolean_.get ();
  }

  BooleanParameterType::boolean_type& BooleanParameterType::
  boolean ()
  {
    return this->boolean_.get ();
  }

  void BooleanParameterType::
  boolean (const boolean_type& x)
  {
    this->boolean_.set (x);
  }


  // TextParameterType
  //

  const TextParameterType::text_type& TextParameterType::
  text () const
  {
    return this->text_.get ();
  }

  TextParameterType::text_type& TextParameterType::
  text ()
  {
    return this->text_.get ();
  }

  void TextParameterType::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void TextParameterType::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // UriParameterType
  //

  const UriParameterType::uri_type& UriParameterType::
  uri () const
  {
    return this->uri_.get ();
  }

  UriParameterType::uri_type& UriParameterType::
  uri ()
  {
    return this->uri_.get ();
  }

  void UriParameterType::
  uri (const uri_type& x)
  {
    this->uri_.set (x);
  }

  void UriParameterType::
  uri (::std::unique_ptr< uri_type > x)
  {
    this->uri_.set (std::move (x));
  }


  // CalAddressListParamType
  //

  const CalAddressListParamType::cal_address_sequence& CalAddressListParamType::
  cal_address () const
  {
    return this->cal_address_;
  }

  CalAddressListParamType::cal_address_sequence& CalAddressListParamType::
  cal_address ()
  {
    return this->cal_address_;
  }

  void CalAddressListParamType::
  cal_address (const cal_address_sequence& s)
  {
    this->cal_address_ = s;
  }


  // CalAddressParamType
  //

  const CalAddressParamType::cal_address_type& CalAddressParamType::
  cal_address () const
  {
    return this->cal_address_.get ();
  }

  CalAddressParamType::cal_address_type& CalAddressParamType::
  cal_address ()
  {
    return this->cal_address_.get ();
  }

  void CalAddressParamType::
  cal_address (const cal_address_type& x)
  {
    this->cal_address_.set (x);
  }

  void CalAddressParamType::
  cal_address (::std::unique_ptr< cal_address_type > x)
  {
    this->cal_address_.set (std::move (x));
  }


  // AltrepParamType
  //


  // CnParamType
  //


  // CutypeParamType
  //


  // DelegatedFromParamType
  //


  // DelegatedToParamType
  //


  // DirParamType
  //


  // EncodingParamType
  //


  // FmttypeParamType
  //


  // FbtypeParamType
  //


  // LanguageParamType
  //


  // MemberParamType
  //


  // PartstatParamType
  //


  // RangeValueType
  //

  RangeValueType::
  RangeValueType (value v)
  : ::xml_schema::token (_xsd_RangeValueType_literals_[v])
  {
  }

  RangeValueType::
  RangeValueType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  RangeValueType::
  RangeValueType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  RangeValueType::
  RangeValueType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  RangeValueType::
  RangeValueType (const RangeValueType& v,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  RangeValueType& RangeValueType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_RangeValueType_literals_[v]);

    return *this;
  }


  // RangeParamType
  //

  const RangeParamType::text_type& RangeParamType::
  text () const
  {
    return this->text_.get ();
  }

  RangeParamType::text_type& RangeParamType::
  text ()
  {
    return this->text_.get ();
  }

  void RangeParamType::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void RangeParamType::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // RelatedParamType
  //


  // ReltypeParamType
  //


  // RoleParamType
  //


  // RsvpParamType
  //


  // SentByParamType
  //


  // TzidParamType
  //


  // ScheduleAgentParamType
  //


  // ScheduleForceSendParamType
  //


  // ScheduleStatusParamType
  //
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

#include <xsd/cxx/tree/type-factory-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_factory_plate< 0, char >
  type_factory_plate_init;
}

namespace icalendar_2_0
{
  // BaseParameterType
  //

  BaseParameterType::
  BaseParameterType ()
  : ::xml_schema::type ()
  {
  }

  BaseParameterType::
  BaseParameterType (const BaseParameterType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c)
  {
  }

  BaseParameterType::
  BaseParameterType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (e, f, c)
  {
  }

  BaseParameterType::
  BaseParameterType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (a, f, c)
  {
  }

  BaseParameterType::
  BaseParameterType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (s, e, f, c)
  {
  }

  BaseParameterType::
  ~BaseParameterType ()
  {
  }

  // ArrayOfParameters
  //

  ArrayOfParameters::
  ArrayOfParameters ()
  : ::xml_schema::type (),
    baseParameter_ (this)
  {
  }

  ArrayOfParameters::
  ArrayOfParameters (const ArrayOfParameters& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    baseParameter_ (x.baseParameter_, f, this)
  {
  }

  ArrayOfParameters::
  ArrayOfParameters (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    baseParameter_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void ArrayOfParameters::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // baseParameter
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "baseParameter",
            "urn:ietf:params:xml:ns:icalendar-2.0",
            0,
            true, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< baseParameter_type > r (
            dynamic_cast< baseParameter_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->baseParameter_.push_back (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  ArrayOfParameters* ArrayOfParameters::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ArrayOfParameters (*this, f, c);
  }

  ArrayOfParameters& ArrayOfParameters::
  operator= (const ArrayOfParameters& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->baseParameter_ = x.baseParameter_;
    }

    return *this;
  }

  ArrayOfParameters::
  ~ArrayOfParameters ()
  {
  }

  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_altrep_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "altrep",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::AltrepParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_cn_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "cn",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::CnParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_cutype_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "cutype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::CutypeParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_delegated_from_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "delegated-from",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DelegatedFromParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_delegated_to_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "delegated-to",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DelegatedToParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_dir_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dir",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::DirParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_encoding_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "encoding",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::EncodingParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_fmttype_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "fmttype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::FmttypeParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_fbtype_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "fbtype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::FbtypeParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_language_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "language",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::LanguageParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_member_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "member",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::MemberParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_partstat_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "partstat",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::PartstatParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_range_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "range",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RangeParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_related_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "related",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RelatedParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_reltype_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "reltype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ReltypeParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_role_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "role",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RoleParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_rsvp_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "rsvp",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::RsvpParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_sent_by_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "sent-by",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::SentByParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_tzid_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzid",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::TzidParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_schedule_agent_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "schedule-agent",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ScheduleAgentParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_schedule_force_send_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "schedule-force-send",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ScheduleForceSendParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_schedule_status_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "schedule-status",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::factory_impl< ::icalendar_2_0::ScheduleStatusParamType >);


  // BooleanParameterType
  //

  BooleanParameterType::
  BooleanParameterType (const boolean_type& boolean)
  : ::icalendar_2_0::BaseParameterType (),
    boolean_ (boolean, this)
  {
  }

  BooleanParameterType::
  BooleanParameterType (const BooleanParameterType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (x, f, c),
    boolean_ (x.boolean_, f, this)
  {
  }

  BooleanParameterType::
  BooleanParameterType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    boolean_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void BooleanParameterType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // boolean
      //
      if (n.name () == "boolean" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        if (!boolean_.present ())
        {
          this->boolean_.set (boolean_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!boolean_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "boolean",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  BooleanParameterType* BooleanParameterType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class BooleanParameterType (*this, f, c);
  }

  BooleanParameterType& BooleanParameterType::
  operator= (const BooleanParameterType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BaseParameterType& > (*this) = x;
      this->boolean_ = x.boolean_;
    }

    return *this;
  }

  BooleanParameterType::
  ~BooleanParameterType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, BooleanParameterType >
  _xsd_BooleanParameterType_type_factory_init (
    "BooleanParameterType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TextParameterType
  //

  TextParameterType::
  TextParameterType (const text_type& text)
  : ::icalendar_2_0::BaseParameterType (),
    text_ (text, this)
  {
  }

  TextParameterType::
  TextParameterType (const TextParameterType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  TextParameterType::
  TextParameterType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TextParameterType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  TextParameterType* TextParameterType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TextParameterType (*this, f, c);
  }

  TextParameterType& TextParameterType::
  operator= (const TextParameterType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BaseParameterType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  TextParameterType::
  ~TextParameterType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TextParameterType >
  _xsd_TextParameterType_type_factory_init (
    "TextParameterType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // UriParameterType
  //

  UriParameterType::
  UriParameterType (const uri_type& uri)
  : ::icalendar_2_0::BaseParameterType (),
    uri_ (uri, this)
  {
  }

  UriParameterType::
  UriParameterType (const UriParameterType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (x, f, c),
    uri_ (x.uri_, f, this)
  {
  }

  UriParameterType::
  UriParameterType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    uri_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void UriParameterType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uri
      //
      if (n.name () == "uri" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< uri_type > r (
          uri_traits::create (i, f, this));

        if (!uri_.present ())
        {
          this->uri_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!uri_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uri",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  UriParameterType* UriParameterType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UriParameterType (*this, f, c);
  }

  UriParameterType& UriParameterType::
  operator= (const UriParameterType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BaseParameterType& > (*this) = x;
      this->uri_ = x.uri_;
    }

    return *this;
  }

  UriParameterType::
  ~UriParameterType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UriParameterType >
  _xsd_UriParameterType_type_factory_init (
    "UriParameterType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CalAddressListParamType
  //

  CalAddressListParamType::
  CalAddressListParamType ()
  : ::icalendar_2_0::BaseParameterType (),
    cal_address_ (this)
  {
  }

  CalAddressListParamType::
  CalAddressListParamType (const CalAddressListParamType& x,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (x, f, c),
    cal_address_ (x.cal_address_, f, this)
  {
  }

  CalAddressListParamType::
  CalAddressListParamType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    cal_address_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void CalAddressListParamType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // cal-address
      //
      if (n.name () == "cal-address" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< cal_address_type > r (
          cal_address_traits::create (i, f, this));

        this->cal_address_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  CalAddressListParamType* CalAddressListParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CalAddressListParamType (*this, f, c);
  }

  CalAddressListParamType& CalAddressListParamType::
  operator= (const CalAddressListParamType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BaseParameterType& > (*this) = x;
      this->cal_address_ = x.cal_address_;
    }

    return *this;
  }

  CalAddressListParamType::
  ~CalAddressListParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CalAddressListParamType >
  _xsd_CalAddressListParamType_type_factory_init (
    "CalAddressListParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CalAddressParamType
  //

  CalAddressParamType::
  CalAddressParamType (const cal_address_type& cal_address)
  : ::icalendar_2_0::BaseParameterType (),
    cal_address_ (cal_address, this)
  {
  }

  CalAddressParamType::
  CalAddressParamType (const CalAddressParamType& x,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (x, f, c),
    cal_address_ (x.cal_address_, f, this)
  {
  }

  CalAddressParamType::
  CalAddressParamType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    cal_address_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void CalAddressParamType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // cal-address
      //
      if (n.name () == "cal-address" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< cal_address_type > r (
          cal_address_traits::create (i, f, this));

        if (!cal_address_.present ())
        {
          this->cal_address_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!cal_address_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "cal-address",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  CalAddressParamType* CalAddressParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CalAddressParamType (*this, f, c);
  }

  CalAddressParamType& CalAddressParamType::
  operator= (const CalAddressParamType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BaseParameterType& > (*this) = x;
      this->cal_address_ = x.cal_address_;
    }

    return *this;
  }

  CalAddressParamType::
  ~CalAddressParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CalAddressParamType >
  _xsd_CalAddressParamType_type_factory_init (
    "CalAddressParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // AltrepParamType
  //

  AltrepParamType::
  AltrepParamType (const uri_type& uri)
  : ::icalendar_2_0::UriParameterType (uri)
  {
  }

  AltrepParamType::
  AltrepParamType (const AltrepParamType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::UriParameterType (x, f, c)
  {
  }

  AltrepParamType::
  AltrepParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::UriParameterType (e, f, c)
  {
  }

  AltrepParamType* AltrepParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class AltrepParamType (*this, f, c);
  }

  AltrepParamType::
  ~AltrepParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, AltrepParamType >
  _xsd_AltrepParamType_type_factory_init (
    "AltrepParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CnParamType
  //

  CnParamType::
  CnParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  CnParamType::
  CnParamType (const CnParamType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  CnParamType::
  CnParamType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  CnParamType* CnParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CnParamType (*this, f, c);
  }

  CnParamType::
  ~CnParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CnParamType >
  _xsd_CnParamType_type_factory_init (
    "CnParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // CutypeParamType
  //

  CutypeParamType::
  CutypeParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  CutypeParamType::
  CutypeParamType (const CutypeParamType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  CutypeParamType::
  CutypeParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  CutypeParamType* CutypeParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CutypeParamType (*this, f, c);
  }

  CutypeParamType::
  ~CutypeParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, CutypeParamType >
  _xsd_CutypeParamType_type_factory_init (
    "CutypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DelegatedFromParamType
  //

  DelegatedFromParamType::
  DelegatedFromParamType ()
  : ::icalendar_2_0::CalAddressListParamType ()
  {
  }

  DelegatedFromParamType::
  DelegatedFromParamType (const DelegatedFromParamType& x,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressListParamType (x, f, c)
  {
  }

  DelegatedFromParamType::
  DelegatedFromParamType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressListParamType (e, f, c)
  {
  }

  DelegatedFromParamType* DelegatedFromParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DelegatedFromParamType (*this, f, c);
  }

  DelegatedFromParamType::
  ~DelegatedFromParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DelegatedFromParamType >
  _xsd_DelegatedFromParamType_type_factory_init (
    "DelegatedFromParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DelegatedToParamType
  //

  DelegatedToParamType::
  DelegatedToParamType ()
  : ::icalendar_2_0::CalAddressListParamType ()
  {
  }

  DelegatedToParamType::
  DelegatedToParamType (const DelegatedToParamType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressListParamType (x, f, c)
  {
  }

  DelegatedToParamType::
  DelegatedToParamType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressListParamType (e, f, c)
  {
  }

  DelegatedToParamType* DelegatedToParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DelegatedToParamType (*this, f, c);
  }

  DelegatedToParamType::
  ~DelegatedToParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DelegatedToParamType >
  _xsd_DelegatedToParamType_type_factory_init (
    "DelegatedToParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // DirParamType
  //

  DirParamType::
  DirParamType (const uri_type& uri)
  : ::icalendar_2_0::UriParameterType (uri)
  {
  }

  DirParamType::
  DirParamType (const DirParamType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::icalendar_2_0::UriParameterType (x, f, c)
  {
  }

  DirParamType::
  DirParamType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::icalendar_2_0::UriParameterType (e, f, c)
  {
  }

  DirParamType* DirParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DirParamType (*this, f, c);
  }

  DirParamType::
  ~DirParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DirParamType >
  _xsd_DirParamType_type_factory_init (
    "DirParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // EncodingParamType
  //

  EncodingParamType::
  EncodingParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  EncodingParamType::
  EncodingParamType (const EncodingParamType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  EncodingParamType::
  EncodingParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  EncodingParamType* EncodingParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class EncodingParamType (*this, f, c);
  }

  EncodingParamType::
  ~EncodingParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, EncodingParamType >
  _xsd_EncodingParamType_type_factory_init (
    "EncodingParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // FmttypeParamType
  //

  FmttypeParamType::
  FmttypeParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  FmttypeParamType::
  FmttypeParamType (const FmttypeParamType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  FmttypeParamType::
  FmttypeParamType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  FmttypeParamType* FmttypeParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FmttypeParamType (*this, f, c);
  }

  FmttypeParamType::
  ~FmttypeParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, FmttypeParamType >
  _xsd_FmttypeParamType_type_factory_init (
    "FmttypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // FbtypeParamType
  //

  FbtypeParamType::
  FbtypeParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  FbtypeParamType::
  FbtypeParamType (const FbtypeParamType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  FbtypeParamType::
  FbtypeParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  FbtypeParamType* FbtypeParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FbtypeParamType (*this, f, c);
  }

  FbtypeParamType::
  ~FbtypeParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, FbtypeParamType >
  _xsd_FbtypeParamType_type_factory_init (
    "FbtypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // LanguageParamType
  //

  LanguageParamType::
  LanguageParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  LanguageParamType::
  LanguageParamType (const LanguageParamType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  LanguageParamType::
  LanguageParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  LanguageParamType* LanguageParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class LanguageParamType (*this, f, c);
  }

  LanguageParamType::
  ~LanguageParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, LanguageParamType >
  _xsd_LanguageParamType_type_factory_init (
    "LanguageParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // MemberParamType
  //

  MemberParamType::
  MemberParamType ()
  : ::icalendar_2_0::CalAddressListParamType ()
  {
  }

  MemberParamType::
  MemberParamType (const MemberParamType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressListParamType (x, f, c)
  {
  }

  MemberParamType::
  MemberParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressListParamType (e, f, c)
  {
  }

  MemberParamType* MemberParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class MemberParamType (*this, f, c);
  }

  MemberParamType::
  ~MemberParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, MemberParamType >
  _xsd_MemberParamType_type_factory_init (
    "MemberParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // PartstatParamType
  //

  PartstatParamType::
  PartstatParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  PartstatParamType::
  PartstatParamType (const PartstatParamType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  PartstatParamType::
  PartstatParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  PartstatParamType* PartstatParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class PartstatParamType (*this, f, c);
  }

  PartstatParamType::
  ~PartstatParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, PartstatParamType >
  _xsd_PartstatParamType_type_factory_init (
    "PartstatParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RangeValueType
  //

  RangeValueType::
  RangeValueType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_RangeValueType_convert ();
  }

  RangeValueType::
  RangeValueType (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_RangeValueType_convert ();
  }

  RangeValueType::
  RangeValueType (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_RangeValueType_convert ();
  }

  RangeValueType* RangeValueType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RangeValueType (*this, f, c);
  }

  RangeValueType::value RangeValueType::
  _xsd_RangeValueType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_RangeValueType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_RangeValueType_indexes_,
                      _xsd_RangeValueType_indexes_ + 1,
                      *this,
                      c));

    if (i == _xsd_RangeValueType_indexes_ + 1 || _xsd_RangeValueType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const RangeValueType::
  _xsd_RangeValueType_literals_[1] =
  {
    "THISANDFUTURE"
  };

  const RangeValueType::value RangeValueType::
  _xsd_RangeValueType_indexes_[1] =
  {
    ::icalendar_2_0::RangeValueType::THISANDFUTURE
  };

  // RangeParamType
  //

  RangeParamType::
  RangeParamType (const text_type& text)
  : ::icalendar_2_0::BaseParameterType (),
    text_ (text, this)
  {
  }

  RangeParamType::
  RangeParamType (const RangeParamType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  RangeParamType::
  RangeParamType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::icalendar_2_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void RangeParamType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:icalendar-2.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:icalendar-2.0");
    }
  }

  RangeParamType* RangeParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RangeParamType (*this, f, c);
  }

  RangeParamType& RangeParamType::
  operator= (const RangeParamType& x)
  {
    if (this != &x)
    {
      static_cast< ::icalendar_2_0::BaseParameterType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  RangeParamType::
  ~RangeParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RangeParamType >
  _xsd_RangeParamType_type_factory_init (
    "RangeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RelatedParamType
  //

  RelatedParamType::
  RelatedParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  RelatedParamType::
  RelatedParamType (const RelatedParamType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  RelatedParamType::
  RelatedParamType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  RelatedParamType* RelatedParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RelatedParamType (*this, f, c);
  }

  RelatedParamType::
  ~RelatedParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RelatedParamType >
  _xsd_RelatedParamType_type_factory_init (
    "RelatedParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ReltypeParamType
  //

  ReltypeParamType::
  ReltypeParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  ReltypeParamType::
  ReltypeParamType (const ReltypeParamType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  ReltypeParamType::
  ReltypeParamType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  ReltypeParamType* ReltypeParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ReltypeParamType (*this, f, c);
  }

  ReltypeParamType::
  ~ReltypeParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ReltypeParamType >
  _xsd_ReltypeParamType_type_factory_init (
    "ReltypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RoleParamType
  //

  RoleParamType::
  RoleParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  RoleParamType::
  RoleParamType (const RoleParamType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  RoleParamType::
  RoleParamType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  RoleParamType* RoleParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RoleParamType (*this, f, c);
  }

  RoleParamType::
  ~RoleParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RoleParamType >
  _xsd_RoleParamType_type_factory_init (
    "RoleParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // RsvpParamType
  //

  RsvpParamType::
  RsvpParamType (const boolean_type& boolean)
  : ::icalendar_2_0::BooleanParameterType (boolean)
  {
  }

  RsvpParamType::
  RsvpParamType (const RsvpParamType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::BooleanParameterType (x, f, c)
  {
  }

  RsvpParamType::
  RsvpParamType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::BooleanParameterType (e, f, c)
  {
  }

  RsvpParamType* RsvpParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class RsvpParamType (*this, f, c);
  }

  RsvpParamType::
  ~RsvpParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, RsvpParamType >
  _xsd_RsvpParamType_type_factory_init (
    "RsvpParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // SentByParamType
  //

  SentByParamType::
  SentByParamType (const cal_address_type& cal_address)
  : ::icalendar_2_0::CalAddressParamType (cal_address)
  {
  }

  SentByParamType::
  SentByParamType (const SentByParamType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressParamType (x, f, c)
  {
  }

  SentByParamType::
  SentByParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::icalendar_2_0::CalAddressParamType (e, f, c)
  {
  }

  SentByParamType* SentByParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class SentByParamType (*this, f, c);
  }

  SentByParamType::
  ~SentByParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, SentByParamType >
  _xsd_SentByParamType_type_factory_init (
    "SentByParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // TzidParamType
  //

  TzidParamType::
  TzidParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  TzidParamType::
  TzidParamType (const TzidParamType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  TzidParamType::
  TzidParamType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  TzidParamType* TzidParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TzidParamType (*this, f, c);
  }

  TzidParamType::
  ~TzidParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TzidParamType >
  _xsd_TzidParamType_type_factory_init (
    "TzidParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ScheduleAgentParamType
  //

  ScheduleAgentParamType::
  ScheduleAgentParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  ScheduleAgentParamType::
  ScheduleAgentParamType (const ScheduleAgentParamType& x,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  ScheduleAgentParamType::
  ScheduleAgentParamType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  ScheduleAgentParamType* ScheduleAgentParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ScheduleAgentParamType (*this, f, c);
  }

  ScheduleAgentParamType::
  ~ScheduleAgentParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ScheduleAgentParamType >
  _xsd_ScheduleAgentParamType_type_factory_init (
    "ScheduleAgentParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ScheduleForceSendParamType
  //

  ScheduleForceSendParamType::
  ScheduleForceSendParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  ScheduleForceSendParamType::
  ScheduleForceSendParamType (const ScheduleForceSendParamType& x,
                              ::xml_schema::flags f,
                              ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  ScheduleForceSendParamType::
  ScheduleForceSendParamType (const ::xercesc::DOMElement& e,
                              ::xml_schema::flags f,
                              ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  ScheduleForceSendParamType* ScheduleForceSendParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ScheduleForceSendParamType (*this, f, c);
  }

  ScheduleForceSendParamType::
  ~ScheduleForceSendParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ScheduleForceSendParamType >
  _xsd_ScheduleForceSendParamType_type_factory_init (
    "ScheduleForceSendParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");

  // ScheduleStatusParamType
  //

  ScheduleStatusParamType::
  ScheduleStatusParamType (const text_type& text)
  : ::icalendar_2_0::TextParameterType (text)
  {
  }

  ScheduleStatusParamType::
  ScheduleStatusParamType (const ScheduleStatusParamType& x,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (x, f, c)
  {
  }

  ScheduleStatusParamType::
  ScheduleStatusParamType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f,
                           ::xml_schema::container* c)
  : ::icalendar_2_0::TextParameterType (e, f, c)
  {
  }

  ScheduleStatusParamType* ScheduleStatusParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ScheduleStatusParamType (*this, f, c);
  }

  ScheduleStatusParamType::
  ~ScheduleStatusParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, ScheduleStatusParamType >
  _xsd_ScheduleStatusParamType_type_factory_init (
    "ScheduleStatusParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace icalendar_2_0
{
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

#include <xsd/cxx/tree/type-serializer-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_serializer_plate< 0, char >
  type_serializer_plate_init;
}

namespace icalendar_2_0
{
  void
  operator<< (::xercesc::DOMElement& e, const BaseParameterType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr&, const BaseParameterType&)
  {
  }

  void
  operator<< (::xml_schema::list_stream&,
              const BaseParameterType&)
  {
  }

  void
  operator<< (::xercesc::DOMElement& e, const ArrayOfParameters& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // baseParameter
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (ArrayOfParameters::baseParameter_const_iterator
           b (i.baseParameter ().begin ()), n (i.baseParameter ().end ());
           b != n; ++b)
      {
        const ArrayOfParameters::baseParameter_type& x (*b);

        if (typeid (ArrayOfParameters::baseParameter_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "baseParameter",
              "urn:ietf:params:xml:ns:icalendar-2.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "baseParameter",
            "urn:ietf:params:xml:ns:icalendar-2.0",
            true, true, e, x);
      }
    }
  }

  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::AltrepParamType >
  _xsd_altrep_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "altrep",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::AltrepParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::CnParamType >
  _xsd_cn_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "cn",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::CnParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::CutypeParamType >
  _xsd_cutype_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "cutype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::CutypeParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DelegatedFromParamType >
  _xsd_delegated_from_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "delegated-from",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DelegatedFromParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DelegatedToParamType >
  _xsd_delegated_to_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "delegated-to",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DelegatedToParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::DirParamType >
  _xsd_dir_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "dir",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::DirParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::EncodingParamType >
  _xsd_encoding_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "encoding",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::EncodingParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::FmttypeParamType >
  _xsd_fmttype_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "fmttype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::FmttypeParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::FbtypeParamType >
  _xsd_fbtype_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "fbtype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::FbtypeParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::LanguageParamType >
  _xsd_language_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "language",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::LanguageParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::MemberParamType >
  _xsd_member_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "member",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::MemberParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::PartstatParamType >
  _xsd_partstat_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "partstat",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::PartstatParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RangeParamType >
  _xsd_range_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "range",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RangeParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RelatedParamType >
  _xsd_related_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "related",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RelatedParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ReltypeParamType >
  _xsd_reltype_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "reltype",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ReltypeParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RoleParamType >
  _xsd_role_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "role",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RoleParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::RsvpParamType >
  _xsd_rsvp_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "rsvp",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::RsvpParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::SentByParamType >
  _xsd_sent_by_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "sent-by",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::SentByParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::TzidParamType >
  _xsd_tzid_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "tzid",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::TzidParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ScheduleAgentParamType >
  _xsd_schedule_agent_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "schedule-agent",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ScheduleAgentParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ScheduleForceSendParamType >
  _xsd_schedule_force_send_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "schedule-force-send",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ScheduleForceSendParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::icalendar_2_0::ScheduleStatusParamType >
  _xsd_schedule_status_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    "schedule-status",
    "urn:ietf:params:xml:ns:icalendar-2.0",
    &::xsd::cxx::tree::serializer_impl< ::icalendar_2_0::ScheduleStatusParamType >);


  void
  operator<< (::xercesc::DOMElement& e, const BooleanParameterType& i)
  {
    e << static_cast< const ::icalendar_2_0::BaseParameterType& > (i);

    // boolean
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "boolean",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.boolean ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, BooleanParameterType >
  _xsd_BooleanParameterType_type_serializer_init (
    "BooleanParameterType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TextParameterType& i)
  {
    e << static_cast< const ::icalendar_2_0::BaseParameterType& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.text ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TextParameterType >
  _xsd_TextParameterType_type_serializer_init (
    "TextParameterType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const UriParameterType& i)
  {
    e << static_cast< const ::icalendar_2_0::BaseParameterType& > (i);

    // uri
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uri",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.uri ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UriParameterType >
  _xsd_UriParameterType_type_serializer_init (
    "UriParameterType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CalAddressListParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::BaseParameterType& > (i);

    // cal-address
    //
    for (CalAddressListParamType::cal_address_const_iterator
         b (i.cal_address ().begin ()), n (i.cal_address ().end ());
         b != n; ++b)
    {
      const CalAddressListParamType::cal_address_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "cal-address",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CalAddressListParamType >
  _xsd_CalAddressListParamType_type_serializer_init (
    "CalAddressListParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CalAddressParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::BaseParameterType& > (i);

    // cal-address
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "cal-address",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.cal_address ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CalAddressParamType >
  _xsd_CalAddressParamType_type_serializer_init (
    "CalAddressParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const AltrepParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::UriParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, AltrepParamType >
  _xsd_AltrepParamType_type_serializer_init (
    "AltrepParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CnParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CnParamType >
  _xsd_CnParamType_type_serializer_init (
    "CnParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const CutypeParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, CutypeParamType >
  _xsd_CutypeParamType_type_serializer_init (
    "CutypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DelegatedFromParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::CalAddressListParamType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DelegatedFromParamType >
  _xsd_DelegatedFromParamType_type_serializer_init (
    "DelegatedFromParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DelegatedToParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::CalAddressListParamType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DelegatedToParamType >
  _xsd_DelegatedToParamType_type_serializer_init (
    "DelegatedToParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const DirParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::UriParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DirParamType >
  _xsd_DirParamType_type_serializer_init (
    "DirParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const EncodingParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, EncodingParamType >
  _xsd_EncodingParamType_type_serializer_init (
    "EncodingParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const FmttypeParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, FmttypeParamType >
  _xsd_FmttypeParamType_type_serializer_init (
    "FmttypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const FbtypeParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, FbtypeParamType >
  _xsd_FbtypeParamType_type_serializer_init (
    "FbtypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const LanguageParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, LanguageParamType >
  _xsd_LanguageParamType_type_serializer_init (
    "LanguageParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const MemberParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::CalAddressListParamType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, MemberParamType >
  _xsd_MemberParamType_type_serializer_init (
    "MemberParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const PartstatParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, PartstatParamType >
  _xsd_PartstatParamType_type_serializer_init (
    "PartstatParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RangeValueType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const RangeValueType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const RangeValueType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const RangeParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::BaseParameterType& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:icalendar-2.0",
          e));

      s << i.text ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RangeParamType >
  _xsd_RangeParamType_type_serializer_init (
    "RangeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RelatedParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RelatedParamType >
  _xsd_RelatedParamType_type_serializer_init (
    "RelatedParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ReltypeParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ReltypeParamType >
  _xsd_ReltypeParamType_type_serializer_init (
    "ReltypeParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RoleParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RoleParamType >
  _xsd_RoleParamType_type_serializer_init (
    "RoleParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const RsvpParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::BooleanParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, RsvpParamType >
  _xsd_RsvpParamType_type_serializer_init (
    "RsvpParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const SentByParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::CalAddressParamType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, SentByParamType >
  _xsd_SentByParamType_type_serializer_init (
    "SentByParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const TzidParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TzidParamType >
  _xsd_TzidParamType_type_serializer_init (
    "TzidParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ScheduleAgentParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ScheduleAgentParamType >
  _xsd_ScheduleAgentParamType_type_serializer_init (
    "ScheduleAgentParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ScheduleForceSendParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ScheduleForceSendParamType >
  _xsd_ScheduleForceSendParamType_type_serializer_init (
    "ScheduleForceSendParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");


  void
  operator<< (::xercesc::DOMElement& e, const ScheduleStatusParamType& i)
  {
    e << static_cast< const ::icalendar_2_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, ScheduleStatusParamType >
  _xsd_ScheduleStatusParamType_type_serializer_init (
    "ScheduleStatusParamType",
    "urn:ietf:params:xml:ns:icalendar-2.0");
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

