// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: frontend.proto

package frontendv2pb

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	httpgrpc "github.com/grafana/dskit/httpgrpc"
	querierpb "github.com/grafana/mimir/pkg/querier/querierpb"
	_ "github.com/grafana/mimir/pkg/querier/stats"
	github_com_grafana_mimir_pkg_querier_stats "github.com/grafana/mimir/pkg/querier/stats"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type QueryResultRequest struct {
	QueryID      uint64                                                `protobuf:"varint,1,opt,name=queryID,proto3" json:"queryID,omitempty"`
	HttpResponse *httpgrpc.HTTPResponse                                `protobuf:"bytes,2,opt,name=httpResponse,proto3" json:"httpResponse,omitempty"`
	Stats        *github_com_grafana_mimir_pkg_querier_stats.SafeStats `protobuf:"bytes,3,opt,name=stats,proto3,customtype=github.com/grafana/mimir/pkg/querier/stats.SafeStats" json:"stats,omitempty"`
}

func (m *QueryResultRequest) Reset()      { *m = QueryResultRequest{} }
func (*QueryResultRequest) ProtoMessage() {}
func (*QueryResultRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{0}
}
func (m *QueryResultRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultRequest.Merge(m, src)
}
func (m *QueryResultRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultRequest proto.InternalMessageInfo

func (m *QueryResultRequest) GetQueryID() uint64 {
	if m != nil {
		return m.QueryID
	}
	return 0
}

func (m *QueryResultRequest) GetHttpResponse() *httpgrpc.HTTPResponse {
	if m != nil {
		return m.HttpResponse
	}
	return nil
}

type QueryResultStreamRequest struct {
	QueryID uint64 `protobuf:"varint,1,opt,name=queryID,proto3" json:"queryID,omitempty"`
	// Types that are valid to be assigned to Data:
	//	*QueryResultStreamRequest_Metadata
	//	*QueryResultStreamRequest_Body
	//	*QueryResultStreamRequest_Error
	//	*QueryResultStreamRequest_EvaluateQueryResponse
	Data isQueryResultStreamRequest_Data `protobuf_oneof:"data"`
}

func (m *QueryResultStreamRequest) Reset()      { *m = QueryResultStreamRequest{} }
func (*QueryResultStreamRequest) ProtoMessage() {}
func (*QueryResultStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{1}
}
func (m *QueryResultStreamRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultStreamRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultStreamRequest.Merge(m, src)
}
func (m *QueryResultStreamRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultStreamRequest proto.InternalMessageInfo

type isQueryResultStreamRequest_Data interface {
	isQueryResultStreamRequest_Data()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type QueryResultStreamRequest_Metadata struct {
	Metadata *QueryResultMetadata `protobuf:"bytes,2,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
}
type QueryResultStreamRequest_Body struct {
	Body *QueryResultBody `protobuf:"bytes,3,opt,name=body,proto3,oneof" json:"body,omitempty"`
}
type QueryResultStreamRequest_Error struct {
	Error *querierpb.Error `protobuf:"bytes,4,opt,name=error,proto3,oneof" json:"error,omitempty"`
}
type QueryResultStreamRequest_EvaluateQueryResponse struct {
	EvaluateQueryResponse *querierpb.EvaluateQueryResponse `protobuf:"bytes,5,opt,name=evaluateQueryResponse,proto3,oneof" json:"evaluateQueryResponse,omitempty"`
}

func (*QueryResultStreamRequest_Metadata) isQueryResultStreamRequest_Data()              {}
func (*QueryResultStreamRequest_Body) isQueryResultStreamRequest_Data()                  {}
func (*QueryResultStreamRequest_Error) isQueryResultStreamRequest_Data()                 {}
func (*QueryResultStreamRequest_EvaluateQueryResponse) isQueryResultStreamRequest_Data() {}

func (m *QueryResultStreamRequest) GetData() isQueryResultStreamRequest_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *QueryResultStreamRequest) GetQueryID() uint64 {
	if m != nil {
		return m.QueryID
	}
	return 0
}

func (m *QueryResultStreamRequest) GetMetadata() *QueryResultMetadata {
	if x, ok := m.GetData().(*QueryResultStreamRequest_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (m *QueryResultStreamRequest) GetBody() *QueryResultBody {
	if x, ok := m.GetData().(*QueryResultStreamRequest_Body); ok {
		return x.Body
	}
	return nil
}

func (m *QueryResultStreamRequest) GetError() *querierpb.Error {
	if x, ok := m.GetData().(*QueryResultStreamRequest_Error); ok {
		return x.Error
	}
	return nil
}

func (m *QueryResultStreamRequest) GetEvaluateQueryResponse() *querierpb.EvaluateQueryResponse {
	if x, ok := m.GetData().(*QueryResultStreamRequest_EvaluateQueryResponse); ok {
		return x.EvaluateQueryResponse
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*QueryResultStreamRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*QueryResultStreamRequest_Metadata)(nil),
		(*QueryResultStreamRequest_Body)(nil),
		(*QueryResultStreamRequest_Error)(nil),
		(*QueryResultStreamRequest_EvaluateQueryResponse)(nil),
	}
}

type QueryResultMetadata struct {
	Code    int32                                                 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Headers []*httpgrpc.Header                                    `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty"`
	Stats   *github_com_grafana_mimir_pkg_querier_stats.SafeStats `protobuf:"bytes,3,opt,name=stats,proto3,customtype=github.com/grafana/mimir/pkg/querier/stats.SafeStats" json:"stats,omitempty"`
}

func (m *QueryResultMetadata) Reset()      { *m = QueryResultMetadata{} }
func (*QueryResultMetadata) ProtoMessage() {}
func (*QueryResultMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{2}
}
func (m *QueryResultMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultMetadata.Merge(m, src)
}
func (m *QueryResultMetadata) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultMetadata proto.InternalMessageInfo

func (m *QueryResultMetadata) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *QueryResultMetadata) GetHeaders() []*httpgrpc.Header {
	if m != nil {
		return m.Headers
	}
	return nil
}

type QueryResultBody struct {
	Chunk []byte `protobuf:"bytes,1,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (m *QueryResultBody) Reset()      { *m = QueryResultBody{} }
func (*QueryResultBody) ProtoMessage() {}
func (*QueryResultBody) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{3}
}
func (m *QueryResultBody) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultBody) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultBody.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultBody) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultBody.Merge(m, src)
}
func (m *QueryResultBody) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultBody) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultBody.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultBody proto.InternalMessageInfo

func (m *QueryResultBody) GetChunk() []byte {
	if m != nil {
		return m.Chunk
	}
	return nil
}

type QueryResultResponse struct {
}

func (m *QueryResultResponse) Reset()      { *m = QueryResultResponse{} }
func (*QueryResultResponse) ProtoMessage() {}
func (*QueryResultResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{4}
}
func (m *QueryResultResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultResponse.Merge(m, src)
}
func (m *QueryResultResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*QueryResultRequest)(nil), "frontendv2pb.QueryResultRequest")
	proto.RegisterType((*QueryResultStreamRequest)(nil), "frontendv2pb.QueryResultStreamRequest")
	proto.RegisterType((*QueryResultMetadata)(nil), "frontendv2pb.QueryResultMetadata")
	proto.RegisterType((*QueryResultBody)(nil), "frontendv2pb.QueryResultBody")
	proto.RegisterType((*QueryResultResponse)(nil), "frontendv2pb.QueryResultResponse")
}

func init() { proto.RegisterFile("frontend.proto", fileDescriptor_eca3873955a29cfe) }

var fileDescriptor_eca3873955a29cfe = []byte{
	// 557 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x94, 0x4f, 0x8b, 0x13, 0x31,
	0x18, 0xc6, 0x93, 0x6e, 0xbb, 0x2b, 0xd9, 0xe2, 0x9f, 0xb8, 0x2b, 0x43, 0xc1, 0xd8, 0xed, 0x41,
	0x8b, 0x87, 0x19, 0xe9, 0x8a, 0x88, 0x08, 0x42, 0xd1, 0xa5, 0x1e, 0x04, 0x37, 0xed, 0x41, 0xc4,
	0x4b, 0xa6, 0x93, 0x4e, 0x4b, 0xb7, 0xcd, 0x6c, 0x26, 0xb3, 0xd0, 0x9b, 0x1f, 0xc1, 0x8f, 0xe1,
	0x5d, 0xf0, 0x33, 0xec, 0x49, 0x7a, 0x5c, 0x3c, 0x88, 0x9d, 0x5e, 0x3c, 0xee, 0x47, 0x90, 0x49,
	0x66, 0xea, 0x54, 0x5b, 0xed, 0xc5, 0xcb, 0xcc, 0x9b, 0xe4, 0xf9, 0xbd, 0x79, 0x9f, 0xbc, 0x21,
	0xe8, 0x6a, 0x4f, 0x8a, 0xb1, 0xe2, 0x63, 0xcf, 0x0e, 0xa4, 0x50, 0x02, 0x97, 0xb3, 0xf1, 0x59,
	0x23, 0x70, 0x2b, 0x0f, 0xfc, 0x81, 0xea, 0x47, 0xae, 0xdd, 0x15, 0x23, 0xc7, 0x97, 0xac, 0xc7,
	0xc6, 0xcc, 0xf1, 0xc2, 0xe1, 0x40, 0x39, 0x7d, 0xa5, 0x02, 0x5f, 0x06, 0xdd, 0x45, 0x60, 0xf8,
	0xca, 0xd3, 0x15, 0xc4, 0x68, 0x30, 0x1a, 0x48, 0x27, 0x18, 0xfa, 0xce, 0x69, 0xc4, 0xe5, 0x80,
	0xcb, 0xec, 0x1f, 0xb8, 0x59, 0x94, 0xd2, 0x8f, 0x36, 0xa2, 0x43, 0xc5, 0x54, 0x68, 0xbe, 0x29,
	0xb7, 0xe7, 0x0b, 0x5f, 0xe8, 0xd0, 0x49, 0x22, 0x33, 0x5b, 0x3b, 0x87, 0x08, 0x1f, 0x47, 0x5c,
	0x4e, 0x28, 0x0f, 0xa3, 0x13, 0x45, 0xf9, 0x69, 0xc4, 0x43, 0x85, 0x2d, 0xb4, 0x93, 0x64, 0x9a,
	0xbc, 0x7c, 0x6e, 0xc1, 0x2a, 0xac, 0x17, 0x69, 0x36, 0xc4, 0x4f, 0x50, 0x39, 0xb1, 0x43, 0x79,
	0x18, 0x88, 0x71, 0xc8, 0xad, 0x42, 0x15, 0xd6, 0x77, 0x1b, 0xb7, 0xec, 0x85, 0xc7, 0x56, 0xa7,
	0xf3, 0x3a, 0x5b, 0xa5, 0x4b, 0x5a, 0xfc, 0x0e, 0x95, 0x74, 0x45, 0xd6, 0x96, 0x86, 0xca, 0xb6,
	0xa9, 0xaf, 0x9d, 0x7c, 0x9b, 0x8f, 0xbf, 0x7e, 0xbb, 0xf3, 0x70, 0x73, 0x6f, 0x76, 0x9b, 0xf5,
	0xb8, 0x26, 0xa9, 0x49, 0x5a, 0xfb, 0x5c, 0x40, 0x56, 0xce, 0x4a, 0x5b, 0x49, 0xce, 0x46, 0xff,
	0x36, 0xf4, 0x0c, 0x5d, 0x19, 0x71, 0xc5, 0x3c, 0xa6, 0x58, 0x6a, 0xe6, 0xc0, 0xce, 0x37, 0xd8,
	0xce, 0xe5, 0x7c, 0x95, 0x0a, 0x5b, 0x80, 0x2e, 0x20, 0x7c, 0x88, 0x8a, 0xae, 0xf0, 0x26, 0xa9,
	0xa9, 0xdb, 0x6b, 0xe1, 0xa6, 0xf0, 0x26, 0x2d, 0x40, 0xb5, 0x18, 0xd7, 0x51, 0x89, 0x4b, 0x29,
	0xa4, 0x55, 0xd4, 0xd4, 0x75, 0x7b, 0xd1, 0x6e, 0xfb, 0x45, 0x32, 0xdf, 0x02, 0xd4, 0x08, 0xf0,
	0x1b, 0xb4, 0xcf, 0xcf, 0xd8, 0x49, 0xc4, 0x14, 0xcf, 0x92, 0x99, 0x93, 0x2f, 0x69, 0xb2, 0x9a,
	0x27, 0x57, 0xe9, 0x5a, 0x80, 0xae, 0x4e, 0xd0, 0xdc, 0x46, 0xc5, 0xc4, 0x40, 0xed, 0x13, 0x44,
	0x37, 0x57, 0x98, 0xc4, 0x18, 0x15, 0xbb, 0xc2, 0xe3, 0xfa, 0xc0, 0x4a, 0x54, 0xc7, 0xf8, 0x3e,
	0xda, 0xe9, 0x73, 0xe6, 0x71, 0x19, 0x5a, 0x85, 0xea, 0x96, 0xae, 0xfc, 0x57, 0xe7, 0xf5, 0x02,
	0xcd, 0x04, 0xff, 0xb9, 0xdd, 0xf7, 0xd0, 0xb5, 0xdf, 0x0e, 0x17, 0xef, 0xa1, 0x52, 0xb7, 0x1f,
	0x8d, 0x87, 0xba, 0xe2, 0x32, 0x35, 0x83, 0xda, 0xfe, 0x92, 0xbb, 0xcc, 0x7d, 0xe3, 0x0b, 0x44,
	0xf8, 0x28, 0x6d, 0xd5, 0x91, 0x90, 0xc7, 0x66, 0x37, 0xdc, 0x41, 0xbb, 0x39, 0x35, 0xae, 0xae,
	0x6d, 0x67, 0x7a, 0xb3, 0x2a, 0x07, 0x7f, 0x51, 0x98, 0xad, 0x6a, 0x00, 0xbb, 0xe8, 0xc6, 0x1f,
	0x57, 0x13, 0xdf, 0x5d, 0x4b, 0x2e, 0xdd, 0xdd, 0x8d, 0x76, 0xa8, 0xc3, 0x66, 0x73, 0x3a, 0x23,
	0xe0, 0x62, 0x46, 0xc0, 0xe5, 0x8c, 0xc0, 0xf7, 0x31, 0x81, 0x1f, 0x63, 0x02, 0xcf, 0x63, 0x02,
	0xa7, 0x31, 0x81, 0xdf, 0x63, 0x02, 0x7f, 0xc4, 0x04, 0x5c, 0xc6, 0x04, 0x7e, 0x98, 0x13, 0x30,
	0x9d, 0x13, 0x70, 0x31, 0x27, 0xe0, 0xed, 0xd2, 0x63, 0xe6, 0x6e, 0xeb, 0x57, 0xe1, 0xf0, 0x67,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xa3, 0xb1, 0x4a, 0x18, 0xf3, 0x04, 0x00, 0x00,
}

func (this *QueryResultRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultRequest)
	if !ok {
		that2, ok := that.(QueryResultRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.QueryID != that1.QueryID {
		return false
	}
	if !this.HttpResponse.Equal(that1.HttpResponse) {
		return false
	}
	if that1.Stats == nil {
		if this.Stats != nil {
			return false
		}
	} else if !this.Stats.Equal(*that1.Stats) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.QueryID != that1.QueryID {
		return false
	}
	if that1.Data == nil {
		if this.Data != nil {
			return false
		}
	} else if this.Data == nil {
		return false
	} else if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest_Metadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest_Metadata)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest_Metadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest_Body) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest_Body)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest_Body)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Body.Equal(that1.Body) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest_Error) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest_Error)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest_Error)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Error.Equal(that1.Error) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest_EvaluateQueryResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest_EvaluateQueryResponse)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest_EvaluateQueryResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.EvaluateQueryResponse.Equal(that1.EvaluateQueryResponse) {
		return false
	}
	return true
}
func (this *QueryResultMetadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultMetadata)
	if !ok {
		that2, ok := that.(QueryResultMetadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Code != that1.Code {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if that1.Stats == nil {
		if this.Stats != nil {
			return false
		}
	} else if !this.Stats.Equal(*that1.Stats) {
		return false
	}
	return true
}
func (this *QueryResultBody) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultBody)
	if !ok {
		that2, ok := that.(QueryResultBody)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Chunk, that1.Chunk) {
		return false
	}
	return true
}
func (this *QueryResultResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultResponse)
	if !ok {
		that2, ok := that.(QueryResultResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *QueryResultRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&frontendv2pb.QueryResultRequest{")
	s = append(s, "QueryID: "+fmt.Sprintf("%#v", this.QueryID)+",\n")
	if this.HttpResponse != nil {
		s = append(s, "HttpResponse: "+fmt.Sprintf("%#v", this.HttpResponse)+",\n")
	}
	s = append(s, "Stats: "+fmt.Sprintf("%#v", this.Stats)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultStreamRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&frontendv2pb.QueryResultStreamRequest{")
	s = append(s, "QueryID: "+fmt.Sprintf("%#v", this.QueryID)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultStreamRequest_Metadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&frontendv2pb.QueryResultStreamRequest_Metadata{` +
		`Metadata:` + fmt.Sprintf("%#v", this.Metadata) + `}`}, ", ")
	return s
}
func (this *QueryResultStreamRequest_Body) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&frontendv2pb.QueryResultStreamRequest_Body{` +
		`Body:` + fmt.Sprintf("%#v", this.Body) + `}`}, ", ")
	return s
}
func (this *QueryResultStreamRequest_Error) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&frontendv2pb.QueryResultStreamRequest_Error{` +
		`Error:` + fmt.Sprintf("%#v", this.Error) + `}`}, ", ")
	return s
}
func (this *QueryResultStreamRequest_EvaluateQueryResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&frontendv2pb.QueryResultStreamRequest_EvaluateQueryResponse{` +
		`EvaluateQueryResponse:` + fmt.Sprintf("%#v", this.EvaluateQueryResponse) + `}`}, ", ")
	return s
}
func (this *QueryResultMetadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&frontendv2pb.QueryResultMetadata{")
	s = append(s, "Code: "+fmt.Sprintf("%#v", this.Code)+",\n")
	if this.Headers != nil {
		s = append(s, "Headers: "+fmt.Sprintf("%#v", this.Headers)+",\n")
	}
	s = append(s, "Stats: "+fmt.Sprintf("%#v", this.Stats)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultBody) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&frontendv2pb.QueryResultBody{")
	s = append(s, "Chunk: "+fmt.Sprintf("%#v", this.Chunk)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&frontendv2pb.QueryResultResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringFrontend(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FrontendForQuerierClient is the client API for FrontendForQuerier service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FrontendForQuerierClient interface {
	QueryResult(ctx context.Context, in *QueryResultRequest, opts ...grpc.CallOption) (*QueryResultResponse, error)
	QueryResultStream(ctx context.Context, opts ...grpc.CallOption) (FrontendForQuerier_QueryResultStreamClient, error)
}

type frontendForQuerierClient struct {
	cc *grpc.ClientConn
}

func NewFrontendForQuerierClient(cc *grpc.ClientConn) FrontendForQuerierClient {
	return &frontendForQuerierClient{cc}
}

func (c *frontendForQuerierClient) QueryResult(ctx context.Context, in *QueryResultRequest, opts ...grpc.CallOption) (*QueryResultResponse, error) {
	out := new(QueryResultResponse)
	err := c.cc.Invoke(ctx, "/frontendv2pb.FrontendForQuerier/QueryResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *frontendForQuerierClient) QueryResultStream(ctx context.Context, opts ...grpc.CallOption) (FrontendForQuerier_QueryResultStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_FrontendForQuerier_serviceDesc.Streams[0], "/frontendv2pb.FrontendForQuerier/QueryResultStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &frontendForQuerierQueryResultStreamClient{stream}
	return x, nil
}

type FrontendForQuerier_QueryResultStreamClient interface {
	Send(*QueryResultStreamRequest) error
	CloseAndRecv() (*QueryResultResponse, error)
	grpc.ClientStream
}

type frontendForQuerierQueryResultStreamClient struct {
	grpc.ClientStream
}

func (x *frontendForQuerierQueryResultStreamClient) Send(m *QueryResultStreamRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *frontendForQuerierQueryResultStreamClient) CloseAndRecv() (*QueryResultResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(QueryResultResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// FrontendForQuerierServer is the server API for FrontendForQuerier service.
type FrontendForQuerierServer interface {
	QueryResult(context.Context, *QueryResultRequest) (*QueryResultResponse, error)
	QueryResultStream(FrontendForQuerier_QueryResultStreamServer) error
}

// UnimplementedFrontendForQuerierServer can be embedded to have forward compatible implementations.
type UnimplementedFrontendForQuerierServer struct {
}

func (*UnimplementedFrontendForQuerierServer) QueryResult(ctx context.Context, req *QueryResultRequest) (*QueryResultResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryResult not implemented")
}
func (*UnimplementedFrontendForQuerierServer) QueryResultStream(srv FrontendForQuerier_QueryResultStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method QueryResultStream not implemented")
}

func RegisterFrontendForQuerierServer(s *grpc.Server, srv FrontendForQuerierServer) {
	s.RegisterService(&_FrontendForQuerier_serviceDesc, srv)
}

func _FrontendForQuerier_QueryResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FrontendForQuerierServer).QueryResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/frontendv2pb.FrontendForQuerier/QueryResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FrontendForQuerierServer).QueryResult(ctx, req.(*QueryResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FrontendForQuerier_QueryResultStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FrontendForQuerierServer).QueryResultStream(&frontendForQuerierQueryResultStreamServer{stream})
}

type FrontendForQuerier_QueryResultStreamServer interface {
	SendAndClose(*QueryResultResponse) error
	Recv() (*QueryResultStreamRequest, error)
	grpc.ServerStream
}

type frontendForQuerierQueryResultStreamServer struct {
	grpc.ServerStream
}

func (x *frontendForQuerierQueryResultStreamServer) SendAndClose(m *QueryResultResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *frontendForQuerierQueryResultStreamServer) Recv() (*QueryResultStreamRequest, error) {
	m := new(QueryResultStreamRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _FrontendForQuerier_serviceDesc = grpc.ServiceDesc{
	ServiceName: "frontendv2pb.FrontendForQuerier",
	HandlerType: (*FrontendForQuerierServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryResult",
			Handler:    _FrontendForQuerier_QueryResult_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "QueryResultStream",
			Handler:       _FrontendForQuerier_QueryResultStream_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "frontend.proto",
}

func (m *QueryResultRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size := m.Stats.Size()
			i -= size
			if _, err := m.Stats.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.HttpResponse != nil {
		{
			size, err := m.HttpResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.QueryID != 0 {
		i = encodeVarintFrontend(dAtA, i, uint64(m.QueryID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultStreamRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultStreamRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		{
			size := m.Data.Size()
			i -= size
			if _, err := m.Data.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.QueryID != 0 {
		i = encodeVarintFrontend(dAtA, i, uint64(m.QueryID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultStreamRequest_Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest_Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *QueryResultStreamRequest_Body) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest_Body) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Body != nil {
		{
			size, err := m.Body.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *QueryResultStreamRequest_Error) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest_Error) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *QueryResultStreamRequest_EvaluateQueryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest_EvaluateQueryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.EvaluateQueryResponse != nil {
		{
			size, err := m.EvaluateQueryResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *QueryResultMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size := m.Stats.Size()
			i -= size
			if _, err := m.Stats.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintFrontend(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Code != 0 {
		i = encodeVarintFrontend(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultBody) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultBody) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultBody) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Chunk) > 0 {
		i -= len(m.Chunk)
		copy(dAtA[i:], m.Chunk)
		i = encodeVarintFrontend(dAtA, i, uint64(len(m.Chunk)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func encodeVarintFrontend(dAtA []byte, offset int, v uint64) int {
	offset -= sovFrontend(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueryResultRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryID != 0 {
		n += 1 + sovFrontend(uint64(m.QueryID))
	}
	if m.HttpResponse != nil {
		l = m.HttpResponse.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}

func (m *QueryResultStreamRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryID != 0 {
		n += 1 + sovFrontend(uint64(m.QueryID))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	return n
}

func (m *QueryResultStreamRequest_Metadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}
func (m *QueryResultStreamRequest_Body) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Body != nil {
		l = m.Body.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}
func (m *QueryResultStreamRequest_Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}
func (m *QueryResultStreamRequest_EvaluateQueryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EvaluateQueryResponse != nil {
		l = m.EvaluateQueryResponse.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}
func (m *QueryResultMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovFrontend(uint64(m.Code))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovFrontend(uint64(l))
		}
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}

func (m *QueryResultBody) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Chunk)
	if l > 0 {
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}

func (m *QueryResultResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovFrontend(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozFrontend(x uint64) (n int) {
	return sovFrontend(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QueryResultRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultRequest{`,
		`QueryID:` + fmt.Sprintf("%v", this.QueryID) + `,`,
		`HttpResponse:` + strings.Replace(fmt.Sprintf("%v", this.HttpResponse), "HTTPResponse", "httpgrpc.HTTPResponse", 1) + `,`,
		`Stats:` + fmt.Sprintf("%v", this.Stats) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest{`,
		`QueryID:` + fmt.Sprintf("%v", this.QueryID) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest_Metadata) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest_Metadata{`,
		`Metadata:` + strings.Replace(fmt.Sprintf("%v", this.Metadata), "QueryResultMetadata", "QueryResultMetadata", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest_Body) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest_Body{`,
		`Body:` + strings.Replace(fmt.Sprintf("%v", this.Body), "QueryResultBody", "QueryResultBody", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest_Error) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest_Error{`,
		`Error:` + strings.Replace(fmt.Sprintf("%v", this.Error), "Error", "querierpb.Error", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest_EvaluateQueryResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest_EvaluateQueryResponse{`,
		`EvaluateQueryResponse:` + strings.Replace(fmt.Sprintf("%v", this.EvaluateQueryResponse), "EvaluateQueryResponse", "querierpb.EvaluateQueryResponse", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultMetadata) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHeaders := "[]*Header{"
	for _, f := range this.Headers {
		repeatedStringForHeaders += strings.Replace(fmt.Sprintf("%v", f), "Header", "httpgrpc.Header", 1) + ","
	}
	repeatedStringForHeaders += "}"
	s := strings.Join([]string{`&QueryResultMetadata{`,
		`Code:` + fmt.Sprintf("%v", this.Code) + `,`,
		`Headers:` + repeatedStringForHeaders + `,`,
		`Stats:` + fmt.Sprintf("%v", this.Stats) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultBody) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultBody{`,
		`Chunk:` + fmt.Sprintf("%v", this.Chunk) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultResponse{`,
		`}`,
	}, "")
	return s
}
func valueToStringFrontend(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QueryResultRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryID", wireType)
			}
			m.QueryID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.QueryID |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpResponse == nil {
				m.HttpResponse = &httpgrpc.HTTPResponse{}
			}
			if err := m.HttpResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &github_com_grafana_mimir_pkg_querier_stats.SafeStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultStreamRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultStreamRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultStreamRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryID", wireType)
			}
			m.QueryID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.QueryID |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryResultMetadata{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &QueryResultStreamRequest_Metadata{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryResultBody{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &QueryResultStreamRequest_Body{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &querierpb.Error{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &QueryResultStreamRequest_Error{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EvaluateQueryResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &querierpb.EvaluateQueryResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &QueryResultStreamRequest_EvaluateQueryResponse{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &httpgrpc.Header{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &github_com_grafana_mimir_pkg_querier_stats.SafeStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultBody) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultBody: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultBody: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunk", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Chunk = append(m.Chunk[:0], dAtA[iNdEx:postIndex]...)
			if m.Chunk == nil {
				m.Chunk = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipFrontend(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthFrontend
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupFrontend
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthFrontend
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthFrontend        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowFrontend          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupFrontend = fmt.Errorf("proto: unexpected end of group")
)
