/**
 * @file coeftab_s.h
 *
 * Precision dependent coeficient array header.
 *
 * @copyright 2012-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author David Goudin
 * @author Pascal Henon
 * @author Francois Pellegrini
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Xavier Lacoste
 * @author Esragul Korkmaz
 * @author Gregoire Pichon
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/sopalin/coeftab_z.h, normal z -> s, Thu Oct 23 06:51:46 2025
 *
 * @addtogroup coeftab
 * @{
 *
 **/
#ifndef _coeftab_s_h_
#define _coeftab_s_h_

/**
 *    @name PastixFloat compression/uncompression routines
 *    @{
 */
pastix_int_t coeftab_scompress  ( SolverMatrix *solvmtx );
void         coeftab_suncompress( SolverMatrix *solvmtx );
void         coeftab_smemory    ( const SolverMatrix *solvmtx,
                                  const pastix_int_t *iparm,
                                  pastix_fixdbl_t    *dparm );

/**
 *    @}
 *    @name PastixFloat Extraction routines
 *    @{
 */
void coeftab_sgetschur( const SolverMatrix *solvmtx,
                        float *S, pastix_int_t lds );

void coeftab_sgetdiag( const SolverMatrix *solvmtx,
                       float *D, pastix_int_t incD );

/**
 *    @}
 *    @name PastixFloat debug routines
 *    @{
 */
void coeftab_sdump( pastix_data_t      *pastix_data,
                    const SolverMatrix *solvmtx,
                    const char         *filename );
void cpucblk_sdumpfile( pastix_coefside_t side,
                        SolverCblk       *cblk,
                        pastix_int_t      itercblk,
                        const char       *directory );
int  coeftab_sdiff( pastix_coefside_t   side,
                    const SolverMatrix *solvA,
                    SolverMatrix       *solvB );

/**
 *    @}
 */
#endif /* _coeftab_s_h_ */

/**
 * @}
 */
