// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewRegisterLinkedClusterParams creates a new RegisterLinkedClusterParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRegisterLinkedClusterParams() *RegisterLinkedClusterParams {
	return &RegisterLinkedClusterParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRegisterLinkedClusterParamsWithTimeout creates a new RegisterLinkedClusterParams object
// with the ability to set a timeout on a request.
func NewRegisterLinkedClusterParamsWithTimeout(timeout time.Duration) *RegisterLinkedClusterParams {
	return &RegisterLinkedClusterParams{
		timeout: timeout,
	}
}

// NewRegisterLinkedClusterParamsWithContext creates a new RegisterLinkedClusterParams object
// with the ability to set a context for a request.
func NewRegisterLinkedClusterParamsWithContext(ctx context.Context) *RegisterLinkedClusterParams {
	return &RegisterLinkedClusterParams{
		Context: ctx,
	}
}

// NewRegisterLinkedClusterParamsWithHTTPClient creates a new RegisterLinkedClusterParams object
// with the ability to set a custom HTTPClient for a request.
func NewRegisterLinkedClusterParamsWithHTTPClient(client *http.Client) *RegisterLinkedClusterParams {
	return &RegisterLinkedClusterParams{
		HTTPClient: client,
	}
}

/*
RegisterLinkedClusterParams contains all the parameters to send to the API endpoint

	for the register linked cluster operation.

	Typically these are written to a http.Request.
*/
type RegisterLinkedClusterParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125RegisterLinkedClusterRequest

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the register linked cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RegisterLinkedClusterParams) WithDefaults() *RegisterLinkedClusterParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the register linked cluster params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RegisterLinkedClusterParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the register linked cluster params
func (o *RegisterLinkedClusterParams) WithTimeout(timeout time.Duration) *RegisterLinkedClusterParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the register linked cluster params
func (o *RegisterLinkedClusterParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the register linked cluster params
func (o *RegisterLinkedClusterParams) WithContext(ctx context.Context) *RegisterLinkedClusterParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the register linked cluster params
func (o *RegisterLinkedClusterParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the register linked cluster params
func (o *RegisterLinkedClusterParams) WithHTTPClient(client *http.Client) *RegisterLinkedClusterParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the register linked cluster params
func (o *RegisterLinkedClusterParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the register linked cluster params
func (o *RegisterLinkedClusterParams) WithBody(body *models.HashicorpCloudVault20201125RegisterLinkedClusterRequest) *RegisterLinkedClusterParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the register linked cluster params
func (o *RegisterLinkedClusterParams) SetBody(body *models.HashicorpCloudVault20201125RegisterLinkedClusterRequest) {
	o.Body = body
}

// WithLocationOrganizationID adds the locationOrganizationID to the register linked cluster params
func (o *RegisterLinkedClusterParams) WithLocationOrganizationID(locationOrganizationID string) *RegisterLinkedClusterParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the register linked cluster params
func (o *RegisterLinkedClusterParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the register linked cluster params
func (o *RegisterLinkedClusterParams) WithLocationProjectID(locationProjectID string) *RegisterLinkedClusterParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the register linked cluster params
func (o *RegisterLinkedClusterParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *RegisterLinkedClusterParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
