// python wrapper for vtkRedistributeDataSetFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkRedistributeDataSetFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkRedistributeDataSetFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkRedistributeDataSetFilter_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkRedistributeDataSetFilter_BoundaryModes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersParallelDIY2.vtkRedistributeDataSetFilter.BoundaryModes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkRedistributeDataSetFilter_BoundaryModes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkRedistributeDataSetFilter_BoundaryModes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkRedistributeDataSetFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkRedistributeDataSetFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkRedistributeDataSetFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkRedistributeDataSetFilter *tempr = vtkRedistributeDataSetFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRedistributeDataSetFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkRedistributeDataSetFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkRedistributeDataSetFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkRedistributeDataSetFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkRedistributeDataSetFilter::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkRedistributeDataSetFilter::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetBoundaryMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoundaryMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBoundaryMode(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetBoundaryMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetBoundaryModeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoundaryModeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBoundaryModeMinValue() :
      op->vtkRedistributeDataSetFilter::GetBoundaryModeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetBoundaryModeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoundaryModeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBoundaryModeMaxValue() :
      op->vtkRedistributeDataSetFilter::GetBoundaryModeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetBoundaryMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBoundaryMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBoundaryMode() :
      op->vtkRedistributeDataSetFilter::GetBoundaryMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetBoundaryModeToAssignToOneRegion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoundaryModeToAssignToOneRegion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetBoundaryModeToAssignToOneRegion();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetBoundaryModeToAssignToOneRegion();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetBoundaryModeToAssignToAllIntersectingRegions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoundaryModeToAssignToAllIntersectingRegions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetBoundaryModeToAssignToAllIntersectingRegions();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetBoundaryModeToAssignToAllIntersectingRegions();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetBoundaryModeToSplitBoundaryCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoundaryModeToSplitBoundaryCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetBoundaryModeToSplitBoundaryCells();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetBoundaryModeToSplitBoundaryCells();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetUseExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseExplicitCuts(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetUseExplicitCuts(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetUseExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseExplicitCuts() :
      op->vtkRedistributeDataSetFilter::GetUseExplicitCuts());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_UseExplicitCutsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseExplicitCutsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseExplicitCutsOn();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::UseExplicitCutsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_UseExplicitCutsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseExplicitCutsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseExplicitCutsOff();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::UseExplicitCutsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_RemoveAllExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllExplicitCuts();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::RemoveAllExplicitCuts();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_AddExplicitCut_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddExplicitCut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  vtkBoundingBox *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkBoundingBox"))
  {
    if (ap.IsBound())
    {
      op->AddExplicitCut(*temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::AddExplicitCut(*temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyObject *
PyvtkRedistributeDataSetFilter_AddExplicitCut_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddExplicitCut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->AddExplicitCut(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::AddExplicitCut(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkRedistributeDataSetFilter_AddExplicitCut_Methods[] = {
  {"AddExplicitCut", PyvtkRedistributeDataSetFilter_AddExplicitCut_s1, METH_VARARGS,
   "@W vtkBoundingBox"},
  {"AddExplicitCut", PyvtkRedistributeDataSetFilter_AddExplicitCut_s2, METH_VARARGS,
   "@P *d"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkRedistributeDataSetFilter_AddExplicitCut(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkRedistributeDataSetFilter_AddExplicitCut_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddExplicitCut");
  return nullptr;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetNumberOfExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfExplicitCuts() :
      op->vtkRedistributeDataSetFilter::GetNumberOfExplicitCuts());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetExplicitCut(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExplicitCut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const vtkBoundingBox *tempr = (ap.IsBound() ?
      &op->GetExplicitCut(temp0) :
      &op->vtkRedistributeDataSetFilter::GetExplicitCut(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkBoundingBox");
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetExpandExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExpandExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExpandExplicitCuts(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetExpandExplicitCuts(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetExpandExplicitCuts(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExpandExplicitCuts");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExpandExplicitCuts() :
      op->vtkRedistributeDataSetFilter::GetExpandExplicitCuts());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_ExpandExplicitCutsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExpandExplicitCutsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExpandExplicitCutsOn();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::ExpandExplicitCutsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_ExpandExplicitCutsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExpandExplicitCutsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExpandExplicitCutsOff();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::ExpandExplicitCutsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetNumberOfPartitions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfPartitions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfPartitions(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetNumberOfPartitions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetNumberOfPartitions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPartitions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfPartitions() :
      op->vtkRedistributeDataSetFilter::GetNumberOfPartitions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetPreservePartitionsInOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreservePartitionsInOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPreservePartitionsInOutput(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetPreservePartitionsInOutput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetPreservePartitionsInOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreservePartitionsInOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPreservePartitionsInOutput() :
      op->vtkRedistributeDataSetFilter::GetPreservePartitionsInOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_PreservePartitionsInOutputOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PreservePartitionsInOutputOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PreservePartitionsInOutputOn();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::PreservePartitionsInOutputOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_PreservePartitionsInOutputOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PreservePartitionsInOutputOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PreservePartitionsInOutputOff();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::PreservePartitionsInOutputOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetGenerateGlobalCellIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateGlobalCellIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateGlobalCellIds(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetGenerateGlobalCellIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetGenerateGlobalCellIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateGlobalCellIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateGlobalCellIds() :
      op->vtkRedistributeDataSetFilter::GetGenerateGlobalCellIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GenerateGlobalCellIdsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateGlobalCellIdsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateGlobalCellIdsOn();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::GenerateGlobalCellIdsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GenerateGlobalCellIdsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateGlobalCellIdsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateGlobalCellIdsOff();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::GenerateGlobalCellIdsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetEnableDebugging(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableDebugging");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableDebugging(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetEnableDebugging(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetEnableDebugging(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableDebugging");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableDebugging() :
      op->vtkRedistributeDataSetFilter::GetEnableDebugging());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_EnableDebuggingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableDebuggingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableDebuggingOn();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::EnableDebuggingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_EnableDebuggingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableDebuggingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableDebuggingOff();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::EnableDebuggingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetLoadBalanceAcrossAllBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLoadBalanceAcrossAllBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLoadBalanceAcrossAllBlocks(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetLoadBalanceAcrossAllBlocks(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetLoadBalanceAcrossAllBlocks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLoadBalanceAcrossAllBlocks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLoadBalanceAcrossAllBlocks() :
      op->vtkRedistributeDataSetFilter::GetLoadBalanceAcrossAllBlocks());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_LoadBalanceAcrossAllBlocksOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadBalanceAcrossAllBlocksOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadBalanceAcrossAllBlocksOn();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::LoadBalanceAcrossAllBlocksOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_LoadBalanceAcrossAllBlocksOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadBalanceAcrossAllBlocksOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->LoadBalanceAcrossAllBlocksOff();
    }
    else
    {
      op->vtkRedistributeDataSetFilter::LoadBalanceAcrossAllBlocksOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_GetStrategy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStrategy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPartitioningStrategy *tempr = (ap.IsBound() ?
      op->GetStrategy() :
      op->vtkRedistributeDataSetFilter::GetStrategy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRedistributeDataSetFilter_SetStrategy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStrategy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRedistributeDataSetFilter *op = static_cast<vtkRedistributeDataSetFilter *>(vp);

  vtkPartitioningStrategy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPartitioningStrategy"))
  {
    if (ap.IsBound())
    {
      op->SetStrategy(temp0);
    }
    else
    {
      op->vtkRedistributeDataSetFilter::SetStrategy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkRedistributeDataSetFilter_Methods[] = {
  {"IsTypeOf", PyvtkRedistributeDataSetFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkRedistributeDataSetFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkRedistributeDataSetFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkRedistributeDataSetFilter\nC++: static vtkRedistributeDataSetFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkRedistributeDataSetFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkRedistributeDataSetFilter\nC++: vtkRedistributeDataSetFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkRedistributeDataSetFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkRedistributeDataSetFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetMTime", PyvtkRedistributeDataSetFilter_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nNecessary to override this in order to take into account\nmodifications to strategy\n"},
  {"SetController", PyvtkRedistributeDataSetFilter_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *)\n\nGet/Set the controller to use. By default\nvtkMultiProcessController::GlobalController will be used.\n"},
  {"GetController", PyvtkRedistributeDataSetFilter_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetBoundaryMode", PyvtkRedistributeDataSetFilter_SetBoundaryMode, METH_VARARGS,
   "SetBoundaryMode(self, _arg:int) -> None\nC++: virtual void SetBoundaryMode(int _arg)\n\nSpecify how cells on the boundaries are handled.\n\n\\li `ASSIGN_TO_ONE_REGION` results in a cell on the boundary\n    uniquely added\n     to one of the ranks containing the region intersecting the\ncell.\n\\li `ASSIGN_TO_ALL_INTERSECTING_REGIONS` results in a cell on the\nboundary\n     added to all ranks containing the region intersecting the\ncell.\n\\li `SPLIT_BOUNDARY_CELLS` results in cells along the boundary\n    being\n     clipped along the region boundaries.\n\nDefault is `ASSIGN_TO_ONE_REGION`.\n"},
  {"GetBoundaryModeMinValue", PyvtkRedistributeDataSetFilter_GetBoundaryModeMinValue, METH_VARARGS,
   "GetBoundaryModeMinValue(self) -> int\nC++: virtual int GetBoundaryModeMinValue()\n\n"},
  {"GetBoundaryModeMaxValue", PyvtkRedistributeDataSetFilter_GetBoundaryModeMaxValue, METH_VARARGS,
   "GetBoundaryModeMaxValue(self) -> int\nC++: virtual int GetBoundaryModeMaxValue()\n\n"},
  {"GetBoundaryMode", PyvtkRedistributeDataSetFilter_GetBoundaryMode, METH_VARARGS,
   "GetBoundaryMode(self) -> int\nC++: virtual int GetBoundaryMode()\n\n"},
  {"SetBoundaryModeToAssignToOneRegion", PyvtkRedistributeDataSetFilter_SetBoundaryModeToAssignToOneRegion, METH_VARARGS,
   "SetBoundaryModeToAssignToOneRegion(self) -> None\nC++: void SetBoundaryModeToAssignToOneRegion()\n\n"},
  {"SetBoundaryModeToAssignToAllIntersectingRegions", PyvtkRedistributeDataSetFilter_SetBoundaryModeToAssignToAllIntersectingRegions, METH_VARARGS,
   "SetBoundaryModeToAssignToAllIntersectingRegions(self) -> None\nC++: void SetBoundaryModeToAssignToAllIntersectingRegions()\n\n"},
  {"SetBoundaryModeToSplitBoundaryCells", PyvtkRedistributeDataSetFilter_SetBoundaryModeToSplitBoundaryCells, METH_VARARGS,
   "SetBoundaryModeToSplitBoundaryCells(self) -> None\nC++: void SetBoundaryModeToSplitBoundaryCells()\n\n"},
  {"SetUseExplicitCuts", PyvtkRedistributeDataSetFilter_SetUseExplicitCuts, METH_VARARGS,
   "SetUseExplicitCuts(self, __a:bool) -> None\nC++: void SetUseExplicitCuts(bool)\n\nSpecify whether to compute the load balancing automatically or\nuse explicitly provided cuts. Set to false (default) to\nautomatically compute the cuts to use for redistributing the\ndataset.\n"},
  {"GetUseExplicitCuts", PyvtkRedistributeDataSetFilter_GetUseExplicitCuts, METH_VARARGS,
   "GetUseExplicitCuts(self) -> bool\nC++: bool GetUseExplicitCuts()\n\n"},
  {"UseExplicitCutsOn", PyvtkRedistributeDataSetFilter_UseExplicitCutsOn, METH_VARARGS,
   "UseExplicitCutsOn(self) -> None\nC++: virtual void UseExplicitCutsOn()\n\n"},
  {"UseExplicitCutsOff", PyvtkRedistributeDataSetFilter_UseExplicitCutsOff, METH_VARARGS,
   "UseExplicitCutsOff(self) -> None\nC++: virtual void UseExplicitCutsOff()\n\n"},
  {"RemoveAllExplicitCuts", PyvtkRedistributeDataSetFilter_RemoveAllExplicitCuts, METH_VARARGS,
   "RemoveAllExplicitCuts(self) -> None\nC++: void RemoveAllExplicitCuts()\n\n"},
  {"AddExplicitCut", PyvtkRedistributeDataSetFilter_AddExplicitCut, METH_VARARGS,
   "AddExplicitCut(self, bbox:vtkBoundingBox) -> None\nC++: void AddExplicitCut(const vtkBoundingBox &bbox)\nAddExplicitCut(self, bbox:(float, float, float, float, float,\n    float)) -> None\nC++: void AddExplicitCut(const double bbox[6])\n\n"},
  {"GetNumberOfExplicitCuts", PyvtkRedistributeDataSetFilter_GetNumberOfExplicitCuts, METH_VARARGS,
   "GetNumberOfExplicitCuts(self) -> int\nC++: int GetNumberOfExplicitCuts()\n\n"},
  {"GetExplicitCut", PyvtkRedistributeDataSetFilter_GetExplicitCut, METH_VARARGS,
   "GetExplicitCut(self, index:int) -> vtkBoundingBox\nC++: const vtkBoundingBox &GetExplicitCut(int index)\n\n"},
  {"SetExpandExplicitCuts", PyvtkRedistributeDataSetFilter_SetExpandExplicitCuts, METH_VARARGS,
   "SetExpandExplicitCuts(self, __a:bool) -> None\nC++: void SetExpandExplicitCuts(bool)\n\nWhen using explicit cuts, it possible that the bounding box\ndefined by all the cuts is smaller than the input's bounds. In\nthat case, the filter can automatically expand the edge boxes to\ninclude the input bounds to avoid clipping of the input dataset\non the external faces of the combined bounding box.\n\nDefault is true, that is explicit cuts will automatically be\nexpanded.\n"},
  {"GetExpandExplicitCuts", PyvtkRedistributeDataSetFilter_GetExpandExplicitCuts, METH_VARARGS,
   "GetExpandExplicitCuts(self) -> bool\nC++: bool GetExpandExplicitCuts()\n\n"},
  {"ExpandExplicitCutsOn", PyvtkRedistributeDataSetFilter_ExpandExplicitCutsOn, METH_VARARGS,
   "ExpandExplicitCutsOn(self) -> None\nC++: virtual void ExpandExplicitCutsOn()\n\n"},
  {"ExpandExplicitCutsOff", PyvtkRedistributeDataSetFilter_ExpandExplicitCutsOff, METH_VARARGS,
   "ExpandExplicitCutsOff(self) -> None\nC++: virtual void ExpandExplicitCutsOff()\n\n"},
  {"SetNumberOfPartitions", PyvtkRedistributeDataSetFilter_SetNumberOfPartitions, METH_VARARGS,
   "SetNumberOfPartitions(self, __a:int) -> None\nC++: void SetNumberOfPartitions(vtkIdType)\n\nSpecify the number of partitions to split the input dataset into.\nSet to -1 to indicate that the partitions should match the number\nof ranks (processes) determined using vtkMultiProcessController\nprovided. Setting to a non-zero positive number will result in\nthe filter generating at least as many partitions.\n\nThis is simply a hint and not an exact number of partitions the\ndata will be split into.\n\nDefault is -1.\n\n@sa PreservePartitionsInOutput\n"},
  {"GetNumberOfPartitions", PyvtkRedistributeDataSetFilter_GetNumberOfPartitions, METH_VARARGS,
   "GetNumberOfPartitions(self) -> int\nC++: vtkIdType GetNumberOfPartitions()\n\n"},
  {"SetPreservePartitionsInOutput", PyvtkRedistributeDataSetFilter_SetPreservePartitionsInOutput, METH_VARARGS,
   "SetPreservePartitionsInOutput(self, _arg:bool) -> None\nC++: virtual void SetPreservePartitionsInOutput(bool _arg)\n\nWhen set to true (default is false), this filter will generate a\nvtkPartitionedDataSet as the output. The advantage of doing that\nis each partition that the input dataset was split into can be\nindividually accessed. Otherwise, when the number of partitions\ngenerated is greater than the number of ranks, a rank with more\nthan one partition will use `vtkAppendFilter` to merge the\nmultiple partitions into a single unstructured grid.\n\nThe output dataset type is always vtkUnstructuredGrid when\nPreservePartitionsInOutput is false and always a\nvtkPartitionedDataSet when PreservePartitionsInOutput is true.\n\nDefault is false i.e. the filter will generate a single\nvtkUnstructuredGrid.\n"},
  {"GetPreservePartitionsInOutput", PyvtkRedistributeDataSetFilter_GetPreservePartitionsInOutput, METH_VARARGS,
   "GetPreservePartitionsInOutput(self) -> bool\nC++: virtual bool GetPreservePartitionsInOutput()\n\n"},
  {"PreservePartitionsInOutputOn", PyvtkRedistributeDataSetFilter_PreservePartitionsInOutputOn, METH_VARARGS,
   "PreservePartitionsInOutputOn(self) -> None\nC++: virtual void PreservePartitionsInOutputOn()\n\n"},
  {"PreservePartitionsInOutputOff", PyvtkRedistributeDataSetFilter_PreservePartitionsInOutputOff, METH_VARARGS,
   "PreservePartitionsInOutputOff(self) -> None\nC++: virtual void PreservePartitionsInOutputOff()\n\n"},
  {"SetGenerateGlobalCellIds", PyvtkRedistributeDataSetFilter_SetGenerateGlobalCellIds, METH_VARARGS,
   "SetGenerateGlobalCellIds(self, _arg:bool) -> None\nC++: virtual void SetGenerateGlobalCellIds(bool _arg)\n\nGenerate global cell ids if none present in the input. If global\ncell ids are present in the input then this flag is ignored.\nDefault is true.\n"},
  {"GetGenerateGlobalCellIds", PyvtkRedistributeDataSetFilter_GetGenerateGlobalCellIds, METH_VARARGS,
   "GetGenerateGlobalCellIds(self) -> bool\nC++: virtual bool GetGenerateGlobalCellIds()\n\n"},
  {"GenerateGlobalCellIdsOn", PyvtkRedistributeDataSetFilter_GenerateGlobalCellIdsOn, METH_VARARGS,
   "GenerateGlobalCellIdsOn(self) -> None\nC++: virtual void GenerateGlobalCellIdsOn()\n\n"},
  {"GenerateGlobalCellIdsOff", PyvtkRedistributeDataSetFilter_GenerateGlobalCellIdsOff, METH_VARARGS,
   "GenerateGlobalCellIdsOff(self) -> None\nC++: virtual void GenerateGlobalCellIdsOff()\n\n"},
  {"SetEnableDebugging", PyvtkRedistributeDataSetFilter_SetEnableDebugging, METH_VARARGS,
   "SetEnableDebugging(self, _arg:bool) -> None\nC++: virtual void SetEnableDebugging(bool _arg)\n\nEnable/disable debugging mode. In this mode internal arrays are\npreserved and ghost cells are not explicitly marked as such so\nthat they can be inspected without risk of being dropped or\nremoved by the pipeline.\n\nDefault is false.\n"},
  {"GetEnableDebugging", PyvtkRedistributeDataSetFilter_GetEnableDebugging, METH_VARARGS,
   "GetEnableDebugging(self) -> bool\nC++: virtual bool GetEnableDebugging()\n\n"},
  {"EnableDebuggingOn", PyvtkRedistributeDataSetFilter_EnableDebuggingOn, METH_VARARGS,
   "EnableDebuggingOn(self) -> None\nC++: virtual void EnableDebuggingOn()\n\n"},
  {"EnableDebuggingOff", PyvtkRedistributeDataSetFilter_EnableDebuggingOff, METH_VARARGS,
   "EnableDebuggingOff(self) -> None\nC++: virtual void EnableDebuggingOff()\n\n"},
  {"SetLoadBalanceAcrossAllBlocks", PyvtkRedistributeDataSetFilter_SetLoadBalanceAcrossAllBlocks, METH_VARARGS,
   "SetLoadBalanceAcrossAllBlocks(self, __a:bool) -> None\nC++: void SetLoadBalanceAcrossAllBlocks(bool)\n\nWhen UseExplicitCuts is false, and input is a\n`vtkPartitionedDataSetCollection`, set this to true to generate\ncuts for load balancing using all the datasets in the\nvtkPartitionedDataSetCollection.\n\nDefault is true.\n"},
  {"GetLoadBalanceAcrossAllBlocks", PyvtkRedistributeDataSetFilter_GetLoadBalanceAcrossAllBlocks, METH_VARARGS,
   "GetLoadBalanceAcrossAllBlocks(self) -> bool\nC++: bool GetLoadBalanceAcrossAllBlocks()\n\n"},
  {"LoadBalanceAcrossAllBlocksOn", PyvtkRedistributeDataSetFilter_LoadBalanceAcrossAllBlocksOn, METH_VARARGS,
   "LoadBalanceAcrossAllBlocksOn(self) -> None\nC++: virtual void LoadBalanceAcrossAllBlocksOn()\n\n"},
  {"LoadBalanceAcrossAllBlocksOff", PyvtkRedistributeDataSetFilter_LoadBalanceAcrossAllBlocksOff, METH_VARARGS,
   "LoadBalanceAcrossAllBlocksOff(self) -> None\nC++: virtual void LoadBalanceAcrossAllBlocksOff()\n\n"},
  {"GetStrategy", PyvtkRedistributeDataSetFilter_GetStrategy, METH_VARARGS,
   "GetStrategy(self) -> vtkPartitioningStrategy\nC++: vtkPartitioningStrategy *GetStrategy()\n\nSetter/Getter for Strategy\n"},
  {"SetStrategy", PyvtkRedistributeDataSetFilter_SetStrategy, METH_VARARGS,
   "SetStrategy(self, __a:vtkPartitioningStrategy) -> None\nC++: void SetStrategy(vtkPartitioningStrategy *)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkRedistributeDataSetFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("boundary_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetBoundaryMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetBoundaryMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetBoundaryMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBoundaryMode/SetBoundaryMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_explicit_cuts"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetUseExplicitCuts(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetUseExplicitCuts(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetUseExplicitCuts(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseExplicitCuts/SetUseExplicitCuts\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("expand_explicit_cuts"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetExpandExplicitCuts(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetExpandExplicitCuts(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetExpandExplicitCuts(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExpandExplicitCuts/SetExpandExplicitCuts\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("preserve_partitions_in_output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetPreservePartitionsInOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetPreservePartitionsInOutput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetPreservePartitionsInOutput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPreservePartitionsInOutput/SetPreservePartitionsInOutput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_global_cell_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetGenerateGlobalCellIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetGenerateGlobalCellIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetGenerateGlobalCellIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateGlobalCellIds/SetGenerateGlobalCellIds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_debugging"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetEnableDebugging(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetEnableDebugging(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetEnableDebugging(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableDebugging/SetEnableDebugging\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("load_balance_across_all_blocks"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetLoadBalanceAcrossAllBlocks(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetLoadBalanceAcrossAllBlocks(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetLoadBalanceAcrossAllBlocks(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLoadBalanceAcrossAllBlocks/SetLoadBalanceAcrossAllBlocks\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("strategy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetStrategy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetStrategy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetStrategy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStrategy/SetStrategy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_partitions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRedistributeDataSetFilter_GetNumberOfPartitions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRedistributeDataSetFilter_SetNumberOfPartitions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRedistributeDataSetFilter_SetNumberOfPartitions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfPartitions/SetNumberOfPartitions\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkRedistributeDataSetFilter_Doc =
  "vtkRedistributeDataSetFilter - redistributes input dataset into\nrequested number of partitions\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkRedistributeDataSetFilter is intended for redistributing data in a\n"
  "load balanced fashion.\n\n"
  "The filter allows users to pick how cells along the boundary of the\n"
  "cuts either automatically generated or explicitly specified are to be\n"
  "distributed using `BoundaryMode`. One can choose to assign those\n"
  "cells uniquely to one of those regions or duplicate then on all\n"
  "regions or split the cells (using vtkTableBasedClipDataSet filter).\n"
  "When cells are duplicated along the boundary,  the filter will mark\n"
  "the duplicated cells as `vtkDataSetAttributes::DUPLICATECELL`\n"
  "correctly on all but one of the partitions using the ghost cell array\n"
  "(@sa `vtkDataSetAttributes::GhostArrayName`).\n\n"
  "@warning Generated duplicate ghost cells do not span entire layers of\n"
  "ghosts.\n"
  "They are sparse, only appearing where cells overlap at the new\n"
  "boundaries between partitions. If one wants to have full layers of\n"
  "ghost cells, one should use `vtkGhostCellsGenerator`.\n\n"
  "Besides redistributing the data, the filter can optionally generate\n"
  "global cell ids. This is provided since it relative easy to generate\n"
  "these on when it is known that the data is spatially partitioned as\n"
  "is the case after this filter has executed.\n\n"
  "@section vtkRedistributeDataSetFilter-SupportedDataTypes  Supported\n"
  "Data Types\n\n"
  "vtkRedistributeDataSetFilter is primarily intended for unstructured\n"
  "datasets i.e. vtkUnstructuredGrid, vtkPolyData and composite datasets\n"
  "comprising of the same. It will work when applied to structured\n"
  "datasets as well, however, it results in conversion of the dataset to\n"
  "an unstructured grid -- which is often not suitable.\n\n"
  "For composite datasets, the filter supports `vtkPartitionedDataSet`\n"
  "and `vtkPartitionedDataSetCollection`. When input is a\n"
  "`vtkPartitionedDataSetCollection`, you can set\n"
  "`LoadBalanceAcrossAllBlocks` to true to build the load balancing\n"
  "KdTree using all vtkPartitionedDataSets in the collection. Default is\n"
  "load balance each `vtkPartitionedDataSet` separately.\n\n"
  "For `vtkMultiBlockDataSet`, the filter internally uses\n"
  "`vtkDataAssemblyUtilities` to convert the vtkMultiBlockDataSet to a\n"
  "vtkPartitionedDataSetCollection and back.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkRedistributeDataSetFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersParallelDIY2.vtkRedistributeDataSetFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkRedistributeDataSetFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkRedistributeDataSetFilter_StaticNew()
{
  return vtkRedistributeDataSetFilter::New();
}

PyObject *PyvtkRedistributeDataSetFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkRedistributeDataSetFilter_Type, PyvtkRedistributeDataSetFilter_Methods,
    "vtkRedistributeDataSetFilter",
 &PyvtkRedistributeDataSetFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkRedistributeDataSetFilter_BoundaryModes_Type);
  PyVTKEnum_Add(&PyvtkRedistributeDataSetFilter_BoundaryModes_Type, "vtkRedistributeDataSetFilter.BoundaryModes");

  o = (PyObject *)&PyvtkRedistributeDataSetFilter_BoundaryModes_Type;
  if (PyDict_SetItemString(d, "BoundaryModes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkRedistributeDataSetFilter::BoundaryModes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "ASSIGN_TO_ONE_REGION", vtkRedistributeDataSetFilter::ASSIGN_TO_ONE_REGION },
        { "ASSIGN_TO_ALL_INTERSECTING_REGIONS", vtkRedistributeDataSetFilter::ASSIGN_TO_ALL_INTERSECTING_REGIONS },
        { "SPLIT_BOUNDARY_CELLS", vtkRedistributeDataSetFilter::SPLIT_BOUNDARY_CELLS },
      };

    o = PyvtkRedistributeDataSetFilter_BoundaryModes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkRedistributeDataSetFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkRedistributeDataSetFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkRedistributeDataSetFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkRedistributeDataSetFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

