// python wrapper for vtkFFMPEGWriter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkFFMPEGWriter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkFFMPEGWriter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkFFMPEGWriter_ClassNew(); }


static PyObject *
PyvtkFFMPEGWriter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkFFMPEGWriter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkFFMPEGWriter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkFFMPEGWriter *tempr = vtkFFMPEGWriter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFFMPEGWriter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkFFMPEGWriter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkFFMPEGWriter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkFFMPEGWriter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_Start(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Start");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Start();
    }
    else
    {
      op->vtkFFMPEGWriter::Start();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_Write(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Write");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Write();
    }
    else
    {
      op->vtkFFMPEGWriter::Write();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_End(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "End");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->End();
    }
    else
    {
      op->vtkFFMPEGWriter::End();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_SetQuality(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetQuality");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetQuality(temp0);
    }
    else
    {
      op->vtkFFMPEGWriter::SetQuality(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetQualityMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQualityMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetQualityMinValue() :
      op->vtkFFMPEGWriter::GetQualityMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetQualityMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQualityMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetQualityMaxValue() :
      op->vtkFFMPEGWriter::GetQualityMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetQuality(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetQuality");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetQuality() :
      op->vtkFFMPEGWriter::GetQuality());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_SetCompression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCompression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCompression(temp0);
    }
    else
    {
      op->vtkFFMPEGWriter::SetCompression(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetCompression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCompression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCompression() :
      op->vtkFFMPEGWriter::GetCompression());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_CompressionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CompressionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CompressionOn();
    }
    else
    {
      op->vtkFFMPEGWriter::CompressionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_CompressionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CompressionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CompressionOff();
    }
    else
    {
      op->vtkFFMPEGWriter::CompressionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_SetRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRate(temp0);
    }
    else
    {
      op->vtkFFMPEGWriter::SetRate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetRateMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRateMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRateMinValue() :
      op->vtkFFMPEGWriter::GetRateMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetRateMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRateMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRateMaxValue() :
      op->vtkFFMPEGWriter::GetRateMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRate() :
      op->vtkFFMPEGWriter::GetRate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_SetBitRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBitRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBitRate(temp0);
    }
    else
    {
      op->vtkFFMPEGWriter::SetBitRate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetBitRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBitRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBitRate() :
      op->vtkFFMPEGWriter::GetBitRate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_SetBitRateTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBitRateTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBitRateTolerance(temp0);
    }
    else
    {
      op->vtkFFMPEGWriter::SetBitRateTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGWriter_GetBitRateTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBitRateTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGWriter *op = static_cast<vtkFFMPEGWriter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBitRateTolerance() :
      op->vtkFFMPEGWriter::GetBitRateTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkFFMPEGWriter_Methods[] = {
  {"IsTypeOf", PyvtkFFMPEGWriter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkFFMPEGWriter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkFFMPEGWriter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkFFMPEGWriter\nC++: static vtkFFMPEGWriter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkFFMPEGWriter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkFFMPEGWriter\nC++: vtkFFMPEGWriter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkFFMPEGWriter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkFFMPEGWriter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Start", PyvtkFFMPEGWriter_Start, METH_VARARGS,
   "Start(self) -> None\nC++: void Start() override;\n\nThese methods start writing an Movie file, write a frame to the\nfile and then end the writing process.\n"},
  {"Write", PyvtkFFMPEGWriter_Write, METH_VARARGS,
   "Write(self) -> None\nC++: void Write() override;\n\n"},
  {"End", PyvtkFFMPEGWriter_End, METH_VARARGS,
   "End(self) -> None\nC++: void End() override;\n\n"},
  {"SetQuality", PyvtkFFMPEGWriter_SetQuality, METH_VARARGS,
   "SetQuality(self, _arg:int) -> None\nC++: virtual void SetQuality(int _arg)\n\nSet/Get the compression quality. 0 means worst quality and\nsmallest file size 2 means best quality and largest file size\n"},
  {"GetQualityMinValue", PyvtkFFMPEGWriter_GetQualityMinValue, METH_VARARGS,
   "GetQualityMinValue(self) -> int\nC++: virtual int GetQualityMinValue()\n\n"},
  {"GetQualityMaxValue", PyvtkFFMPEGWriter_GetQualityMaxValue, METH_VARARGS,
   "GetQualityMaxValue(self) -> int\nC++: virtual int GetQualityMaxValue()\n\n"},
  {"GetQuality", PyvtkFFMPEGWriter_GetQuality, METH_VARARGS,
   "GetQuality(self) -> int\nC++: virtual int GetQuality()\n\n"},
  {"SetCompression", PyvtkFFMPEGWriter_SetCompression, METH_VARARGS,
   "SetCompression(self, _arg:bool) -> None\nC++: virtual void SetCompression(bool _arg)\n\nTurns on(the default) or off compression. Turning off compression\noverrides quality setting.\n"},
  {"GetCompression", PyvtkFFMPEGWriter_GetCompression, METH_VARARGS,
   "GetCompression(self) -> bool\nC++: virtual bool GetCompression()\n\n"},
  {"CompressionOn", PyvtkFFMPEGWriter_CompressionOn, METH_VARARGS,
   "CompressionOn(self) -> None\nC++: virtual void CompressionOn()\n\n"},
  {"CompressionOff", PyvtkFFMPEGWriter_CompressionOff, METH_VARARGS,
   "CompressionOff(self) -> None\nC++: virtual void CompressionOff()\n\n"},
  {"SetRate", PyvtkFFMPEGWriter_SetRate, METH_VARARGS,
   "SetRate(self, _arg:int) -> None\nC++: virtual void SetRate(int _arg)\n\nSet/Get the frame rate, in frame/s.\n"},
  {"GetRateMinValue", PyvtkFFMPEGWriter_GetRateMinValue, METH_VARARGS,
   "GetRateMinValue(self) -> int\nC++: virtual int GetRateMinValue()\n\n"},
  {"GetRateMaxValue", PyvtkFFMPEGWriter_GetRateMaxValue, METH_VARARGS,
   "GetRateMaxValue(self) -> int\nC++: virtual int GetRateMaxValue()\n\n"},
  {"GetRate", PyvtkFFMPEGWriter_GetRate, METH_VARARGS,
   "GetRate(self) -> int\nC++: virtual int GetRate()\n\n"},
  {"SetBitRate", PyvtkFFMPEGWriter_SetBitRate, METH_VARARGS,
   "SetBitRate(self, _arg:int) -> None\nC++: virtual void SetBitRate(int _arg)\n\nSet/Get the bit-rate\n"},
  {"GetBitRate", PyvtkFFMPEGWriter_GetBitRate, METH_VARARGS,
   "GetBitRate(self) -> int\nC++: virtual int GetBitRate()\n\n"},
  {"SetBitRateTolerance", PyvtkFFMPEGWriter_SetBitRateTolerance, METH_VARARGS,
   "SetBitRateTolerance(self, _arg:int) -> None\nC++: virtual void SetBitRateTolerance(int _arg)\n\nSet/Get the bit-rate tolerance\n"},
  {"GetBitRateTolerance", PyvtkFFMPEGWriter_GetBitRateTolerance, METH_VARARGS,
   "GetBitRateTolerance(self) -> int\nC++: virtual int GetBitRateTolerance()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkFFMPEGWriter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("quality"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGWriter_GetQuality(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGWriter_SetQuality(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGWriter_SetQuality(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetQuality/SetQuality\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compression"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGWriter_GetCompression(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGWriter_SetCompression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGWriter_SetCompression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCompression/SetCompression\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGWriter_GetRate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGWriter_SetRate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGWriter_SetRate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRate/SetRate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bit_rate"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGWriter_GetBitRate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGWriter_SetBitRate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGWriter_SetBitRate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBitRate/SetBitRate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bit_rate_tolerance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGWriter_GetBitRateTolerance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGWriter_SetBitRateTolerance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGWriter_SetBitRateTolerance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBitRateTolerance/SetBitRateTolerance\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkFFMPEGWriter_Doc =
  "vtkFFMPEGWriter - Uses the FFMPEG library to write video files.\n\n"
  "Superclass: vtkGenericMovieWriter\n\n"
  "vtkFFMPEGWriter is an adapter that allows VTK to use the LGPL'd\n"
  "FFMPEG library to write movie files. FFMPEG can create a variety of\n"
  "multimedia file formats and can use a variety of encoding algorithms\n"
  "(codecs). This class creates .avi files containing MP43 encoded video\n"
  "without audio.\n\n"
  "The FFMPEG multimedia library source code can be obtained from the\n"
  "sourceforge web site at http://ffmpeg.sourceforge.net/download.php or\n"
  "is a tarball along with installation instructions at\n"
  "http://www.vtk.org/files/support/ffmpeg_source.tar.gz\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFFMPEGWriter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFFMPEG.vtkFFMPEGWriter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkFFMPEGWriter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkFFMPEGWriter_StaticNew()
{
  return vtkFFMPEGWriter::New();
}

PyObject *PyvtkFFMPEGWriter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkFFMPEGWriter_Type, PyvtkFFMPEGWriter_Methods,
    "vtkFFMPEGWriter",
 &PyvtkFFMPEGWriter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkGenericMovieWriter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkFFMPEGWriter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkFFMPEGWriter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkFFMPEGWriter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkFFMPEGWriter", o) != 0)
  {
    Py_DECREF(o);
  }

}

