// python wrapper for vtkBoostLogWeighting
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkBoostLogWeighting.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBoostLogWeighting(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBoostLogWeighting_ClassNew(); }


static PyObject *
PyvtkBoostLogWeighting_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBoostLogWeighting::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBoostLogWeighting::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBoostLogWeighting *tempr = vtkBoostLogWeighting::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBoostLogWeighting *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBoostLogWeighting::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBoostLogWeighting::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBoostLogWeighting::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_SetBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBase(temp0);
    }
    else
    {
      op->vtkBoostLogWeighting::SetBase(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_GetBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBase() :
      op->vtkBoostLogWeighting::GetBase());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_SetEmitProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEmitProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEmitProgress(temp0);
    }
    else
    {
      op->vtkBoostLogWeighting::SetEmitProgress(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_GetEmitProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEmitProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEmitProgress() :
      op->vtkBoostLogWeighting::GetEmitProgress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_EmitProgressOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EmitProgressOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EmitProgressOn();
    }
    else
    {
      op->vtkBoostLogWeighting::EmitProgressOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostLogWeighting_EmitProgressOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EmitProgressOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostLogWeighting *op = static_cast<vtkBoostLogWeighting *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EmitProgressOff();
    }
    else
    {
      op->vtkBoostLogWeighting::EmitProgressOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkBoostLogWeighting_Methods[] = {
  {"IsTypeOf", PyvtkBoostLogWeighting_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBoostLogWeighting_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBoostLogWeighting_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBoostLogWeighting\nC++: static vtkBoostLogWeighting *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBoostLogWeighting_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBoostLogWeighting\nC++: vtkBoostLogWeighting *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBoostLogWeighting_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBoostLogWeighting_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetBase", PyvtkBoostLogWeighting_SetBase, METH_VARARGS,
   "SetBase(self, _arg:int) -> None\nC++: virtual void SetBase(int _arg)\n\nSpecify the logarithm base to apply\n"},
  {"GetBase", PyvtkBoostLogWeighting_GetBase, METH_VARARGS,
   "GetBase(self) -> int\nC++: virtual int GetBase()\n\n"},
  {"SetEmitProgress", PyvtkBoostLogWeighting_SetEmitProgress, METH_VARARGS,
   "SetEmitProgress(self, _arg:bool) -> None\nC++: virtual void SetEmitProgress(bool _arg)\n\nSpecify whether this filter should emit progress events\n"},
  {"GetEmitProgress", PyvtkBoostLogWeighting_GetEmitProgress, METH_VARARGS,
   "GetEmitProgress(self) -> bool\nC++: virtual bool GetEmitProgress()\n\n"},
  {"EmitProgressOn", PyvtkBoostLogWeighting_EmitProgressOn, METH_VARARGS,
   "EmitProgressOn(self) -> None\nC++: virtual void EmitProgressOn()\n\n"},
  {"EmitProgressOff", PyvtkBoostLogWeighting_EmitProgressOff, METH_VARARGS,
   "EmitProgressOff(self) -> None\nC++: virtual void EmitProgressOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBoostLogWeighting_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("base"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostLogWeighting_GetBase(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostLogWeighting_SetBase(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostLogWeighting_SetBase(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBase/SetBase\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("emit_progress"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostLogWeighting_GetEmitProgress(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostLogWeighting_SetEmitProgress(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostLogWeighting_SetEmitProgress(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEmitProgress/SetEmitProgress\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBoostLogWeighting_Doc =
  "vtkBoostLogWeighting - Given an arbitrary-dimension array of doubles,\nreplaces each value x with one of:\n\n"
  "Superclass: vtkArrayDataAlgorithm\n\n"
  "* The natural logarithm of 1 + x (the default)\n"
  "* The base-2 logarithm of 1 + x\n\n"
  "@par Thanks: Developed by Timothy M. Shead (tshead@sandia.gov) at\n"
  "Sandia National Laboratories.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBoostLogWeighting_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkInfovisBoostGraphAlgorithms.vtkBoostLogWeighting", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBoostLogWeighting_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBoostLogWeighting_StaticNew()
{
  return vtkBoostLogWeighting::New();
}

PyObject *PyvtkBoostLogWeighting_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBoostLogWeighting_Type, PyvtkBoostLogWeighting_Methods,
    "vtkBoostLogWeighting",
 &PyvtkBoostLogWeighting_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkArrayDataAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "BASE_E", vtkBoostLogWeighting::BASE_E },
        { "BASE_2", vtkBoostLogWeighting::BASE_2 },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBoostLogWeighting_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBoostLogWeighting(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBoostLogWeighting_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBoostLogWeighting", o) != 0)
  {
    Py_DECREF(o);
  }

}

