// python wrapper for vtkAnariSceneGraph
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkAnariSceneGraph.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAnariSceneGraph(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAnariSceneGraph_ClassNew(); }


static PyObject *
PyvtkAnariSceneGraph_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAnariSceneGraph::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAnariSceneGraph::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAnariSceneGraph *tempr = vtkAnariSceneGraph::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAnariSceneGraph *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAnariSceneGraph::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAnariSceneGraph::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAnariSceneGraph::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_Build(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Build");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Build(temp0);
    }
    else
    {
      op->vtkAnariSceneGraph::Build(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Render(temp0);
    }
    else
    {
      op->vtkAnariSceneGraph::Render(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_Invalidate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Invalidate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Invalidate(temp0);
    }
    else
    {
      op->vtkAnariSceneGraph::Invalidate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_SetUpdateWorldOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUpdateWorldOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    if (ap.IsBound())
    {
      op->SetUpdateWorldOnly(temp0);
    }
    else
    {
      op->vtkAnariSceneGraph::SetUpdateWorldOnly(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_ACCUMULATION_COUNT(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ACCUMULATION_COUNT");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkAnariSceneGraph::ACCUMULATION_COUNT();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_SetAccumulationCount(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetAccumulationCount");

  vtkRenderer *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkRenderer") &&
      ap.GetValue(temp1))
  {
    vtkAnariSceneGraph::SetAccumulationCount(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_GetAccumulationCount(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetAccumulationCount");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkAnariSceneGraph::GetAccumulationCount(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_COMPOSITE_ON_GL(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "COMPOSITE_ON_GL");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkAnariSceneGraph::COMPOSITE_ON_GL();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_SetCompositeOnGL(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetCompositeOnGL");

  vtkRenderer *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkRenderer") &&
      ap.GetValue(temp1))
  {
    vtkAnariSceneGraph::SetCompositeOnGL(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_GetCompositeOnGL(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetCompositeOnGL");

  vtkRenderer *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderer"))
  {
    int tempr = vtkAnariSceneGraph::GetCompositeOnGL(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_GetBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const unsigned char *tempr = (ap.IsBound() ?
      op->GetBuffer() :
      op->vtkAnariSceneGraph::GetBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_GetZBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const float *tempr = (ap.IsBound() ?
      op->GetZBuffer() :
      op->vtkAnariSceneGraph::GetZBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_Traverse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Traverse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Traverse(temp0);
    }
    else
    {
      op->vtkAnariSceneGraph::Traverse(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer() :
      op->vtkAnariSceneGraph::GetRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_WriteLayer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteLayer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<unsigned char> store0(2*size0);
  unsigned char *temp0 = store0.Data();
  unsigned char *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<float> store1(2*size1);
  float *temp1 = store1.Data();
  float *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    vtkPythonArgs::Save(temp0, save0, size0);
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->WriteLayer(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkAnariSceneGraph::WriteLayer(temp0, temp1, temp2, temp3, temp4);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_InvalidateSceneStructure(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvalidateSceneStructure");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InvalidateSceneStructure();
    }
    else
    {
      op->vtkAnariSceneGraph::InvalidateSceneStructure();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_ReservePropId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReservePropId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->ReservePropId() :
      op->vtkAnariSceneGraph::ReservePropId());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariSceneGraph_WarningMacroOnce(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WarningMacroOnce");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariSceneGraph *op = static_cast<vtkAnariSceneGraph *>(vp);

  vtkSmartPointer<vtkObject> temp0;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkObject") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->WarningMacroOnce(temp0, temp1);
    }
    else
    {
      op->vtkAnariSceneGraph::WarningMacroOnce(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkAnariSceneGraph_Methods[] = {
  {"IsTypeOf", PyvtkAnariSceneGraph_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAnariSceneGraph_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAnariSceneGraph_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAnariSceneGraph\nC++: static vtkAnariSceneGraph *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAnariSceneGraph_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAnariSceneGraph\nC++: vtkAnariSceneGraph *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAnariSceneGraph_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAnariSceneGraph_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Build", PyvtkAnariSceneGraph_Build, METH_VARARGS,
   "Build(self, prepass:bool) -> None\nC++: void Build(bool prepass) override;\n\nBuilds objects for this renderer.\n"},
  {"Render", PyvtkAnariSceneGraph_Render, METH_VARARGS,
   "Render(self, prepass:bool) -> None\nC++: void Render(bool prepass) override;\n\nTraverse graph in ANARI's preferred order and render\n"},
  {"Invalidate", PyvtkAnariSceneGraph_Invalidate, METH_VARARGS,
   "Invalidate(self, prepass:bool) -> None\nC++: void Invalidate(bool prepass) override;\n\nInvalidates cached rendering data.\n"},
  {"SetUpdateWorldOnly", PyvtkAnariSceneGraph_SetUpdateWorldOnly, METH_VARARGS,
   "SetUpdateWorldOnly(self, onlyUpdateWorld:bool=False) -> None\nC++: void SetUpdateWorldOnly(bool onlyUpdateWorld=false)\n\nWhen passing 'true', the renderer will skip actually rendering\nframe. This is for when an application wants to externally use\nthe anari::World in their own non-VTK viewport using their own\nanari::Frame/Renderer/Camera, but still wants VTK to manage the\ncontents of the anari::World.\n"},
  {"ACCUMULATION_COUNT", PyvtkAnariSceneGraph_ACCUMULATION_COUNT, METH_VARARGS,
   "ACCUMULATION_COUNT() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *ACCUMULATION_COUNT()\n\nSet the number of frames to render which are accumulated to\nresult in a better converged image.\n"},
  {"SetAccumulationCount", PyvtkAnariSceneGraph_SetAccumulationCount, METH_VARARGS,
   "SetAccumulationCount(renderer:vtkRenderer, __b:int) -> None\nC++: static void SetAccumulationCount(vtkRenderer *renderer, int)\n\nConvenience method to set/get ACCUMULATION_COUNT on a\nvtkRenderer.\n"},
  {"GetAccumulationCount", PyvtkAnariSceneGraph_GetAccumulationCount, METH_VARARGS,
   "GetAccumulationCount(renderer:vtkRenderer) -> int\nC++: static int GetAccumulationCount(vtkRenderer *renderer)\n\nConvenience method to set/get ACCUMULATION_COUNT on a\nvtkRenderer.\n"},
  {"COMPOSITE_ON_GL", PyvtkAnariSceneGraph_COMPOSITE_ON_GL, METH_VARARGS,
   "COMPOSITE_ON_GL() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *COMPOSITE_ON_GL()\n\nused to make the renderer add ANARI's content onto GL rendered\ncontent on the window\n"},
  {"SetCompositeOnGL", PyvtkAnariSceneGraph_SetCompositeOnGL, METH_VARARGS,
   "SetCompositeOnGL(renderer:vtkRenderer, __b:int) -> None\nC++: static void SetCompositeOnGL(vtkRenderer *renderer, int)\n\nConvenience method to set/get COMPOSITE_ON_GL on a vtkRenderer.\n"},
  {"GetCompositeOnGL", PyvtkAnariSceneGraph_GetCompositeOnGL, METH_VARARGS,
   "GetCompositeOnGL(renderer:vtkRenderer) -> int\nC++: static int GetCompositeOnGL(vtkRenderer *renderer)\n\nConvenience method to set/get COMPOSITE_ON_GL on a vtkRenderer.\n"},
  {"GetBuffer", PyvtkAnariSceneGraph_GetBuffer, METH_VARARGS,
   "GetBuffer(self) -> Pointer\nC++: virtual const unsigned char *GetBuffer()\n\nGet the last rendered ColorBuffer\n"},
  {"GetZBuffer", PyvtkAnariSceneGraph_GetZBuffer, METH_VARARGS,
   "GetZBuffer(self) -> Pointer\nC++: virtual const float *GetZBuffer()\n\nGet the last rendered ZBuffer\n"},
  {"Traverse", PyvtkAnariSceneGraph_Traverse, METH_VARARGS,
   "Traverse(self, operation:int) -> None\nC++: virtual void Traverse(int operation) override;\n\n"},
  {"GetRenderer", PyvtkAnariSceneGraph_GetRenderer, METH_VARARGS,
   "GetRenderer(self) -> vtkRenderer\nC++: vtkRenderer *GetRenderer()\n\nConvenience method to get and downcast renderable.\n"},
  {"WriteLayer", PyvtkAnariSceneGraph_WriteLayer, METH_VARARGS,
   "WriteLayer(self, buffer:[int, ...], zbuffer:[float, ...],\n    buffx:int, buffy:int, layer:int) -> None\nC++: virtual void WriteLayer(unsigned char *buffer,\n    float *zbuffer, int buffx, int buffy, int layer)\n\nPut my results into the correct place in the provided pixel\nbuffer.\n"},
  {"InvalidateSceneStructure", PyvtkAnariSceneGraph_InvalidateSceneStructure, METH_VARARGS,
   "InvalidateSceneStructure(self) -> None\nC++: void InvalidateSceneStructure()\n\nIndicate that a new RenderTraversal of children needs to occur\nnext frame\n"},
  {"ReservePropId", PyvtkAnariSceneGraph_ReservePropId, METH_VARARGS,
   "ReservePropId(self) -> int\nC++: int ReservePropId()\n\nReserve an Id which is unique to a render call.\n"},
  {"WarningMacroOnce", PyvtkAnariSceneGraph_WarningMacroOnce, METH_VARARGS,
   "WarningMacroOnce(self, caller:vtkObject, warning:str) -> None\nC++: void WarningMacroOnce(vtkSmartPointer<vtkObject> caller,\n    const std::string &warning)\n\nConvenience API to warn the user once per device per renderer per\nwarning type.\n\nThis saves the warning/error buffers to be filled each frame.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAnariSceneGraph_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("update_world_only"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAnariSceneGraph_SetUpdateWorldOnly(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAnariSceneGraph_SetUpdateWorldOnly(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUpdateWorldOnly\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("buffer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariSceneGraph_GetBuffer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_buffer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariSceneGraph_GetZBuffer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetZBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariSceneGraph_GetRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderer\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAnariSceneGraph_Doc =
  "vtkAnariSceneGraph - links vtkRenderers to ANARI\n\n"
  "Superclass: vtkRendererNode\n\n"
  "This class acts as a root node managing an anari::Frame and\n"
  "everything within it. The anari::Frame is the top-level object to\n"
  "render images using ANARI, containing the anari::Camera,\n"
  "anari::World, and anari::Renderer all from a particular\n"
  "anari::Device. vtkAnariSceneGraph expects to be given the\n"
  "anari::Device and anari::Renderer externally, which are managed by\n"
  "other classes which use vtkAnariSceneGraph (e.g. vtkAnariPass and\n"
  "vtkAnariWindowNode). vtkAnariSceneGraph expects to be given a valid\n"
  "anari::Device before any scene graph traversals occur.\n\n"
  " @par Thanks:\n"
  " Kevin Griffin kgriffin\n\n"
  "vidia.com for creating and contributing the class\n"
  " and NVIDIA for supporting this work.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAnariSceneGraph_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingAnari.vtkAnariSceneGraph", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAnariSceneGraph_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAnariSceneGraph_StaticNew()
{
  return vtkAnariSceneGraph::New();
}

PyObject *PyvtkAnariSceneGraph_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAnariSceneGraph_Type, PyvtkAnariSceneGraph_Methods,
    "vtkAnariSceneGraph",
 &PyvtkAnariSceneGraph_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkRendererNode");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAnariSceneGraph_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAnariSceneGraph(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAnariSceneGraph_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAnariSceneGraph", o) != 0)
  {
    Py_DECREF(o);
  }

}

