// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkLineIntegralConvolution2D_LIC0.h"

const char *vtkLineIntegralConvolution2D_LIC0 =
"//VTK::System::Dec\n"
"\n"
"\n"
"/**\n"
"This shader initializes the convolution for the LIC computation.\n"
"*/\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"uniform sampler2D texMaskVectors;\n"
"uniform sampler2D texNoise;\n"
"uniform sampler2D texLIC;\n"
"\n"
"uniform int   uStepNo;         // in step 0 initialize lic and seeds, else just seeds\n"
"uniform int   uPassNo;         // in pass 1 hpf of pass 0 is convolved.\n"
"uniform float uMaskThreshold;  // if |V| < uMaskThreshold render transparent\n"
"uniform vec2  uNoiseBoundsPt1; // tc of upper right pt of noise texture\n"
"\n"
"in vec2 tcoordVC;\n"
"\n"
"// convert from vector coordinate space to noise coordinate space.\n"
"// the noise texture is tiled across the *whole* domain\n"
"vec2 VectorTCToNoiseTC(vec2 vectc)\n"
"{\n"
"  return vectc/uNoiseBoundsPt1;\n"
"}\n"
"\n"
"// get the texture coordidnate to lookup noise value. this\n"
"// depends on the pass number.\n"
"vec2 getNoiseTC(vec2 vectc)\n"
"{\n"
"  // in pass 1 : convert from vector tc to noise tc\n"
"  // in pass 2 : use vector tc\n"
"  if (uPassNo == 0)\n"
"    {\n"
"    return VectorTCToNoiseTC(vectc);\n"
"    }\n"
"  else\n"
"    {\n"
"    return vectc;\n"
"    }\n"
"}\n"
"\n"
"// look up noise value at the given location. The location\n"
"// is supplied in vector texture coordinates, hence the\n"
"// need to convert to noise texture coordinates.\n"
"float getNoise(vec2 vectc)\n"
"{\n"
"  return texture2D(texNoise, getNoiseTC(vectc)).r;\n"
"}\n"
"\n"
"void main(void)\n"
"{\n"
"  vec2 vectc = tcoordVC.st;\n"
"\n"
"  // lic => (convolution, mask, 0, step count)\n"
"  if (uStepNo == 0)\n"
"    {\n"
"    float maskCriteria = length(texture2D(texMaskVectors, vectc).xyz);\n"
"    float maskFlag;\n"
"    if (maskCriteria <= uMaskThreshold)\n"
"      {\n"
"      maskFlag = 1.0;\n"
"      }\n"
"    else\n"
"      {\n"
"      maskFlag = 0.0;\n"
"      }\n"
"    float noise = getNoise(vectc);\n"
"    gl_FragData[0] = vec4(noise, maskFlag, 0.0, 1.0);\n"
"    }\n"
"  else\n"
"    {\n"
"    gl_FragData[0] = texture2D(texLIC, vectc);\n"
"    }\n"
"\n"
"  // initial seed\n"
"  gl_FragData[1] = vec4(vectc, 0.0, 1.0);\n"
"}\n"
"";
