// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperDepthFilterNarrowRangeFS.h"

const char *vtkFluidMapperDepthFilterNarrowRangeFS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"uniform sampler2D fluidZTexture;\n"
"uniform int       viewportWidth;\n"
"uniform int       viewportHeight;\n"
"uniform float     particleRadius;\n"
"uniform int       filterRadius = 5;\n"
"uniform float     lambda       = 10.0f;\n"
"uniform float     mu           = 1.0f;\n"
"uniform float     farZValue;\n"
"\n"
"in vec2 texCoord;\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n"
"#define MAX_ADAPTIVE_RADIUS 32\n"
"#define PI_OVER_8           0.392699082f\n"
"#define FIX_OTHER_WEIGHT\n"
"#define RANGE_EXTENSION\n"
"\n"
"float compute_weight2D(vec2 r, float two_sigma2)\n"
"{\n"
"  return exp(-dot(r, r) / two_sigma2);\n"
"}\n"
"\n"
"void modifiedGaussianFilter2D(inout float sampleDepth, inout float weight, inout float weight_other,\n"
"                              inout float upper, inout float lower, float lower_clamp, float threshold)\n"
"{\n"
"  if(sampleDepth > upper)\n"
"  {\n"
"    weight = 0;\n"
"#ifdef FIX_OTHER_WEIGHT\n"
"    weight_other = 0;\n"
"#endif\n"
"  }\n"
"  else\n"
"  {\n"
"    if(sampleDepth < lower)\n"
"    {\n"
"      sampleDepth = lower_clamp;\n"
"    }\n"
"#ifdef RANGE_EXTENSION\n"
"    else\n"
"    {\n"
"      upper = max(upper, sampleDepth + threshold);\n"
"      lower = min(lower, sampleDepth - threshold);\n"
"    }\n"
"#endif\n"
"  }\n"
"}\n"
"\n"
"float filter2D(float pixelDepth)\n"
"{\n"
"  if(filterRadius == 0) {\n"
"      return pixelDepth;\n"
"  }\n"
"\n"
"  vec2  blurRadius = vec2(1.0 / viewportWidth, 1.0 / viewportHeight);\n"
"  float threshold  = particleRadius * lambda;\n"
"  float ratio      = viewportHeight / 2.0 / tan(PI_OVER_8);\n"
"  float K          = -filterRadius * ratio * particleRadius * 0.1f;\n"
"  int   filterSize = min(MAX_ADAPTIVE_RADIUS, int(ceil(K / pixelDepth)));\n"
"\n"
"  float upper       = pixelDepth + threshold;\n"
"  float lower       = pixelDepth - threshold;\n"
"  float lower_clamp = pixelDepth - particleRadius * mu;\n"
"\n"
"  float sigma      = filterSize / 3.0f;\n"
"  float two_sigma2 = 2.0f * sigma * sigma;\n"
"\n"
"  vec4 f_tex = texCoord.xyxy;\n"
"\n"
"  vec2 r     = vec2(0, 0);\n"
"  vec4 sum4  = vec4(pixelDepth, 0, 0, 0);\n"
"  vec4 wsum4 = vec4(1, 0, 0, 0);\n"
"  vec4 sampleDepth;\n"
"  vec4 w4;\n"
"\n"
"  for(int x = 1; x <= filterSize; ++x)\n"
"  {\n"
"    r.x     += blurRadius.x;\n"
"    f_tex.x += blurRadius.x;\n"
"    f_tex.z -= blurRadius.x;\n"
"    vec4 f_tex1 = f_tex.xyxy;\n"
"    vec4 f_tex2 = f_tex.zwzw;\n"
"\n"
"    for(int y = 1; y <= filterSize; ++y)\n"
"    {\n"
"      f_tex1.y += blurRadius.y;\n"
"      f_tex1.w -= blurRadius.y;\n"
"      f_tex2.y += blurRadius.y;\n"
"      f_tex2.w -= blurRadius.y;\n"
"\n"
"      sampleDepth.x = texture(fluidZTexture, f_tex1.xy).r;\n"
"      sampleDepth.y = texture(fluidZTexture, f_tex1.zw).r;\n"
"      sampleDepth.z = texture(fluidZTexture, f_tex2.xy).r;\n"
"      sampleDepth.w = texture(fluidZTexture, f_tex2.zw).r;\n"
"\n"
"      r.y += blurRadius.y;\n"
"      w4   = vec4(compute_weight2D(blurRadius * r, two_sigma2));\n"
"\n"
"      modifiedGaussianFilter2D(sampleDepth.x, w4.x, w4.w, upper, lower, lower_clamp, threshold);\n"
"      modifiedGaussianFilter2D(sampleDepth.y, w4.y, w4.z, upper, lower, lower_clamp, threshold);\n"
"      modifiedGaussianFilter2D(sampleDepth.z, w4.z, w4.y, upper, lower, lower_clamp, threshold);\n"
"      modifiedGaussianFilter2D(sampleDepth.w, w4.w, w4.x, upper, lower, lower_clamp, threshold);\n"
"\n"
"      sum4  += sampleDepth * w4;\n"
"      wsum4 += w4;\n"
"    }\n"
"  }\n"
"\n"
"  vec2 filterVal;\n"
"  filterVal.x = dot(sum4, vec4(1, 1, 1, 1));\n"
"  filterVal.y = dot(wsum4, vec4(1, 1, 1, 1));\n"
"  return filterVal.x / filterVal.y;\n"
"}\n"
"\n"
"//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+\n"
"void main()\n"
"{\n"
"  float pixelDepth = texture(fluidZTexture, texCoord).r;\n"
"  float finalDepth;\n"
"  if (pixelDepth > 0.0 || pixelDepth <= farZValue)\n"
"  {\n"
"    finalDepth = pixelDepth;\n"
"  }\n"
"  else\n"
"  {\n"
"    finalDepth = filter2D(pixelDepth);\n"
"  }\n"
"  gl_FragData[0] = vec4(finalDepth, 0, 0, 1.0);\n"
"}\n"
"";
