// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkPSurfaceLICComposite_CompFS.h"

const char *vtkPSurfaceLICComposite_CompFS =
"//VTK::System::Dec\n"
"\n"
"// This shader composites for surface lic\n"
"// it expects float depth values encoded\n"
"// in alpha channel.\n"
"\n"
"// The following line handles system declarations such as\n"
"// default precisions, or defining precisions to null\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"uniform sampler2D texData;\n"
"\n"
"in vec2 tcoordVC;\n"
"\n"
"void main()\n"
"{\n"
"  vec4 newData = texture2D(texData, tcoordVC.st);\n"
"  float newDepth = newData.a;\n"
"  if (newDepth == 0.0)\n"
"    {\n"
"    discard;\n"
"    }\n"
"  gl_FragDepth = newDepth;\n"
"  gl_FragData[0] = newData;\n"
"}\n"
"";
