// java wrapper for vtkPlotHistogram2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPlotHistogram2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPlot_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPlotHistogram2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPlotHistogram2D",dType)) { return me; }
  if ((res= vtkPlot_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlotHistogram2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlotHistogram2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlotHistogram2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlotHistogram2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotHistogram2D_Update_14(JNIEnv* env, jobject obj)
{

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlotHistogram2D_Paint_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotHistogram2D_SetInputData_16(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkImageData * temp0;
  long long   temp1;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotHistogram2D_SetInputData_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTable * temp0;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotHistogram2D_SetInputData_18(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2)
{
  vtkTable * temp0;
  vtkStdString temp1;
  vtkStdString temp2;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlotHistogram2D_GetInputImageData_19(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputImageData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotHistogram2D_SetTransferFunction_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransferFunction(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlotHistogram2D_GetTransferFunction_111(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransferFunction();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotHistogram2D_GetBounds_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotHistogram2D_SetArrayName_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlotHistogram2D_GetArrayName_114(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlotHistogram2D_UpdateCache_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPlotHistogram2D* op = static_cast<vtkPlotHistogram2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateCache();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPlotHistogram2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPlotHistogram2D::New());
}
