// java wrapper for vtkPlotPoints object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPlotPoints.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPlot_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPlotPoints_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPlotPoints",dType)) { return me; }
  if ((res= vtkPlot_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlotPoints_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlotPoints_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlotPoints_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlotPoints_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlotPoints_Paint_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_GetBounds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_GetUnscaledInputBounds_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetUnscaledInputBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_SetLookupTable_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlotPoints_GetLookupTable_18(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_CreateDefaultLookupTable_19(JNIEnv* env, jobject obj)
{

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLookupTable();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_SetScalarVisibility_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlotPoints_GetScalarVisibility_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_ScalarVisibilityOn_112(JNIEnv* env, jobject obj)
{

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_ScalarVisibilityOff_113(JNIEnv* env, jobject obj)
{

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScalarVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_SelectColorArray_114(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectColorArray(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_SelectColorArray_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectColorArray(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlotPoints_GetColorArrayName_116(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorArrayName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlotPoints_GetMarkerStyle_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarkerStyle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_SetMarkerStyle_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMarkerStyle(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkPlotPoints_GetMarkerSize_119(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarkerSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_SetMarkerSize_120(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMarkerSize(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlotPoints_GetValidPointMaskName_121(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValidPointMaskName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_SetValidPointMaskName_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValidPointMaskName(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPlotPoints_UpdateCache_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateCache();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlotPoints_ReleaseGraphicsCache_124(JNIEnv* env, jobject obj)
{

  vtkPlotPoints* op = static_cast<vtkPlotPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsCache();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPlotPoints_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPlotPoints::New());
}
