// java wrapper for vtkDataObjectToDataSetFilter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataObjectToDataSetFilter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataObjectToDataSetFilter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataObjectToDataSetFilter",dType)) { return me; }
  if ((res= vtkDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetInput_14(JNIEnv* env, jobject obj)
{
  vtkDataObject * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDataSetType_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetDataSetType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSetType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDataSetTypeToPolyData_17(JNIEnv* env, jobject obj)
{

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetTypeToPolyData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDataSetTypeToStructuredPoints_18(JNIEnv* env, jobject obj)
{

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetTypeToStructuredPoints();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDataSetTypeToStructuredGrid_19(JNIEnv* env, jobject obj)
{

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetTypeToStructuredGrid();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDataSetTypeToRectilinearGrid_110(JNIEnv* env, jobject obj)
{

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetTypeToRectilinearGrid();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDataSetTypeToUnstructuredGrid_111(JNIEnv* env, jobject obj)
{

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetTypeToUnstructuredGrid();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetOutput_112(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetOutput_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSet * temp20;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPolyDataOutput_114(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolyDataOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetStructuredPointsOutput_115(JNIEnv* env, jobject obj)
{
  vtkStructuredPoints * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStructuredPointsOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetStructuredGridOutput_116(JNIEnv* env, jobject obj)
{
  vtkStructuredGrid * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStructuredGridOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetUnstructuredGridOutput_117(JNIEnv* env, jobject obj)
{
  vtkUnstructuredGrid * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnstructuredGridOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetRectilinearGridOutput_118(JNIEnv* env, jobject obj)
{
  vtkRectilinearGrid * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRectilinearGridOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetPointComponent_119(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  char * temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointComponent(temp0,temp1,temp2,temp3,temp4,temp5);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetPointComponent_120(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1,jint id2)
{
  int   temp0;
  char * temp1;
  int   temp2;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);
  temp2 = id2;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointComponent(temp0,temp1,temp2);
  delete[] temp1;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPointComponentArrayName_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointComponentArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPointComponentArrayComponent_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointComponentArrayComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPointComponentMinRange_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointComponentMinRange(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPointComponentMaxRange_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointComponentMaxRange(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPointComponentNormailzeFlag_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointComponentNormailzeFlag(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetVertsComponent_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertsComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetVertsComponent_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertsComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetVertsComponentArrayName_128(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertsComponentArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetVertsComponentArrayComponent_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertsComponentArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetVertsComponentMinRange_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertsComponentMinRange();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetVertsComponentMaxRange_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertsComponentMaxRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetLinesComponent_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLinesComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetLinesComponent_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLinesComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetLinesComponentArrayName_134(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinesComponentArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetLinesComponentArrayComponent_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinesComponentArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetLinesComponentMinRange_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinesComponentMinRange();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetLinesComponentMaxRange_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinesComponentMaxRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetPolysComponent_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolysComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetPolysComponent_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolysComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPolysComponentArrayName_140(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolysComponentArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPolysComponentArrayComponent_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolysComponentArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPolysComponentMinRange_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolysComponentMinRange();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetPolysComponentMaxRange_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolysComponentMaxRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetStripsComponent_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStripsComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetStripsComponent_145(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStripsComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetStripsComponentArrayName_146(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStripsComponentArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetStripsComponentArrayComponent_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStripsComponentArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetStripsComponentMinRange_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStripsComponentMinRange();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetStripsComponentMaxRange_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStripsComponentMaxRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetCellTypeComponent_150(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetCellTypeComponent_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellTypeComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellTypeComponentArrayName_152(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellTypeComponentArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellTypeComponentArrayComponent_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellTypeComponentArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellTypeComponentMinRange_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellTypeComponentMinRange();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellTypeComponentMaxRange_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellTypeComponentMaxRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetCellConnectivityComponent_156(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellConnectivityComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetCellConnectivityComponent_157(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellConnectivityComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellConnectivityComponentArrayName_158(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellConnectivityComponentArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellConnectivityComponentArrayComponent_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellConnectivityComponentArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellConnectivityComponentMinRange_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellConnectivityComponentMinRange();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetCellConnectivityComponentMaxRange_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellConnectivityComponentMaxRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDefaultNormalize_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultNormalize(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetDefaultNormalize_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultNormalize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_DefaultNormalizeOn_164(JNIEnv* env, jobject obj)
{

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->DefaultNormalizeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_DefaultNormalizeOff_165(JNIEnv* env, jobject obj)
{

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->DefaultNormalizeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDimensions_166(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDimensions_167(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetDimensions_168(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetOrigin_169(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetOrigin_170(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetOrigin_171(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetSpacing_172(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetSpacing_173(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_GetSpacing_174(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDimensionsComponent_175(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensionsComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetDimensionsComponent_176(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensionsComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetSpacingComponent_177(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacingComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetSpacingComponent_178(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpacingComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetOriginComponent_179(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginComponent(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectToDataSetFilter_SetOriginComponent_180(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataObjectToDataSetFilter* op = static_cast<vtkDataObjectToDataSetFilter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOriginComponent(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataObjectToDataSetFilter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataObjectToDataSetFilter::New());
}
